CREATE NONCLUSTERED INDEX FLW_IDX_IDM_INFO_GROUP_ID_REF ON FLW_IDENTITY_INFO (GROUP_ID_REF_);

ALTER TABLE FLW_ID_MEMBERSHIP DROP CONSTRAINT FLW_FK_MEMB_GROUP;

ALTER TABLE FLW_ID_MEMBERSHIP DROP CONSTRAINT PK_FLW_ID_MEMBERSHIP;

ALTER TABLE FLW_ID_GROUP DROP CONSTRAINT PK_FLW_ID_GROUP;

DROP INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP;

ALTER TABLE FLW_ID_GROUP ALTER COLUMN ID_ nvarchar(255) NOT NULL;

ALTER TABLE FLW_ID_GROUP ADD CONSTRAINT PK_FLW_ID_GROUP PRIMARY KEY (ID_);

ALTER TABLE FLW_ID_MEMBERSHIP ALTER COLUMN GROUP_ID_ nvarchar(255) NOT NULL;

ALTER TABLE FLW_ID_MEMBERSHIP ADD CONSTRAINT PK_FLW_ID_MEMBERSHIP PRIMARY KEY (USER_ID_, GROUP_ID_);

CREATE NONCLUSTERED INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP(GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

update ACT_GE_PROPERTY set VALUE_ = '22' where NAME_ = 'idm.schema.version';


ALTER TABLE FLW_AGENT_INSTANCE ADD NAME_ nvarchar(255);
ALTER TABLE FLW_AGENT_INSTANCE ADD CALLBACK_SCOPE_ID_ varchar(255);

CREATE NONCLUSTERED INDEX IDX_FLW_AGT_INS_CALLB_SCOPE_ID ON FLW_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);
ALTER TABLE FLW_HI_AGENT_INSTANCE ADD NAME_ nvarchar(255);

ALTER TABLE FLW_HI_AGENT_INSTANCE ADD CALLBACK_SCOPE_ID_ nvarchar(255);

CREATE INDEX IDX_FLW_HI_AGT_INST_CALL_SCP_ID ON FLW_HI_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION
(
    ID_                     varchar(255) NOT NULL,
    REV_                    int      NOT NULL,
    AGENT_INSTANCE_ID_      varchar(255) NOT NULL,
    OPERATION_KEY_          nvarchar(255),
    START_TIME_             datetime2(6) NOT NULL,
    END_TIME_               datetime2(6),
    USER_ID_                nvarchar(255),
    PROMPT_TOKEN_COUNT_     numeric(19,0),
    OUTPUT_TOKEN_COUNT_     numeric(19,0),
    CONSTRAINT PK_FLW_HI_AGENT_INVOCATION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_AGT_ID ON FLW_HI_AGENT_INVOCATION (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_AGT_ID FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION_EXCH
(
    ID_                         varchar(255) NOT NULL,
    REV_                        int      NOT NULL,
    INVOCATION_ID_              varchar(255) NOT NULL,
    CREATION_TIME_              datetime2(6) NOT NULL,
    END_TIME_                   datetime2(6),
    DURATION_                   numeric(19,0),
    TYPE_                       varchar(255),
    SUB_TYPE_                   nvarchar(2000),
    USER_ID_                    nvarchar(255),
    PROMPT_TOKEN_COUNT_         numeric(19,0),
    OUTPUT_TOKEN_COUNT_         numeric(19,0),
    TRANSACTION_ORDER_          int NOT NULL DEFAULT 1,
    CONSTRAINT PK_FLW_HI_AGENT_INVOC_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_INV ON FLW_HI_AGENT_INVOCATION_EXCH (INVOCATION_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION_EXCH
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_INVOC FOREIGN KEY (INVOCATION_ID_) REFERENCES FLW_HI_AGENT_INVOCATION (ID_);

CREATE TABLE FLW_HI_AGENT_INVOC_EXCH_PART
(
    ID_                         varchar(255) NOT NULL,
    EXCHANGE_ID_                varchar(255) NOT NULL,
    TYPE_                       varchar(255) NOT NULL,
    SUB_TYPE_                   nvarchar(2000),
    CONTENT_                    nvarchar(max),
    INVOCATION_SEQUENCE_        INTEGER NOT NULL DEFAULT 1,
    CONSTRAINT PK_FLW_HI_AGT_INVOC_EXCH_PART PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_PART ON FLW_HI_AGENT_INVOC_EXCH_PART (EXCHANGE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOC_EXCH_PART
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_PART FOREIGN KEY (EXCHANGE_ID_) REFERENCES FLW_HI_AGENT_INVOCATION_EXCH (ID_);
    
DROP TABLE FLW_AGENT_INSTANCE_EXCHANGE;
DROP TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE;

update ACT_GE_PROPERTY set VALUE_ = '2' where NAME_ = 'agent.schema.version';

