

CREATE TABLE [FLW_ID_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_ID_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_ID_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_ID_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_ID_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:48:52.666' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_ID_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_ID_PROPERTY] ([NAME_] [nvarchar](64) NOT NULL, [VALUE_] [nvarchar](300), [REV_] [int] NOT NULL, CONSTRAINT [PK_FLW_ID_PROPERTY] PRIMARY KEY ([NAME_]))

CREATE TABLE [FLW_ID_GROUP] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [NAME_] [nvarchar](255), [TYPE_] [nvarchar](255), CONSTRAINT [PK_FLW_ID_GROUP] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_USER] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [USER_DEFINITION_ID_] [nvarchar](64), [SYSTEM_ID_] [nvarchar](255), [STATE_] [nvarchar](255), [SYSTEM_TYPE_] [nvarchar](255), [FIRST_] [nvarchar](255), [LAST_] [nvarchar](255), [DISPLAY_NAME_] [nvarchar](255), [EMAIL_] [nvarchar](255), [PWD_] [nvarchar](255), [TENANT_ID_] [nvarchar](255) CONSTRAINT [DF_FLW_ID_USER_TENANT_ID_] DEFAULT '', CONSTRAINT [PK_FLW_ID_USER] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_MEMBERSHIP] ([USER_ID_] [nvarchar](64) NOT NULL, [GROUP_ID_] [nvarchar](64) NOT NULL, CONSTRAINT [PK_FLW_ID_MEMBERSHIP] PRIMARY KEY ([USER_ID_], [GROUP_ID_]))

CREATE TABLE [FLW_ID_USER_DEFINITIONS] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [NAME_] [nvarchar](128), [KEY_] [nvarchar](128), [SUB_TYPE_] [nvarchar](128), [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_ID_USER_DEFINITIONS_TENANT_ID_] DEFAULT '', [CREATION_TIME_] [datetime2](6) NOT NULL, [CREATOR_ID_] [nvarchar](64) NOT NULL, [UPDATE_TIME_] [datetime2](6), [UPDATER_ID_] [nvarchar](64), [DEFINITION_CONTENT_] [nvarchar](MAX), CONSTRAINT [PK_ID_USER_DEFINITIONS] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_INFO] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [USER_ID_] [nvarchar](64), [TYPE_] [nvarchar](64), [KEY_] [nvarchar](255), [VALUE_] [nvarchar](255), [PASSWORD_] [varbinary](MAX), [PARENT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_ID_INFO] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_IDENTITY_INFO] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [TYPE_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255) NOT NULL, [SCOPE_ID_] [nvarchar](255), [SUB_SCOPE_ID_] [nvarchar](255), [SCOPE_TYPE_] [nvarchar](255), [DOUBLE_] [float](53), [LONG_] [bigint], [TEXT_] [nvarchar](4000), [TEXT2_] [nvarchar](4000), CONSTRAINT [PK_FLW_IDENTITY_INFO] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_TOKEN] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [TOKEN_VALUE_] [nvarchar](255), [TOKEN_DATE_] [datetime2](6), [IP_ADDRESS_] [nvarchar](255), [USER_AGENT_] [nvarchar](255), [USER_ID_] [nvarchar](255), [TOKEN_DATA_] [nvarchar](2000), CONSTRAINT [PK_FLW_ID_TOKEN] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_PRIV] ([ID_] [nvarchar](64) NOT NULL, [NAME_] [nvarchar](255) NOT NULL, CONSTRAINT [PK_FLW_ID_PRIV] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_PRIV_MAPPING] ([ID_] [nvarchar](64) NOT NULL, [PRIV_ID_] [nvarchar](64) NOT NULL, [USER_ID_] [nvarchar](255), [GROUP_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_ID_PRIV_MAPPING] PRIMARY KEY ([ID_]))

CREATE NONCLUSTERED INDEX FLW_IDX_IDM_INFO_SCOPE_ID_TYPE ON [FLW_IDENTITY_INFO]([SCOPE_ID_], [SCOPE_TYPE_])

CREATE NONCLUSTERED INDEX FLW_IDX_MEMB_GROUP ON [FLW_ID_MEMBERSHIP]([GROUP_ID_])

ALTER TABLE [FLW_ID_MEMBERSHIP] ADD CONSTRAINT [FLW_FK_MEMB_GROUP] FOREIGN KEY ([GROUP_ID_]) REFERENCES [FLW_ID_GROUP] ([ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_MEMB_USER ON [FLW_ID_MEMBERSHIP]([USER_ID_])

ALTER TABLE [FLW_ID_MEMBERSHIP] ADD CONSTRAINT [FLW_FK_MEMB_USER] FOREIGN KEY ([USER_ID_]) REFERENCES [FLW_ID_USER] ([ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_PRIV_MAPPING ON [FLW_ID_PRIV_MAPPING]([PRIV_ID_])

ALTER TABLE [FLW_ID_PRIV_MAPPING] ADD CONSTRAINT [FLW_FK_PRIV_MAPPING] FOREIGN KEY ([PRIV_ID_]) REFERENCES [FLW_ID_PRIV] ([ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_PRIV_USER ON [FLW_ID_PRIV_MAPPING]([USER_ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_PRIV_GROUP ON [FLW_ID_PRIV_MAPPING]([GROUP_ID_])

ALTER TABLE [FLW_ID_PRIV] ADD CONSTRAINT [FLW_UNIQ_PRIV_NAME] UNIQUE ([NAME_])

CREATE NONCLUSTERED INDEX FLW_IDX_USER_SYSTEM ON [FLW_ID_USER]([SYSTEM_ID_], [SYSTEM_TYPE_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 1, '7:05ba195724a17e7fdcb4b9891afdd59a', 'createTable tableName=FLW_ID_PROPERTY; createTable tableName=FLW_ID_GROUP; createTable tableName=FLW_ID_USER; createTable tableName=FLW_ID_MEMBERSHIP; createTable tableName=FLW_ID_USER_DEFINITIONS; createTable tableName=FLW_ID_INFO; createTable ta...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

CREATE NONCLUSTERED INDEX FLW_IDX_USER_USER_DEF ON [FLW_ID_USER]([USER_DEFINITION_ID_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 2, '7:40704c0abe6e375c21447558e4b6489c', 'createIndex indexName=FLW_IDX_USER_USER_DEF, tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_USER] ADD [SUB_STATE_] [nvarchar](255)

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('3', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 3, '7:b2cc2a8d2deb8d22541f4b805c2bd1d7', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_USER] ADD [CREATOR_ID_] [nvarchar](64)

ALTER TABLE [FLW_ID_USER] ADD [CREATION_TIME_] [datetime2](6)

ALTER TABLE [FLW_ID_USER] ADD [UPDATER_ID_] [nvarchar](64)

ALTER TABLE [FLW_ID_USER] ADD [UPDATE_TIME_] [datetime2](6)

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('4', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 4, '7:cbe0eb742f321d23f63bedda479c1490', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

CREATE NONCLUSTERED INDEX FLW_IDX_USER_CREATE_TIME ON [FLW_ID_USER]([CREATION_TIME_])

CREATE NONCLUSTERED INDEX FLW_IDX_USER_UPDATE_TIME ON [FLW_ID_USER]([UPDATE_TIME_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('5', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 5, '7:abd1224a027b2cc45a14e4f1d22eefe4', 'createIndex indexName=FLW_IDX_USER_CREATE_TIME, tableName=FLW_ID_USER; createIndex indexName=FLW_IDX_USER_UPDATE_TIME, tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_IDENTITY_INFO] ADD [USER_ID_] [nvarchar](64)

ALTER TABLE [FLW_IDENTITY_INFO] ADD [GROUP_ID_] [nvarchar](64)

ALTER TABLE [FLW_IDENTITY_INFO] ADD CONSTRAINT [FK_IDENTITY_INFO_ID_USER] FOREIGN KEY ([USER_ID_]) REFERENCES [FLW_ID_USER] ([ID_]) ON UPDATE NO ACTION ON DELETE CASCADE

ALTER TABLE [FLW_IDENTITY_INFO] ADD CONSTRAINT [FK_IDENTITY_INFO_ID_GROUP] FOREIGN KEY ([GROUP_ID_]) REFERENCES [FLW_ID_GROUP] ([ID_]) ON UPDATE NO ACTION ON DELETE CASCADE

UPDATE FLW_IDENTITY_INFO SET USER_ID_ = SCOPE_ID_

DROP INDEX FLW_IDX_IDM_INFO_SCOPE_ID_TYPE ON [FLW_IDENTITY_INFO]

ALTER TABLE [FLW_IDENTITY_INFO] DROP COLUMN [SCOPE_ID_]

ALTER TABLE [FLW_IDENTITY_INFO] DROP COLUMN [SCOPE_TYPE_]

ALTER TABLE [FLW_IDENTITY_INFO] DROP COLUMN [SUB_SCOPE_ID_]

CREATE NONCLUSTERED INDEX FLW_IDX_IDM_INFO_USER_ID ON [FLW_IDENTITY_INFO]([USER_ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_IDM_INFO_GROUP_ID ON [FLW_IDENTITY_INFO]([GROUP_ID_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('6', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 6, '7:33a6f1b6195df313d538e2dc958ed956', 'addColumn tableName=FLW_IDENTITY_INFO; addForeignKeyConstraint baseTableName=FLW_IDENTITY_INFO, constraintName=FK_IDENTITY_INFO_ID_USER, referencedTableName=FLW_ID_USER; addForeignKeyConstraint baseTableName=FLW_IDENTITY_INFO, constraintName=FK_ID...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_USER_DEFINITIONS] ALTER COLUMN [CREATOR_ID_] [nvarchar](64) NULL

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('7', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 7, '7:ff69c2f890a0607c31992a36676f9972', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ID_USER_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_USER] ADD [AVATAR_ID_] [nvarchar](255)

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('8', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 8, '7:df637d40a416c8ebaa382896ad288316', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_USER] ADD [PRESENCE_] [nvarchar](255)

ALTER TABLE [FLW_ID_USER] ADD [PRESENCE_TIME_] [datetime2](6)

ALTER TABLE [FLW_ID_USER] ADD [TYPE_] [nvarchar](64)

ALTER TABLE [FLW_ID_USER] ADD [SUB_TYPE_] [nvarchar](64)

ALTER TABLE [FLW_ID_USER] ADD [LANGUAGE_] [nvarchar](64)

ALTER TABLE [FLW_ID_USER] ADD [THEME_] [nvarchar](64)

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('9', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 9, '7:b0415e93ce444caa71cff2d045b0ca7d', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

CREATE TABLE [FLW_ID_USER_ACCOUNT_DEFINITION] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [NAME_] [nvarchar](128), [KEY_] [nvarchar](128), [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_ID_USER_ACCOUNT_DEFINITION_TENANT_ID_] DEFAULT '', [CREATION_TIME_] [datetime2](6) NOT NULL, [CREATOR_ID_] [nvarchar](64), [UPDATE_TIME_] [datetime2](6), [UPDATER_ID_] [nvarchar](64), [DEFINITION_CONTENT_] [nvarchar](MAX), CONSTRAINT [PK_ID_USER_ACCOUNT_DEFINITION] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ID_USER_ACCOUNT] ([ID_] [nvarchar](64) NOT NULL, [REV_] [int] NOT NULL, [USER_ID_] [nvarchar](64), [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_ID_USER_ACCOUNT_TENANT_ID_] DEFAULT '', [NAME_] [nvarchar](255), [TYPE_] [nvarchar](64), [SUB_TYPE_] [nvarchar](64), [STATE_] [nvarchar](64), [SUB_STATE_] [nvarchar](64), [BUSINESS_ACCOUNT_ID_] [nvarchar](255), [EXTERNAL_USER_ID_] [nvarchar](255), [USER_ACCOUNT_DEFINITION_ID_] [nvarchar](64), [CREATOR_ID_] [nvarchar](64), [CREATION_TIME_] [datetime2](6) NOT NULL, [UPDATER_ID_] [nvarchar](64), [UPDATE_TIME_] [datetime2](6), CONSTRAINT [PK_FLW_ID_USER_ACCOUNT] PRIMARY KEY ([ID_]), CONSTRAINT [FK_ID_USER_ACCOUNT_USER_DEF] FOREIGN KEY ([USER_ACCOUNT_DEFINITION_ID_]) REFERENCES [FLW_ID_USER_ACCOUNT_DEFINITION]([ID_]), CONSTRAINT [FK_ID_USER_ACCOUNT_USER] FOREIGN KEY ([USER_ID_]) REFERENCES [FLW_ID_USER]([ID_]) ON DELETE CASCADE)

CREATE NONCLUSTERED INDEX IDX_USER_ACC_TYPE_SUB_EXT_USER ON [FLW_ID_USER_ACCOUNT]([TYPE_], [SUB_TYPE_], [EXTERNAL_USER_ID_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('10', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 10, '7:63ff4c02ee0aaed812363c10eda65679', 'createTable tableName=FLW_ID_USER_ACCOUNT_DEFINITION; createTable tableName=FLW_ID_USER_ACCOUNT; createIndex indexName=IDX_USER_ACC_TYPE_SUB_EXT_USER, tableName=FLW_ID_USER_ACCOUNT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

CREATE NONCLUSTERED INDEX IDX_USER_ACCOUNT_USER ON [FLW_ID_USER_ACCOUNT]([USER_ID_])

CREATE NONCLUSTERED INDEX IDX_USER_ACCOUNT_USER_DEF ON [FLW_ID_USER_ACCOUNT]([USER_ACCOUNT_DEFINITION_ID_])

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('11', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 11, '7:771d3901ac8fa6a55f2c155986a3bc60', 'createIndex indexName=IDX_USER_ACCOUNT_USER, tableName=FLW_ID_USER_ACCOUNT; createIndex indexName=IDX_USER_ACCOUNT_USER_DEF, tableName=FLW_ID_USER_ACCOUNT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

UPDATE U
            SET U.SUB_TYPE_ = (SELECT DEF.SUB_TYPE_ FROM FLW_ID_USER_DEFINITIONS DEF WHERE DEF.ID_ = U.USER_DEFINITION_ID_)
            FROM FLW_ID_USER U
            WHERE U.USER_DEFINITION_ID_ IS NOT NULL

ALTER TABLE [FLW_ID_USER_DEFINITIONS] DROP COLUMN [SUB_TYPE_]

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('12', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 12, '7:e743654b5fdbb9899a771561fc554ca9', 'sql; dropColumn columnName=SUB_TYPE_, tableName=FLW_ID_USER_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

ALTER TABLE [FLW_ID_GROUP] ADD [KEY_] [nvarchar](64) CONSTRAINT DF_FLW_ID_GROUP_KEY_ DEFAULT ''

ALTER TABLE [FLW_ID_GROUP] ADD [TENANT_ID_] [nvarchar](255) CONSTRAINT DF_FLW_ID_GROUP_TENANT_ID_ DEFAULT ''

UPDATE FLW_ID_GROUP SET KEY_ = ID_

UPDATE FLW_ID_USER_DEFINITIONS set TENANT_ID_ = ''

UPDATE FLW_ID_USER_ACCOUNT set TENANT_ID_ = ''

INSERT INTO [FLW_ID_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('13', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', GETDATE(), 13, '7:a5494e2f25fb46924684473aeb829ce7', 'addColumn tableName=FLW_ID_GROUP; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633333295')

UPDATE [FLW_ID_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1



CREATE TABLE [FLW_FO_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_FO_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_FO_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_FO_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_FO_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:49:08.321' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_FO_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_FO_FORM_DEPLOYMENT] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255), [CATEGORY_] [varchar](255), [DEPLOY_TIME_] [datetime], [TENANT_ID_] [varchar](255), [PARENT_DEPLOYMENT_ID_] [varchar](255), CONSTRAINT [PK_FLW_FO_FORM_DEPLOYMENT] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_FO_FORM_RESOURCE] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255), [DEPLOYMENT_ID_] [varchar](255), [RESOURCE_BYTES_] [varbinary](MAX), CONSTRAINT [PK_FLW_FO_FORM_RESOURCE] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_FO_FORM_DEFINITION] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255), [VERSION_] [int], [KEY_] [varchar](255), [CATEGORY_] [varchar](255), [DEPLOYMENT_ID_] [varchar](255), [PARENT_DEPLOYMENT_ID_] [varchar](255), [TENANT_ID_] [varchar](255), [RESOURCE_NAME_] [varchar](255), [DESCRIPTION_] [varchar](255), CONSTRAINT [PK_FLW_FO_FORM_DEFINITION] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_FO_FORM_INSTANCE] ([ID_] [varchar](255) NOT NULL, [FORM_DEFINITION_ID_] [varchar](255) NOT NULL, [TASK_ID_] [varchar](255), [PROC_INST_ID_] [varchar](255), [PROC_DEF_ID_] [varchar](255), [SUBMITTED_DATE_] [datetime], [SUBMITTED_BY_] [varchar](255), [FORM_VALUES_ID_] [varchar](255), [TENANT_ID_] [varchar](255), CONSTRAINT [PK_FLW_FO_FORM_INSTANCE] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_FO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', GETDATE(), 1, '7:525fa509c296a5eb09a3397fbce39466', 'createTable tableName=FLW_FO_FORM_DEPLOYMENT; createTable tableName=FLW_FO_FORM_RESOURCE; createTable tableName=FLW_FO_FORM_DEFINITION; createTable tableName=FLW_FO_FORM_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633348414')

ALTER TABLE [FLW_FO_FORM_INSTANCE] ADD [SCOPE_ID_] [varchar](255)

ALTER TABLE [FLW_FO_FORM_INSTANCE] ADD [SCOPE_TYPE_] [varchar](255)

ALTER TABLE [FLW_FO_FORM_INSTANCE] ADD [SCOPE_DEFINITION_ID_] [varchar](255)

INSERT INTO [FLW_FO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', GETDATE(), 2, '7:99bcac2aa557db19014b7be2bc669ce7', 'addColumn tableName=FLW_FO_FORM_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633348414')

ALTER TABLE [FLW_FO_FORM_DEFINITION] DROP COLUMN [PARENT_DEPLOYMENT_ID_]

INSERT INTO [FLW_FO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('3', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', GETDATE(), 3, '7:6c08be805ae55bc0ec5756ee58b7fc90', 'dropColumn columnName=PARENT_DEPLOYMENT_ID_, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633348414')

CREATE UNIQUE NONCLUSTERED INDEX ACT_IDX_FORM_DEF_UNIQ ON [FLW_FO_FORM_DEFINITION]([KEY_], [VERSION_], [TENANT_ID_])

INSERT INTO [FLW_FO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('5', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', GETDATE(), 4, '7:31d5d350673c835ae9d7d77f3792b8d4', 'createIndex indexName=ACT_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633348414')

DROP INDEX ACT_IDX_FORM_DEF_UNIQ ON [FLW_FO_FORM_DEFINITION]

CREATE UNIQUE NONCLUSTERED INDEX FLW_IDX_FORM_DEF_UNIQ ON [FLW_FO_FORM_DEFINITION]([KEY_], [VERSION_], [TENANT_ID_])

INSERT INTO [FLW_FO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('6', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', GETDATE(), 5, '7:e9f5867270835c1fcc3cc409e342c0ef', 'dropIndex indexName=ACT_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION; createIndex indexName=FLW_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633348414')

UPDATE [FLW_FO_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1



CREATE TABLE [FLW_CO_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_CO_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_CO_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_CO_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_CO_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:49:15.535' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_CO_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_CO_CONTENT_ITEM] ([ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255) NOT NULL, [MIME_TYPE_] [varchar](255), [TASK_ID_] [varchar](255), [PROC_INST_ID_] [varchar](255), [CONTENT_STORE_ID_] [varchar](255), [CONTENT_STORE_NAME_] [varchar](255), [FIELD_] [varchar](400), [CONTENT_AVAILABLE_] [bit] CONSTRAINT [DF_FLW_CO_CONTENT_ITEM_CONTENT_AVAILABLE_] DEFAULT 0, [CREATED_] [datetime], [CREATED_BY_] [varchar](255), [LAST_MODIFIED_] [datetime], [LAST_MODIFIED_BY_] [varchar](255), [CONTENT_SIZE_] [bigint] CONSTRAINT [DF_FLW_CO_CONTENT_ITEM_CONTENT_SIZE_] DEFAULT 0, [TENANT_ID_] [varchar](255), CONSTRAINT [PK_FLW_CO_CONTENT_ITEM] PRIMARY KEY ([ID_]))

CREATE NONCLUSTERED INDEX idx_contitem_taskid ON [FLW_CO_CONTENT_ITEM]([TASK_ID_])

CREATE NONCLUSTERED INDEX idx_contitem_procid ON [FLW_CO_CONTENT_ITEM]([PROC_INST_ID_])

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 1, '7:6e7a92ae97a9c5ad391a6d518f225887', 'createTable tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_taskid, tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_procid, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [SCOPE_ID_] [varchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [SCOPE_TYPE_] [varchar](255)

CREATE NONCLUSTERED INDEX idx_contitem_scope ON [FLW_CO_CONTENT_ITEM]([SCOPE_ID_], [SCOPE_TYPE_])

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 2, '7:145f5d28f0c1f0acc639d0dd905917fc', 'addColumn tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_scope, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

CREATE TABLE [FLW_CO_RENDITION_ITEM] ([ID_] [varchar](255) NOT NULL, [CONTENT_ITEM_ID_] [varchar](255) NOT NULL, [NAME_] [varchar](255) NOT NULL, [MIME_TYPE_] [varchar](255), [TASK_ID_] [varchar](255), [PROC_INST_ID_] [varchar](255), [CONTENT_STORE_ID_] [varchar](255), [CONTENT_STORE_NAME_] [varchar](255), [CONTENT_AVAILABLE_] [bit] CONSTRAINT [DF_FLW_CO_RENDITION_ITEM_CONTENT_AVAILABLE_] DEFAULT 0, [CREATED_] [datetime], [LAST_MODIFIED_] [datetime], [CONTENT_SIZE_] [bigint] CONSTRAINT [DF_FLW_CO_RENDITION_ITEM_CONTENT_SIZE_] DEFAULT 0, [TENANT_ID_] [varchar](255), [SCOPE_ID_] [varchar](255), [SCOPE_TYPE_] [varchar](255), CONSTRAINT [PK_FLW_CO_RENDITION_ITEM] PRIMARY KEY ([ID_]))

CREATE NONCLUSTERED INDEX idx_rendition_taskid ON [FLW_CO_RENDITION_ITEM]([TASK_ID_])

CREATE NONCLUSTERED INDEX idx_rendition_procid ON [FLW_CO_RENDITION_ITEM]([PROC_INST_ID_])

CREATE NONCLUSTERED INDEX idx_rendition_scope ON [FLW_CO_RENDITION_ITEM]([SCOPE_ID_], [SCOPE_TYPE_])

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('3', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 3, '7:7b29eaf43fac87a767fcb9e2a19016b3', 'createTable tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_taskid, tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_procid, tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_scope, table...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

ALTER TABLE [FLW_CO_CONTENT_ITEM] DROP COLUMN [FIELD_]

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('4', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 4, '7:f85c5a823734966db4c0a5d972b29620', 'dropColumn columnName=FIELD_, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

CREATE TABLE [FLW_CO_CONTENT_OBJECT] ([ID_] [varchar](255) NOT NULL, [CREATED_] [datetime], [CONTENT_] [varbinary](MAX), CONSTRAINT [PK_FLW_CO_CONTENT_OBJECT] PRIMARY KEY ([ID_]))

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [LOCK_INFO_] [varchar](255)

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('5', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 5, '7:244196650fb5485babd5fd9e384b373a', 'createTable tableName=FLW_CO_CONTENT_OBJECT; addColumn tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

ALTER TABLE [FLW_CO_RENDITION_ITEM] ADD [RENDITION_TYPE_] [varchar](255)

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('6', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 6, '7:28652b75e4fe380d4690dd452dc51b96', 'addColumn tableName=FLW_CO_RENDITION_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

CREATE TABLE [FLW_CO_DEPLOYMENT] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [KEY_] [nvarchar](255), [CATEGORY_] [nvarchar](255), [DEPLOY_TIME_] [datetime], [TENANT_ID_] [nvarchar](255), [PARENT_DEPLOYMENT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_CO_DEPLOYMENT] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_CO_DEPLOYMENT_RESOURCE] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [DEPLOYMENT_ID_] [nvarchar](255), [RESOURCE_BYTES_] [varbinary](MAX), CONSTRAINT [PK_FLW_CO_DEPLOYMENT_RESOURCE] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_CO_DEFINITION] ([ID_] [nvarchar](255) NOT NULL, [REV_] [int] NOT NULL, [KEY_] [nvarchar](128), [DEPLOYMENT_ID_] [nvarchar](255) NOT NULL, [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_CO_DEFINITION_TENANT_ID_] DEFAULT '', [NAME_] [nvarchar](128), [VERSION_] [int], [RESOURCE_NAME_] [nvarchar](4000), [CATEGORY_] [nvarchar](255), [CREATION_TIME_] [datetime2](6) NOT NULL, [UPDATE_TIME_] [datetime2](6), CONSTRAINT [PK_CO_DEFINITIONS] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('7', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 7, '7:f5c080c2d7c1a5863fca0894a370ff0d', 'createTable tableName=FLW_CO_DEPLOYMENT; createTable tableName=FLW_CO_DEPLOYMENT_RESOURCE; createTable tableName=FLW_CO_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

CREATE TABLE [FLW_CO_METADATA] ([ID_] [nvarchar](255) NOT NULL, [REV_] [int] NOT NULL, [TYPE_] [nvarchar](255), [NAME_] [nvarchar](255), [CONTENT_ITEM_ID_] [nvarchar](255), [BYTEARRAY_ID_] [nvarchar](255), [DOUBLE_] [float](53), [LONG_] [bigint], [TEXT_] [nvarchar](4000), [TEXT2_] [nvarchar](4000), CONSTRAINT [PK_FLW_CO_METADATA] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('8', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 8, '7:88114bd1be5f921edf5534255178889d', 'createTable tableName=FLW_CO_METADATA', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [VERSION_] [int]

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [VERSION_INFO_] [nvarchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [VERSION_PARENT_ID_] [nvarchar](255)

UPDATE FLW_CO_CONTENT_ITEM SET VERSION_ = 1

UPDATE FLW_CO_CONTENT_ITEM SET VERSION_PARENT_ID_ = ID_

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('9', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 9, '7:9c077298eced03901ce15ffffb867dc4', 'addColumn tableName=FLW_CO_CONTENT_ITEM; sql; sql', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [DEFINITION_ID_] [nvarchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [TYPE_] [nvarchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [SUB_TYPE_] [nvarchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [STATE_] [nvarchar](255)

ALTER TABLE [FLW_CO_CONTENT_ITEM] ADD [SUB_STATE_] [nvarchar](255)

INSERT INTO [FLW_CO_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('10', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', GETDATE(), 10, '7:f4252c6e065037bbdae37489b89ae73a', 'addColumn tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633355631')

UPDATE [FLW_CO_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1



CREATE TABLE [FLW_AD_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_AD_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_AD_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_AD_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_AD_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:49:23.129' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_AD_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_ACTION_DEPLOYMENT] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [KEY_] [nvarchar](255), [CATEGORY_] [nvarchar](255), [DEPLOY_TIME_] [datetime], [TENANT_ID_] [nvarchar](255), [PARENT_DEPLOYMENT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_ACTION_DEPLOYMENT] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ACTION_DEPLOYMENT_RESOURCE] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [DEPLOYMENT_ID_] [nvarchar](255), [RESOURCE_BYTES_] [varbinary](MAX), CONSTRAINT [PK_FLW_ACTION_DEPLOYMENT_RESOURCE] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ACTION_DEFINITION] ([ID_] [nvarchar](255) NOT NULL, [REV_] [int] NOT NULL, [KEY_] [nvarchar](128), [DEPLOYMENT_ID_] [nvarchar](255) NOT NULL, [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_ACTION_DEFINITION_TENANT_ID_] DEFAULT '', [BOT_KEY_] [nvarchar](128), [MANDATORY_] [bit], [NAME_] [nvarchar](128), [VERSION_] [int], [RESOURCE_NAME_] [nvarchar](4000), [SCOPE_TYPE_] [nvarchar](128), [FORM_KEY_] [nvarchar](128), [GLOBAL_] [bit], [CREATION_TIME_] [datetime2](6) NOT NULL, [CREATOR_ID_] [nvarchar](64) NOT NULL, [UPDATE_TIME_] [datetime2](6), [UPDATER_ID_] [nvarchar](64), CONSTRAINT [PK_ACTION_DEFINITIONS] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_ACTION_DEF_LINKS] ([ID_] [nvarchar](64) NOT NULL, [ACTION_DEFINITION_ID_] [nvarchar](255) NOT NULL, [REFERENCE_ID_] [nvarchar](255) NOT NULL, [REFERENCE_TYPE_] [nvarchar](255) NOT NULL, [REFERENCE_DEFINITION_TYPE_] [nvarchar](255), CONSTRAINT [PK_ACTION_DEF_LINKS] PRIMARY KEY ([ID_]), CONSTRAINT [FK_ACTION_DEF_LINK_ACTION_DEFS] FOREIGN KEY ([ACTION_DEFINITION_ID_]) REFERENCES [FLW_ACTION_DEFINITION]([ID_]))

CREATE TABLE [FLW_ACTION_INSTANCE] ([ID_] [nvarchar](255) NOT NULL, [ACTION_DEFINITION_ID_] [nvarchar](255) NOT NULL, [START_DATE_] [datetime2](6), [EXECUTION_DATE_] [datetime2](6), [EXECUTED_BY_] [nvarchar](255), [FORM_INSTANCE_ID_] [nvarchar](255), [SCOPE_DEFINITION_ID_] [nvarchar](255), [SCOPE_ID_] [nvarchar](255), [SCOPE_TYPE_] [nvarchar](255), [TENANT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_ACTION_INSTANCE] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 1, '7:c55db757c8da981f1eba144d84f3b710', 'createTable tableName=FLW_ACTION_DEPLOYMENT; createTable tableName=FLW_ACTION_DEPLOYMENT_RESOURCE; createTable tableName=FLW_ACTION_DEFINITION; createTable tableName=FLW_ACTION_DEF_LINKS; createTable tableName=FLW_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE TABLE [FLW_ACTION_LINK] ([ID_] [nvarchar](255) NOT NULL, [ACTION_INSTANCE_ID_] [nvarchar](255) NOT NULL, [ACTION_DEFINITION_ID_] [nvarchar](255) NOT NULL, [SCOPE_ID_] [nvarchar](255) NOT NULL, [SCOPE_TYPE_] [nvarchar](255) NOT NULL, [CREATION_TIME_] [datetime2](6), CONSTRAINT [PK_FLW_ACTION_LINK] PRIMARY KEY ([ID_]), CONSTRAINT [FK_ACTION_LINK_ACTION_INST] FOREIGN KEY ([ACTION_INSTANCE_ID_]) REFERENCES [FLW_ACTION_INSTANCE]([ID_]), CONSTRAINT [FK_ACTION_LINK_ACTION_DEF] FOREIGN KEY ([ACTION_DEFINITION_ID_]) REFERENCES [FLW_ACTION_DEFINITION]([ID_]))

CREATE NONCLUSTERED INDEX FLW_IDX_ACTION_LINK_SCOPE ON [FLW_ACTION_LINK]([SCOPE_ID_], [SCOPE_TYPE_])

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 2, '7:5e4bff32ad35b7ff3225af7367fee0a4', 'createTable tableName=FLW_ACTION_LINK; createIndex indexName=FLW_IDX_ACTION_LINK_SCOPE, tableName=FLW_ACTION_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

ALTER TABLE [FLW_ACTION_DEFINITION] ADD CONSTRAINT [FK_ACTION_DEF_DEPLOYMENT] FOREIGN KEY ([DEPLOYMENT_ID_]) REFERENCES [FLW_ACTION_DEPLOYMENT] ([ID_])

ALTER TABLE [FLW_ACTION_INSTANCE] ADD CONSTRAINT [FK_ACTION_INST_ACTION_DEF] FOREIGN KEY ([ACTION_DEFINITION_ID_]) REFERENCES [FLW_ACTION_DEFINITION] ([ID_])

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('3', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 3, '7:5ed72e935faee78950edec7accaa7ddf', 'addForeignKeyConstraint baseTableName=FLW_ACTION_DEFINITION, constraintName=FK_ACTION_DEF_DEPLOYMENT, referencedTableName=FLW_ACTION_DEPLOYMENT; addForeignKeyConstraint baseTableName=FLW_ACTION_INSTANCE, constraintName=FK_ACTION_INST_ACTION_DEF, r...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE NONCLUSTERED INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON [FLW_ACTION_DEF_LINKS]([ACTION_DEFINITION_ID_])

CREATE NONCLUSTERED INDEX IDX_ACTION_LINK_ACTION_INST ON [FLW_ACTION_LINK]([ACTION_INSTANCE_ID_])

CREATE NONCLUSTERED INDEX ACTION_DEFINITION_ID_ ON [FLW_ACTION_LINK]([ACTION_DEFINITION_ID_])

CREATE NONCLUSTERED INDEX IDX_ACTION_DEF_DEPLOYMENT ON [FLW_ACTION_DEFINITION]([DEPLOYMENT_ID_])

CREATE NONCLUSTERED INDEX IDX_ACTION_INST_ACTION_DEF ON [FLW_ACTION_INSTANCE]([ACTION_DEFINITION_ID_])

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('4', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 4, '7:d9f08bc7d96af83ed124d0b929b50a8f', 'createIndex indexName=IDX_ACTION_DEF_LINK_ACTION_DEF, tableName=FLW_ACTION_DEF_LINKS; createIndex indexName=IDX_ACTION_LINK_ACTION_INST, tableName=FLW_ACTION_LINK; createIndex indexName=ACTION_DEFINITION_ID_, tableName=FLW_ACTION_LINK; createIndex...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE TABLE [FLW_HI_ACTION_INSTANCE] ([ID_] [nvarchar](255) NOT NULL, [ACTION_DEFINITION_ID_] [nvarchar](255) NOT NULL, [START_DATE_] [datetime2](6), [EXECUTION_DATE_] [datetime2](6), [EXECUTED_BY_] [nvarchar](255), [FORM_INSTANCE_ID_] [nvarchar](255), [SCOPE_DEFINITION_ID_] [nvarchar](255), [SCOPE_ID_] [nvarchar](255), [SCOPE_TYPE_] [nvarchar](255), [TENANT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_HI_ACTION_INSTANCE] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_HI_ACTION_LINK] ([ID_] [nvarchar](255) NOT NULL, [ACTION_INSTANCE_ID_] [nvarchar](255), [ACTION_DEFINITION_ID_] [nvarchar](255), [SCOPE_ID_] [nvarchar](255) NOT NULL, [SCOPE_TYPE_] [nvarchar](255) NOT NULL, [CREATION_TIME_] [datetime2](6), CONSTRAINT [PK_FLW_HI_ACTION_LINK] PRIMARY KEY ([ID_]))

CREATE NONCLUSTERED INDEX FLW_IDX_HI_ACTION_LINK_SCOPE ON [FLW_HI_ACTION_LINK]([SCOPE_ID_], [SCOPE_TYPE_])

CREATE NONCLUSTERED INDEX IDX_HI_ACTION_LINK_ACTION_INST ON [FLW_HI_ACTION_LINK]([ACTION_INSTANCE_ID_])

CREATE NONCLUSTERED INDEX ACTION_HI_DEFINITION_ID_ ON [FLW_HI_ACTION_LINK]([ACTION_DEFINITION_ID_])

CREATE NONCLUSTERED INDEX IDX_HI_ACTION_INST_ACTION_DEF ON [FLW_HI_ACTION_INSTANCE]([ACTION_DEFINITION_ID_])

ALTER TABLE [FLW_ACTION_INSTANCE] DROP COLUMN [EXECUTED_BY_]

ALTER TABLE [FLW_ACTION_INSTANCE] DROP COLUMN [EXECUTION_DATE_]

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('5', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 5, '7:66b9b62359fe1aa30204f1cb67dfb89e', 'createTable tableName=FLW_HI_ACTION_INSTANCE; createTable tableName=FLW_HI_ACTION_LINK; createIndex indexName=FLW_IDX_HI_ACTION_LINK_SCOPE, tableName=FLW_HI_ACTION_LINK; createIndex indexName=IDX_HI_ACTION_LINK_ACTION_INST, tableName=FLW_HI_ACTION...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

ALTER TABLE [FLW_ACTION_DEFINITION] ALTER COLUMN [CREATOR_ID_] [nvarchar](64) NULL

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('6', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 6, '7:4cae759fbe513a78c08311e4e6afe518', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ACTION_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE TABLE [FLW_ACTION_DEF_LINK] ([ID_] [nvarchar](255) NOT NULL, [ACTION_DEFINITION_ID_] [nvarchar](255) NOT NULL, [TYPE_] [nvarchar](255) NOT NULL, [LINK_VALUE_] [nvarchar](255), CONSTRAINT [PK_FLW_ACTION_DEF_LINK] PRIMARY KEY ([ID_]), CONSTRAINT [FK_ACTION_DEF_LINK_ACTION_DEF] FOREIGN KEY ([ACTION_DEFINITION_ID_]) REFERENCES [FLW_ACTION_DEFINITION]([ID_]))

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('7', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 7, '7:be7cba73063cfb19d4cb40e52d3c4982', 'createTable tableName=FLW_ACTION_DEF_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

DROP TABLE [FLW_ACTION_DEF_LINKS]

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('8', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 8, '7:6ae84d090ccbb44f0cbd5c3c81862126', 'dropTable tableName=FLW_ACTION_DEF_LINKS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE NONCLUSTERED INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON [FLW_ACTION_DEF_LINK]([ACTION_DEFINITION_ID_])

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('9', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 9, '7:53cdd26bbb56f7cb69318514558fb0a5', 'createIndex indexName=IDX_ACTION_DEF_LINK_ACTION_DEF, tableName=FLW_ACTION_DEF_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

ALTER TABLE [FLW_ACTION_INSTANCE] ADD [SUB_SCOPE_ID_] [nvarchar](255)

ALTER TABLE [FLW_HI_ACTION_INSTANCE] ADD [SUB_SCOPE_ID_] [nvarchar](255)

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('10', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 10, '7:dc1ac89af31e4ac83f8205e0713f71f1', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

ALTER TABLE [FLW_ACTION_INSTANCE] ADD [NAME_] [nvarchar](255)

ALTER TABLE [FLW_HI_ACTION_INSTANCE] ADD [NAME_] [nvarchar](255)

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('11', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 11, '7:43c68b959bd5c7a66a2a6a97d1d2c7d8', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

CREATE UNIQUE NONCLUSTERED INDEX ACT_IDX_ACTIONs_DEF_UNIQ ON [FLW_ACTION_DEFINITION]([KEY_], [VERSION_], [TENANT_ID_])

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('12', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 12, '7:13987d51cfbbafac29c9a52d54ab8794', 'createIndex indexName=ACT_IDX_ACTIONs_DEF_UNIQ, tableName=FLW_ACTION_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

ALTER TABLE [FLW_ACTION_INSTANCE] ADD [FORM_KEY_] [nvarchar](128)

ALTER TABLE [FLW_HI_ACTION_INSTANCE] ADD [FORM_KEY_] [nvarchar](128)

INSERT INTO [FLW_AD_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('13', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', GETDATE(), 13, '7:a487774a4035eb4e2372ffee306cbd0b', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633363224')

UPDATE [FLW_AD_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1



CREATE TABLE [FLW_AU_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_AU_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_AU_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_AU_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_AU_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:49:31.017' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_AU_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_AUDIT_INSTANCE] ([ID_] [nvarchar](255) NOT NULL, [AUDIT_DEFINITION_ID_] [nvarchar](255), [CREATION_TIME_] [datetime2](6), [CREATOR_ID_] [nvarchar](255), [EXTERNAL_ID_] [nvarchar](255), [TYPE_] [nvarchar](255), [SUB_TYPE_] [nvarchar](255), [SCOPE_DEFINITION_ID_] [nvarchar](255), [SCOPE_ID_] [nvarchar](255), [SCOPE_TYPE_] [nvarchar](255), [PAYLOAD_] [nvarchar](MAX), [TENANT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_AUDIT_INSTANCE] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_AU_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/audit/db/liquibase/flowable-audit-db-changelog.xml', GETDATE(), 1, '7:767e7394eeb4ae22234f19dfa9cff00c', 'createTable tableName=FLW_AUDIT_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633371102')

CREATE NONCLUSTERED INDEX FLW_IDX_AUDIT_INST_DEF ON [FLW_AUDIT_INSTANCE]([AUDIT_DEFINITION_ID_])

CREATE NONCLUSTERED INDEX FLW_IDX_AUDIT_INST_TYPE ON [FLW_AUDIT_INSTANCE]([TYPE_])

CREATE NONCLUSTERED INDEX FLW_IDX_AUDIT_INST_SCOPE ON [FLW_AUDIT_INSTANCE]([SCOPE_ID_], [SCOPE_TYPE_])

CREATE NONCLUSTERED INDEX FLW_IDX_AUDIT_INST_CREATE ON [FLW_AUDIT_INSTANCE]([CREATION_TIME_])

INSERT INTO [FLW_AU_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/audit/db/liquibase/flowable-audit-db-changelog.xml', GETDATE(), 2, '7:698e1206d862b3398091ab054fd2c615', 'createIndex indexName=FLW_IDX_AUDIT_INST_DEF, tableName=FLW_AUDIT_INSTANCE; createIndex indexName=FLW_IDX_AUDIT_INST_TYPE, tableName=FLW_AUDIT_INSTANCE; createIndex indexName=FLW_IDX_AUDIT_INST_SCOPE, tableName=FLW_AUDIT_INSTANCE; createIndex inde...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633371102')

UPDATE [FLW_AU_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1



CREATE TABLE [FLW_TP_DATABASECHANGELOGLOCK] ([ID] [int] NOT NULL, [LOCKED] [bit] NOT NULL, [LOCKGRANTED] [datetime2](3), [LOCKEDBY] [nvarchar](255), CONSTRAINT [PK_FLW_TP_DATABASECHANGELOGLOCK] PRIMARY KEY ([ID]))

DELETE FROM [FLW_TP_DATABASECHANGELOGLOCK]

INSERT INTO [FLW_TP_DATABASECHANGELOGLOCK] ([ID], [LOCKED]) VALUES (1, 0)

UPDATE [FLW_TP_DATABASECHANGELOGLOCK] SET [LOCKED] = 1, [LOCKEDBY] = '192.168.10.1 (192.168.10.1)', [LOCKGRANTED] = '2019-03-26T21:49:37.768' WHERE [ID] = 1 AND [LOCKED] = 0

CREATE TABLE [FLW_TP_DATABASECHANGELOG] ([ID] [nvarchar](255) NOT NULL, [AUTHOR] [nvarchar](255) NOT NULL, [FILENAME] [nvarchar](255) NOT NULL, [DATEEXECUTED] [datetime2](3) NOT NULL, [ORDEREXECUTED] [int] NOT NULL, [EXECTYPE] [nvarchar](10) NOT NULL, [MD5SUM] [nvarchar](35), [DESCRIPTION] [nvarchar](255), [COMMENTS] [nvarchar](255), [TAG] [nvarchar](255), [LIQUIBASE] [nvarchar](20), [CONTEXTS] [nvarchar](255), [LABELS] [nvarchar](255), [DEPLOYMENT_ID] [nvarchar](10))

CREATE TABLE [FLW_TEMPL_DEPLOYMENT] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [KEY_] [nvarchar](255), [CATEGORY_] [nvarchar](255), [DEPLOY_TIME_] [datetime], [TENANT_ID_] [nvarchar](255), [PARENT_DEPLOYMENT_ID_] [nvarchar](255), CONSTRAINT [PK_FLW_TEMPL_DEPLOYMENT] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_TEMPL_DEPLOYMENT_RESOURCE] ([ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](255), [DEPLOYMENT_ID_] [nvarchar](255), [RESOURCE_BYTES_] [varbinary](MAX), CONSTRAINT [PK_FLW_TEMPL_DEPLOYMENT_RESOURCE] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_TEMPL_DEFINITION] ([ID_] [nvarchar](255) NOT NULL, [REV_] [int] NOT NULL, [KEY_] [nvarchar](128), [VERSION_] [int], [DEPLOYMENT_ID_] [nvarchar](255) NOT NULL, [NAME_] [nvarchar](128), [TYPE_] [nvarchar](128), [SUB_TYPE_] [nvarchar](128), [FORM_KEY_] [nvarchar](128), [RESOURCE_NAME_] [nvarchar](4000), [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_TEMPL_DEFINITION_TENANT_ID_] DEFAULT '', [CREATION_TIME_] [datetime2](6) NOT NULL, [CREATOR_ID_] [nvarchar](64) NOT NULL, [UPDATE_TIME_] [datetime2](6), [UPDATOR_ID_] [nvarchar](64), CONSTRAINT [PK_TEMPL_DEFINITIONS] PRIMARY KEY ([ID_]))

CREATE TABLE [FLW_TEMPL_VAR_DEFINITION] ([ID_] [nvarchar](255) NOT NULL, [REV_] [int] NOT NULL, [TEMPLATE_DEF_KEY_] [nvarchar](128), [VARIATION_KEY_] [nvarchar](128), [DEPLOYMENT_ID_] [nvarchar](255) NOT NULL, [VERSION_] [int], [VALID_FROM_] [datetime2](6), [VALID_TO_] [datetime2](6), [RESOURCE_NAME_] [nvarchar](4000), [EXTERNAL_ID_] [nvarchar](255), [CONTENT_ID_] [nvarchar](255), [TENANT_ID_] [nvarchar](64) CONSTRAINT [DF_FLW_TEMPL_VAR_DEFINITION_TENANT_ID_] DEFAULT '', [CREATION_TIME_] [datetime2](6) NOT NULL, [CREATOR_ID_] [nvarchar](64) NOT NULL, CONSTRAINT [PK_TEMPL_VAR_DEFINITIONS] PRIMARY KEY ([ID_]))

INSERT INTO [FLW_TP_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('1', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', GETDATE(), 1, '7:820035986a6d91042d9d576b7304e48e', 'createTable tableName=FLW_TEMPL_DEPLOYMENT; createTable tableName=FLW_TEMPL_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEMPL_DEFINITION; createTable tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633377855')

ALTER TABLE [FLW_TEMPL_VAR_DEFINITION] ADD [NAME_] [nvarchar](128)

INSERT INTO [FLW_TP_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('2', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', GETDATE(), 2, '7:e88768e7b69d2d95e8efb54b8a435b8b', 'addColumn tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633377855')

DELETE FROM [FLW_TEMPL_VAR_DEFINITION]

DELETE FROM [FLW_TEMPL_DEFINITION]

DELETE FROM [FLW_TEMPL_DEPLOYMENT_RESOURCE]

DELETE FROM [FLW_TEMPL_DEPLOYMENT]

INSERT INTO [FLW_TP_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('3', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', GETDATE(), 3, '7:9b7a62b3c7b157181009ca95f43e88a6', 'delete tableName=FLW_TEMPL_VAR_DEFINITION; delete tableName=FLW_TEMPL_DEFINITION; delete tableName=FLW_TEMPL_DEPLOYMENT_RESOURCE; delete tableName=FLW_TEMPL_DEPLOYMENT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633377855')

ALTER TABLE [FLW_TEMPL_DEFINITION] ALTER COLUMN [CREATOR_ID_] [nvarchar](64) NULL

ALTER TABLE [FLW_TEMPL_VAR_DEFINITION] ALTER COLUMN [CREATOR_ID_] [nvarchar](64) NULL

INSERT INTO [FLW_TP_DATABASECHANGELOG] ([ID], [AUTHOR], [FILENAME], [DATEEXECUTED], [ORDEREXECUTED], [MD5SUM], [DESCRIPTION], [COMMENTS], [EXECTYPE], [CONTEXTS], [LABELS], [LIQUIBASE], [DEPLOYMENT_ID]) VALUES ('4', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', GETDATE(), 4, '7:4a14d82028c4b87ce27a273d4b39561c', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_TEMPL_DEFINITION; dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3633377855')

UPDATE [FLW_TP_DATABASECHANGELOGLOCK] SET [LOCKED] = 0, [LOCKEDBY] = NULL, [LOCKGRANTED] = NULL WHERE [ID] = 1

