
CREATE TABLE FLW_INSP_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    TEST_MODEL_ID_ VARCHAR(255),
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    TEST_MODEL_ID_ VARCHAR(255) NOT NULL,
    START_DATE_ datetime(6) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    INSTANCE_CONTENT_ LONGTEXT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_USER_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    DISPLAY_NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    USER_DEF_CONTENT_ LONGTEXT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_TEST_MODEL (
    ID_ VARCHAR(255) NOT NULL,
    KEY_ VARCHAR(128) NULL,
    NAME_ VARCHAR(128) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    MODEL_CONTENT_ LONGTEXT NULL,
    CREATION_TIME_ datetime NULL,
    CREATOR_ID_ VARCHAR(255) NULL,
    END_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_)
);

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL (CREATOR_ID_);

CREATE TABLE FLW_INSP_META_MODEL (
    ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    META_MODEL_CONTENT_ LONGTEXT,
    CREATION_TIME_ datetime NULL,
    CREATOR_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL (TYPE_, SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('inspect.schema.version', '11', 1);

