
CREATE TABLE flw_id_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_ID_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_id_databasechangeloglock;

INSERT INTO flw_id_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_id_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:15.102' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_id_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_ID_PROPERTY (NAME_ VARCHAR(64) NOT NULL, VALUE_ VARCHAR(300), REV_ INT NOT NULL, CONSTRAINT PK_FLW_ID_PROPERTY PRIMARY KEY (NAME_));

CREATE TABLE FLW_ID_GROUP (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, NAME_ VARCHAR(255), TYPE_ VARCHAR(255), CONSTRAINT PK_FLW_ID_GROUP PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_USER (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, USER_DEFINITION_ID_ VARCHAR(64), SYSTEM_ID_ VARCHAR(255), STATE_ VARCHAR(255), SYSTEM_TYPE_ VARCHAR(255), FIRST_ VARCHAR(255), LAST_ VARCHAR(255), DISPLAY_NAME_ VARCHAR(255), EMAIL_ VARCHAR(255), PWD_ VARCHAR(255), TENANT_ID_ VARCHAR(255) DEFAULT '', CONSTRAINT PK_FLW_ID_USER PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_MEMBERSHIP (USER_ID_ VARCHAR(64) NOT NULL, GROUP_ID_ VARCHAR(64) NOT NULL, CONSTRAINT PK_FLW_ID_MEMBERSHIP PRIMARY KEY (USER_ID_, GROUP_ID_));

CREATE TABLE FLW_ID_USER_DEFINITIONS (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, NAME_ VARCHAR(128), KEY_ VARCHAR(128), SUB_TYPE_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), DEFINITION_CONTENT_ TEXT, CONSTRAINT PK_ID_USER_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_INFO (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, USER_ID_ VARCHAR(64), TYPE_ VARCHAR(64), KEY_ VARCHAR(255), VALUE_ VARCHAR(255), PASSWORD_ BYTEA, PARENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_ID_INFO PRIMARY KEY (ID_));

CREATE TABLE FLW_IDENTITY_INFO (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, TYPE_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NOT NULL, SCOPE_ID_ VARCHAR(255), SUB_SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), DOUBLE_ DOUBLE PRECISION, LONG_ BIGINT, TEXT_ VARCHAR(4000), TEXT2_ VARCHAR(4000), CONSTRAINT PK_FLW_IDENTITY_INFO PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_TOKEN (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, TOKEN_VALUE_ VARCHAR(255), TOKEN_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE, IP_ADDRESS_ VARCHAR(255), USER_AGENT_ VARCHAR(255), USER_ID_ VARCHAR(255), TOKEN_DATA_ VARCHAR(2000), CONSTRAINT PK_FLW_ID_TOKEN PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_PRIV (ID_ VARCHAR(64) NOT NULL, NAME_ VARCHAR(255) NOT NULL, CONSTRAINT PK_FLW_ID_PRIV PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_PRIV_MAPPING (ID_ VARCHAR(64) NOT NULL, PRIV_ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(255), GROUP_ID_ VARCHAR(255), CONSTRAINT PK_FLW_ID_PRIV_MAPPING PRIMARY KEY (ID_));

CREATE INDEX FLW_IDX_IDM_INFO_SCOPE_ID_TYPE ON FLW_IDENTITY_INFO(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP(GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

CREATE INDEX FLW_IDX_MEMB_USER ON FLW_ID_MEMBERSHIP(USER_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP ADD CONSTRAINT FLW_FK_MEMB_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER (ID_);

CREATE INDEX FLW_IDX_PRIV_MAPPING ON FLW_ID_PRIV_MAPPING(PRIV_ID_);

ALTER TABLE FLW_ID_PRIV_MAPPING ADD CONSTRAINT FLW_FK_PRIV_MAPPING FOREIGN KEY (PRIV_ID_) REFERENCES FLW_ID_PRIV (ID_);

CREATE INDEX FLW_IDX_PRIV_USER ON FLW_ID_PRIV_MAPPING(USER_ID_);

CREATE INDEX FLW_IDX_PRIV_GROUP ON FLW_ID_PRIV_MAPPING(GROUP_ID_);

ALTER TABLE FLW_ID_PRIV ADD CONSTRAINT FLW_UNIQ_PRIV_NAME UNIQUE (NAME_);

CREATE INDEX FLW_IDX_USER_SYSTEM ON FLW_ID_USER(SYSTEM_ID_, SYSTEM_TYPE_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 1, '7:2891b32cfb727db2f89db751542ba22a', 'createTable tableName=FLW_ID_PROPERTY; createTable tableName=FLW_ID_GROUP; createTable tableName=FLW_ID_USER; createTable tableName=FLW_ID_MEMBERSHIP; createTable tableName=FLW_ID_USER_DEFINITIONS; createTable tableName=FLW_ID_INFO; createTable ta...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

CREATE INDEX FLW_IDX_USER_USER_DEF ON FLW_ID_USER(USER_DEFINITION_ID_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 2, '7:40704c0abe6e375c21447558e4b6489c', 'createIndex indexName=FLW_IDX_USER_USER_DEF, tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_USER ADD SUB_STATE_ VARCHAR(255);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 3, '7:15b423b468c6266493b31528c156b677', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_USER ADD CREATOR_ID_ VARCHAR(64);

ALTER TABLE FLW_ID_USER ADD CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE;

ALTER TABLE FLW_ID_USER ADD UPDATER_ID_ VARCHAR(64);

ALTER TABLE FLW_ID_USER ADD UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE;

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 4, '7:75439b318ca2c07cfaf8849d347454ea', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

CREATE INDEX FLW_IDX_USER_CREATE_TIME ON FLW_ID_USER(CREATION_TIME_);

CREATE INDEX FLW_IDX_USER_UPDATE_TIME ON FLW_ID_USER(UPDATE_TIME_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 5, '7:abd1224a027b2cc45a14e4f1d22eefe4', 'createIndex indexName=FLW_IDX_USER_CREATE_TIME, tableName=FLW_ID_USER; createIndex indexName=FLW_IDX_USER_UPDATE_TIME, tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_IDENTITY_INFO ADD USER_ID_ VARCHAR(64);

ALTER TABLE FLW_IDENTITY_INFO ADD GROUP_ID_ VARCHAR(64);

ALTER TABLE FLW_IDENTITY_INFO ADD CONSTRAINT FK_IDENTITY_INFO_ID_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER (ID_) ON UPDATE NO ACTION ON DELETE CASCADE;

ALTER TABLE FLW_IDENTITY_INFO ADD CONSTRAINT FK_IDENTITY_INFO_ID_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_) ON UPDATE NO ACTION ON DELETE CASCADE;

UPDATE FLW_IDENTITY_INFO SET USER_ID_ = SCOPE_ID_;

DROP INDEX FLW_IDX_IDM_INFO_SCOPE_ID_TYPE;

ALTER TABLE FLW_IDENTITY_INFO DROP COLUMN SCOPE_ID_;

ALTER TABLE FLW_IDENTITY_INFO DROP COLUMN SCOPE_TYPE_;

ALTER TABLE FLW_IDENTITY_INFO DROP COLUMN SUB_SCOPE_ID_;

CREATE INDEX FLW_IDX_IDM_INFO_USER_ID ON FLW_IDENTITY_INFO(USER_ID_);

CREATE INDEX FLW_IDX_IDM_INFO_GROUP_ID ON FLW_IDENTITY_INFO(GROUP_ID_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 6, '7:b84e52c4c8c0b5012870a7a89525f0b9', 'addColumn tableName=FLW_IDENTITY_INFO; addForeignKeyConstraint baseTableName=FLW_IDENTITY_INFO, constraintName=FK_IDENTITY_INFO_ID_USER, referencedTableName=FLW_ID_USER; addForeignKeyConstraint baseTableName=FLW_IDENTITY_INFO, constraintName=FK_ID...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_USER_DEFINITIONS ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 7, '7:ad94820baf9f8ade202bef6370e9a0ae', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ID_USER_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_USER ADD AVATAR_ID_ VARCHAR(255);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 8, '7:75b5b7d1025b1d8ee03c75cb4950e921', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_USER ADD PRESENCE_ VARCHAR(255);

ALTER TABLE FLW_ID_USER ADD PRESENCE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE;

ALTER TABLE FLW_ID_USER ADD TYPE_ VARCHAR(64);

ALTER TABLE FLW_ID_USER ADD SUB_TYPE_ VARCHAR(64);

ALTER TABLE FLW_ID_USER ADD LANGUAGE_ VARCHAR(64);

ALTER TABLE FLW_ID_USER ADD THEME_ VARCHAR(64);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 9, '7:4cf92fc5beca32e466e519908d7ef5e6', 'addColumn tableName=FLW_ID_USER', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

CREATE TABLE FLW_ID_USER_ACCOUNT_DEFINITION (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, NAME_ VARCHAR(128), KEY_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), DEFINITION_CONTENT_ TEXT, CONSTRAINT PK_ID_USER_ACCOUNT_DEFINITION PRIMARY KEY (ID_));

CREATE TABLE FLW_ID_USER_ACCOUNT (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, USER_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', NAME_ VARCHAR(255), TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), STATE_ VARCHAR(64), SUB_STATE_ VARCHAR(64), BUSINESS_ACCOUNT_ID_ VARCHAR(255), EXTERNAL_USER_ID_ VARCHAR(255), USER_ACCOUNT_DEFINITION_ID_ VARCHAR(64), CREATOR_ID_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, UPDATER_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_FLW_ID_USER_ACCOUNT PRIMARY KEY (ID_), CONSTRAINT FK_ID_USER_ACCOUNT_USER_DEF FOREIGN KEY (USER_ACCOUNT_DEFINITION_ID_) REFERENCES FLW_ID_USER_ACCOUNT_DEFINITION(ID_), CONSTRAINT FK_ID_USER_ACCOUNT_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER(ID_) ON DELETE CASCADE);

CREATE INDEX IDX_USER_ACC_TYPE_SUB_EXT_USER ON FLW_ID_USER_ACCOUNT(TYPE_, SUB_TYPE_, EXTERNAL_USER_ID_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('10', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 10, '7:849f504bc136df2a16494e3b29b2ea4d', 'createTable tableName=FLW_ID_USER_ACCOUNT_DEFINITION; createTable tableName=FLW_ID_USER_ACCOUNT; createIndex indexName=IDX_USER_ACC_TYPE_SUB_EXT_USER, tableName=FLW_ID_USER_ACCOUNT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

CREATE INDEX IDX_USER_ACCOUNT_USER ON FLW_ID_USER_ACCOUNT(USER_ID_);

CREATE INDEX IDX_USER_ACCOUNT_USER_DEF ON FLW_ID_USER_ACCOUNT(USER_ACCOUNT_DEFINITION_ID_);

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('11', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 11, '7:771d3901ac8fa6a55f2c155986a3bc60', 'createIndex indexName=IDX_USER_ACCOUNT_USER, tableName=FLW_ID_USER_ACCOUNT; createIndex indexName=IDX_USER_ACCOUNT_USER_DEF, tableName=FLW_ID_USER_ACCOUNT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

UPDATE FLW_ID_USER U
            SET SUB_TYPE_ = (SELECT DEF.SUB_TYPE_ FROM FLW_ID_USER_DEFINITIONS DEF WHERE DEF.ID_ = U.USER_DEFINITION_ID_)
            WHERE U.USER_DEFINITION_ID_ IS NOT NULL;

ALTER TABLE FLW_ID_USER_DEFINITIONS DROP COLUMN SUB_TYPE_;

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('12', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 12, '7:610ea1b7b56a66403209150d4bc75774', 'sql; dropColumn columnName=SUB_TYPE_, tableName=FLW_ID_USER_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

ALTER TABLE FLW_ID_GROUP ADD KEY_ VARCHAR(64) DEFAULT '';

ALTER TABLE FLW_ID_GROUP ADD TENANT_ID_ VARCHAR(255) DEFAULT '';

UPDATE FLW_ID_GROUP SET KEY_ = ID_;

UPDATE FLW_ID_USER_DEFINITIONS set TENANT_ID_ = '';

UPDATE FLW_ID_USER_ACCOUNT set TENANT_ID_ = '';

INSERT INTO flw_id_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('13', 'flowable', 'com/flowable/platform/idm/db/liquibase/flowable-idm-db-changelog.xml', NOW(), 13, '7:3a8d25dd882c3fed136f12ccf677bb8f', 'addColumn tableName=FLW_ID_GROUP; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631075200');

UPDATE flw_id_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_fo_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_FO_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_fo_databasechangeloglock;

INSERT INTO flw_fo_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_fo_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:16.072' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_fo_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_FO_FORM_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE, TENANT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_FO_FORM_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_FO_FORM_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, CONSTRAINT PK_FLW_FO_FORM_RESOURCE PRIMARY KEY (ID_));

CREATE TABLE FLW_FO_FORM_DEFINITION (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), VERSION_ INT, KEY_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(255), RESOURCE_NAME_ VARCHAR(255), DESCRIPTION_ VARCHAR(255), CONSTRAINT PK_FLW_FO_FORM_DEFINITION PRIMARY KEY (ID_));

CREATE TABLE FLW_FO_FORM_INSTANCE (ID_ VARCHAR(255) NOT NULL, FORM_DEFINITION_ID_ VARCHAR(255) NOT NULL, TASK_ID_ VARCHAR(255), PROC_INST_ID_ VARCHAR(255), PROC_DEF_ID_ VARCHAR(255), SUBMITTED_DATE_ TIMESTAMP WITHOUT TIME ZONE, SUBMITTED_BY_ VARCHAR(255), FORM_VALUES_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_FO_FORM_INSTANCE PRIMARY KEY (ID_));

INSERT INTO flw_fo_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', NOW(), 1, '7:525fa509c296a5eb09a3397fbce39466', 'createTable tableName=FLW_FO_FORM_DEPLOYMENT; createTable tableName=FLW_FO_FORM_RESOURCE; createTable tableName=FLW_FO_FORM_DEFINITION; createTable tableName=FLW_FO_FORM_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076127');

ALTER TABLE FLW_FO_FORM_INSTANCE ADD SCOPE_ID_ VARCHAR(255);

ALTER TABLE FLW_FO_FORM_INSTANCE ADD SCOPE_TYPE_ VARCHAR(255);

ALTER TABLE FLW_FO_FORM_INSTANCE ADD SCOPE_DEFINITION_ID_ VARCHAR(255);

INSERT INTO flw_fo_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', NOW(), 2, '7:99bcac2aa557db19014b7be2bc669ce7', 'addColumn tableName=FLW_FO_FORM_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076127');

ALTER TABLE FLW_FO_FORM_DEFINITION DROP COLUMN PARENT_DEPLOYMENT_ID_;

INSERT INTO flw_fo_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', NOW(), 3, '7:6c08be805ae55bc0ec5756ee58b7fc90', 'dropColumn columnName=PARENT_DEPLOYMENT_ID_, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076127');

CREATE UNIQUE INDEX ACT_IDX_FORM_DEF_UNIQ ON FLW_FO_FORM_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO flw_fo_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', NOW(), 4, '7:31d5d350673c835ae9d7d77f3792b8d4', 'createIndex indexName=ACT_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076127');

DROP INDEX ACT_IDX_FORM_DEF_UNIQ;

CREATE UNIQUE INDEX FLW_IDX_FORM_DEF_UNIQ ON FLW_FO_FORM_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO flw_fo_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/form/db/liquibase/flowable-form-db-changelog.xml', NOW(), 5, '7:e9f5867270835c1fcc3cc409e342c0ef', 'dropIndex indexName=ACT_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION; createIndex indexName=FLW_IDX_FORM_DEF_UNIQ, tableName=FLW_FO_FORM_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076127');

UPDATE flw_fo_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_co_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_CO_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_co_databasechangeloglock;

INSERT INTO flw_co_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_co_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:16.432' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_co_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_CO_CONTENT_ITEM (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NOT NULL, MIME_TYPE_ VARCHAR(255), TASK_ID_ VARCHAR(255), PROC_INST_ID_ VARCHAR(255), CONTENT_STORE_ID_ VARCHAR(255), CONTENT_STORE_NAME_ VARCHAR(255), FIELD_ VARCHAR(400), CONTENT_AVAILABLE_ BOOLEAN DEFAULT FALSE, CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE, CREATED_BY_ VARCHAR(255), LAST_MODIFIED_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_MODIFIED_BY_ VARCHAR(255), CONTENT_SIZE_ BIGINT DEFAULT 0, TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_CO_CONTENT_ITEM PRIMARY KEY (ID_));

CREATE INDEX idx_contitem_taskid ON FLW_CO_CONTENT_ITEM(TASK_ID_);

CREATE INDEX idx_contitem_procid ON FLW_CO_CONTENT_ITEM(PROC_INST_ID_);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 1, '7:6e7a92ae97a9c5ad391a6d518f225887', 'createTable tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_taskid, tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_procid, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

ALTER TABLE FLW_CO_CONTENT_ITEM ADD SCOPE_ID_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD SCOPE_TYPE_ VARCHAR(255);

CREATE INDEX idx_contitem_scope ON FLW_CO_CONTENT_ITEM(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 2, '7:145f5d28f0c1f0acc639d0dd905917fc', 'addColumn tableName=FLW_CO_CONTENT_ITEM; createIndex indexName=idx_contitem_scope, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

CREATE TABLE FLW_CO_RENDITION_ITEM (ID_ VARCHAR(255) NOT NULL, CONTENT_ITEM_ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NOT NULL, MIME_TYPE_ VARCHAR(255), TASK_ID_ VARCHAR(255), PROC_INST_ID_ VARCHAR(255), CONTENT_STORE_ID_ VARCHAR(255), CONTENT_STORE_NAME_ VARCHAR(255), CONTENT_AVAILABLE_ BOOLEAN DEFAULT FALSE, CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_MODIFIED_ TIMESTAMP(6) WITHOUT TIME ZONE, CONTENT_SIZE_ BIGINT DEFAULT 0, TENANT_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), CONSTRAINT PK_FLW_CO_RENDITION_ITEM PRIMARY KEY (ID_));

CREATE INDEX idx_rendition_taskid ON FLW_CO_RENDITION_ITEM(TASK_ID_);

CREATE INDEX idx_rendition_procid ON FLW_CO_RENDITION_ITEM(PROC_INST_ID_);

CREATE INDEX idx_rendition_scope ON FLW_CO_RENDITION_ITEM(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 3, '7:7b29eaf43fac87a767fcb9e2a19016b3', 'createTable tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_taskid, tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_procid, tableName=FLW_CO_RENDITION_ITEM; createIndex indexName=idx_rendition_scope, table...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

ALTER TABLE FLW_CO_CONTENT_ITEM DROP COLUMN FIELD_;

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 4, '7:f85c5a823734966db4c0a5d972b29620', 'dropColumn columnName=FIELD_, tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

CREATE TABLE FLW_CO_CONTENT_OBJECT (ID_ VARCHAR(255) NOT NULL, CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE, CONTENT_ BYTEA, CONSTRAINT PK_FLW_CO_CONTENT_OBJECT PRIMARY KEY (ID_));

ALTER TABLE FLW_CO_CONTENT_ITEM ADD LOCK_INFO_ VARCHAR(255);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 5, '7:244196650fb5485babd5fd9e384b373a', 'createTable tableName=FLW_CO_CONTENT_OBJECT; addColumn tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

ALTER TABLE FLW_CO_RENDITION_ITEM ADD RENDITION_TYPE_ VARCHAR(255);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 6, '7:28652b75e4fe380d4690dd452dc51b96', 'addColumn tableName=FLW_CO_RENDITION_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

CREATE TABLE FLW_CO_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), KEY_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE, TENANT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_CO_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_CO_DEPLOYMENT_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, CONSTRAINT PK_FLW_CO_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_));

CREATE TABLE FLW_CO_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, KEY_ VARCHAR(128), DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '', NAME_ VARCHAR(128), VERSION_ INT, RESOURCE_NAME_ VARCHAR(4000), CATEGORY_ VARCHAR(255), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_CO_DEFINITIONS PRIMARY KEY (ID_));

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 7, '7:d309378b3332abb360413ece874c876a', 'createTable tableName=FLW_CO_DEPLOYMENT; createTable tableName=FLW_CO_DEPLOYMENT_RESOURCE; createTable tableName=FLW_CO_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

CREATE TABLE FLW_CO_METADATA (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, TYPE_ VARCHAR(255), NAME_ VARCHAR(255), CONTENT_ITEM_ID_ VARCHAR(255), BYTEARRAY_ID_ VARCHAR(255), DOUBLE_ DOUBLE PRECISION, LONG_ BIGINT, TEXT_ VARCHAR(4000), TEXT2_ VARCHAR(4000), CONSTRAINT PK_FLW_CO_METADATA PRIMARY KEY (ID_));

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 8, '7:d9ae2d7156f6163525024216673337c4', 'createTable tableName=FLW_CO_METADATA', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

ALTER TABLE FLW_CO_CONTENT_ITEM ADD VERSION_ INT;

ALTER TABLE FLW_CO_CONTENT_ITEM ADD VERSION_INFO_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD VERSION_PARENT_ID_ VARCHAR(255);

UPDATE FLW_CO_CONTENT_ITEM SET VERSION_ = 1;

UPDATE FLW_CO_CONTENT_ITEM SET VERSION_PARENT_ID_ = ID_;

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 9, '7:4fc883e77092c18531f6777286f1c11a', 'addColumn tableName=FLW_CO_CONTENT_ITEM; sql; sql', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

ALTER TABLE FLW_CO_CONTENT_ITEM ADD DEFINITION_ID_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD TYPE_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD SUB_TYPE_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD STATE_ VARCHAR(255);

ALTER TABLE FLW_CO_CONTENT_ITEM ADD SUB_STATE_ VARCHAR(255);

INSERT INTO flw_co_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('10', 'flowable', 'com/flowable/content/db/liquibase/flowable-content-db-changelog.xml', NOW(), 10, '7:2109341310362f70024460ca174ac209', 'addColumn tableName=FLW_CO_CONTENT_ITEM', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076464');

UPDATE flw_co_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_ad_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_AD_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_ad_databasechangeloglock;

INSERT INTO flw_ad_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_ad_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:16.796' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_ad_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_ACTION_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), KEY_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE, TENANT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_ACTION_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_ACTION_DEPLOYMENT_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, CONSTRAINT PK_FLW_ACTION_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_));

CREATE TABLE FLW_ACTION_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, KEY_ VARCHAR(128), DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '', BOT_KEY_ VARCHAR(128), MANDATORY_ BOOLEAN, NAME_ VARCHAR(128), VERSION_ INT, RESOURCE_NAME_ VARCHAR(4000), SCOPE_TYPE_ VARCHAR(128), FORM_KEY_ VARCHAR(128), GLOBAL_ BOOLEAN, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), CONSTRAINT PK_ACTION_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_ACTION_DEF_LINKS (ID_ VARCHAR(64) NOT NULL, ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL, REFERENCE_ID_ VARCHAR(255) NOT NULL, REFERENCE_TYPE_ VARCHAR(255) NOT NULL, REFERENCE_DEFINITION_TYPE_ VARCHAR(255), CONSTRAINT PK_ACTION_DEF_LINKS PRIMARY KEY (ID_), CONSTRAINT FK_ACTION_DEF_LINK_ACTION_DEFS FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION(ID_));

CREATE TABLE FLW_ACTION_INSTANCE (ID_ VARCHAR(255) NOT NULL, ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL, START_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE, EXECUTION_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE, EXECUTED_BY_ VARCHAR(255), FORM_INSTANCE_ID_ VARCHAR(255), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_ACTION_INSTANCE PRIMARY KEY (ID_));

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 1, '7:715c505b07f084ec4794b7b5a51b221f', 'createTable tableName=FLW_ACTION_DEPLOYMENT; createTable tableName=FLW_ACTION_DEPLOYMENT_RESOURCE; createTable tableName=FLW_ACTION_DEFINITION; createTable tableName=FLW_ACTION_DEF_LINKS; createTable tableName=FLW_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE TABLE FLW_ACTION_LINK (ID_ VARCHAR(255) NOT NULL, ACTION_INSTANCE_ID_ VARCHAR(255) NOT NULL, ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL, SCOPE_ID_ VARCHAR(255) NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_FLW_ACTION_LINK PRIMARY KEY (ID_), CONSTRAINT FK_ACTION_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION(ID_), CONSTRAINT FK_ACTION_LINK_ACTION_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE(ID_));

CREATE INDEX FLW_IDX_ACTION_LINK_SCOPE ON FLW_ACTION_LINK(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 2, '7:da642b1da8880aa55d98a38bce79f08d', 'createTable tableName=FLW_ACTION_LINK; createIndex indexName=FLW_IDX_ACTION_LINK_SCOPE, tableName=FLW_ACTION_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

ALTER TABLE FLW_ACTION_DEFINITION ADD CONSTRAINT FK_ACTION_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

ALTER TABLE FLW_ACTION_INSTANCE ADD CONSTRAINT FK_ACTION_INST_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 3, '7:5ed72e935faee78950edec7accaa7ddf', 'addForeignKeyConstraint baseTableName=FLW_ACTION_DEFINITION, constraintName=FK_ACTION_DEF_DEPLOYMENT, referencedTableName=FLW_ACTION_DEPLOYMENT; addForeignKeyConstraint baseTableName=FLW_ACTION_INSTANCE, constraintName=FK_ACTION_INST_ACTION_DEF, r...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON FLW_ACTION_DEF_LINKS(ACTION_DEFINITION_ID_);

CREATE INDEX IDX_ACTION_LINK_ACTION_INST ON FLW_ACTION_LINK(ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_DEFINITION_ID_ ON FLW_ACTION_LINK(ACTION_DEFINITION_ID_);

CREATE INDEX IDX_ACTION_DEF_DEPLOYMENT ON FLW_ACTION_DEFINITION(DEPLOYMENT_ID_);

CREATE INDEX IDX_ACTION_INST_ACTION_DEF ON FLW_ACTION_INSTANCE(ACTION_DEFINITION_ID_);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 4, '7:d9f08bc7d96af83ed124d0b929b50a8f', 'createIndex indexName=IDX_ACTION_DEF_LINK_ACTION_DEF, tableName=FLW_ACTION_DEF_LINKS; createIndex indexName=IDX_ACTION_LINK_ACTION_INST, tableName=FLW_ACTION_LINK; createIndex indexName=ACTION_DEFINITION_ID_, tableName=FLW_ACTION_LINK; createIndex...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE TABLE FLW_HI_ACTION_INSTANCE (ID_ VARCHAR(255) NOT NULL, ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL, START_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE, EXECUTION_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE, EXECUTED_BY_ VARCHAR(255), FORM_INSTANCE_ID_ VARCHAR(255), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_HI_ACTION_INSTANCE PRIMARY KEY (ID_));

CREATE TABLE FLW_HI_ACTION_LINK (ID_ VARCHAR(255) NOT NULL, ACTION_INSTANCE_ID_ VARCHAR(255), ACTION_DEFINITION_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255) NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_FLW_HI_ACTION_LINK PRIMARY KEY (ID_));

CREATE INDEX FLW_IDX_HI_ACTION_LINK_SCOPE ON FLW_HI_ACTION_LINK(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_HI_ACTION_LINK_ACTION_INST ON FLW_HI_ACTION_LINK(ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_HI_DEFINITION_ID_ ON FLW_HI_ACTION_LINK(ACTION_DEFINITION_ID_);

CREATE INDEX IDX_HI_ACTION_INST_ACTION_DEF ON FLW_HI_ACTION_INSTANCE(ACTION_DEFINITION_ID_);

ALTER TABLE FLW_ACTION_INSTANCE DROP COLUMN EXECUTED_BY_;

ALTER TABLE FLW_ACTION_INSTANCE DROP COLUMN EXECUTION_DATE_;

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 5, '7:26a4bc49b288e892048389d88b283d02', 'createTable tableName=FLW_HI_ACTION_INSTANCE; createTable tableName=FLW_HI_ACTION_LINK; createIndex indexName=FLW_IDX_HI_ACTION_LINK_SCOPE, tableName=FLW_HI_ACTION_LINK; createIndex indexName=IDX_HI_ACTION_LINK_ACTION_INST, tableName=FLW_HI_ACTION...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

ALTER TABLE FLW_ACTION_DEFINITION ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 6, '7:25614514e47f8e982657584a3de2b1b5', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ACTION_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE TABLE FLW_ACTION_DEF_LINK (ID_ VARCHAR(255) NOT NULL, ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL, TYPE_ VARCHAR(255) NOT NULL, LINK_VALUE_ VARCHAR(255), CONSTRAINT PK_FLW_ACTION_DEF_LINK PRIMARY KEY (ID_), CONSTRAINT FK_ACTION_DEF_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION(ID_));

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 7, '7:c2d63267cb6c494fca5b560db79054c4', 'createTable tableName=FLW_ACTION_DEF_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

DROP TABLE FLW_ACTION_DEF_LINKS CASCADE;

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 8, '7:6ae84d090ccbb44f0cbd5c3c81862126', 'dropTable tableName=FLW_ACTION_DEF_LINKS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON FLW_ACTION_DEF_LINK(ACTION_DEFINITION_ID_);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 9, '7:53cdd26bbb56f7cb69318514558fb0a5', 'createIndex indexName=IDX_ACTION_DEF_LINK_ACTION_DEF, tableName=FLW_ACTION_DEF_LINK', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

ALTER TABLE FLW_ACTION_INSTANCE ADD SUB_SCOPE_ID_ VARCHAR(255);

ALTER TABLE FLW_HI_ACTION_INSTANCE ADD SUB_SCOPE_ID_ VARCHAR(255);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('10', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 10, '7:262e2b954e7d2ae044782469e58d8088', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

ALTER TABLE FLW_ACTION_INSTANCE ADD NAME_ VARCHAR(255);

ALTER TABLE FLW_HI_ACTION_INSTANCE ADD NAME_ VARCHAR(255);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('11', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 11, '7:c672eb4462f2a95b7466eb60157d3124', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

CREATE UNIQUE INDEX "ACT_IDX_ACTIONs_DEF_UNIQ" ON FLW_ACTION_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('12', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 12, '7:13987d51cfbbafac29c9a52d54ab8794', 'createIndex indexName=ACT_IDX_ACTIONs_DEF_UNIQ, tableName=FLW_ACTION_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

ALTER TABLE FLW_ACTION_INSTANCE ADD FORM_KEY_ VARCHAR(128);

ALTER TABLE FLW_HI_ACTION_INSTANCE ADD FORM_KEY_ VARCHAR(128);

INSERT INTO flw_ad_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('13', 'flowable', 'com/flowable/action/db/liquibase/flowable-action-db-changelog.xml', NOW(), 13, '7:d49c6f2f961fa5417234e0b39d89f5ef', 'addColumn tableName=FLW_ACTION_INSTANCE; addColumn tableName=FLW_HI_ACTION_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631076848');

UPDATE flw_ad_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_au_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_AU_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_au_databasechangeloglock;

INSERT INTO flw_au_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_au_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:17.206' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_au_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_AUDIT_INSTANCE (ID_ VARCHAR(255) NOT NULL, AUDIT_DEFINITION_ID_ VARCHAR(255), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CREATOR_ID_ VARCHAR(255), EXTERNAL_ID_ VARCHAR(255), TYPE_ VARCHAR(255), SUB_TYPE_ VARCHAR(255), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), PAYLOAD_ TEXT, TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_AUDIT_INSTANCE PRIMARY KEY (ID_));

INSERT INTO flw_au_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/audit/db/liquibase/flowable-audit-db-changelog.xml', NOW(), 1, '7:aaa086cb017579252677856dfb79b6a7', 'createTable tableName=FLW_AUDIT_INSTANCE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077234');

CREATE INDEX FLW_IDX_AUDIT_INST_DEF ON FLW_AUDIT_INSTANCE(AUDIT_DEFINITION_ID_);

CREATE INDEX FLW_IDX_AUDIT_INST_TYPE ON FLW_AUDIT_INSTANCE(TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_SCOPE ON FLW_AUDIT_INSTANCE(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_CREATE ON FLW_AUDIT_INSTANCE(CREATION_TIME_);

INSERT INTO flw_au_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/audit/db/liquibase/flowable-audit-db-changelog.xml', NOW(), 2, '7:698e1206d862b3398091ab054fd2c615', 'createIndex indexName=FLW_IDX_AUDIT_INST_DEF, tableName=FLW_AUDIT_INSTANCE; createIndex indexName=FLW_IDX_AUDIT_INST_TYPE, tableName=FLW_AUDIT_INSTANCE; createIndex indexName=FLW_IDX_AUDIT_INST_SCOPE, tableName=FLW_AUDIT_INSTANCE; createIndex inde...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077234');

UPDATE flw_au_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_tp_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_TP_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_tp_databasechangeloglock;

INSERT INTO flw_tp_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_tp_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:17.375' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_tp_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_TEMPL_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), KEY_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE, TENANT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_));

CREATE TABLE FLW_TEMPL_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, KEY_ VARCHAR(128), VERSION_ INT, DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(128), TYPE_ VARCHAR(128), SUB_TYPE_ VARCHAR(128), FORM_KEY_ VARCHAR(128), RESOURCE_NAME_ VARCHAR(4000), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATOR_ID_ VARCHAR(64), CONSTRAINT PK_TEMPL_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_TEMPL_VAR_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, TEMPLATE_DEF_KEY_ VARCHAR(128), VARIATION_KEY_ VARCHAR(128), DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, VERSION_ INT, VALID_FROM_ TIMESTAMP(6) WITHOUT TIME ZONE, VALID_TO_ TIMESTAMP(6) WITHOUT TIME ZONE, RESOURCE_NAME_ VARCHAR(4000), EXTERNAL_ID_ VARCHAR(255), CONTENT_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, CONSTRAINT PK_TEMPL_VAR_DEFINITIONS PRIMARY KEY (ID_));

INSERT INTO flw_tp_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', NOW(), 1, '7:cc534c4f5d37c0b737e3e8b52457bfc8', 'createTable tableName=FLW_TEMPL_DEPLOYMENT; createTable tableName=FLW_TEMPL_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEMPL_DEFINITION; createTable tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077393');

ALTER TABLE FLW_TEMPL_VAR_DEFINITION ADD NAME_ VARCHAR(128);

INSERT INTO flw_tp_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', NOW(), 2, '7:bc2a9becc81836fa1bc3aed1d00f5a0c', 'addColumn tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077393');

DELETE FROM FLW_TEMPL_VAR_DEFINITION;

DELETE FROM FLW_TEMPL_DEFINITION;

DELETE FROM FLW_TEMPL_DEPLOYMENT_RESOURCE;

DELETE FROM FLW_TEMPL_DEPLOYMENT;

INSERT INTO flw_tp_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', NOW(), 3, '7:9b7a62b3c7b157181009ca95f43e88a6', 'delete tableName=FLW_TEMPL_VAR_DEFINITION; delete tableName=FLW_TEMPL_DEFINITION; delete tableName=FLW_TEMPL_DEPLOYMENT_RESOURCE; delete tableName=FLW_TEMPL_DEPLOYMENT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077393');

ALTER TABLE FLW_TEMPL_DEFINITION ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

ALTER TABLE FLW_TEMPL_VAR_DEFINITION ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

INSERT INTO flw_tp_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/template/db/liquibase/flowable-template-db-changelog.xml', NOW(), 4, '7:0c4283c6248be298c0c8fec1e57faf52', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_TEMPL_DEFINITION; dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_TEMPL_VAR_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077393');

UPDATE flw_tp_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


CREATE TABLE flw_eng_databasechangeloglock (ID INT NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT PK_FLW_ENG_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM flw_eng_databasechangeloglock;

INSERT INTO flw_eng_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_eng_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2019-03-26 21:11:17.547' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_eng_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_ENGAGE_CONVERSATION (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '', PARENT_ID_ VARCHAR(64), REFERENCE_ID_ VARCHAR(64), REFERENCE_TYPE_ VARCHAR(64), REFERENCE_DEFINITION_ID_ VARCHAR(64), CONVERSATION_DEFINITION_ID_ VARCHAR(64), STATE_ VARCHAR(64), TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), PERMISSION_TYPE_ VARCHAR(64), JOINING_TYPE_ VARCHAR(64), PRIORITY_ INT, NAME_ VARCHAR(255), FALLBACK_NAME_ VARCHAR(4000), DESCRIPTION_ VARCHAR(4000), AVATAR_INFO_ VARCHAR(4000), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), RESUBMISSION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_MESSAGE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, METADATA_ TEXT, TAGS_ TEXT, CONSTRAINT PK_ENGAGE_CONVERSATION PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_MESSAGE (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, EXTERNAL_ID_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR(128), MEDIA_CONTENT_ID_ VARCHAR(128), CATEGORY_ VARCHAR(64) NOT NULL, TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), SENDER_ID_ VARCHAR(64) NOT NULL, PRIVATE_ BOOLEAN DEFAULT FALSE, CONVERSATION_ID_ VARCHAR(64), ADDITIONAL_CONTENT_ TEXT, STICKY_ BOOLEAN DEFAULT FALSE, TAGS_ TEXT, MAIN_CONTENT_ TEXT, MAIN_CONTENT_TYPE_ VARCHAR(64), METADATA_ TEXT, OWNER_ID_ VARCHAR(64), ASSIGNEE_ID_ VARCHAR(64), ASSIGNED_GROUP_ID_ VARCHAR(64), CANDIDATE_USER_IDS_ TEXT, CANDIDATE_GROUP_IDS_ TEXT, CONSTRAINT PK_ENGAGE_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_MESSAGE_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_MSG_CONVERSATION ON FLW_ENGAGE_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_MSG_CREATION_TIME ON FLW_ENGAGE_MESSAGE(CREATION_TIME_);

CREATE TABLE FLW_CONV_PARTICIPANT_REGISTRY (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, CONVERSATION_ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(64) NOT NULL, PARTICIPANT_TYPE_ VARCHAR(255), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, JOINING_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, LEAVING_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_CONV_PARTICIPANT_REGISTRY PRIMARY KEY (ID_), CONSTRAINT FK_CONV_PART_REG_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_) ON DELETE CASCADE);

CREATE TABLE FLW_ENGAGE_CONV_DEFINITIONS (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, NAME_ VARCHAR(128), KEY_ VARCHAR(128), SUB_TYPE_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64) NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), DEFINITION_CONTENT_ TEXT, CONSTRAINT PK_ENGAGE_CONV_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_CONVERSATION_STATUS (ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(64) NOT NULL, CONVERSATION_ID_ VARCHAR(64), FILTER_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', UNREAD_MESSAGE_COUNT_ INT, UNREAD_PERSONAL_MESSAGE_COUNT_ INT, UNSENT_MESSAGE_COUNT_ INT, LAST_READ_MESSAGE_ID_ VARCHAR(64), LAST_READ_MESSAGE_TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_SENT_MESSAGE_ID_ VARCHAR(64), LAST_SENT_MESSAGE_TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_ENGAGE_CONVERSATION_STATUS PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_CONV_STAT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV_FLT ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_, FILTER_ID_);

CREATE TABLE FLW_ENGAGE_ARC_CONV_EVENT (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CONVERSATION_ID_ VARCHAR(64), SECTION_ID_ INT, PERIOD_START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, PERIOD_END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, PARTICIPANT_IDS_ TEXT, PARTICIPANT_NAMES_ TEXT, MESSAGE_COUNT_ INT, EVENT_COUNT_ INT, ATTACHMENT_COUNT_ INT, CONSTRAINT PK_ENGAGE_ARC_CONV_EVENT PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_ARC_JOB_EVENT (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONVERSATION_COUNT_ INT, PARTICIPANT_COUNT_ INT, DATA_COUNT_ INT, CONSTRAINT PK_ENGAGE_ARC_JOB_EVENT PRIMARY KEY (ID_));

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 1, '7:6b68fe4d0812331e6eefc0cfbd5f30dd', 'createTable tableName=FLW_ENGAGE_CONVERSATION; createTable tableName=FLW_ENGAGE_MESSAGE; createIndex indexName=FLW_IDX_MSG_CONVERSATION, tableName=FLW_ENGAGE_MESSAGE; createIndex indexName=FLW_IDX_MSG_CREATION_TIME, tableName=FLW_ENGAGE_MESSAGE; c...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE INDEX IDX_ENGAGE_ARC_CONV_CREATE ON FLW_ENGAGE_ARC_CONV_EVENT(CREATION_TIME_);

CREATE INDEX IDX_ENGAGE_ARC_CONV_CONV ON FLW_ENGAGE_ARC_CONV_EVENT(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_ARC_JOB_EVT_CREATE ON FLW_ENGAGE_ARC_JOB_EVENT(CREATION_TIME_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 2, '7:f8d2b2d56b92e2c40a16280b2c014b0b', 'createIndex indexName=IDX_ENGAGE_ARC_CONV_CREATE, tableName=FLW_ENGAGE_ARC_CONV_EVENT; createIndex indexName=IDX_ENGAGE_ARC_CONV_CONV, tableName=FLW_ENGAGE_ARC_CONV_EVENT; createIndex indexName=IDX_ENGAGE_ARC_JOB_EVT_CREATE, tableName=FLW_ENGAGE_A...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE INDEX IDX_CONV_PART_REG_CONVERSATION ON FLW_CONV_PARTICIPANT_REGISTRY(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_CONV_STAT_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(CONVERSATION_ID_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 3, '7:48e1903a227d66e3048f13127b617e6f', 'createIndex indexName=IDX_CONV_PART_REG_CONVERSATION, tableName=FLW_CONV_PARTICIPANT_REGISTRY; createIndex indexName=IDX_ENGAGE_CONV_STAT_CONV, tableName=FLW_ENGAGE_CONVERSATION_STATUS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE TABLE FLW_ENGAGE_USER_ANALYTICS (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, USER_ID_ VARCHAR(64), START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONVERSATION_COUNT_ INT, MESSAGE_COUNT_ INT, CONSTRAINT PK_ENGAGE_USER_ANALYTICS PRIMARY KEY (ID_));

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 4, '7:e922e2996118a7df8565d2e9e288481a', 'createTable tableName=FLW_ENGAGE_USER_ANALYTICS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE INDEX FLW_IDX_MSG_EXTERNAL_ID ON FLW_ENGAGE_MESSAGE(EXTERNAL_ID_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 5, '7:58258572cd685e919734332bf7609f59', 'createIndex indexName=FLW_IDX_MSG_EXTERNAL_ID, tableName=FLW_ENGAGE_MESSAGE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_MESSAGE ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

ALTER TABLE FLW_ENGAGE_CONV_DEFINITIONS ALTER COLUMN  CREATOR_ID_ DROP NOT NULL;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 6, '7:6febd4d732ddac076c3948deffe019f9', 'dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ENGAGE_MESSAGE; dropNotNullConstraint columnName=CREATOR_ID_, tableName=FLW_ENGAGE_CONV_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_CONVERSATION ADD USER_ACCOUNT_ID_ VARCHAR(64);

ALTER TABLE FLW_ENGAGE_CONVERSATION ADD CONSTRAINT FK_CONV_USER_ACCOUNT FOREIGN KEY (USER_ACCOUNT_ID_) REFERENCES FLW_ID_USER_ACCOUNT (ID_) ON DELETE SET NULL;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 7, '7:8ed3ca4cf5e8b987928d83c451257010', 'addColumn tableName=FLW_ENGAGE_CONVERSATION; addForeignKeyConstraint baseTableName=FLW_ENGAGE_CONVERSATION, constraintName=FK_CONV_USER_ACCOUNT, referencedTableName=FLW_ID_USER_ACCOUNT', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE INDEX FLW_IDX_CONV_USER_ACCOUNT ON FLW_ENGAGE_CONVERSATION(USER_ACCOUNT_ID_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 8, '7:5ac04cb13ad82e4769858223f6443858', 'createIndex indexName=FLW_IDX_CONV_USER_ACCOUNT, tableName=FLW_ENGAGE_CONVERSATION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN ADDITIONAL_CONTENT_;

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN ASSIGNEE_ID_;

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN ASSIGNED_GROUP_ID_;

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN CANDIDATE_USER_IDS_;

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN CANDIDATE_GROUP_IDS_;

ALTER TABLE FLW_ENGAGE_MESSAGE DROP COLUMN METADATA_;

ALTER TABLE FLW_ENGAGE_MESSAGE RENAME COLUMN OWNER_ID_ TO RECIPIENT_ID_;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 9, '7:47b4a0391598ef384f43a44b66eb6043', 'dropColumn columnName=ADDITIONAL_CONTENT_, tableName=FLW_ENGAGE_MESSAGE; dropColumn columnName=ASSIGNEE_ID_, tableName=FLW_ENGAGE_MESSAGE; dropColumn columnName=ASSIGNED_GROUP_ID_, tableName=FLW_ENGAGE_MESSAGE; dropColumn columnName=CANDIDATE_USER...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_CONVERSATION ADD EXTERNAL_ID_ VARCHAR(128);

CREATE INDEX FLW_IDX_CONV_EXTERNAL_ID ON FLW_ENGAGE_CONVERSATION(EXTERNAL_ID_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('10', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 10, '7:b2e9b81817736669d88f5eaf8d8481d2', 'addColumn tableName=FLW_ENGAGE_CONVERSATION; createIndex indexName=FLW_IDX_CONV_EXTERNAL_ID, tableName=FLW_ENGAGE_CONVERSATION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_MESSAGE ADD REFERENCE_ID_ VARCHAR(128);

ALTER TABLE FLW_ENGAGE_MESSAGE ADD REFERENCE_TYPE_ VARCHAR(128);

CREATE TABLE FLW_ENGAGE_TEMP_MESSAGE (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, EXTERNAL_ID_ VARCHAR(128), REFERENCE_ID_ VARCHAR(128), REFERENCE_TYPE_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR(128), MEDIA_CONTENT_ID_ VARCHAR(128), CATEGORY_ VARCHAR(64) NOT NULL, TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), SENDER_ID_ VARCHAR(64) NOT NULL, PRIVATE_ BOOLEAN DEFAULT FALSE, CONVERSATION_ID_ VARCHAR(64), STICKY_ BOOLEAN DEFAULT FALSE, TAGS_ TEXT, MAIN_CONTENT_ TEXT, MAIN_CONTENT_TYPE_ VARCHAR(64), RECIPIENT_ID_ VARCHAR(64), PROCESSED_ BOOLEAN DEFAULT FALSE, PROCESSING_STATUS_ VARCHAR(255), PROCESSING_REASON_ TEXT, CONSTRAINT PK_ENGAGE_TEMP_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_TEMP_MSG_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_TEMP_MSG_CONVERSATION ON FLW_ENGAGE_TEMP_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_TEMP_MSG_CREATION_TIME ON FLW_ENGAGE_TEMP_MESSAGE(CREATION_TIME_);

CREATE INDEX FLW_IDX_TEMP_MSG_EXTERNAL_ID ON FLW_ENGAGE_TEMP_MESSAGE(EXTERNAL_ID_);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('11', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 11, '7:4394e37c64a35773d781a902a3355e34', 'addColumn tableName=FLW_ENGAGE_MESSAGE; createTable tableName=FLW_ENGAGE_TEMP_MESSAGE; createIndex indexName=FLW_IDX_TEMP_MSG_CONVERSATION, tableName=FLW_ENGAGE_TEMP_MESSAGE; createIndex indexName=FLW_IDX_TEMP_MSG_CREATION_TIME, tableName=FLW_ENGA...', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_CONVERSATION ADD AVATAR_ID_ VARCHAR(255);

ALTER TABLE FLW_ENGAGE_CONVERSATION DROP COLUMN AVATAR_INFO_;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('12', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 12, '7:9318c687d45b8ff6640e4a6f5fcb15d7', 'addColumn tableName=FLW_ENGAGE_CONVERSATION; dropColumn columnName=AVATAR_INFO_, tableName=FLW_ENGAGE_CONVERSATION', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_CONV_PARTICIPANT_REGISTRY ADD GROUP_ID_ VARCHAR(64);

ALTER TABLE FLW_CONV_PARTICIPANT_REGISTRY ALTER COLUMN  USER_ID_ DROP NOT NULL;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('13', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 13, '7:4c79db8b81aed118591a02525b40dba0', 'addColumn tableName=FLW_CONV_PARTICIPANT_REGISTRY; dropNotNullConstraint columnName=USER_ID_, tableName=FLW_CONV_PARTICIPANT_REGISTRY', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

ALTER TABLE FLW_ENGAGE_MESSAGE ADD RECIPIENT_GROUP_ID_ VARCHAR(64);

ALTER TABLE FLW_ENGAGE_TEMP_MESSAGE ADD RECIPIENT_GROUP_ID_ VARCHAR(64);

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('14', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 14, '7:64e2fa4441a6f2cd7a61af195992108f', 'addColumn tableName=FLW_ENGAGE_MESSAGE; addColumn tableName=FLW_ENGAGE_TEMP_MESSAGE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

CREATE TABLE FLW_ENGAGE_DEVICE (ID_ VARCHAR(64) NOT NULL, REV_ INT NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', TOKEN_ VARCHAR(255), TOKEN_ENCODING_ VARCHAR(64), ENABLED_ BOOLEAN DEFAULT TRUE, DEVICE_OS_ VARCHAR(64), USER_ID_ VARCHAR(64), APPLICATION_ID_ VARCHAR(255), CONSTRAINT PK_ENGAGE_DEVICE PRIMARY KEY (ID_));

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('15', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 15, '7:3a40052fc17034c663f23c0c00d7b907', 'createTable tableName=FLW_ENGAGE_DEVICE', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

update FLW_ENGAGE_CONVERSATION set TYPE_ = SUB_TYPE_;

update FLW_ENGAGE_CONVERSATION set SUB_TYPE_ = 'default';

ALTER TABLE FLW_ENGAGE_CONV_DEFINITIONS RENAME COLUMN SUB_TYPE_ TO TYPE_;

INSERT INTO flw_eng_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('16', 'flowable', 'com/flowable/engage/db/liquibase/flowable-engage-db-changelog.xml', NOW(), 16, '7:b25d3bea538f97ec5a4d09e021b2a8f9', 'sql; sql; renameColumn newColumnName=TYPE_, oldColumnName=SUB_TYPE_, tableName=FLW_ENGAGE_CONV_DEFINITIONS', '', 'EXECUTED', NULL, NULL, '3.5.3', '3631077579');

UPDATE flw_eng_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

