CREATE INDEX FLW_IDX_IDM_INFO_GROUP_ID_REF ON FLW_IDENTITY_INFO (GROUP_ID_REF_);

ALTER TABLE FLW_ID_GROUP MODIFY ID_ VARCHAR2(255);

ALTER TABLE FLW_ID_MEMBERSHIP MODIFY GROUP_ID_ VARCHAR2(255);

UPDATE ACT_GE_PROPERTY SET value_= 22 WHERE name_='idm.schema.version';


ALTER TABLE FLW_AGENT_INSTANCE ADD NAME_ VARCHAR2(255);
ALTER TABLE FLW_AGENT_INSTANCE ADD CALLBACK_SCOPE_ID_ VARCHAR2(255);

CREATE INDEX IDX_FLW_AGT_INS_CALLB_SCOPE_ID ON FLW_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

ALTER TABLE FLW_HI_AGENT_INSTANCE ADD NAME_ VARCHAR2(255);
ALTER TABLE FLW_HI_AGENT_INSTANCE ADD CALLBACK_SCOPE_ID_ VARCHAR2(255);

CREATE INDEX IDX_FLW_HI_AGT_INS_CALL_SCP_ID ON FLW_HI_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION
(
    ID_                     VARCHAR2(255) NOT NULL,
    REV_                    INTEGER       NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR2(255) NOT NULL,
    OPERATION_KEY_          VARCHAR2(255),
    START_TIME_             TIMESTAMP(6)  NOT NULL,
    END_TIME_               TIMESTAMP(6),
    USER_ID_                VARCHAR2(255),
    PROMPT_TOKEN_COUNT_     NUMBER(19,0),
    OUTPUT_TOKEN_COUNT_     NUMBER(19,0),
    CONSTRAINT PK_FLW_HI_AGENT_INVOCATION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_AGT_ID ON FLW_HI_AGENT_INVOCATION (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_AGT_ID FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION_EXCH
(
    ID_                         VARCHAR2(255) NOT NULL,
    REV_                        INTEGER      NOT NULL,
    INVOCATION_ID_              VARCHAR2(255) NOT NULL,
    CREATION_TIME_              TIMESTAMP(6) NOT NULL,
    END_TIME_                   TIMESTAMP(6),
    DURATION_                   NUMBER(19,0),
    TYPE_                       VARCHAR2(255),
    SUB_TYPE_                   VARCHAR2(2000),
    USER_ID_                    VARCHAR2(255),
    PROMPT_TOKEN_COUNT_         NUMBER(19,0),
    OUTPUT_TOKEN_COUNT_         NUMBER(19,0),
    TRANSACTION_ORDER_          INTEGER DEFAULT 1 NOT NULL,
    CONSTRAINT PK_FLW_HI_AGENT_INVOC_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_INV ON FLW_HI_AGENT_INVOCATION_EXCH (INVOCATION_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION_EXCH
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_INVOC FOREIGN KEY (INVOCATION_ID_) REFERENCES FLW_HI_AGENT_INVOCATION (ID_);

CREATE TABLE FLW_HI_AGENT_INVOC_EXCH_PART
(
    ID_                         VARCHAR2(255) NOT NULL,
    EXCHANGE_ID_                VARCHAR2(255) NOT NULL,
    TYPE_                       VARCHAR2(255) NOT NULL,
    SUB_TYPE_                   VARCHAR2(2000),
    CONTENT_                    CLOB,
    INVOCATION_SEQUENCE_        INTEGER DEFAULT 1 NOT NULL,
    CONSTRAINT PK_FLW_HI_AGT_INVOC_EXCH_PART PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_PART ON FLW_HI_AGENT_INVOC_EXCH_PART (EXCHANGE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOC_EXCH_PART
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_PART FOREIGN KEY (EXCHANGE_ID_) REFERENCES FLW_HI_AGENT_INVOCATION_EXCH (ID_);

drop table FLW_AGENT_INSTANCE_EXCHANGE cascade constraints;
drop table FLW_HI_AGENT_INSTANCE_EXCHANGE cascade constraints;

update ACT_GE_PROPERTY set VALUE_ = '2' where NAME_ = 'agent.schema.version';


