CREATE INDEX FLW_IDX_IDM_INFO_GROUP_ID_REF ON FLW_IDENTITY_INFO (GROUP_ID_REF_);

ALTER TABLE FLW_ID_MEMBERSHIP DROP FOREIGN KEY FLW_FK_MEMB_GROUP;

ALTER TABLE FLW_ID_MEMBERSHIP DROP PRIMARY KEY;

ALTER TABLE FLW_ID_GROUP DROP PRIMARY KEY;

DROP INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP;

ALTER TABLE FLW_ID_GROUP MODIFY ID_ VARCHAR(255);

ALTER TABLE FLW_ID_GROUP ADD CONSTRAINT PK_FLW_ID_GROUP PRIMARY KEY (ID_);

ALTER TABLE FLW_ID_MEMBERSHIP MODIFY GROUP_ID_ VARCHAR(255);

CREATE INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP (GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

UPDATE ACT_GE_PROPERTY SET value_= 22 WHERE name_='idm.schema.version';


ALTER TABLE FLW_AGENT_INSTANCE ADD COLUMN NAME_ VARCHAR(255);
ALTER TABLE FLW_AGENT_INSTANCE ADD COLUMN CALLBACK_SCOPE_ID_ VARCHAR(255);

CREATE INDEX IDX_FLW_AGT_INS_CALLB_SCOPE_ID ON FLW_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

ALTER TABLE FLW_HI_AGENT_INSTANCE ADD COLUMN NAME_ VARCHAR(255);
ALTER TABLE FLW_HI_AGENT_INSTANCE ADD COLUMN CALLBACK_SCOPE_ID_ VARCHAR(255);

CREATE INDEX IDX_FLW_HI_AGT_INST_CALL_SCP_ID ON FLW_HI_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION
(
    ID_                     VARCHAR(255) NOT NULL,
    REV_                    INT      NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR(255) NOT NULL,
    OPERATION_KEY_          VARCHAR(255),
    START_TIME_             datetime(6) NOT NULL,
    END_TIME_               datetime(6),
    USER_ID_                VARCHAR(255),
    PROMPT_TOKEN_COUNT_     bigint,
    OUTPUT_TOKEN_COUNT_     bigint,
    CONSTRAINT PK_FLW_HI_AGENT_INVOCATION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_AGT_ID ON FLW_HI_AGENT_INVOCATION (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_AGT_ID FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION_EXCH
(
    ID_                         VARCHAR(255) NOT NULL,
    REV_                        INT      NOT NULL,
    INVOCATION_ID_              VARCHAR(255) NOT NULL,
    CREATION_TIME_              TIMESTAMP(6) NOT NULL,
    END_TIME_                   TIMESTAMP(6),
    DURATION_                   bigint,
    TYPE_                       VARCHAR(255),
    SUB_TYPE_                   VARCHAR(2000),
    USER_ID_                    VARCHAR(255),
    PROMPT_TOKEN_COUNT_         bigint,
    OUTPUT_TOKEN_COUNT_         bigint,
    TRANSACTION_ORDER_          INT NOT NULL DEFAULT 1,
    CONSTRAINT PK_FLW_HI_AGENT_INVOC_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_INV ON FLW_HI_AGENT_INVOCATION_EXCH (INVOCATION_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION_EXCH
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_INVOC FOREIGN KEY (INVOCATION_ID_) REFERENCES FLW_HI_AGENT_INVOCATION (ID_);

CREATE TABLE FLW_HI_AGENT_INVOC_EXCH_PART
(
    ID_                         VARCHAR(255) NOT NULL,
    EXCHANGE_ID_                VARCHAR(255) NOT NULL,
    TYPE_                       VARCHAR(255) NOT NULL,
    SUB_TYPE_                   VARCHAR(2000),
    CONTENT_                    TEXT,
    INVOCATION_SEQUENCE_        INT NOT NULL DEFAULT 1,
    CONSTRAINT PK_FLW_HI_AGT_INVOC_EXCH_PART PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_PART ON FLW_HI_AGENT_INVOC_EXCH_PART (EXCHANGE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOC_EXCH_PART
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_PART FOREIGN KEY (EXCHANGE_ID_) REFERENCES FLW_HI_AGENT_INVOCATION_EXCH (ID_);

drop table if exists FLW_AGENT_INSTANCE_EXCHANGE;
drop table if exists FLW_HI_AGENT_INSTANCE_EXCHANGE;

update ACT_GE_PROPERTY set VALUE_ = '2' where NAME_ = 'agent.schema.version';

