
CREATE TABLE FLW_ID_PROPERTY (
    NAME_ VARCHAR2(64) NOT NULL,
    VALUE_ VARCHAR2(300),
    REV_ INTEGER NOT NULL,
    CONSTRAINT PK_FLW_ID_PROPERTY PRIMARY KEY (NAME_)
);

CREATE TABLE FLW_ID_GROUP (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(64) DEFAULT '',
    NAME_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_FLW_ID_GROUP PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    FIRST_ VARCHAR2(255),
    LAST_ VARCHAR2(255),
    DISPLAY_NAME_ VARCHAR2(255),
    EMAIL_ VARCHAR2(255),
    PWD_ VARCHAR2(255),
    CREATOR_ID_ VARCHAR2(64),
    CREATION_TIME_ TIMESTAMP(6),
    UPDATER_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    AVATAR_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_FLW_ID_USER PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_MEMBERSHIP (
    USER_ID_ VARCHAR2(64) NOT NULL,
    GROUP_ID_ VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_FLW_ID_MEMBERSHIP PRIMARY KEY (USER_ID_, GROUP_ID_)
);

CREATE TABLE FLW_ID_USER_DEFINITIONS (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(128),
    KEY_ VARCHAR2(128),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    UPDATER_ID_ VARCHAR2(64),
    DEFINITION_CONTENT_ CLOB,
    CONSTRAINT PK_ID_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_INFO (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    USER_ID_ VARCHAR2(64),
    TYPE_ VARCHAR2(64),
    KEY_ VARCHAR2(255),
    VALUE_ VARCHAR2(255),
    PASSWORD_ BLOB,
    PARENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ID_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_IDENTITY_INFO (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    USER_ID_ VARCHAR2(64),
    GROUP_ID_REF_ VARCHAR2(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    TEXT2_ VARCHAR2(4000),
    UPDATE_TIME_ TIMESTAMP(6),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_FLW_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_TOKEN (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    TOKEN_VALUE_ VARCHAR2(255),
    TOKEN_DATE_ TIMESTAMP(6),
    IP_ADDRESS_ VARCHAR2(255),
    USER_AGENT_ VARCHAR2(255),
    USER_ID_ VARCHAR2(255),
    TOKEN_DATA_ VARCHAR2(2000),
    CONSTRAINT PK_FLW_ID_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV (
    ID_ VARCHAR2(64) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_FLW_ID_PRIV PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV_MAPPING (
    ID_ VARCHAR2(64) NOT NULL,
    PRIV_ID_ VARCHAR2(64) NOT NULL,
    USER_ID_ VARCHAR2(255),
    GROUP_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ID_PRIV_MAPPING PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP (GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

CREATE INDEX FLW_IDX_MEMB_USER ON FLW_ID_MEMBERSHIP (USER_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER (ID_);

CREATE INDEX FLW_IDX_PRIV_MAPPING ON FLW_ID_PRIV_MAPPING (PRIV_ID_);

ALTER TABLE FLW_ID_PRIV_MAPPING
    ADD CONSTRAINT FLW_FK_PRIV_MAPPING FOREIGN KEY (PRIV_ID_) REFERENCES FLW_ID_PRIV (ID_);

CREATE INDEX FLW_IDX_PRIV_USER ON FLW_ID_PRIV_MAPPING (USER_ID_);

CREATE INDEX FLW_IDX_PRIV_GROUP ON FLW_ID_PRIV_MAPPING (GROUP_ID_);

ALTER TABLE FLW_ID_PRIV
    ADD CONSTRAINT FLW_UNIQ_PRIV_NAME UNIQUE (NAME_);

CREATE INDEX FLW_IDX_USER_CREATE_TIME ON FLW_ID_USER (CREATION_TIME_);

CREATE INDEX FLW_IDX_USER_UPDATE_TIME ON FLW_ID_USER (UPDATE_TIME_);

CREATE INDEX FLW_IDX_IDM_INFO_USER_ID ON FLW_IDENTITY_INFO (USER_ID_);

CREATE INDEX FLW_IDX_IDM_INFO_GROUP_ID_REF ON FLW_IDENTITY_INFO (GROUP_ID_REF_);

CREATE TABLE FLW_ID_USER_ACCOUNT_DEFINITION (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(128),
    KEY_ VARCHAR2(128),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    UPDATER_ID_ VARCHAR2(64),
    DEFINITION_CONTENT_ CLOB,
    CONSTRAINT PK_ID_USER_ACCOUNT_DEFINITION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER_ACCOUNT (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    USER_ID_ VARCHAR2(64),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    NAME_ VARCHAR2(255),
    TYPE_ VARCHAR2(64),
    SUB_TYPE_ VARCHAR2(64),
    STATE_ VARCHAR2(64),
    SUB_STATE_ VARCHAR2(64),
    BUSINESS_ACCOUNT_ID_ VARCHAR2(255),
    EXTERNAL_USER_ID_ VARCHAR2(255),
    USER_ACCOUNT_DEFINITION_ID_ VARCHAR2(64),
    CREATOR_ID_ VARCHAR2(64),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATER_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_ID_USER_ACCOUNT PRIMARY KEY (ID_),
    CONSTRAINT FK_ID_USER_ACCOUNT_USER_DEF FOREIGN KEY (USER_ACCOUNT_DEFINITION_ID_) REFERENCES FLW_ID_USER_ACCOUNT_DEFINITION (ID_)
);

CREATE INDEX IDX_USER_ACC_TYPE_SUB_EXT_USER ON FLW_ID_USER_ACCOUNT (TYPE_, SUB_TYPE_, EXTERNAL_USER_ID_);

CREATE INDEX IDX_USER_ACCOUNT_USER ON FLW_ID_USER_ACCOUNT (USER_ID_);

CREATE INDEX IDX_USER_ACCOUNT_USER_DEF ON FLW_ID_USER_ACCOUNT (USER_ACCOUNT_DEFINITION_ID_);

CREATE TABLE FLW_ID_DESIGN_AUTHENTICATION (
    ID_ VARCHAR2(255) NOT NULL,
    USER_ID_ VARCHAR2(100) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    CREATE_TIME_ TIMESTAMP(6) NOT NULL,
    TOKEN_ VARCHAR2(2000),
    CONSTRAINT PK_FLW_ID_DESIGN_AUTHENTICATIO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_ACCESS_TOKEN (
    ID_ VARCHAR2(64) NOT NULL,
    NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(2000),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    EXPIRATION_TIME_ TIMESTAMP(6),
    USER_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    TOKEN_VALUE_ VARCHAR2(2000),
    CONSTRAINT PK_FLW_ID_ACCESS_TOKEN PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('idm.schema.version', '22', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR2(255) NOT NULL, RESOURCE_BYTES_ BLOB, CREATION_TIME_ TIMESTAMP(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR2(255) NOT NULL, TIMESTAMP_ TIMESTAMP(6) NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL, TENANT_ID_ VARCHAR2(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR2(255), TIMESTAMP_ TIMESTAMP(6) NOT NULL, COUNT_ NUMBER(38, 0) NOT NULL, SCOPE_TYPE_ VARCHAR2(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR2(255) NOT NULL, SIGNATURE_ CLOB NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_TRANSLATION (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATER_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR2(64) NOT NULL,
    KEY_ VARCHAR2(255) NOT NULL,
    LOCALE_ VARCHAR2(16) NOT NULL,
    VALUE_ CLOB,
    CONSTRAINT PK_FLW_TRANSLATION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TRANSLATION
    ADD CONSTRAINT FLW_UQ_TRANSL_SCOPE_KEY_LOCALE UNIQUE (SCOPE_ID_, SCOPE_TYPE_, KEY_, LOCALE_);

CREATE INDEX FLW_IDX_TRANSLATION_SCOPE ON FLW_TRANSLATION (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_COMMENT (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    CONTENT_ CLOB,
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(64),
    USER_ID_ VARCHAR2(255),
    CREATED_ TIMESTAMP(6),
    UPDATED_ TIMESTAMP(6),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_COMMENT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_COMMENT_SCOPE_ID ON FLW_COMMENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_COMMENT_USER_ID ON FLW_COMMENT (USER_ID_);

CREATE TABLE FLW_CONFIGURATION_PROPERTY (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAMESPACE_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(500),
    TEXT_VALUE_ CLOB,
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    LAST_UPDATER_ID_ VARCHAR2(64),
    LAST_UPDATE_TIME_ TIMESTAMP(6) NOT NULL,
    CONSTRAINT PK_FLW_CONFIGURATION_PROPERTY PRIMARY KEY (ID_)
);

CREATE INDEX FLW_CON_PROP_NS_NAME_TENANT ON FLW_CONFIGURATION_PROPERTY (NAMESPACE_, NAME_, TENANT_ID_);

CREATE TABLE FLW_PL_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_PL_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_PL_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_PL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PL_RSRC_DPL ON FLW_PL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_QUERY_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    TYPE_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_QUERY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_QUERY_DEF_UNIQ ON FLW_QUERY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_QUERY_DEF_DEPLOYMENT ON FLW_QUERY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_QUERY_DEFINITION
    ADD CONSTRAINT FK_QUERY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_VAR_EXT_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    TYPE_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_VAR_EXT_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_VAR_EXT_DEF_UNIQ ON FLW_VAR_EXT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_VAR_EXT_DEF_DEPLOYMENT ON FLW_VAR_EXT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_VAR_EXT_DEFINITION
    ADD CONSTRAINT FK_VAR_EXT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SEQUENCE_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_SEQUENCE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SEQUENCE_DEF_UNIQ ON FLW_SEQUENCE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SEQUENCE_DEF_DEPLOYMENT ON FLW_SEQUENCE_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SEQUENCE_DEFINITION
    ADD CONSTRAINT FK_SEQUENCE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_DATA_DICTIONARY_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_DATA_DICTIONARY_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_DATA_DICT_DEF_UNIQ ON FLW_DATA_DICTIONARY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DATA_DICT_DEF_DEPLOYMENT ON FLW_DATA_DICTIONARY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DATA_DICTIONARY_DEFINITION
    ADD CONSTRAINT FK_DATA_DICT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SLA_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_SLA_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SLA_DEF_UNIQ ON FLW_SLA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SLA_DEF_DEPLOYMENT ON FLW_SLA_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SLA_DEFINITION
    ADD CONSTRAINT FK_SLA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_TEN_VARIABLE (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255),
    NAME_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    BYTEARRAY_ID_ VARCHAR2(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    VARIABLE_PROTECTED_ NUMBER(1),
    CREATED_ TIMESTAMP(6),
    CREATED_BY_ VARCHAR2(255),
    LAST_MODIFIED_ TIMESTAMP(6),
    LAST_MODIFIED_BY_ VARCHAR2(255),
    CONSTRAINT PK_FLW_TEN_VARIABLE PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_TEN_VAR_NAME_TENANT ON FLW_TEN_VARIABLE (NAME_, TENANT_ID_);

CREATE TABLE FLW_SLA_AUDIT (
    ID_ VARCHAR2(255) NOT NULL,
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SUB_SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(64) NOT NULL,
    ROOT_SCOPE_ID_ VARCHAR2(255) NOT NULL,
    ROOT_SCOPE_TYPE_ VARCHAR2(64) NOT NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    SUB_SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    APP_KEY_ VARCHAR2(255),
    SLA_DEFINITION_KEY_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    CREATE_TIME_ TIMESTAMP(6) NOT NULL,
    IN_PROGRESS_START_TIME_ TIMESTAMP(6),
    IN_PROGRESS_STARTED_BY_ VARCHAR2(255),
    CLAIM_TIME_ TIMESTAMP(6),
    CLAIMED_BY_ VARCHAR2(255),
    COMPLETION_TIME_ TIMESTAMP(6),
    COMPLETED_BY_ VARCHAR2(255),
    IN_PROGRESS_START_DUE_TIME_ TIMESTAMP(6),
    COMPLETION_DUE_TIME_ TIMESTAMP(6),
    IN_PROGRESS_START_DUE_DUR_ INTEGER,
    COMPLETION_DUE_DURATION_ INTEGER,
    IN_PROGRESS_START_DURATION_ INTEGER,
    COMPLETION_DURATION_ INTEGER,
    IN_PROGRESS_START_RELATIVE_ INTEGER,
    COMPLETION_RELATIVE_ INTEGER,
    IN_PROGRESS_START_SLA_BREACH_ INTEGER,
    COMPLETION_SLA_BREACHED_ INTEGER,
    PAYLOAD_ CLOB,
    CONSTRAINT PK_FLW_SLA_AUDIT PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_SLA_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_SLA_SUB_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SUB_SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_DASHBOARD (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(255),
    CREATOR_ID_ VARCHAR2(255),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATER_ID_ VARCHAR2(255),
    UPDATE_TIME_ TIMESTAMP(6),
    CONFIGURATION_ CLOB,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_DASHBOARD PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DASHBOARD_COMP_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_DASHB_COMP_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_DASHB_COMP_DEF_UNIQ ON FLW_DASHBOARD_COMP_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DASHB_COMP_DEF_DEPLOYMENT ON FLW_DASHBOARD_COMP_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DASHBOARD_COMP_DEFINITION
    ADD CONSTRAINT FK_DASHB_COMP_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_OAUTH_CLIENT_REG (
    ID_ VARCHAR2(255) NOT NULL,
    REGISTRATION_KEY_ VARCHAR2(255) NOT NULL,
    CLIENT_ID_ VARCHAR2(100),
    CLIENT_SECRET_ VARCHAR2(255),
    CLIENT_NAME_ VARCHAR2(255),
    CLIENT_AUTHENTICATION_METHOD_ VARCHAR2(200),
    SCOPES_ VARCHAR2(2000),
    ISSUER_URI_ VARCHAR2(2000),
    TOKEN_URI_ VARCHAR2(2000),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT FLW_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_OAUTH_CL_REG_KEY_TEN ON FLW_OAUTH_CLIENT_REG (REGISTRATION_KEY_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('platform.schema.version', '19', 1);


CREATE TABLE ACT_APP_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    CREATOR_ID_ VARCHAR2(64),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_ACT_APP_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_APP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT ACT_FK_APP_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_RSRC_DPL ON ACT_APP_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE ACT_APP_APPDEF (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    CATEGORY_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    SUB_TYPE_ VARCHAR2(255),
    STATE_ VARCHAR2(255),
    SUB_STATE_ VARCHAR2(255),
    APP_URL_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_NAME_ VARCHAR2(4000),
    DESCRIPTION_ VARCHAR2(4000),
    CREATION_TIME_ TIMESTAMP(6),
    CREATOR_ID_ VARCHAR2(64),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_ACT_APP_APPDEF PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_APPDEF
    ADD CONSTRAINT ACT_FK_APP_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_DEF_DPLY ON ACT_APP_APPDEF (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_APP_DEF_UNIQ ON ACT_APP_APPDEF (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE ACT_APP_PAGEDEF (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    APP_ID_ VARCHAR2(255),
    APP_KEY_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255) NOT NULL,
    PAGE_URL_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_ACT_APP_PAGEDEF PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_VARIABLE (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255),
    NAME_ VARCHAR2(255) NOT NULL,
    APP_KEY_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    BYTEARRAY_ID_ VARCHAR2(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    CONSTRAINT PK_ACT_APP_VARIABLE PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_VAR_KEY ON ACT_APP_VARIABLE (APP_KEY_);

CREATE INDEX ACT_IDX_APP_VAR_KEY_TENANT ON ACT_APP_VARIABLE (APP_KEY_, TENANT_ID_);

CREATE TABLE ACT_APP_INCIDENT (
    ID_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    SUB_TYPE_ VARCHAR2(255),
    APP_KEY_ VARCHAR2(255),
    ROOT_SCOPE_ID_ VARCHAR2(255),
    ROOT_SCOPE_TYPE_ VARCHAR2(255),
    ROOT_SCOPE_DEFINITION_ID_ VARCHAR2(255),
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SUB_SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    ELEMENT_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    INCIDENT_INFO_ CLOB,
    CREATE_TIME_ TIMESTAMP(6) NOT NULL,
    CONSTRAINT PK_ACT_APP_INCIDENT PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_INC_DEF_ROOT_KEY ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_K_TENANT ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY_TENANT ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_SCOPE ON ACT_APP_INCIDENT (ROOT_SCOPE_ID_, ROOT_SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_KEY ON ACT_APP_INCIDENT (APP_KEY_);

CREATE INDEX ACT_IDX_APP_INC_KEY_TENANT ON ACT_APP_INCIDENT (APP_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_SCOPE ON ACT_APP_INCIDENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_CREATE ON ACT_APP_INCIDENT (CREATE_TIME_);

insert into ACT_GE_PROPERTY
    values ('app.schema.version', '12', 1);


CREATE TABLE FLW_FO_FORM_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_FO_FORM_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_FO_FORM_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_FO_FORM_RESOURCE
    ADD CONSTRAINT FLW_FK_FO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_FO_FORM_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_FO_RSRC_DPL ON FLW_FO_FORM_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_FO_FORM_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    VERSION_ INTEGER,
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    RESOURCE_NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(255),
    CONSTRAINT PK_FLW_FO_FORM_DEFINITION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    FORM_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    TASK_ID_ VARCHAR2(255),
    PROC_INST_ID_ VARCHAR2(255),
    PROC_DEF_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SUBMITTED_DATE_ TIMESTAMP,
    SUBMITTED_BY_ VARCHAR2(255),
    FORM_VALUES_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_FO_FORM_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_CUSTOM_COMPONENT_DEF (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NULL,
    VERSION_ INTEGER,
    KEY_ VARCHAR2(255) NULL,
    DEPLOYMENT_ID_ VARCHAR2(255) NULL,
    COMPONENT_VERSION_ VARCHAR2(255) NULL,
    TENANT_ID_ VARCHAR2(255) NULL,
    DESCRIPTION_ VARCHAR2(255) NULL,
    CONSTRAINT PK_FLW_FO_CUST_COMPONENT_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX FLW_IDX_FORM_DEF_UNIQ ON FLW_FO_FORM_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE UNIQUE INDEX FLW_IDX_CUST_COMP_DEF_UNIQ ON FLW_FO_CUSTOM_COMPONENT_DEF (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX FLW_IDX_FORM_TASK ON FLW_FO_FORM_INSTANCE (TASK_ID_);

CREATE INDEX FLW_IDX_FORM_PROC ON FLW_FO_FORM_INSTANCE (PROC_INST_ID_);

CREATE INDEX FLW_IDX_FORM_SCOPE ON FLW_FO_FORM_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('form.schema.version', '11', 1);


CREATE TABLE FLW_CO_CONTENT_ITEM (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    MIME_TYPE_ VARCHAR2(255),
    TASK_ID_ VARCHAR2(255),
    PROC_INST_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    DEFINITION_ID_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    SUB_TYPE_ VARCHAR2(255),
    STATE_ VARCHAR2(255),
    SUB_STATE_ VARCHAR2(255),
    CONTENT_STORE_ID_ VARCHAR2(255),
    CONTENT_STORE_NAME_ VARCHAR2(255),
    CONTENT_AVAILABLE_ NUMBER(1) DEFAULT 0,
    CREATED_ TIMESTAMP(6),
    CREATED_BY_ VARCHAR2(255),
    LAST_MODIFIED_ TIMESTAMP(6),
    LAST_MODIFIED_BY_ VARCHAR2(255),
    CONTENT_SIZE_ NUMBER(38, 0) DEFAULT 0,
    LOCK_INFO_ VARCHAR2(255),
    VERSION_ INTEGER,
    VERSION_INFO_ VARCHAR2(255),
    VERSION_PARENT_ID_ VARCHAR2(255),
    FOLDER_PARENT_ID_ VARCHAR2(255),
    FOLDER_BASE_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_CO_CONTENT_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX idx_contitem_taskid ON FLW_CO_CONTENT_ITEM (TASK_ID_);

CREATE INDEX idx_contitem_procid ON FLW_CO_CONTENT_ITEM (PROC_INST_ID_);

CREATE INDEX idx_contitem_scope ON FLW_CO_CONTENT_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_RENDITION_ITEM (
    ID_ VARCHAR2(255) NOT NULL,
    CONTENT_ITEM_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    MIME_TYPE_ VARCHAR2(255),
    RENDITION_TYPE_ VARCHAR2(255),
    TASK_ID_ VARCHAR2(255),
    PROC_INST_ID_ VARCHAR2(255),
    CONTENT_STORE_ID_ VARCHAR2(255),
    CONTENT_STORE_NAME_ VARCHAR2(255),
    CONTENT_AVAILABLE_ NUMBER(1) DEFAULT 0,
    CREATED_ TIMESTAMP(6),
    LAST_MODIFIED_ TIMESTAMP(6),
    CONTENT_SIZE_ NUMBER(38, 0) DEFAULT 0,
    TENANT_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    CONSTRAINT PK_FLW_CO_RENDITION_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX idx_rendition_taskid ON FLW_CO_RENDITION_ITEM (TASK_ID_);

CREATE INDEX idx_rendition_procid ON FLW_CO_RENDITION_ITEM (PROC_INST_ID_);

CREATE INDEX idx_rendition_scope ON FLW_CO_RENDITION_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_CONTENT_OBJECT (
    ID_ VARCHAR2(255) NOT NULL,
    CREATED_ TIMESTAMP(6),
    CONTENT_ BLOB,
    CONSTRAINT PK_FLW_CO_CONTENT_OBJECT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_CO_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_CO_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    NAME_ VARCHAR2(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    CATEGORY_ VARCHAR2(255),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATE_TIME_ TIMESTAMP(6),
    CONSTRAINT PK_CO_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_METADATA (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    CONTENT_ITEM_ID_ VARCHAR2(255),
    BYTEARRAY_ID_ VARCHAR2(255),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    TEXT2_ VARCHAR2(4000),
    CONSTRAINT PK_FLW_CO_METADATA PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CO_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_CO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_CO_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_CO_RSRC_DPL ON FLW_CO_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE INDEX idx_contitem_folder ON FLW_CO_CONTENT_ITEM (FOLDER_PARENT_ID_);

CREATE INDEX idx_contitem_name ON FLW_CO_CONTENT_ITEM (NAME_);

CREATE INDEX idx_contitem_verparid ON FLW_CO_CONTENT_ITEM (VERSION_PARENT_ID_);

CREATE INDEX idx_contitem_bfolder ON FLW_CO_CONTENT_ITEM (FOLDER_BASE_ID_);

CREATE INDEX idx_rendition_contentid ON FLW_CO_RENDITION_ITEM (CONTENT_ITEM_ID_);

CREATE INDEX idx_metadata_contentid ON FLW_CO_METADATA (CONTENT_ITEM_ID_);

CREATE UNIQUE INDEX FLW_IDX_CO_DEF_UNIQ ON FLW_CO_DEFINITION (KEY_, VERSION_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('content.schema.version', '18', 1);


CREATE TABLE FLW_ACTION_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ACTION_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_ACTION_DEPLOYMENT_RESOU PRIMARY KEY (ID_)
);

ALTER TABLE FLW_ACTION_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_ACTION_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_ACTION_RSRC_DPL ON FLW_ACTION_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_ACTION_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    BOT_KEY_ VARCHAR2(128),
    MANDATORY_ NUMBER(1),
    NAME_ VARCHAR2(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    SCOPE_TYPE_ VARCHAR2(128),
    FORM_KEY_ VARCHAR2(128),
    GLOBAL_ NUMBER(1),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64) NULL,
    UPDATE_TIME_ TIMESTAMP(6),
    UPDATER_ID_ VARCHAR2(64),
    CONSTRAINT PK_ACTION_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    START_DATE_ TIMESTAMP(6),
    FORM_KEY_ VARCHAR2(128),
    FORM_INSTANCE_ID_ VARCHAR2(255),
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SUB_SCOPE_ID_ VARCHAR2(255),
    PRIORITY_ INTEGER,
    ICON_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ACTION_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR2(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR2(255) NOT NULL,
    CREATION_TIME_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_ACTION_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_)
);

CREATE INDEX FLW_IDX_ACTION_LINK_SCOPE ON FLW_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_ACTION_DEFINITION
    ADD CONSTRAINT FK_ACTION_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

ALTER TABLE FLW_ACTION_INSTANCE
    ADD CONSTRAINT FK_ACTION_INST_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_);

CREATE INDEX IDX_ACTION_LINK_ACTION_INST ON FLW_ACTION_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_DEFINITION_ID_ ON FLW_ACTION_LINK (ACTION_DEFINITION_ID_);

CREATE INDEX IDX_ACTION_DEF_DEPLOYMENT ON FLW_ACTION_DEFINITION (DEPLOYMENT_ID_);

CREATE INDEX IDX_ACTION_INST_ACTION_DEF ON FLW_ACTION_INSTANCE (ACTION_DEFINITION_ID_);

CREATE TABLE FLW_HI_ACTION_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    START_DATE_ TIMESTAMP(6),
    EXECUTION_DATE_ TIMESTAMP(6),
    EXECUTED_BY_ VARCHAR2(255),
    FORM_KEY_ VARCHAR2(128),
    FORM_INSTANCE_ID_ VARCHAR2(255),
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SUB_SCOPE_ID_ VARCHAR2(255),
    PRIORITY_ INTEGER,
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_HI_ACTION_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_HI_ACTION_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR2(255),
    ACTION_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR2(255) NOT NULL,
    CREATION_TIME_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_HI_ACTION_LINK PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_HI_ACTION_LINK_SCOPE ON FLW_HI_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_HI_ACTION_LINK_ACTION_INST ON FLW_HI_ACTION_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_HI_DEFINITION_ID_ ON FLW_HI_ACTION_LINK (ACTION_DEFINITION_ID_);

CREATE INDEX IDX_HI_ACTION_INST_ACTION_DEF ON FLW_HI_ACTION_INSTANCE (ACTION_DEFINITION_ID_);

CREATE TABLE FLW_ACTION_DEF_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    LINK_VALUE_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ACTION_DEF_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_DEF_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_)
);

CREATE INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON FLW_ACTION_DEF_LINK (ACTION_DEFINITION_ID_);

CREATE UNIQUE INDEX ACT_IDX_ACTIONs_DEF_UNIQ ON FLW_ACTION_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_ACTION_TYPE_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    LINK_VALUE_ VARCHAR2(255),
    CONSTRAINT PK_FLW_ACTION_TYPE_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACT_TYPE_LINK_ACT_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_)
);

CREATE INDEX IDX_ACT_TYPE_LINK_ACT_INST ON FLW_ACTION_TYPE_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACT_IDX_SCOPE_ID_TYPE ON FLW_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_HI_IDX_SCOPE_ID_TYPE ON FLW_HI_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('action.schema.version', '20', 1);


CREATE TABLE FLW_AUDIT_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    AUDIT_DEFINITION_ID_ VARCHAR2(255),
    CREATION_TIME_ TIMESTAMP(6),
    CREATOR_ID_ VARCHAR2(255),
    EXTERNAL_ID_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    SUB_TYPE_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SUB_SCOPE_ID_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    PAYLOAD_ CLOB,
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_AUDIT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_AUDIT_INST_DEF ON FLW_AUDIT_INSTANCE (AUDIT_DEFINITION_ID_);

CREATE INDEX FLW_IDX_AUDIT_INST_TYPE ON FLW_AUDIT_INSTANCE (TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_SCOPE ON FLW_AUDIT_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_CREATE ON FLW_AUDIT_INSTANCE (CREATION_TIME_);

insert into ACT_GE_PROPERTY
    values ('audit.schema.version', '4', 1);


CREATE TABLE FLW_DATAOBJECT_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_DATAOBJECT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_DO_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DATAOBJECT_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    NAME_ VARCHAR2(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    SOURCE_ID_ VARCHAR2(128),
    SOURCE_TYPE_ VARCHAR2(128),
    TYPE_ VARCHAR2(128),
    SUB_TYPE_ VARCHAR2(128),
    EXTERNAL_ID_ VARCHAR2(128),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    CONSTRAINT PK_DO_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DATAOBJECT_DEFINITION
    ADD CONSTRAINT FK_DATAOBJECT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DATAOBJECT_DEF_DEPLOYMENT ON FLW_DATAOBJECT_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DATAOBJECT_DEF_UNIQ ON FLW_DATAOBJECT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_MASTER_DATA_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR2(255) NOT NULL,
    EXTERNAL_ID_ VARCHAR2(128),
    KEY_ VARCHAR2(128),
    NAME_ VARCHAR2(255),
    STATE_ VARCHAR2(64),
    SORT_ORDER_ INTEGER,
    IS_FAVORITE_ NUMBER(1),
    DESCRIPTION_ VARCHAR2(2000),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(128),
    UPDATE_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATER_ID_ VARCHAR2(128),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_DO_DATA_INSTANCES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_VARIABLES (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    DATA_INSTANCE_ID_ VARCHAR2(255),
    BYTEARRAY_ID_ VARCHAR2(255),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    TEXT2_ VARCHAR2(4000),
    CONSTRAINT PK_FLW_DO_VARIABLES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_SCHEMA_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    CONSTRAINT PK_DO_SCHEMA_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DO_SCHEMA_DEFINITION
    ADD CONSTRAINT FK_DO_SCHEMA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DO_SCHEMA_DEF_DEPLOYMENT ON FLW_DO_SCHEMA_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DO_SCHEMA_DEF_UNIQ ON FLW_DO_SCHEMA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DO_DATAOBJECT_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR2(255) NOT NULL,
    LOOKUP_ID_ VARCHAR2(128),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(128),
    UPDATE_TIME_ TIMESTAMP(6) NOT NULL,
    UPDATER_ID_ VARCHAR2(128),
    SCOPE_ID_ VARCHAR2(255),
    SUB_SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    CONSTRAINT PK_DO_DATAOBJECT_INSTANCES PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('dataobject.schema.version', '7', 1);


CREATE TABLE FLW_POLICY_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_POLICY_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_POLICY_DEPLOYMENT_RESOU PRIMARY KEY (ID_)
);

ALTER TABLE FLW_POLICY_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_POLICY_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_POLICY_RSRC_DPL ON FLW_POLICY_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_POLICY_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    TYPE_ VARCHAR2(128),
    NAME_ VARCHAR2(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    CONSTRAINT PK_POLICY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEF_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    POLICY_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    LINK_VALUE_ VARCHAR2(255),
    CONSTRAINT PK_FLW_POLICY_DEF_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_POLICY_DEF_LINK_POLICY_DEF FOREIGN KEY (POLICY_DEFINITION_ID_) REFERENCES FLW_POLICY_DEFINITION (ID_)
);

ALTER TABLE FLW_POLICY_DEFINITION
    ADD CONSTRAINT FK_POLICY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX IDX_POLICY_DEF_DEPLOYMENT ON FLW_POLICY_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_POLICIES_DEF_UNIQ ON FLW_POLICY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_POLICY_DEF_LINK_POLICY_DEF ON FLW_POLICY_DEF_LINK (POLICY_DEFINITION_ID_);

insert into ACT_GE_PROPERTY
    values ('policy.schema.version', '3', 1);


CREATE TABLE FLW_SE_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_SE_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_SE_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_SE_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_SE_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_SE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_SE_RSRC_DPL ON FLW_SE_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_SE_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    REFERENCE_KEY_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    NAME_ VARCHAR2(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR2(4000),
    CONSTRAINT PK_SERVICE_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX ACT_IDX_SERVICE_DEF_UNIQ ON FLW_SE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_SE_DEFINITION
    ADD CONSTRAINT FK_SERVICE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX IDX_SERVICE_DEF_DEPLOYMENT ON FLW_SE_DEFINITION (DEPLOYMENT_ID_);

insert into ACT_GE_PROPERTY
    values ('service.schema.version', '4', 1);


CREATE TABLE FLW_TEMPL_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT_RESOUR PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_TEMPL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_TEMPL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_TEMPL_RSRC_DPL ON FLW_TEMPL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_TEMPL_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    TYPE_ VARCHAR2(128),
    SUB_TYPE_ VARCHAR2(128),
    FORM_KEY_ VARCHAR2(128),
    RESOURCE_NAME_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    UPDATE_TIME_ TIMESTAMP(6),
    UPDATOR_ID_ VARCHAR2(64),
    CONSTRAINT PK_TEMPL_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_VAR_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(128),
    TEMPLATE_DEF_KEY_ VARCHAR2(128),
    VARIATION_KEY_ VARCHAR2(128),
    DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL,
    VERSION_ INTEGER,
    VALID_FROM_ TIMESTAMP(6),
    VALID_TO_ TIMESTAMP(6),
    RESOURCE_NAME_ VARCHAR2(4000),
    EXTERNAL_ID_ VARCHAR2(255),
    CONTENT_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    CREATOR_ID_ VARCHAR2(64),
    CONSTRAINT PK_TEMPL_VAR_DEFINITIONS PRIMARY KEY (ID_)
);

create index FLW_IDX_TEMPL_VAR_DEF_DEF_KEY
    on FLW_TEMPL_VAR_DEFINITION (TEMPLATE_DEF_KEY_, VARIATION_KEY_);

INSERT INTO ACT_GE_PROPERTY
VALUES ('template.schema.version', '8', 1);


CREATE TABLE FLW_AGENT_DEPLOYMENT
(
    ID_                   VARCHAR2(255) NOT NULL,
    NAME_                 VARCHAR2(255),
    KEY_                  VARCHAR2(255),
    CATEGORY_             VARCHAR2(255),
    DEPLOY_TIME_          TIMESTAMP,
    TENANT_ID_            VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEPLOYMENT_RES
(
    ID_             VARCHAR2(255) NOT NULL,
    NAME_           VARCHAR2(255),
    DEPLOYMENT_ID_  VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEFINITION
(
    ID_              VARCHAR2(255) NOT NULL,
    REV_             INTEGER       NOT NULL,
    KEY_             VARCHAR2(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR2(255) NOT NULL,
    NAME_            VARCHAR2(255),
    DESCRIPTION_     VARCHAR2(4000),
    API_ENABLED_     NUMBER(1) DEFAULT 0,
    RESOURCE_NAME_   VARCHAR2(4000),
    TYPE_            VARCHAR2(255) NOT NULL,
    TENANT_ID_       VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_AGENT_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_DEF_UNIQ ON FLW_AGENT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_DEF_DEPLOYMENT ON FLW_AGENT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);

CREATE TABLE FLW_AGENT_INSTANCE
(
    ID_                  VARCHAR2(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    NAME_                VARCHAR2(255),
    TENANT_ID_           VARCHAR2(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) NOT NULL,
    START_USER_ID_       VARCHAR2(255),
    CHAT_ENABLED_        NUMBER(1) DEFAULT 0,
    REFERENCE_ID_        VARCHAR2(255),
    REFERENCE_TYPE_      VARCHAR2(255),
    CALLBACK_SCOPE_ID_   VARCHAR2(255),
    CALLBACK_ID_         VARCHAR2(255),
    CALLBACK_TYPE_       VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INSTANCE_DEF_ID ON FLW_AGENT_INSTANCE (AGENT_DEFINITION_ID_);
CREATE INDEX IDX_FLW_AGENT_INSTANCE_REF_ID ON FLW_AGENT_INSTANCE (REFERENCE_ID_);
CREATE INDEX IDX_FLW_AGT_INS_CALLB_SCOPE_ID ON FLW_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE
    ADD CONSTRAINT FK_FLW_AGENT_INSTANCE_DEF FOREIGN KEY (AGENT_DEFINITION_ID_) REFERENCES FLW_AGENT_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_KB_DEFINITION
(
    ID_              VARCHAR2(255) NOT NULL,
    REV_             INTEGER      NOT NULL,
    KEY_             VARCHAR2(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR2(255) NOT NULL,
    NAME_            VARCHAR2(255),
    DESCRIPTION_     VARCHAR2(4000),
    RESOURCE_NAME_   VARCHAR2(4000),
    TENANT_ID_       VARCHAR2(64) DEFAULT '',
    READY_           NUMBER(1) DEFAULT 0 NOT NULL,
    CONSTRAINT PK_FLW_AGENT_KB_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_UNIQ ON FLW_AGENT_KB_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_KB_DEF_DEPL ON FLW_AGENT_KB_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_KB_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_KB_DEF_DEPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);


CREATE TABLE FLW_AGENT_KB_ITEM
(
    ID_                    VARCHAR2(255) NOT NULL,
    PARENT_ID_             VARCHAR2(255),
    ROOT_ID_               VARCHAR2(255),
    KB_DEF_ID_             VARCHAR2(255),
    IS_CONTAINER_          NUMBER(1) DEFAULT 0 NOT NULL,
    SCOPE_ID_              VARCHAR2(255),
    SCOPE_TYPE_            VARCHAR2(255),
    CHECKSUM_              VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_UNIQ ON FLW_AGENT_KB_ITEM (SCOPE_ID_, SCOPE_TYPE_);
CREATE INDEX IDX_FLW_AGENT_KB_ITEM_DEF ON FLW_AGENT_KB_ITEM (KB_DEF_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_DEF FOREIGN KEY (KB_DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE
(
    ID_                  VARCHAR2(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    NAME_                VARCHAR2(255),
    TENANT_ID_           VARCHAR2(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) NOT NULL,
    END_TIME_            TIMESTAMP(6),
    CHAT_ENABLED_        NUMBER(1) DEFAULT 0,
    STATE_               VARCHAR2(255),
    START_USER_ID_       VARCHAR2(255),
    REFERENCE_ID_        VARCHAR2(255),
    REFERENCE_TYPE_      VARCHAR2(255),
    CALLBACK_SCOPE_ID_   VARCHAR2(255),
    CALLBACK_ID_         VARCHAR2(255),
    CALLBACK_TYPE_       VARCHAR2(255),
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_DEF_ID ON FLW_HI_AGENT_INSTANCE (AGENT_DEFINITION_ID_);
CREATE INDEX IDX_FLW_HI_AGT_INS_CALL_SCP_ID ON FLW_HI_AGENT_INSTANCE (CALLBACK_SCOPE_ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION
(
    ID_                     VARCHAR2(255) NOT NULL,
    REV_                    INTEGER      NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR2(255) NOT NULL,
    OPERATION_KEY_          VARCHAR2(255),
    START_TIME_             TIMESTAMP(6) NOT NULL,
    END_TIME_               TIMESTAMP(6),
    USER_ID_                VARCHAR2(255),
    PROMPT_TOKEN_COUNT_     NUMBER(19,0),
    OUTPUT_TOKEN_COUNT_     NUMBER(19,0),
    CONSTRAINT PK_FLW_HI_AGENT_INVOCATION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_AGT_ID ON FLW_HI_AGENT_INVOCATION (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_AGT_ID FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INVOCATION_EXCH
(
    ID_                         VARCHAR2(255) NOT NULL,
    REV_                        INTEGER      NOT NULL,
    INVOCATION_ID_              VARCHAR2(255) NOT NULL,
    CREATION_TIME_              TIMESTAMP(6) NOT NULL,
    END_TIME_                   TIMESTAMP(6),
    DURATION_                   NUMBER(19,0),
    TYPE_                       VARCHAR2(255),
    SUB_TYPE_                   VARCHAR2(2000),
    USER_ID_                    VARCHAR2(255),
    PROMPT_TOKEN_COUNT_         NUMBER(19,0),
    OUTPUT_TOKEN_COUNT_         NUMBER(19,0),
    TRANSACTION_ORDER_          INTEGER DEFAULT 1 NOT NULL,
    CONSTRAINT PK_FLW_HI_AGENT_INVOC_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_INV ON FLW_HI_AGENT_INVOCATION_EXCH (INVOCATION_ID_);

ALTER TABLE FLW_HI_AGENT_INVOCATION_EXCH
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_INVOC FOREIGN KEY (INVOCATION_ID_) REFERENCES FLW_HI_AGENT_INVOCATION (ID_);

CREATE TABLE FLW_HI_AGENT_INVOC_EXCH_PART
(
    ID_                         VARCHAR2(255) NOT NULL,
    EXCHANGE_ID_                VARCHAR2(255) NOT NULL,
    TYPE_                       VARCHAR2(255) NOT NULL,
    SUB_TYPE_                   VARCHAR2(2000),
    CONTENT_                    CLOB,
    INVOCATION_SEQUENCE_        INTEGER DEFAULT 1 NOT NULL,
    CONSTRAINT PK_FLW_HI_AGT_INVOC_EXCH_PART PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGT_INVOC_EXCH_PART ON FLW_HI_AGENT_INVOC_EXCH_PART (EXCHANGE_ID_);

ALTER TABLE FLW_HI_AGENT_INVOC_EXCH_PART
    ADD CONSTRAINT FK_FLW_HI_AGT_INVOC_EXCH_PART FOREIGN KEY (EXCHANGE_ID_) REFERENCES FLW_HI_AGENT_INVOCATION_EXCH (ID_);

CREATE TABLE FLW_AGENT_KB_ITEM_SECTION
(
    ID_                     VARCHAR2(255) NOT NULL,
    KB_ITEM_ID_             VARCHAR2(255) NOT NULL,
    EXTERNAL_ID_            VARCHAR2(500),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM_SECTION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_SEC_ITEM ON FLW_AGENT_KB_ITEM_SECTION (KB_ITEM_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM_SECTION
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_SEC_ITEM FOREIGN KEY (KB_ITEM_ID_) REFERENCES FLW_AGENT_KB_ITEM (ID_);


CREATE TABLE FLW_HI_AGENT_INSTANCE_KB_LINK
(
    ID_                             VARCHAR2(255) NOT NULL,
    REV_                            INTEGER NOT NULL,
    AGENT_INSTANCE_ID_              VARCHAR2(255),
    KB_ITEM_SECTION_ID_             VARCHAR2(255),
    EXTERNAL_ID_                    VARCHAR2(500),
    SCORE_                          DOUBLE PRECISION,
    CONSTRAINT PK_FLW_HI_AGENT_INST_KB_LINK PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_KB_DEF_METADATA
(
    ID_     VARCHAR2(255) NOT NULL,
    REV_    INTEGER NOT NULL,
    DEF_ID_ VARCHAR2(255) NOT NULL,
    NAME_   VARCHAR2(255),
    VALUE_  VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_KB_DEF_METADATA PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_META_UNIQ ON FLW_AGENT_KB_DEF_METADATA (DEF_ID_, NAME_);

ALTER TABLE FLW_AGENT_KB_DEF_METADATA
    ADD CONSTRAINT FK_AGENT_KB_DEF_META_DEF_ FOREIGN KEY (DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

insert into ACT_GE_PROPERTY
values ('agent.schema.version', '2', 1);


CREATE TABLE FLW_ENGAGE_CONVERSATION (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR2(128), TENANT_ID_ VARCHAR2(64) DEFAULT '', PARENT_ID_ VARCHAR2(64), REFERENCE_ID_ VARCHAR2(64), REFERENCE_TYPE_ VARCHAR2(64), REFERENCE_DEFINITION_ID_ VARCHAR2(64), CONVERSATION_DEFINITION_ID_ VARCHAR2(64), STATE_ VARCHAR2(64), TYPE_ VARCHAR2(64), SUB_TYPE_ VARCHAR2(64), PERMISSION_TYPE_ VARCHAR2(64), JOINING_TYPE_ VARCHAR2(64), PRIORITY_ INTEGER, NAME_ VARCHAR2(255), FALLBACK_NAME_ VARCHAR2(4000), DESCRIPTION_ VARCHAR2(4000), AVATAR_ID_ VARCHAR2(255), CREATION_TIME_ TIMESTAMP(6), CREATOR_ID_ VARCHAR2(64), UPDATE_TIME_ TIMESTAMP(6), UPDATER_ID_ VARCHAR2(64), RESUBMISSION_TIME_ TIMESTAMP(6), LAST_MESSAGE_TIME_ TIMESTAMP(6), METADATA_ CLOB, TAGS_ CLOB, CONSTRAINT PK_ENGAGE_CONVERSATION PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_MESSAGE (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR2(128), REPLY_TO_MESSAGE_ID_ VARCHAR2(64), TENANT_ID_ VARCHAR2(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR2(128), MEDIA_CONTENT_ID_ VARCHAR2(128), RECIPIENT_GROUP_ID_ VARCHAR2(64), CATEGORY_ VARCHAR2(64) NOT NULL, TYPE_ VARCHAR2(64), SUB_TYPE_ VARCHAR2(64), CREATION_TIME_ TIMESTAMP(6) NOT NULL, CREATOR_ID_ VARCHAR2(64), UPDATE_TIME_ TIMESTAMP(6), UPDATER_ID_ VARCHAR2(64), SENDER_ID_ VARCHAR2(64) NOT NULL, PRIVATE_ NUMBER(1) DEFAULT 0, CONVERSATION_ID_ VARCHAR2(64), STICKY_ NUMBER(1) DEFAULT 0, TAGS_ CLOB, MAIN_CONTENT_ CLOB, MAIN_CONTENT_TYPE_ VARCHAR2(64), RECIPIENT_ID_ VARCHAR2(64), CONSTRAINT PK_ENGAGE_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_MESSAGE_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_MSG_CONVERSATION ON FLW_ENGAGE_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_MSG_CREATION_TIME ON FLW_ENGAGE_MESSAGE(CREATION_TIME_);

CREATE TABLE FLW_CONV_PARTICIPANT_REGISTRY (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, CONVERSATION_ID_ VARCHAR2(64) NOT NULL, USER_ID_ VARCHAR2(64), GROUP_ID_ VARCHAR2(64), USER_ACCOUNT_ID_ VARCHAR2(64), PARTICIPANT_TYPE_ VARCHAR2(255), CREATION_TIME_ TIMESTAMP(6) NOT NULL, UPDATE_TIME_ TIMESTAMP(6), JOINING_TIME_ TIMESTAMP(6) NOT NULL, LEAVING_TIME_ TIMESTAMP(6), CONSTRAINT PK_CONV_PARTICIPANT_REGISTRY PRIMARY KEY (ID_), CONSTRAINT FK_CONV_PART_REG_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_) ON DELETE CASCADE);

CREATE TABLE FLW_ENGAGE_CONV_DEFINITIONS (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, NAME_ VARCHAR2(128), KEY_ VARCHAR2(128), TYPE_ VARCHAR2(128), TENANT_ID_ VARCHAR2(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) NOT NULL, CREATOR_ID_ VARCHAR2(64), UPDATE_TIME_ TIMESTAMP(6), UPDATER_ID_ VARCHAR2(64), DEFINITION_CONTENT_ CLOB, CONSTRAINT PK_ENGAGE_CONV_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_CONVERSATION_STATUS (ID_ VARCHAR2(64) NOT NULL, USER_ID_ VARCHAR2(64) NOT NULL, CONVERSATION_ID_ VARCHAR2(64), FILTER_ID_ VARCHAR2(64), TENANT_ID_ VARCHAR2(64) DEFAULT '', UNREAD_MESSAGE_COUNT_ INTEGER, UNREAD_PERSONAL_MESSAGE_COUNT_ INTEGER, UNSENT_MESSAGE_COUNT_ INTEGER, LAST_READ_MESSAGE_ID_ VARCHAR2(64), LAST_READ_MESSAGE_TIMESTAMP_ TIMESTAMP(6), LAST_SENT_MESSAGE_ID_ VARCHAR2(64), LAST_SENT_MESSAGE_TIMESTAMP_ TIMESTAMP(6), CONSTRAINT PK_ENGAGE_CONVERSATION_STATUS PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_CONV_STAT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV_FLT ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_, FILTER_ID_);

CREATE TABLE FLW_ENGAGE_ARC_CONV_EVENT (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) NOT NULL, CONVERSATION_ID_ VARCHAR2(64), SECTION_ID_ INTEGER, PERIOD_START_TIME_ TIMESTAMP(6), PERIOD_END_TIME_ TIMESTAMP(6), PARTICIPANT_IDS_ CLOB, PARTICIPANT_NAMES_ CLOB, MESSAGE_COUNT_ INTEGER, EVENT_COUNT_ INTEGER, ATTACHMENT_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_ARC_CONV_EVENT PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_ARC_JOB_EVENT (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) NOT NULL, START_TIME_ TIMESTAMP(6), END_TIME_ TIMESTAMP(6), CONVERSATION_COUNT_ INTEGER, PARTICIPANT_COUNT_ INTEGER, DATA_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_ARC_JOB_EVENT PRIMARY KEY (ID_));

CREATE INDEX IDX_ENGAGE_ARC_CONV_CREATE ON FLW_ENGAGE_ARC_CONV_EVENT(CREATION_TIME_);

CREATE INDEX IDX_ENGAGE_ARC_CONV_CONV ON FLW_ENGAGE_ARC_CONV_EVENT(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_ARC_JOB_EVT_CREATE ON FLW_ENGAGE_ARC_JOB_EVENT(CREATION_TIME_);

CREATE INDEX IDX_CONV_PART_REG_CONVERSATION ON FLW_CONV_PARTICIPANT_REGISTRY(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_CONV_STAT_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(CONVERSATION_ID_);

CREATE TABLE FLW_ENGAGE_USER_ANALYTICS (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) NOT NULL, USER_ID_ VARCHAR2(64), START_TIME_ TIMESTAMP(6), END_TIME_ TIMESTAMP(6), CONVERSATION_COUNT_ INTEGER, MESSAGE_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_USER_ANALYTICS PRIMARY KEY (ID_));

CREATE INDEX FLW_IDX_MSG_EXTERNAL_ID ON FLW_ENGAGE_MESSAGE(EXTERNAL_ID_);

CREATE INDEX FLW_IDX_CONV_EXTERNAL_ID ON FLW_ENGAGE_CONVERSATION(EXTERNAL_ID_);

CREATE TABLE FLW_ENGAGE_TEMP_MESSAGE (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR2(128), REPLY_TO_MESSAGE_ID_ VARCHAR2(64), TENANT_ID_ VARCHAR2(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR2(128), MEDIA_CONTENT_ID_ VARCHAR2(128), RECIPIENT_GROUP_ID_ VARCHAR2(64), CATEGORY_ VARCHAR2(64) NOT NULL, TYPE_ VARCHAR2(64), SUB_TYPE_ VARCHAR2(64), CREATION_TIME_ TIMESTAMP(6) NOT NULL, CREATOR_ID_ VARCHAR2(64), UPDATE_TIME_ TIMESTAMP(6), UPDATER_ID_ VARCHAR2(64), SENDER_ID_ VARCHAR2(64) NOT NULL, PRIVATE_ NUMBER(1) DEFAULT 0, CONVERSATION_ID_ VARCHAR2(64), STICKY_ NUMBER(1) DEFAULT 0, TAGS_ CLOB, MAIN_CONTENT_ CLOB, MAIN_CONTENT_TYPE_ VARCHAR2(64), RECIPIENT_ID_ VARCHAR2(64), PROCESSED_ NUMBER(1) DEFAULT 0, PROCESSING_STATUS_ VARCHAR2(255), PROCESSING_REASON_ CLOB, CONSTRAINT PK_ENGAGE_TEMP_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_TEMP_MSG_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_TEMP_MSG_CONVERSATION ON FLW_ENGAGE_TEMP_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_TEMP_MSG_CREATION_TIME ON FLW_ENGAGE_TEMP_MESSAGE(CREATION_TIME_);

CREATE INDEX FLW_IDX_TEMP_MSG_EXTERNAL_ID ON FLW_ENGAGE_TEMP_MESSAGE(EXTERNAL_ID_);

CREATE TABLE FLW_ENGAGE_DEVICE (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) NOT NULL, CREATOR_ID_ VARCHAR2(64), UPDATE_TIME_ TIMESTAMP(6), UPDATER_ID_ VARCHAR2(64), TENANT_ID_ VARCHAR2(64) DEFAULT '', TOKEN_ VARCHAR2(255), TOKEN_ENCODING_ VARCHAR2(64), ENABLED_ NUMBER(1) DEFAULT 1, DEVICE_OS_ VARCHAR2(64), USER_ID_ VARCHAR2(64), APPLICATION_ID_ VARCHAR2(255), CONSTRAINT PK_ENGAGE_DEVICE PRIMARY KEY (ID_));

CREATE INDEX IDX_ENGAGE_USR_FILTER ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, FILTER_ID_);

CREATE TABLE FLW_ENGAGE_REACTION (ID_ VARCHAR2(64) NOT NULL, MESSAGE_ID_ VARCHAR2(64) NOT NULL, USER_ID_ VARCHAR2(64) NOT NULL, REACTION_ CLOB NOT NULL, CONSTRAINT PK_ENGAGE_REACTION PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_REACTION_MESSAGE FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE);

CREATE INDEX FLW_IDX_REACTION_MSG ON FLW_ENGAGE_REACTION(MESSAGE_ID_);

CREATE TABLE FLW_ENGAGE_MESSAGE_AUDIT (ID_ VARCHAR2(64) NOT NULL, REV_ INTEGER NOT NULL, MESSAGE_ID_ VARCHAR2(64) NOT NULL, MEDIA_CONTENT_ID_ VARCHAR2(128), CONVERSATION_ID_ VARCHAR2(64), MAIN_CONTENT_ CLOB, MAIN_CONTENT_TYPE_ VARCHAR2(64), CREATION_TIME_ TIMESTAMP(6) NOT NULL, CREATOR_ID_ VARCHAR2(64), MODIFY_TIME_ TIMESTAMP(6) NOT NULL, MODIFIER_ID_ VARCHAR2(64), CONSTRAINT PK_ENGAGE_MESSAGE_AUDIT PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_MESSAGE_AUDIT_MSG FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE, CONSTRAINT FK_ENGAGE_MESSAGE_AUDIT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_MESSAGE_AUDIT_MSG ON FLW_ENGAGE_MESSAGE_AUDIT(MESSAGE_ID_);

CREATE INDEX FLW_IDX_MESSAGE_AUDIT_CONV ON FLW_ENGAGE_MESSAGE_AUDIT(CONVERSATION_ID_);

CREATE TABLE FLW_ENGAGE_CONV_USR_ACCOUNT (CONVERSATION_ID_ VARCHAR2(64) NOT NULL, USER_ACCOUNT_ID_ VARCHAR2(64) NOT NULL, CONSTRAINT FK_CONV_USER_ACCOUNT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_) ON DELETE CASCADE, CONSTRAINT FK_CONV_USER_ACCOUNT_ACCOUNT FOREIGN KEY (USER_ACCOUNT_ID_) REFERENCES FLW_ID_USER_ACCOUNT(ID_) ON DELETE CASCADE);

CREATE TABLE FLW_ENGAGE_MSG_REF_MAPPING (MESSAGE_ID_ VARCHAR2(64) NOT NULL, REFERENCE_ID_ VARCHAR2(128), REFERENCE_TYPE_ VARCHAR2(64), CONSTRAINT FK_MSG_REF_MAPPING_MESSAGE_ID FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE);

CREATE INDEX FLW_IDX_MSG_REF_MAPPING_REF ON FLW_ENGAGE_MSG_REF_MAPPING(REFERENCE_TYPE_, REFERENCE_ID_);

CREATE INDEX FLW_IDX_CONV_USR_ACC_CONV ON FLW_ENGAGE_CONV_USR_ACCOUNT(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_CONV_USR_ACC_ACCOUNT ON FLW_ENGAGE_CONV_USR_ACCOUNT(USER_ACCOUNT_ID_);

CREATE INDEX FLW_IDX_MSG_REF_MAPPING_MSG ON FLW_ENGAGE_MSG_REF_MAPPING(MESSAGE_ID_);

insert into ACT_GE_PROPERTY
    values ('engage.schema.version', '28', 1);

