CREATE TABLE flw_pal_databasechangeloglock (ID INTEGER NOT NULL, LOCKED BOOLEAN NOT NULL, LOCKGRANTED TIMESTAMP WITHOUT TIME ZONE, LOCKEDBY VARCHAR(255), CONSTRAINT FLW_PAL_DATABASECHANGELOGLOCK_PKEY PRIMARY KEY (ID));

DELETE FROM flw_pal_databasechangeloglock;

INSERT INTO flw_pal_databasechangeloglock (ID, LOCKED) VALUES (1, FALSE);

UPDATE flw_pal_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02 09:47:17.609' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE flw_pal_databasechangelog (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP WITHOUT TIME ZONE NOT NULL, ORDEREXECUTED INTEGER NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_PALETTE_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), CATEGORY_ VARCHAR(255), KEY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, PARENT_DEPLOYMENT_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(255) DEFAULT '', CONSTRAINT FLW_PALETTE_DEPLOYMENT_PKEY PRIMARY KEY (ID_));

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_));

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES(DEPLOYMENT_ID_);

CREATE TABLE FLW_PALETTE_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INTEGER NOT NULL, NAME_ VARCHAR(255), KEY_ VARCHAR(255) NOT NULL, VERSION_ INTEGER NOT NULL, DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_NAME_ VARCHAR(4000), DESCRIPTION_ VARCHAR(4000), SCOPE_TYPE_ VARCHAR(255), TENANT_ID_ VARCHAR(255) DEFAULT '', CONSTRAINT FLW_PALETTE_DEFINITION_PKEY PRIMARY KEY (ID_));

CREATE UNIQUE INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION(KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_PALETTE_DEFINITION ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION(DEPLOYMENT_ID_);

INSERT INTO flw_pal_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/palette/db/liquibase/flowable-palette-db-changelog.xml', NOW(), 1, '8:9b2702b823e8fdbd4e097db40cc57c20', 'createTable tableName=FLW_PALETTE_DEPLOYMENT; createTable tableName=FLW_PALETTE_DEPLOYMENT_RES; addForeignKeyConstraint baseTableName=FLW_PALETTE_DEPLOYMENT_RES, constraintName=FLW_FK_PALETTE_RSRC_DPL, referencedTableName=FLW_PALETTE_DEPLOYMENT; c...', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791638405');

UPDATE flw_pal_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

UPDATE act_de_databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02 09:47:19.226' WHERE ID = 1 AND LOCKED = FALSE;

CREATE TABLE FLW_DE_TENANT (TENANT_ID_ VARCHAR(255) NOT NULL, CONSTRAINT FLW_DE_TENANT_PKEY PRIMARY KEY (TENANT_ID_));

INSERT INTO FLW_DE_TENANT (TENANT_ID_) VALUES ('default');

INSERT INTO act_de_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 6, '8:23bc223608ea31a73f17ca2adb0a13b8', 'createTable tableName=FLW_DE_TENANT; insert tableName=FLW_DE_TENANT', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791639468');

ALTER TABLE ACT_DE_MODEL_RELATION ADD app_model_id VARCHAR(255);

ALTER TABLE ACT_DE_MODEL_METADATA ADD scope_info TEXT;

INSERT INTO act_de_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 7, '8:4e404d08cf64d77c45dc56bb8e436ab4', 'addColumn tableName=ACT_DE_MODEL_RELATION; addColumn tableName=ACT_DE_MODEL_METADATA', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791639468');

CREATE TABLE ACT_DE_MODEL_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), TYPE_ VARCHAR(255), CREATION_TIME_ TIMESTAMP WITHOUT TIME ZONE NOT NULL, MODEL_ID_ VARCHAR(255), RESOURCE_BYTES_ BYTEA, RESOURCE_TYPE_ VARCHAR(255), CONSTRAINT ACT_DE_MODEL_RESOURCE_PKEY PRIMARY KEY (ID_));

ALTER TABLE ACT_DE_MODEL_RESOURCE ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id);

CREATE INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE(MODEL_ID_);

INSERT INTO act_de_databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 8, '8:7ef6226e5b7ebb80e002b30ee84e92fc', 'createTable tableName=ACT_DE_MODEL_RESOURCE; addForeignKeyConstraint baseTableName=ACT_DE_MODEL_RESOURCE, constraintName=fk_model_resource, referencedTableName=ACT_DE_MODEL; createIndex indexName=idx_model_resource, tableName=ACT_DE_MODEL_RESOURCE', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791639468');

UPDATE act_de_databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;
