
CREATE TABLE FLOWABLE.FLW_PAL_DATABASECHANGELOGLOCK (ID INTEGER NOT NULL, LOCKED NUMBER(1) NOT NULL, LOCKGRANTED TIMESTAMP, LOCKEDBY VARCHAR2(255), CONSTRAINT PK_FLW_PAL_DATABASECHANGELOGLO PRIMARY KEY (ID));

DELETE FROM FLOWABLE.FLW_PAL_DATABASECHANGELOGLOCK;

INSERT INTO FLOWABLE.FLW_PAL_DATABASECHANGELOGLOCK (ID, LOCKED) VALUES (1, 0);

UPDATE FLOWABLE.FLW_PAL_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = TO_TIMESTAMP('2022-02-02 08:51:13.231', 'YYYY-MM-DD HH24:MI:SS.FF') WHERE ID = 1 AND LOCKED = 0;

CREATE TABLE FLOWABLE.FLW_PAL_DATABASECHANGELOG (ID VARCHAR2(255) NOT NULL, AUTHOR VARCHAR2(255) NOT NULL, FILENAME VARCHAR2(255) NOT NULL, DATEEXECUTED TIMESTAMP NOT NULL, ORDEREXECUTED INTEGER NOT NULL, EXECTYPE VARCHAR2(10) NOT NULL, MD5SUM VARCHAR2(35), DESCRIPTION VARCHAR2(255), COMMENTS VARCHAR2(255), TAG VARCHAR2(255), LIQUIBASE VARCHAR2(20), CONTEXTS VARCHAR2(255), LABELS VARCHAR2(255), DEPLOYMENT_ID VARCHAR2(10));

CREATE TABLE FLOWABLE.FLW_PALETTE_DEPLOYMENT (ID_ VARCHAR2(255) NOT NULL, NAME_ VARCHAR2(255), CATEGORY_ VARCHAR2(255), KEY_ VARCHAR2(255), DEPLOY_TIME_ TIMESTAMP(6), PARENT_DEPLOYMENT_ID_ VARCHAR2(255), TENANT_ID_ VARCHAR2(255) DEFAULT '', CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLOWABLE.FLW_PALETTE_DEPLOYMENT_RES (ID_ VARCHAR2(255) NOT NULL, NAME_ VARCHAR2(255), DEPLOYMENT_ID_ VARCHAR2(255), RESOURCE_BYTES_ BLOB, CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_));

ALTER TABLE FLOWABLE.FLW_PALETTE_DEPLOYMENT_RES ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLOWABLE.FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLOWABLE.FLW_IDX_PALETTE_RSRC_DPL ON FLOWABLE.FLW_PALETTE_DEPLOYMENT_RES(DEPLOYMENT_ID_);

CREATE TABLE FLOWABLE.FLW_PALETTE_DEFINITION (ID_ VARCHAR2(255) NOT NULL, REV_ INTEGER NOT NULL, NAME_ VARCHAR2(255), KEY_ VARCHAR2(255) NOT NULL, VERSION_ INTEGER NOT NULL, DEPLOYMENT_ID_ VARCHAR2(255), RESOURCE_NAME_ VARCHAR2(4000), DESCRIPTION_ VARCHAR2(4000), SCOPE_TYPE_ VARCHAR2(255), TENANT_ID_ VARCHAR2(255) DEFAULT '', CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_));

CREATE UNIQUE INDEX FLOWABLE.FLW_IDX_PALETTE_DEF_UNIQ ON FLOWABLE.FLW_PALETTE_DEFINITION(KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLOWABLE.FLW_PALETTE_DEFINITION ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLOWABLE.FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLOWABLE.FLW_IDX_PALETTE_DEF_DPLY ON FLOWABLE.FLW_PALETTE_DEFINITION(DEPLOYMENT_ID_);

INSERT INTO FLOWABLE.FLW_PAL_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/palette/db/liquibase/flowable-palette-db-changelog.xml', SYSTIMESTAMP, 1, '8:9b2702b823e8fdbd4e097db40cc57c20', 'createTable tableName=FLW_PALETTE_DEPLOYMENT; createTable tableName=FLW_PALETTE_DEPLOYMENT_RES; addForeignKeyConstraint baseTableName=FLW_PALETTE_DEPLOYMENT_RES, constraintName=FLW_FK_PALETTE_RSRC_DPL, referencedTableName=FLW_PALETTE_DEPLOYMENT; c...', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791873787');

UPDATE FLOWABLE.FLW_PAL_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


UPDATE FLOWABLE.ACT_DE_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = TO_TIMESTAMP('2022-02-02 08:51:16.849', 'YYYY-MM-DD HH24:MI:SS.FF') WHERE ID = 1 AND LOCKED = 0;

CREATE TABLE FLOWABLE.FLW_DE_TENANT (TENANT_ID_ VARCHAR2(255) NOT NULL, CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (TENANT_ID_));

INSERT INTO FLOWABLE.FLW_DE_TENANT (TENANT_ID_) VALUES ('default');

INSERT INTO FLOWABLE.ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', SYSTIMESTAMP, 6, '8:23bc223608ea31a73f17ca2adb0a13b8', 'createTable tableName=FLW_DE_TENANT; insert tableName=FLW_DE_TENANT', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791879316');

ALTER TABLE FLOWABLE.ACT_DE_MODEL_RELATION ADD app_model_id VARCHAR2(255);

ALTER TABLE FLOWABLE.ACT_DE_MODEL_METADATA ADD scope_info CLOB;

INSERT INTO FLOWABLE.ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', SYSTIMESTAMP, 7, '8:4e404d08cf64d77c45dc56bb8e436ab4', 'addColumn tableName=ACT_DE_MODEL_RELATION; addColumn tableName=ACT_DE_MODEL_METADATA', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791879316');

CREATE TABLE FLOWABLE.ACT_DE_MODEL_RESOURCE (ID_ VARCHAR2(255) NOT NULL, NAME_ VARCHAR2(255), TYPE_ VARCHAR2(255), CREATION_TIME_ TIMESTAMP NOT NULL, MODEL_ID_ VARCHAR2(255), RESOURCE_BYTES_ BLOB, RESOURCE_TYPE_ VARCHAR2(255), CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_));

ALTER TABLE FLOWABLE.ACT_DE_MODEL_RESOURCE ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES FLOWABLE.ACT_DE_MODEL (id);

CREATE INDEX FLOWABLE.idx_model_resource ON FLOWABLE.ACT_DE_MODEL_RESOURCE(MODEL_ID_);

INSERT INTO FLOWABLE.ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', SYSTIMESTAMP, 8, '8:7ef6226e5b7ebb80e002b30ee84e92fc', 'createTable tableName=ACT_DE_MODEL_RESOURCE; addForeignKeyConstraint baseTableName=ACT_DE_MODEL_RESOURCE, constraintName=fk_model_resource, referencedTableName=ACT_DE_MODEL; createIndex indexName=idx_model_resource, tableName=ACT_DE_MODEL_RESOURCE', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791879316');

UPDATE FLOWABLE.ACT_DE_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

