
CREATE TABLE FLW_PAL_DATABASECHANGELOGLOCK (ID INT NOT NULL, `LOCKED` BIT(1) NOT NULL, LOCKGRANTED datetime NULL, LOCKEDBY VARCHAR(255) NULL, CONSTRAINT PK_FLW_PAL_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM FLW_PAL_DATABASECHANGELOGLOCK;

INSERT INTO FLW_PAL_DATABASECHANGELOGLOCK (ID, `LOCKED`) VALUES (1, 0);

UPDATE FLW_PAL_DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02 09:39:54.08' WHERE ID = 1 AND `LOCKED` = 0;

CREATE TABLE FLW_PAL_DATABASECHANGELOG (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED datetime NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35) NULL, `DESCRIPTION` VARCHAR(255) NULL, COMMENTS VARCHAR(255) NULL, TAG VARCHAR(255) NULL, LIQUIBASE VARCHAR(20) NULL, CONTEXTS VARCHAR(255) NULL, LABELS VARCHAR(255) NULL, DEPLOYMENT_ID VARCHAR(10) NULL);

CREATE TABLE FLW_PALETTE_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NULL, CATEGORY_ VARCHAR(255) NULL, KEY_ VARCHAR(255) NULL, DEPLOY_TIME_ datetime(6) NULL, PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL, TENANT_ID_ VARCHAR(255) DEFAULT '' NULL, CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NULL, DEPLOYMENT_ID_ VARCHAR(255) NULL, RESOURCE_BYTES_ LONGBLOB NULL, CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_));

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES(DEPLOYMENT_ID_);

CREATE TABLE FLW_PALETTE_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, NAME_ VARCHAR(255) NULL, KEY_ VARCHAR(255) NOT NULL, VERSION_ INT NOT NULL, DEPLOYMENT_ID_ VARCHAR(255) NULL, RESOURCE_NAME_ VARCHAR(4000) NULL, DESCRIPTION_ VARCHAR(4000) NULL, SCOPE_TYPE_ VARCHAR(255) NULL, TENANT_ID_ VARCHAR(255) DEFAULT '' NULL, CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_));

CREATE UNIQUE INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION(KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_PALETTE_DEFINITION ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION(DEPLOYMENT_ID_);

INSERT INTO FLW_PAL_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/palette/db/liquibase/flowable-palette-db-changelog.xml', NOW(), 1, '8:9b2702b823e8fdbd4e097db40cc57c20', 'createTable tableName=FLW_PALETTE_DEPLOYMENT; createTable tableName=FLW_PALETTE_DEPLOYMENT_RES; addForeignKeyConstraint baseTableName=FLW_PALETTE_DEPLOYMENT_RES, constraintName=FLW_FK_PALETTE_RSRC_DPL, referencedTableName=FLW_PALETTE_DEPLOYMENT; c...', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791194614');

UPDATE FLW_PAL_DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;


UPDATE ACT_DE_DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02 09:39:55.342' WHERE ID = 1 AND `LOCKED` = 0;

CREATE TABLE FLW_DE_TENANT (TENANT_ID_ VARCHAR(255) NOT NULL, CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (TENANT_ID_));

INSERT INTO FLW_DE_TENANT (TENANT_ID_) VALUES ('default');

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 6, '8:23bc223608ea31a73f17ca2adb0a13b8', 'createTable tableName=FLW_DE_TENANT; insert tableName=FLW_DE_TENANT', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791195532');

ALTER TABLE ACT_DE_MODEL_RELATION ADD app_model_id VARCHAR(255) NULL;

ALTER TABLE ACT_DE_MODEL_METADATA ADD scope_info LONGTEXT NULL;

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 7, '8:4e404d08cf64d77c45dc56bb8e436ab4', 'addColumn tableName=ACT_DE_MODEL_RELATION; addColumn tableName=ACT_DE_MODEL_METADATA', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791195532');

CREATE TABLE ACT_DE_MODEL_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NULL, TYPE_ VARCHAR(255) NULL, CREATION_TIME_ datetime NOT NULL, MODEL_ID_ VARCHAR(255) NULL, RESOURCE_BYTES_ LONGBLOB NULL, RESOURCE_TYPE_ VARCHAR(255) NULL, CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_));

ALTER TABLE ACT_DE_MODEL_RESOURCE ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id);

CREATE INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE(MODEL_ID_);

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', NOW(), 8, '8:7ef6226e5b7ebb80e002b30ee84e92fc', 'createTable tableName=ACT_DE_MODEL_RESOURCE; addForeignKeyConstraint baseTableName=ACT_DE_MODEL_RESOURCE, constraintName=fk_model_resource, referencedTableName=ACT_DE_MODEL; createIndex indexName=idx_model_resource, tableName=ACT_DE_MODEL_RESOURCE', '', 'EXECUTED', NULL, NULL, '4.3.5', '3791195532');

UPDATE ACT_DE_DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

