
CREATE TABLE ACT_DE_MODEL (
    id varchar(255) NOT NULL,
    name varchar(400) NOT NULL,
    model_key varchar(400) NOT NULL,
    description varchar(4000),
    model_comment varchar(4000),
    created datetime2,
    created_by varchar(255),
    last_updated datetime2,
    last_updated_by varchar(255),
    version int,
    model_type int,
    model_sub_type nvarchar(64),
    model_editor_json varchar(MAX), 
    thumbnail varbinary(MAX), 
    model_svg varchar(MAX), 
    latest_deployment_id varchar(64), 
    visibility_ varchar(15) 
    CONSTRAINT DF_ACT_DE_MODEL_visibility_ DEFAULT 'internal' NOT NULL, 
    palette_def_category_ nvarchar(64), 
    palette_def_key_ nvarchar(64), 
    locked_by_ varchar(255), 
    locked_at_ datetime, 
    workspace_id_ varchar(256) NOT NULL,
    validation_status_ varchar(255),
    CONSTRAINT PK_ACT_DE_MODEL PRIMARY KEY (id));

CREATE NONCLUSTERED INDEX idx_proc_mod_created ON ACT_DE_MODEL(created_by);

CREATE TABLE ACT_DE_MODEL_HISTORY (
    id varchar(255) NOT NULL,
    name varchar(400) NOT NULL,
    model_key varchar(400) NOT NULL,
    description varchar(4000),
    model_comment varchar(4000),
    created datetime2,
    created_by varchar(255),
    last_updated datetime2,
    last_updated_by varchar(255),
    removal_date datetime2,
    version int,
    model_editor_json varchar(MAX), 
    model_id varchar(255) NOT NULL, 
    model_type int, 
    model_sub_type nvarchar(64), 
    model_svg varchar(MAX), 
    palette_def_category_ nvarchar(64), 
    palette_def_key_ nvarchar(64), 
    tags_json varchar(MAX), 
    latest_deployment_id varchar(64), 
    workspace_id_ varchar(256) NOT NULL, 
    CONSTRAINT PK_ACT_DE_MODEL_HISTORY PRIMARY KEY (id));

CREATE NONCLUSTERED INDEX idx_proc_mod_history_proc ON ACT_DE_MODEL_HISTORY(model_id);

CREATE TABLE ACT_DE_MODEL_RELATION (
    id varchar(255) NOT NULL,
    parent_model_id varchar(255),
    model_id varchar(255),
    model_key varchar(255),
    model_type int,
    relation_type varchar(255),
    app_model_id varchar(255),
    workspace_id_ varchar(255),
    CONSTRAINT PK_ACT_DE_MODEL_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_parent FOREIGN KEY (parent_model_id) REFERENCES ACT_DE_MODEL (id);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_child FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE ACT_DE_USER (
    ID_ varchar(255) NOT NULL,
    REV_ int CONSTRAINT DF_ACT_DE_USER_REV_ DEFAULT 1 NOT NULL,
    FIRST_NAME_ varchar(256) NOT NULL,
    LAST_NAME_ varchar(400) NOT NULL,
    DISPLAY_NAME_ varchar(400) NOT NULL,
    PASSWORD_ varchar(128),
    EMAIL_ varchar(256),
    TENANT_ID_ varchar(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_USER PRIMARY KEY (ID_)
);

CREATE TABLE ACT_DE_TOKEN (
    ID_ varchar(64) NOT NULL,
    TOKEN_VALUE_ varchar(255),
    TOKEN_DATE_ datetime,
    IP_ADDRESS_ varchar(255),
    USER_AGENT_ varchar(255),
    USER_ID_ varchar(255),
    TOKEN_DATA_ varchar(2000),
    CONSTRAINT PK_ACT_DE_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_TENANT (
    ID_ varchar(255) NOT NULL,
    REV_ int CONSTRAINT DF_FLW_DE_TENANT_REV_ DEFAULT 1 NOT NULL,
    NAME_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    CREATED_AT_ datetime2(6),
    CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (ID_)
);

INSERT INTO FLW_DE_TENANT (ID_)
    VALUES ('default');

CREATE TABLE ACT_DE_MODEL_RESOURCE (
    ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    TYPE_ varchar(255),
    CREATION_TIME_ datetime2 NOT NULL,
    MODEL_ID_ varchar(255),
    RESOURCE_BYTES_ varbinary(MAX),
    RESOURCE_TYPE_ varchar(255),
    CREATOR_ID_ varchar(255),
    UPDATE_TIME_ datetime2,
    UPDATER_ID_ varchar(255),
    CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_DE_MODEL_RESOURCE
    ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE NONCLUSTERED INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE(MODEL_ID_);

CREATE TABLE ACT_DE_MODEL_TAG (
    id varchar(255) NOT NULL,
    name varchar(400) NOT NULL,
    tenant_id varchar(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG PRIMARY KEY (id)
);

CREATE TABLE ACT_DE_MODEL_TAG_RELATION (
    id varchar(255) NOT NULL,
    model_tag_id varchar(255) NOT NULL,
    model_id varchar(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_tag FOREIGN KEY (model_tag_id) REFERENCES ACT_DE_MODEL_TAG (id);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_model FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE FLW_DE_WORKSPACE (
    ID_ varchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ varchar(255) NOT NULL,
    SHARED_WORKSPACE_ID_ varchar(255),
    TENANT_ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    ALLOWED_PACKAGE_TYPE_ int CONSTRAINT DF_FLW_DE_WORKSPACE_ALLOWED_PACKAGE_TYPE_ DEFAULT 3 NOT NULL,
    VISIBILITY_ varchar(15) CONSTRAINT DF_FLW_DE_WORKSPACE_VISIBILITY_ DEFAULT 'private' NOT NULL,
    CREATED_AT_ datetime2(6) NOT NULL,
    CREATED_BY_ varchar(255),
    UPDATED_AT_ datetime2(6),
    UPDATED_BY_ varchar(255),
    CONSTRAINT PK_FLW_DE_WORKSPACE PRIMARY KEY (ID_),
    CONSTRAINT FK_FLW_DE_WORKSPACE_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT UQ_FLW_DE_WORKSPACE_KEY_TENANT UNIQUE (KEY_, TENANT_ID_);

INSERT INTO FLW_DE_WORKSPACE (ID_, REV_, KEY_, TENANT_ID_, NAME_, VISIBILITY_, CREATED_AT_)
    VALUES (CONVERT(varchar (64), newid()), 1, 'default', 'default', 'Generated default', 'public', getdate());

CREATE TABLE FLW_DE_IDENTITY_LINK (
    ID_ varchar(64) NOT NULL,
    USER_ID_ varchar(255),
    GROUP_ID_ varchar(255),
    TYPE_ varchar(255),
    SCOPE_ID_ varchar(255),
    SCOPE_TYPE_ varchar(255),
    CONSTRAINT PK_FLW_DE_IDENTITY_LINK PRIMARY KEY (ID_)
);

CREATE NONCLUSTERED INDEX IDX_FLW_DE_IDENT_LINK_USER ON FLW_DE_IDENTITY_LINK(USER_ID_);

CREATE NONCLUSTERED INDEX IDX_FLW_DE_IDENT_LINK_GROUP ON FLW_DE_IDENTITY_LINK(GROUP_ID_);

CREATE NONCLUSTERED INDEX IDX_FLW_DE_IDENT_LINK_SCOPE ON FLW_DE_IDENTITY_LINK(SCOPE_TYPE_, SCOPE_ID_);

CREATE TABLE FLW_DE_PRIVILEGE_MAPPING (
    ID_ nvarchar(64) NOT NULL,
    PRIVILEGE_ nvarchar(64) NOT NULL,
    USER_ID_ nvarchar(255),
    GROUP_ID_ nvarchar(255),
    CONSTRAINT PK_FLW_DE_PRIVILEGE_MAPPING PRIMARY KEY (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_PRIVILEGE_USER ON FLW_DE_PRIVILEGE_MAPPING(USER_ID_);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_PRIV_GROUP ON FLW_DE_PRIVILEGE_MAPPING(GROUP_ID_);

ALTER TABLE ACT_DE_MODEL
    ADD template_ bit CONSTRAINT DF_ACT_DE_MODEL_template_ DEFAULT 0;

CREATE TABLE FLW_DE_APP_REVISION (
    ID_ varchar(255) NOT NULL,
    KEY_ varchar(400) NOT NULL,
    DESCRIPTION_ varchar(4000),
    CREATED_ datetime,
    CREATED_BY_ varchar(255),
    APP_ID_ varchar(255) NOT NULL,
    EXPORT_BYTES_ varbinary(MAX),
    CONSTRAINT PK_FLW_DE_APP_REVISION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_FK_APP_REVISION_APP_ID FOREIGN KEY (APP_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE NONCLUSTERED INDEX FLW_DE_IDX_APP_REVISION_APP_ID ON FLW_DE_APP_REVISION(APP_ID_);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_UQ_APP_REV_APP_ID_KEY UNIQUE (APP_ID_, KEY_);

CREATE TABLE FLW_DE_IDENTITY_INFO (
    ID_ varchar(64) NOT NULL,
    REV_ int NOT NULL,
    TYPE_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255) NOT NULL,
    USER_ID_ nvarchar(64) NOT NULL,
    DOUBLE_ float(53),
    LONG_ bigint,
    TEXT_ nvarchar(4000),
    TEXT2_ nvarchar(4000),
    UPDATE_TIME_ datetime2(6),
    TENANT_ID_ nvarchar(255),
    CONSTRAINT PK_FLW_DE_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_IDM_INFO_USER_ID ON FLW_DE_IDENTITY_INFO(USER_ID_);

ALTER TABLE FLW_DE_IDENTITY_INFO
    ADD CONSTRAINT FLW_DE_UQ_ID_INFO_TEN_USR_NAME UNIQUE (TENANT_ID_, USER_ID_, NAME_);

CREATE TABLE FLW_DE_ACCESS_TOKEN (
    ID_ varchar(64) NOT NULL,
    NAME_ varchar(255),
    DESCRIPTION_ varchar(2000),
    CREATION_TIME_ datetime NOT NULL,
    EXPIRATION_TIME_ datetime,
    USER_ID_ varchar(255) NOT NULL,
    TENANT_ID_ varchar(255) NOT NULL,
    TOKEN_VALUE_ varchar(2000),
    CONSTRAINT PK_FLW_DE_ACCESS_TOKEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT FK_FLW_DE_WORKSPACE_SHARED_ID FOREIGN KEY (SHARED_WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

CREATE NONCLUSTERED INDEX ACT_DE_IDX_MODEL_REL_APP_ID ON ACT_DE_MODEL_RELATION(app_model_id);

CREATE NONCLUSTERED INDEX ACT_DE_IDX_MODEL_REL_PARENT_ID ON ACT_DE_MODEL_RELATION(parent_model_id);

CREATE NONCLUSTERED INDEX ACT_DE_IDX_MODEL_REL_MODEL_ID ON ACT_DE_MODEL_RELATION(model_id);

CREATE TABLE FLW_DE_MODEL_STAR (
    USER_ID_ varchar(255) NOT NULL,
    MODEL_ID_ varchar(255) NOT NULL
);

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_FK_MODEL_STAR_MODEL_ID FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_UQ_MODEL_STAR_USR_MODEL UNIQUE (USER_ID_, MODEL_ID_);
    
CREATE TABLE FLW_DE_CUSTOM_COMP_PROJECT (
    ID_ varchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    STATE_ nvarchar(255),
    UPLOADED_BUNDLE_HASH_ nvarchar(255),
    INSTALLED_BUNDLE_HASH_ nvarchar(255),
    APP_KEY_ nvarchar(255),
    WORKSPACE_KEY_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    TENANT_ID_ varchar(255),
    CREATE_DATE_ datetime2(6),
    INSTALLATION_DATE_ datetime2(6),
    CONSTRAINT PK_FLW_DE_COMP_PROJ PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_COMP_PROJ_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_DE_IDX_COMP_PROJ_KEY_TEN ON FLW_DE_CUSTOM_COMP_PROJECT(KEY_, TENANT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT (
    ID_ varchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ nvarchar(255) NOT NULL,
    PROJECT_ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    STATE_ nvarchar(255),
    XML_TAG_ nvarchar(255),
    VERSION_ nvarchar(255),
    ICON_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    CREATE_DATE_ datetime2(6),
    META_DATA_ nvarchar(MAX),
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_DE_IDX_CUSTOM_COMP_KEY_PROJ ON FLW_DE_CUSTOM_COMPONENT(KEY_, PROJECT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMP_MODEL_REL (
    ID_ varchar(255) NOT NULL,
    MODEL_ID_ varchar(255) NOT NULL,
    PROJECT_KEY_ nvarchar(255) NOT NULL,
    CUSTOM_COMPONENT_KEY_ nvarchar(255) NOT NULL,
    WORKSPACE_ID_ varchar(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_CUST_COMP_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_WRKS FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_CUST_COMP_REL_MOD ON FLW_DE_CUSTOM_COMP_MODEL_REL(MODEL_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT_RES (
    ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    BUNDLE_HASH_ nvarchar(255),
    PROJECT_ID_ varchar(255),
    RESOURCE_BYTES_ varbinary(MAX),    
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_RES_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE TABLE FLW_DE_PLUGIN (
    ID_ nvarchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    VERSION_ nvarchar(255) NOT NULL,
    MAJOR_VERSION_ int NOT NULL,
    MINOR_VERSION_ int NOT NULL,
    PATCH_VERSION_ int NOT NULL,
    DESCRIPTION_ nvarchar(4000),
    TENANT_ID_ varchar(255),
    RELEASE_DATE_ datetime2(6),
    INSTALLATION_DATE_ datetime2(6),
    CONSTRAINT PK_FLW_DE_PLUGIN PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_DE_IDX_PLUGIN_KEY_VER_TEN ON FLW_DE_PLUGIN(KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DE_PLUGIN_RESOURCE (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255) NOT NULL,
    PLUGIN_ID_ nvarchar(255) NOT NULL,
    REFERENCE_ nvarchar(255),
    REFERENCE_TYPE_ nvarchar(255),
    GENERATED_ bit,
    RESOURCE_BYTES_ varbinary(MAX),
    CONSTRAINT PK_PLUGIN_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_RES_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_FK_PLUGIN_RES_PLUGIN ON FLW_DE_PLUGIN_RESOURCE(PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_LINK (
    ID_ nvarchar(255) NOT NULL,
    PLUGIN_KEY_ nvarchar(255) NOT NULL,
    PLUGIN_ID_ nvarchar(255) NOT NULL,
    USE_FIX_VERSION_ bit NOT NULL,
    SCOPE_ID_ varchar(255) NOT NULL,
    SCOPE_TYPE_ nvarchar(255) NOT NULL,
    TENANT_ID_ varchar(255) NOT NULL,
    CONSTRAINT PK_PLUGIN_LINK PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_UQ_PLUG_LINK_KEY_SCOPE UNIQUE (PLUGIN_KEY_, SCOPE_ID_, SCOPE_TYPE_);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_PLUGIN_LINK_SCOPE ON FLW_DE_PLUGIN_LINK(SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_FK_PLUGIN_LINK_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_PLUGIN_LINK_PLUG_ID ON FLW_DE_PLUGIN_LINK(PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_MODEL_RELATION (
    ID_ nvarchar(255) NOT NULL,
    MODEL_ID_ varchar(255) NOT NULL,
    PLUGIN_KEY_ nvarchar(255) NOT NULL,
    REFERENCE_KEY_ nvarchar(255) NOT NULL,
    REFERENCE_TYPE_ nvarchar(255) NOT NULL,
    TYPE_ nvarchar(255),
    WORKSPACE_ID_ varchar(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_PLUGIN_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_PLUG_MOD_REL_MOD_ID ON FLW_DE_PLUGIN_MODEL_RELATION(MODEL_ID_);

CREATE TABLE FLW_DE_DEPLOYMENT_SERVER_INFO (
    ID_ varchar(255) NOT NULL,
    SCOPE_ID_ varchar(255) NOT NULL,
    SCOPE_TYPE_ varchar(255) NOT NULL,
    NAME_ varchar(255) NOT NULL,
    TENANT_ID_ varchar(255),
    DEPLOYMENT_TENANT_ID_ varchar(255),
    BASE_SERVER_ADDRESS_ varchar(2000) NOT NULL,
    AUTHENTICATION_TYPE_ varchar(100),
    USER_INFO_ varchar(255),
    SECRET_ varchar(2000),
    CONSTRAINT FLW_DE_PK_DEPL_SERVER_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_OAUTH_CLIENT_REG (
    ID_ varchar(255) NOT NULL,
    REGISTRATION_KEY_ varchar(255) NOT NULL,
    CLIENT_ID_ varchar(100) NOT NULL,
    CLIENT_SECRET_ varchar(255),
    CLIENT_NAME_ varchar(255),
    CLIENT_AUTHENTICATION_METHOD_ varchar(200),
    SCOPES_ varchar(2000),
    ISSUER_URI_ varchar(2000),
    TOKEN_URI_ varchar(2000),
    TENANT_ID_ varchar(255),
    CONSTRAINT FLW_DE_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_MODEL_GENERATION (
    ID_ varchar(255) NOT NULL,
    WORKSPACE_ID_ varchar(255) NOT NULL,
    PACKAGE_ID_ varchar(255),
    NAME_ nvarchar(255),
    PROMPT_ nvarchar(MAX),
    GENERATION_TYPE_ varchar(255),
    SCOPE_TYPE_ varchar(255),
    STATUS_ varchar(255),
    CREATED_ datetime,
    LAST_UPDATED_ datetime,
    CONSTRAINT FLW_DE_PK_MODEL_GEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PACKAGE FOREIGN KEY (PACKAGE_ID_) REFERENCES ACT_DE_MODEL (id);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_WORKSPACE ON FLW_DE_MODEL_GENERATION (WORKSPACE_ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PACKAGE ON FLW_DE_MODEL_GENERATION (PACKAGE_ID_);

CREATE TABLE FLW_DE_MODEL_GENERATION_PART (
    ID_ varchar(255) NOT NULL,
    MODEL_GENERATION_ID_ varchar(255) NOT NULL,
    KEY_ varchar(255),
    NAME_ nvarchar(255),
    USER_PROMPT_ varchar(MAX),
    SYSTEM_PROMPT_ varchar(MAX),
    STATUS_ varchar(255),
    TYPE_ varchar(255),
    RESPONSE_ varchar(MAX),
    MODEL_CONTENT_ varchar(MAX),
    PART_REFERENCE_ varchar(255),
    PART_COUNT_ int,
    REFERENCE_SCOPE_KEY_ varchar(255),
    REFERENCE_SCOPE_TYPE_ varchar(255),
    CREATED_ datetime,
    LAST_UPDATED_ datetime,
    CONSTRAINT FLW_DE_PK_MODEL_GEN_PART PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION_PART
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PART_MOD_GEN FOREIGN KEY (MODEL_GENERATION_ID_) REFERENCES FLW_DE_MODEL_GENERATION (ID_);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_PART_GEN ON FLW_DE_MODEL_GENERATION_PART (MODEL_GENERATION_ID_);

CREATE TABLE FLW_PALETTE_DEPLOYMENT (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    CATEGORY_ nvarchar(255),
    KEY_ nvarchar(255),
    DEPLOY_TIME_ datetime2(6),
    PARENT_DEPLOYMENT_ID_ nvarchar(255),
    TENANT_ID_ nvarchar(255) CONSTRAINT DF_FLW_PALETTE_DEPLOYMENT_TENANT_ID_ DEFAULT '',
    CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    DEPLOYMENT_ID_ nvarchar(255),
    RESOURCE_BYTES_ varbinary(MAX),
    CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES
    ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE NONCLUSTERED INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES(DEPLOYMENT_ID_);

CREATE TABLE FLW_PALETTE_DEFINITION (
    ID_ nvarchar(255) NOT NULL,
    REV_ int NOT NULL,
    NAME_ nvarchar(255),
    KEY_ nvarchar(255) NOT NULL,
    VERSION_ int NOT NULL,
    DEPLOYMENT_ID_ nvarchar(255),
    RESOURCE_NAME_ nvarchar(4000),
    DESCRIPTION_ nvarchar(4000),
    SCOPE_TYPE_ nvarchar(255),
    CATEGORY_ nvarchar(255),
    TENANT_ID_ nvarchar(255) CONSTRAINT DF_FLW_PALETTE_DEFINITION_TENANT_ID_ DEFAULT '',
    CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION(KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_PALETTE_DEFINITION
    ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE NONCLUSTERED INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION(DEPLOYMENT_ID_);

CREATE TABLE FLW_DE_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);

insert into FLW_DE_PROPERTY
    values ('design.schema.version', '77', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ nvarchar(255) NOT NULL, RESOURCE_BYTES_ varbinary(MAX), CREATION_TIME_ datetime2(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ nvarchar(255) NOT NULL, TIMESTAMP_ datetime2(6) NOT NULL, APPLICATION_ nvarchar(255) NOT NULL, TENANT_ID_ nvarchar(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ nvarchar(255), TIMESTAMP_ datetime2(6) NOT NULL, COUNT_ bigint NOT NULL, SCOPE_TYPE_ nvarchar(255) NOT NULL, SCOPE_SUB_TYPE_ nvarchar(255) NOT NULL, SIGNATURE_ nvarchar(MAX) NOT NULL, APPLICATION_ nvarchar(255) NOT NULL);

CREATE NONCLUSTERED INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);

