
CREATE TABLE FLW_LIC_LICENSE (ID_ nvarchar(255) NOT NULL, RESOURCE_BYTES_ varbinary(MAX), CREATION_TIME_ datetime2(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ nvarchar(255) NOT NULL, TIMESTAMP_ datetime2(6) NOT NULL, APPLICATION_ nvarchar(255) NOT NULL, TENANT_ID_ nvarchar(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ nvarchar(255), TIMESTAMP_ datetime2(6) NOT NULL, COUNT_ bigint NOT NULL, SCOPE_TYPE_ nvarchar(255) NOT NULL, SCOPE_SUB_TYPE_ nvarchar(255) NOT NULL, SIGNATURE_ nvarchar(MAX) NOT NULL, APPLICATION_ nvarchar(255) NOT NULL);

CREATE NONCLUSTERED INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_CTRL_SERVER_CONFIG (
    ID_ varchar(255) NOT NULL,
    NAME_ varchar(50),
    DESCRIPTION_ varchar(255),
    SERVER_ADDRESS_ varchar(100),
    PORT_ int,
    CONTEXT_ROOT_ varchar(100),
    REST_ROOT_ varchar(100),
    USER_NAME_ varchar(100),
    PASSWORD_ varchar(2000),
    ENDPOINT_TYPE_ int,
    CLUSTER_ID_ varchar(255) CONSTRAINT DF_FLW_CTRL_SERVER_CONFIG_CLUSTER_ID_ DEFAULT '' NOT NULL,
    CLUSTER_OVERRIDE_ bit CONSTRAINT DF_FLW_CTRL_SERVER_CONFIG_CLUSTER_OVERRIDE_ DEFAULT 0 NOT NULL,
    AUTHENTICATION_TYPE_ varchar(100) CONSTRAINT DF_FLW_CTRL_SERVER_CONFIG_AUTHENTICATION_TYPE_ DEFAULT 'basic',
    TENANT_ID_ varchar(50),
    CONSTRAINT PK_FLW_CTRL_SERVER_CONFIG PRIMARY KEY (ID_)
)

CREATE TABLE FLW_CTRL_USER (
    ID_ varchar(255) NOT NULL,
    FIRST_NAME_ varchar(256) NOT NULL,
    LAST_NAME_ varchar(400) NOT NULL,
    DISPLAY_NAME_ varchar(400) NOT NULL,
    USERNAME_ varchar(128) NOT NULL,
    PASSWORD_ varchar(128),
    EMAIL_ varchar(256),
    TENANT_ID_ varchar(256),
    IS_ADMIN_ bit,
    CONTROL_RIGHTS_ varchar(MAX
) , CONSTRAINT PK_FLW_CTRL_USER PRIMARY KEY (ID_))

CREATE TABLE FLW_CTRL_TOKEN (
    ID_ varchar(64) NOT NULL,
    TOKEN_VALUE_ varchar(255),
    TOKEN_DATE_ datetime,
    IP_ADDRESS_ varchar(255),
    USER_AGENT_ varchar(255),
    USER_ID_ varchar(255),
    TOKEN_DATA_ varchar(2000),
    CONSTRAINT PK_FLW_CTRL_TOKEN PRIMARY KEY (ID_)
)

CREATE TABLE FLW_CTRL_CLUSTER_CONFIG (
    ID_ varchar(255) NOT NULL,
    NAME_ varchar(50),
    DESCRIPTION_ varchar(255),
    SERVER_ADDRESS_ varchar(100),
    PORT_ int,
    CONTEXT_ROOT_ varchar(100),
    USER_NAME_ varchar(100),
    PASSWORD_ varchar(2000),
    TYPE_ varchar(100),
    AUTHENTICATION_TYPE_ varchar(100) CONSTRAINT DF_FLW_CTRL_CLUSTER_CONFIG_AUTHENTICATION_TYPE_ DEFAULT 'basic',
    MULTI_TENANCY_ bit CONSTRAINT DF_FLW_CTRL_CLUSTER_CONFIG_MULTI_TENANCY_ DEFAULT 0 NOT NULL,
    TENANT_ID_ varchar(50),
    CONSTRAINT PK_FLW_CTRL_CLUSTER_CONFIG PRIMARY KEY (ID_)
)

CREATE TABLE FLW_CTRL_AUDIT_LOG (
    ID_ nvarchar(255) NOT NULL,
    CLUSTER_ID_ nvarchar(255),
    CREATED_BY_ nvarchar(255),
    CREATED_ON_ datetime2(6),
    TENANT_ID_ nvarchar(255),
    TYPE_ nvarchar(255),
    SUB_TYPE_ nvarchar(255),
    PAYLOAD_ nvarchar(MAX),
    CONSTRAINT PK_FLW_CTRL_AUDIT_LOG PRIMARY KEY (ID_)
)

CREATE TABLE FLW_CTRL_ROLE (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    PRIVILEGES_ nvarchar(MAX),
    CONSTRAINT PK_FLW_CTRL_ROLE PRIMARY KEY (ID_)
)

CREATE TABLE FLW_CTRL_ROLE_USER_MAPPING (
    ID_ nvarchar(64) NOT NULL,
    USER_ID_ nvarchar(255),
    ROLE_ID_ nvarchar(255),
    GROUP_ID_ nvarchar(255),
    CONSTRAINT PK_FLW_CTRL_ROLE_USER_MAPPING PRIMARY KEY (ID_)
)

ALTER TABLE FLW_CTRL_USER ADD CONSTRAINT FLW_CTRL_UNIQ_USERNAME UNIQUE (USERNAME_)

CREATE TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING (
    ID_ nvarchar(255) NOT NULL,
    AUTHORITY_ nvarchar(255),
    CLUSTER_CONFIG_ID_ varchar(255),
    CONSTRAINT PK_FLW_CTRL_AUTH_CLUSTER_MAPPING PRIMARY KEY (ID_)
)

ALTER TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING
    ADD CONSTRAINT FLW_CTRL_FK_CLUSTER_CONFIG FOREIGN KEY (CLUSTER_CONFIG_ID_) REFERENCES FLW_CTRL_CLUSTER_CONFIG (ID_) ON DELETE CASCADE

CREATE NONCLUSTERED INDEX FLW_CTRL_IDX_AUTHORITY_ ON FLW_CTRL_AUTH_CLUSTER_MAPPING(AUTHORITY_)

CREATE NONCLUSTERED INDEX FLW_CTRL_IDX_PRIVILEGE_GROUP ON FLW_CTRL_ROLE_USER_MAPPING(GROUP_ID_)

CREATE NONCLUSTERED INDEX FLW_CTRL_IDX_PRIVILEGE_ROLE ON FLW_CTRL_ROLE_USER_MAPPING(ROLE_ID_)

CREATE TABLE FLW_CTRL_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);

insert into FLW_CTRL_PROPERTY
    values ('control.schema.version', '13', 1);

