ALTER TABLE FLW_PL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_PL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);
CREATE INDEX FLW_IDX_PL_RSRC_DPL ON FLW_PL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);



CREATE UNIQUE INDEX IDX_FLW_OAUTH_CL_REG_KEY_TEN ON FLW_OAUTH_CLIENT_REG (REGISTRATION_KEY_, TENANT_ID_);



ALTER TABLE FLW_OAUTH_CLIENT_REG MODIFY CLIENT_ID_ NULL;

update ACT_GE_PROPERTY set VALUE_ = '19' where NAME_ = 'platform.schema.version';


ALTER TABLE ACT_APP_INCIDENT ADD ROOT_SCOPE_ID_ VARCHAR2(255);

ALTER TABLE ACT_APP_INCIDENT ADD ROOT_SCOPE_TYPE_ VARCHAR2(255);

ALTER TABLE ACT_APP_INCIDENT ADD ROOT_SCOPE_DEFINITION_ID_ VARCHAR2(255);

ALTER TABLE ACT_APP_INCIDENT ADD ROOT_SCOPE_DEFINITION_KEY_ VARCHAR2(255);

ALTER TABLE ACT_APP_INCIDENT ADD SCOPE_DEFINITION_KEY_ VARCHAR2(255);

ALTER TABLE ACT_APP_INCIDENT ADD ELEMENT_ID_ VARCHAR2(255);

CREATE INDEX ACT_IDX_APP_INC_DEF_ROOT_KEY ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_K_TENANT ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY_TENANT ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_SCOPE ON ACT_APP_INCIDENT (ROOT_SCOPE_ID_, ROOT_SCOPE_TYPE_);

update ACT_GE_PROPERTY set VALUE_ = '12' where NAME_ = 'app.schema.version';


ALTER TABLE FLW_FO_FORM_RESOURCE
    ADD CONSTRAINT FLW_FK_FO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_FO_FORM_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_FO_RSRC_DPL ON FLW_FO_FORM_RESOURCE (DEPLOYMENT_ID_);

update ACT_GE_PROPERTY set VALUE_ = '11' where NAME_ = 'form.schema.version';


DELETE FROM FLW_CO_DEPLOYMENT_RESOURCE WHERE DEPLOYMENT_ID_ IS NOT NULL AND DEPLOYMENT_ID_ NOT IN (SELECT ID_ FROM FLW_CO_DEPLOYMENT);

ALTER TABLE FLW_CO_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_CO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_CO_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_CO_RSRC_DPL ON FLW_CO_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

update ACT_GE_PROPERTY set VALUE_ = '18' where NAME_ = 'content.schema.version';


DELETE FROM FLW_ACTION_DEPLOYMENT_RESOURCE WHERE DEPLOYMENT_ID_ IS NOT NULL AND DEPLOYMENT_ID_ NOT IN (SELECT ID_ FROM FLW_ACTION_DEPLOYMENT);

ALTER TABLE FLW_ACTION_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_ACTION_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_ACTION_RSRC_DPL ON FLW_ACTION_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

update ACT_GE_PROPERTY set VALUE_ = '20' where NAME_ = 'action.schema.version';


ALTER TABLE FLW_POLICY_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_POLICY_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_POLICY_RSRC_DPL ON FLW_POLICY_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

update ACT_GE_PROPERTY set VALUE_ = '3' where NAME_ = 'policy.schema.version';


DELETE FROM FLW_TEMPL_DEPLOYMENT_RESOURCE WHERE DEPLOYMENT_ID_ IS NOT NULL AND DEPLOYMENT_ID_ NOT IN (SELECT ID_ FROM FLW_TEMPL_DEPLOYMENT);

ALTER TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_TEMPL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_TEMPL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_TEMPL_RSRC_DPL ON FLW_TEMPL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

update ACT_GE_PROPERTY set VALUE_ = '8' where NAME_ = 'template.schema.version';

CREATE TABLE FLW_AGENT_DEPLOYMENT
(
    ID_                   VARCHAR2(255) NOT NULL,
    NAME_                 VARCHAR2(255),
    KEY_                  VARCHAR2(255),
    CATEGORY_             VARCHAR2(255),
    DEPLOY_TIME_          TIMESTAMP,
    TENANT_ID_            VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEPLOYMENT_RES
(
    ID_             VARCHAR2(255) NOT NULL,
    NAME_           VARCHAR2(255),
    DEPLOYMENT_ID_  VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEFINITION
(
    ID_              VARCHAR2(255) NOT NULL,
    REV_             INTEGER       NOT NULL,
    KEY_             VARCHAR2(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR2(255) NOT NULL,
    NAME_            VARCHAR2(255),
    DESCRIPTION_     VARCHAR2(4000),
    API_ENABLED_     NUMBER(1) DEFAULT 0,
    RESOURCE_NAME_   VARCHAR2(4000),
    TYPE_            VARCHAR2(255) NOT NULL,
    TENANT_ID_       VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_FLW_AGENT_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_DEF_UNIQ ON FLW_AGENT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_DEF_DEPLOYMENT ON FLW_AGENT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);

CREATE TABLE FLW_AGENT_INSTANCE
(
    ID_                  VARCHAR2(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    TENANT_ID_           VARCHAR2(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) NOT NULL,
    START_USER_ID_       VARCHAR2(255),
    CHAT_ENABLED_        NUMBER(1) DEFAULT 0,
    REFERENCE_ID_        VARCHAR2(255),
    REFERENCE_TYPE_      VARCHAR2(255),
    CALLBACK_ID_         VARCHAR2(255),
    CALLBACK_TYPE_       VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INSTANCE_DEF_ID ON FLW_AGENT_INSTANCE (AGENT_DEFINITION_ID_);
CREATE INDEX IDX_FLW_AGENT_INSTANCE_REF_ID ON FLW_AGENT_INSTANCE (REFERENCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE
    ADD CONSTRAINT FK_FLW_AGENT_INSTANCE_DEF FOREIGN KEY (AGENT_DEFINITION_ID_) REFERENCES FLW_AGENT_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_KB_DEFINITION
(
    ID_              VARCHAR2(255) NOT NULL,
    REV_             INTEGER      NOT NULL,
    KEY_             VARCHAR2(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR2(255) NOT NULL,
    NAME_            VARCHAR2(255),
    DESCRIPTION_     VARCHAR2(4000),
    RESOURCE_NAME_   VARCHAR2(4000),
    TENANT_ID_       VARCHAR2(64) DEFAULT '',
    READY_           NUMBER(1) DEFAULT 0 NOT NULL,
    CONSTRAINT PK_FLW_AGENT_KB_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_UNIQ ON FLW_AGENT_KB_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_KB_DEF_DEPL ON FLW_AGENT_KB_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_KB_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_KB_DEF_DEPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);


CREATE TABLE FLW_AGENT_KB_ITEM
(
    ID_                    VARCHAR2(255) NOT NULL,
    PARENT_ID_             VARCHAR2(255),
    ROOT_ID_               VARCHAR2(255),
    KB_DEF_ID_             VARCHAR2(255),
    IS_CONTAINER_          NUMBER(1) DEFAULT 0 NOT NULL,
    SCOPE_ID_              VARCHAR2(255),
    SCOPE_TYPE_            VARCHAR2(255),
    CHECKSUM_              VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_UNIQ ON FLW_AGENT_KB_ITEM (SCOPE_ID_, SCOPE_TYPE_);
CREATE INDEX IDX_FLW_AGENT_KB_ITEM_DEF ON FLW_AGENT_KB_ITEM (KB_DEF_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_DEF FOREIGN KEY (KB_DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_INSTANCE_EXCHANGE
(
    ID_                     VARCHAR2(255) NOT NULL,
    REV_                    INTEGER       NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR2(255),
    OPERATION_KEY_          VARCHAR2(255),
    CREATION_TIME_          TIMESTAMP(6) NOT NULL,
    TYPE_                   VARCHAR2(255),
    USER_ID_                VARCHAR2(255),
    PROCESSING_             NUMBER(1) DEFAULT 0,
    CONTENT_                CLOB,
    TECHNICAL_CONTENT_      CLOB,
    TOKEN_COUNT_            INTEGER,
    CONSTRAINT PK_FLW_AGENT_INSTANCE_EXCHANGE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INST_EXCH_INST ON FLW_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_AGENT_INST_EXCH_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE
(
    ID_                  VARCHAR2(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    TENANT_ID_           VARCHAR2(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR2(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) NOT NULL,
    END_TIME_            TIMESTAMP(6),
    CHAT_ENABLED_        NUMBER(1) DEFAULT 0,
    STATE_               VARCHAR2(255),
    START_USER_ID_       VARCHAR2(255),
    REFERENCE_ID_        VARCHAR2(255),
    REFERENCE_TYPE_      VARCHAR2(255),
    CALLBACK_ID_         VARCHAR2(255),
    CALLBACK_TYPE_       VARCHAR2(255),
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_DEF_ID ON FLW_HI_AGENT_INSTANCE (AGENT_DEFINITION_ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
(
    ID_                         VARCHAR2(255) NOT NULL,
    REV_                        INTEGER       NOT NULL,
    AGENT_INSTANCE_ID_          VARCHAR2(255),
    OPERATION_KEY_              VARCHAR2(255),
    CREATION_TIME_              TIMESTAMP(6) NOT NULL,
    TYPE_                       VARCHAR2(255),
    USER_ID_                    VARCHAR2(255),
    PROCESSING_                 NUMBER(1) DEFAULT 0,
    CONTENT_                    CLOB,
    TECHNICAL_CONTENT_          CLOB,
    TOKEN_COUNT_                INTEGER,
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_EXC_INST ON FLW_HI_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_HI_AGENT_INST_EXC_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_AGENT_KB_ITEM_SECTION
(
    ID_                     VARCHAR2(255) NOT NULL,
    KB_ITEM_ID_             VARCHAR2(255) NOT NULL,
    EXTERNAL_ID_            VARCHAR2(500),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM_SECTION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_SEC_ITEM ON FLW_AGENT_KB_ITEM_SECTION (KB_ITEM_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM_SECTION
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_SEC_ITEM FOREIGN KEY (KB_ITEM_ID_) REFERENCES FLW_AGENT_KB_ITEM (ID_);


CREATE TABLE FLW_HI_AGENT_INSTANCE_KB_LINK
(
    ID_                             VARCHAR2(255) NOT NULL,
    REV_                            INTEGER NOT NULL,
    AGENT_INSTANCE_ID_              VARCHAR2(255),
    KB_ITEM_SECTION_ID_             VARCHAR2(255),
    EXTERNAL_ID_                    VARCHAR2(500),
    SCORE_                          DOUBLE PRECISION,
    CONSTRAINT PK_FLW_HI_AGENT_INST_KB_LINK PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_KB_DEF_METADATA
(
    ID_     VARCHAR2(255) NOT NULL,
    REV_    INTEGER NOT NULL,
    DEF_ID_ VARCHAR2(255) NOT NULL,
    NAME_   VARCHAR2(255),
    VALUE_  VARCHAR2(255),
    CONSTRAINT PK_FLW_AGENT_KB_DEF_METADATA PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_META_UNIQ ON FLW_AGENT_KB_DEF_METADATA (DEF_ID_, NAME_);

ALTER TABLE FLW_AGENT_KB_DEF_METADATA
    ADD CONSTRAINT FK_AGENT_KB_DEF_META_DEF_ FOREIGN KEY (DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

insert into ACT_GE_PROPERTY
values ('agent.schema.version', '1', 1);
