
CREATE TABLE FLW_ID_PROPERTY (
    NAME_ VARCHAR(64) NOT NULL,
    VALUE_ VARCHAR(300) NULL,
    REV_ INT NOT NULL,
    CONSTRAINT PK_FLW_ID_PROPERTY PRIMARY KEY (NAME_)
);

CREATE TABLE FLW_ID_GROUP (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    KEY_ VARCHAR(64) DEFAULT '' NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_ID_GROUP PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    FIRST_ VARCHAR(255) NULL,
    LAST_ VARCHAR(255) NULL,
    DISPLAY_NAME_ VARCHAR(255) NULL,
    EMAIL_ VARCHAR(255) NULL,
    PWD_ VARCHAR(255) NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CREATION_TIME_ datetime(6) NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    AVATAR_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_ID_USER PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_MEMBERSHIP (
    USER_ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(64) NOT NULL,
    CONSTRAINT PK_FLW_ID_MEMBERSHIP PRIMARY KEY (USER_ID_, GROUP_ID_)
);

CREATE TABLE FLW_ID_USER_DEFINITIONS (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(128) NULL,
    KEY_ VARCHAR(128) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    DEFINITION_CONTENT_ LONGTEXT NULL,
    CONSTRAINT PK_ID_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_INFO (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    USER_ID_ VARCHAR(64) NULL,
    TYPE_ VARCHAR(64) NULL,
    KEY_ VARCHAR(255) NULL,
    VALUE_ VARCHAR(255) NULL,
    PASSWORD_ LONGBLOB NULL,
    PARENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ID_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_IDENTITY_INFO (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    USER_ID_ VARCHAR(64) NULL,
    GROUP_ID_REF_ VARCHAR(64) NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    TEXT2_ VARCHAR(4000) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    TOKEN_VALUE_ VARCHAR(255) NULL,
    TOKEN_DATE_ datetime(6) NULL,
    IP_ADDRESS_ VARCHAR(255) NULL,
    USER_AGENT_ VARCHAR(255) NULL,
    USER_ID_ VARCHAR(255) NULL,
    TOKEN_DATA_ VARCHAR(2000) NULL,
    CONSTRAINT PK_FLW_ID_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV (
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    CONSTRAINT PK_FLW_ID_PRIV PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV_MAPPING (
    ID_ VARCHAR(64) NOT NULL,
    PRIV_ID_ VARCHAR(64) NOT NULL,
    USER_ID_ VARCHAR(255) NULL,
    GROUP_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ID_PRIV_MAPPING PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP (GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

CREATE INDEX FLW_IDX_MEMB_USER ON FLW_ID_MEMBERSHIP (USER_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER (ID_);

CREATE INDEX FLW_IDX_PRIV_MAPPING ON FLW_ID_PRIV_MAPPING (PRIV_ID_);

ALTER TABLE FLW_ID_PRIV_MAPPING
    ADD CONSTRAINT FLW_FK_PRIV_MAPPING FOREIGN KEY (PRIV_ID_) REFERENCES FLW_ID_PRIV (ID_);

CREATE INDEX FLW_IDX_PRIV_USER ON FLW_ID_PRIV_MAPPING (USER_ID_);

CREATE INDEX FLW_IDX_PRIV_GROUP ON FLW_ID_PRIV_MAPPING (GROUP_ID_);

ALTER TABLE FLW_ID_PRIV
    ADD CONSTRAINT FLW_UNIQ_PRIV_NAME UNIQUE (NAME_);

CREATE INDEX FLW_IDX_USER_CREATE_TIME ON FLW_ID_USER (CREATION_TIME_);

CREATE INDEX FLW_IDX_USER_UPDATE_TIME ON FLW_ID_USER (UPDATE_TIME_);

CREATE INDEX FLW_IDX_IDM_INFO_USER_ID ON FLW_IDENTITY_INFO (USER_ID_);

CREATE TABLE FLW_ID_USER_ACCOUNT_DEFINITION (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(128) NULL,
    KEY_ VARCHAR(128) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    DEFINITION_CONTENT_ LONGTEXT NULL,
    CONSTRAINT PK_ID_USER_ACCOUNT_DEFINITION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER_ACCOUNT (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    USER_ID_ VARCHAR(64) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    NAME_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(64) NULL,
    SUB_TYPE_ VARCHAR(64) NULL,
    STATE_ VARCHAR(64) NULL,
    SUB_STATE_ VARCHAR(64) NULL,
    BUSINESS_ACCOUNT_ID_ VARCHAR(255) NULL,
    EXTERNAL_USER_ID_ VARCHAR(255) NULL,
    USER_ACCOUNT_DEFINITION_ID_ VARCHAR(64) NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    CONSTRAINT PK_FLW_ID_USER_ACCOUNT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_USER_ACC_TYPE_SUB_EXT_USER ON FLW_ID_USER_ACCOUNT (TYPE_, SUB_TYPE_, EXTERNAL_USER_ID_);

CREATE TABLE FLW_ID_DESIGN_AUTHENTICATION (
    ID_ VARCHAR(255) NOT NULL,
    USER_ID_ VARCHAR(100) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CREATE_TIME_ datetime(6) NOT NULL,
    TOKEN_ VARCHAR(2000) NULL,
    CONSTRAINT PK_FLW_ID_DESIGN_AUTHENTICATION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_ACCESS_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(2000) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    EXPIRATION_TIME_ datetime(6) NULL,
    USER_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    TOKEN_VALUE_ VARCHAR(2000) NULL,
    CONSTRAINT PK_FLW_ID_ACCESS_TOKEN PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('idm.schema.version', '21', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR(255) NOT NULL, RESOURCE_BYTES_ LONGBLOB NULL, CREATION_TIME_ datetime(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR(255) NOT NULL, TIMESTAMP_ datetime(6) NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(255) NULL);

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR(255) NULL, TIMESTAMP_ datetime(6) NOT NULL, COUNT_ BIGINT NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR(255) NOT NULL, SIGNATURE_ LONGTEXT NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_TRANSLATION (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    LOCALE_ VARCHAR(16) NOT NULL,
    VALUE_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_TRANSLATION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TRANSLATION
    ADD CONSTRAINT FLW_UQ_TRANSL_SCOPE_KEY_LOCALE UNIQUE (SCOPE_ID_, SCOPE_TYPE_, KEY_, LOCALE_);

CREATE INDEX FLW_IDX_TRANSLATION_SCOPE ON FLW_TRANSLATION (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_COMMENT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    CONTENT_ LONGTEXT NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(64) NULL,
    USER_ID_ VARCHAR(255) NULL,
    CREATED_ datetime(6) NULL,
    UPDATED_ datetime(6) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_COMMENT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_COMMENT_SCOPE_ID ON FLW_COMMENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_COMMENT_USER_ID ON FLW_COMMENT (USER_ID_);

CREATE TABLE FLW_CONFIGURATION_PROPERTY (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    NAMESPACE_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(500) NULL,
    TEXT_VALUE_ LONGTEXT NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    LAST_UPDATER_ID_ VARCHAR(64) NULL,
    LAST_UPDATE_TIME_ datetime(6) NOT NULL,
    CONSTRAINT PK_FLW_CONFIGURATION_PROPERTY PRIMARY KEY (ID_)
);

CREATE INDEX FLW_CON_PROP_NS_NAME_TENANT ON FLW_CONFIGURATION_PROPERTY (NAMESPACE_, NAME_, TENANT_ID_);

CREATE TABLE FLW_PL_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_PL_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_PL_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_PL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PL_RSRC_DPL ON FLW_PL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_QUERY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    TYPE_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_QUERY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_QUERY_DEF_UNIQ ON FLW_QUERY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_QUERY_DEF_DEPLOYMENT ON FLW_QUERY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_QUERY_DEFINITION
    ADD CONSTRAINT FK_QUERY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_VAR_EXT_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    TYPE_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_VAR_EXT_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_VAR_EXT_DEF_UNIQ ON FLW_VAR_EXT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_VAR_EXT_DEF_DEPLOYMENT ON FLW_VAR_EXT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_VAR_EXT_DEFINITION
    ADD CONSTRAINT FK_VAR_EXT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SEQUENCE_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_SEQUENCE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SEQUENCE_DEF_UNIQ ON FLW_SEQUENCE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SEQUENCE_DEF_DEPLOYMENT ON FLW_SEQUENCE_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SEQUENCE_DEFINITION
    ADD CONSTRAINT FK_SEQUENCE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_DATA_DICTIONARY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_DATA_DICTIONARY_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_DATA_DICT_DEF_UNIQ ON FLW_DATA_DICTIONARY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DATA_DICT_DEF_DEPLOYMENT ON FLW_DATA_DICTIONARY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DATA_DICTIONARY_DEFINITION
    ADD CONSTRAINT FK_DATA_DICT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SLA_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_SLA_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SLA_DEF_UNIQ ON FLW_SLA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SLA_DEF_DEPLOYMENT ON FLW_SLA_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SLA_DEFINITION
    ADD CONSTRAINT FK_SLA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_TEN_VARIABLE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    BYTEARRAY_ID_ VARCHAR(64) NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    VARIABLE_PROTECTED_ TINYINT NULL,
    CREATED_ timestamp(6) NULL,
    CREATED_BY_ VARCHAR(255) NULL,
    LAST_MODIFIED_ timestamp(6) NULL,
    LAST_MODIFIED_BY_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_TEN_VARIABLE PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_TEN_VAR_NAME_TENANT ON FLW_TEN_VARIABLE (NAME_, TENANT_ID_);

CREATE TABLE FLW_SLA_AUDIT (
    ID_ VARCHAR(255) NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    ROOT_SCOPE_ID_ VARCHAR(255) NOT NULL,
    ROOT_SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    SUB_SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    APP_KEY_ VARCHAR(255) NULL,
    SLA_DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CREATE_TIME_ datetime(6) NOT NULL,
    IN_PROGRESS_START_TIME_ datetime(6) NULL,
    IN_PROGRESS_STARTED_BY_ VARCHAR(255) NULL,
    CLAIM_TIME_ datetime(6) NULL,
    CLAIMED_BY_ VARCHAR(255) NULL,
    COMPLETION_TIME_ datetime(6) NULL,
    COMPLETED_BY_ VARCHAR(255) NULL,
    IN_PROGRESS_START_DUE_TIME_ datetime(6) NULL,
    COMPLETION_DUE_TIME_ datetime(6) NULL,
    IN_PROGRESS_START_DUE_DUR_ INT NULL,
    COMPLETION_DUE_DURATION_ INT NULL,
    IN_PROGRESS_START_DURATION_ INT NULL,
    COMPLETION_DURATION_ INT NULL,
    IN_PROGRESS_START_RELATIVE_ INT NULL,
    COMPLETION_RELATIVE_ INT NULL,
    IN_PROGRESS_START_SLA_BREACH_ INT NULL,
    COMPLETION_SLA_BREACHED_ INT NULL,
    PAYLOAD_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_SLA_AUDIT PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_SLA_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_SLA_SUB_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SUB_SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_DASHBOARD (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(255) NULL,
    CREATOR_ID_ VARCHAR(255) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    UPDATER_ID_ VARCHAR(255) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    CONFIGURATION_ LONGTEXT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_DASHBOARD PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DASHBOARD_COMP_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_DASHB_COMP_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_DASHB_COMP_DEF_UNIQ ON FLW_DASHBOARD_COMP_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DASHB_COMP_DEF_DEPLOYMENT ON FLW_DASHBOARD_COMP_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DASHBOARD_COMP_DEFINITION
    ADD CONSTRAINT FK_DASHB_COMP_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_OAUTH_CLIENT_REG (
    ID_ VARCHAR(255) NOT NULL,
    REGISTRATION_KEY_ VARCHAR(255) NOT NULL,
    CLIENT_ID_ VARCHAR(100) NULL,
    CLIENT_SECRET_ VARCHAR(255) NULL,
    CLIENT_NAME_ VARCHAR(255) NULL,
    CLIENT_AUTHENTICATION_METHOD_ VARCHAR(200) NULL,
    SCOPES_ VARCHAR(2000) NULL,
    ISSUER_URI_ VARCHAR(2000) NULL,
    TOKEN_URI_ VARCHAR(2000) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT FLW_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_OAUTH_CL_REG_KEY_TEN ON FLW_OAUTH_CLIENT_REG (REGISTRATION_KEY_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('platform.schema.version', '19', 1);


CREATE TABLE ACT_APP_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime(3) NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_ACT_APP_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_APP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT ACT_FK_APP_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_RSRC_DPL ON ACT_APP_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE ACT_APP_APPDEF (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NOT NULL,
    VERSION_ INT NOT NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    TYPE_ VARCHAR(255) NULL,
    SUB_TYPE_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    SUB_STATE_ VARCHAR(255) NULL,
    APP_URL_ VARCHAR(255) NULL,
    CREATION_TIME_ datetime(6) NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_ACT_APP_APPDEF PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_APPDEF
    ADD CONSTRAINT ACT_FK_APP_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_DEF_DPLY ON ACT_APP_APPDEF (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_APP_DEF_UNIQ ON ACT_APP_APPDEF (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE ACT_APP_PAGEDEF (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    APP_ID_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NOT NULL,
    PAGE_URL_ VARCHAR(255) NULL,
    APP_KEY_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_ACT_APP_PAGEDEF PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_VARIABLE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NOT NULL,
    APP_KEY_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    BYTEARRAY_ID_ VARCHAR(64) NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    CONSTRAINT PK_ACT_APP_VARIABLE PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_VAR_KEY ON ACT_APP_VARIABLE (APP_KEY_);

CREATE INDEX ACT_IDX_APP_VAR_KEY_TENANT ON ACT_APP_VARIABLE (APP_KEY_, TENANT_ID_);

CREATE TABLE ACT_APP_INCIDENT (
    ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    SUB_TYPE_ VARCHAR(255) NULL,
    APP_KEY_ VARCHAR(255) NULL,
    ROOT_SCOPE_ID_ VARCHAR(255) NULL,
    ROOT_SCOPE_TYPE_ VARCHAR(255) NULL,
    ROOT_SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    ELEMENT_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    INCIDENT_INFO_ LONGTEXT NULL,
    CREATE_TIME_ datetime(6) NOT NULL,
    CONSTRAINT PK_ACT_APP_INCIDENT PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_INC_DEF_ROOT_KEY ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_K_TENANT ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY_TENANT ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_SCOPE ON ACT_APP_INCIDENT (ROOT_SCOPE_ID_, ROOT_SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_KEY ON ACT_APP_INCIDENT (APP_KEY_);

CREATE INDEX ACT_IDX_APP_INC_KEY_TENANT ON ACT_APP_INCIDENT (APP_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_SCOPE ON ACT_APP_INCIDENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_CREATE ON ACT_APP_INCIDENT (CREATE_TIME_);

insert into ACT_GE_PROPERTY
    values ('app.schema.version', '12', 1);


CREATE TABLE FLW_FO_FORM_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime(3) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_FO_FORM_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_FO_FORM_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_FO_FORM_RESOURCE
    ADD CONSTRAINT FLW_FK_FO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_FO_FORM_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_FO_RSRC_DPL ON FLW_FO_FORM_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_FO_FORM_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    VERSION_ INT NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    RESOURCE_NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_FO_FORM_DEFINITION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    FORM_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TASK_ID_ VARCHAR(255) NULL,
    PROC_INST_ID_ VARCHAR(255) NULL,
    PROC_DEF_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SUBMITTED_DATE_ datetime(3) NULL,
    SUBMITTED_BY_ VARCHAR(255) NULL,
    FORM_VALUES_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_FO_FORM_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_CUSTOM_COMPONENT_DEF (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    VERSION_ INT,
    KEY_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    COMPONENT_VERSION_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_FO_CUST_COMPONENT_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX FLW_IDX_FORM_DEF_UNIQ ON FLW_FO_FORM_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE UNIQUE INDEX FLW_IDX_CUST_COMP_DEF_UNIQ ON FLW_FO_CUSTOM_COMPONENT_DEF (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX FLW_IDX_FORM_TASK ON FLW_FO_FORM_INSTANCE (TASK_ID_);

CREATE INDEX FLW_IDX_FORM_PROC ON FLW_FO_FORM_INSTANCE (PROC_INST_ID_);

CREATE INDEX FLW_IDX_FORM_SCOPE ON FLW_FO_FORM_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('form.schema.version', '11', 1);


CREATE TABLE FLW_CO_CONTENT_ITEM (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    MIME_TYPE_ VARCHAR(255) NULL,
    DEFINITION_ID_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    SUB_TYPE_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    SUB_STATE_ VARCHAR(255) NULL,
    TASK_ID_ VARCHAR(255) NULL,
    PROC_INST_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    CONTENT_STORE_ID_ VARCHAR(255) NULL,
    CONTENT_STORE_NAME_ VARCHAR(255) NULL,
    CONTENT_AVAILABLE_ TINYINT DEFAULT 0 NULL,
    CREATED_ timestamp(6) NULL,
    CREATED_BY_ VARCHAR(255) NULL,
    LAST_MODIFIED_ timestamp(6) NULL,
    LAST_MODIFIED_BY_ VARCHAR(255) NULL,
    CONTENT_SIZE_ BIGINT DEFAULT 0 NULL,
    LOCK_INFO_ VARCHAR(255) NULL,
    VERSION_ INT NULL,
    VERSION_INFO_ VARCHAR(255) NULL,
    VERSION_PARENT_ID_ VARCHAR(255) NULL,
    FOLDER_PARENT_ID_ VARCHAR(255) NULL,
    FOLDER_BASE_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_CO_CONTENT_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX idx_contitem_taskid ON FLW_CO_CONTENT_ITEM (TASK_ID_);

CREATE INDEX idx_contitem_procid ON FLW_CO_CONTENT_ITEM (PROC_INST_ID_);

CREATE INDEX idx_contitem_scope ON FLW_CO_CONTENT_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_RENDITION_ITEM (
    ID_ VARCHAR(255) NOT NULL,
    CONTENT_ITEM_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    MIME_TYPE_ VARCHAR(255) NULL,
    RENDITION_TYPE_ VARCHAR(255) NULL,
    TASK_ID_ VARCHAR(255) NULL,
    PROC_INST_ID_ VARCHAR(255) NULL,
    CONTENT_STORE_ID_ VARCHAR(255) NULL,
    CONTENT_STORE_NAME_ VARCHAR(255) NULL,
    CONTENT_AVAILABLE_ TINYINT DEFAULT 0 NULL,
    CREATED_ timestamp(6) NULL,
    LAST_MODIFIED_ timestamp(6) NULL,
    CONTENT_SIZE_ BIGINT DEFAULT 0 NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_CO_RENDITION_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX idx_rendition_taskid ON FLW_CO_RENDITION_ITEM (TASK_ID_);

CREATE INDEX idx_rendition_procid ON FLW_CO_RENDITION_ITEM (PROC_INST_ID_);

CREATE INDEX idx_rendition_scope ON FLW_CO_RENDITION_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_CONTENT_OBJECT (
    ID_ VARCHAR(255) NOT NULL,
    CREATED_ timestamp(6) NULL,
    CONTENT_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_CO_CONTENT_OBJECT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_CO_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_CO_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    NAME_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    UPDATE_TIME_ datetime(6) NULL,
    CONSTRAINT PK_CO_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_METADATA (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    CONTENT_ITEM_ID_ VARCHAR(255) NULL,
    BYTEARRAY_ID_ VARCHAR(255) NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    TEXT2_ VARCHAR(4000) NULL,
    CONSTRAINT PK_FLW_CO_METADATA PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CO_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_CO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_CO_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_CO_RSRC_DPL ON FLW_CO_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE INDEX idx_contitem_folder ON FLW_CO_CONTENT_ITEM (FOLDER_PARENT_ID_);

CREATE INDEX idx_contitem_name ON FLW_CO_CONTENT_ITEM (NAME_);

CREATE INDEX idx_contitem_verparid ON FLW_CO_CONTENT_ITEM (VERSION_PARENT_ID_);

CREATE INDEX idx_contitem_bfolder ON FLW_CO_CONTENT_ITEM (FOLDER_BASE_ID_);

CREATE INDEX idx_rendition_contentid ON FLW_CO_RENDITION_ITEM (CONTENT_ITEM_ID_);

CREATE INDEX idx_metadata_contentid ON FLW_CO_METADATA (CONTENT_ITEM_ID_);

CREATE UNIQUE INDEX FLW_IDX_CO_DEF_UNIQ ON FLW_CO_DEFINITION (KEY_, VERSION_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('content.schema.version', '18', 1);


CREATE TABLE FLW_ACTION_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ACTION_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_ACTION_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_ACTION_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_ACTION_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_ACTION_RSRC_DPL ON FLW_ACTION_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_ACTION_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    BOT_KEY_ VARCHAR(128) NULL,
    MANDATORY_ TINYINT NULL,
    NAME_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    SCOPE_TYPE_ VARCHAR(128) NULL,
    FORM_KEY_ VARCHAR(128) NULL,
    GLOBAL_ TINYINT NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    UPDATER_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_ACTION_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    START_DATE_ datetime(6) NULL,
    FORM_KEY_ VARCHAR(128) NULL,
    FORM_INSTANCE_ID_ VARCHAR(255) NULL,
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    PRIORITY_ INT NULL,
    ICON_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ACTION_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    CREATION_TIME_ datetime(6) NULL,
    CONSTRAINT PK_FLW_ACTION_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_)
);

CREATE INDEX FLW_IDX_ACTION_LINK_SCOPE ON FLW_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_ACTION_DEFINITION
    ADD CONSTRAINT FK_ACTION_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

ALTER TABLE FLW_ACTION_INSTANCE
    ADD CONSTRAINT FK_ACTION_INST_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_);

CREATE TABLE FLW_HI_ACTION_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    START_DATE_ datetime(6) NULL,
    EXECUTION_DATE_ datetime(6) NULL,
    EXECUTED_BY_ VARCHAR(255) NULL,
    FORM_KEY_ VARCHAR(128) NULL,
    FORM_INSTANCE_ID_ VARCHAR(255) NULL,
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    PRIORITY_ INT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_HI_ACTION_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_HI_ACTION_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255) NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    CREATION_TIME_ datetime(6) NULL,
    CONSTRAINT PK_FLW_HI_ACTION_LINK PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_HI_ACTION_LINK_SCOPE ON FLW_HI_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_HI_ACTION_LINK_ACTION_INST ON FLW_HI_ACTION_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_HI_DEFINITION_ID_ ON FLW_HI_ACTION_LINK (ACTION_DEFINITION_ID_);

CREATE INDEX IDX_HI_ACTION_INST_ACTION_DEF ON FLW_HI_ACTION_INSTANCE (ACTION_DEFINITION_ID_);

CREATE TABLE FLW_ACTION_DEF_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ACTION_DEF_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_DEF_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_)
);

CREATE UNIQUE INDEX ACT_IDX_ACTIONs_DEF_UNIQ ON FLW_ACTION_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_ACTION_TYPE_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_ACTION_TYPE_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_ACT_TYPE_LINK_ACT_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_)
);

CREATE INDEX IDX_ACT_TYPE_LINK_ACT_INST ON FLW_ACTION_TYPE_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACT_IDX_SCOPE_ID_TYPE ON FLW_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_HI_IDX_SCOPE_ID_TYPE ON FLW_HI_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('action.schema.version', '20', 1);


CREATE TABLE FLW_AUDIT_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    AUDIT_DEFINITION_ID_ VARCHAR(255) NULL,
    CREATION_TIME_ datetime(6) NULL,
    CREATOR_ID_ VARCHAR(255) NULL,
    EXTERNAL_ID_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    SUB_TYPE_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    PAYLOAD_ LONGTEXT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_AUDIT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_AUDIT_INST_DEF ON FLW_AUDIT_INSTANCE (AUDIT_DEFINITION_ID_);

CREATE INDEX FLW_IDX_AUDIT_INST_TYPE ON FLW_AUDIT_INSTANCE (TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_SCOPE ON FLW_AUDIT_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_CREATE ON FLW_AUDIT_INSTANCE (CREATION_TIME_);

insert into ACT_GE_PROPERTY
    values ('audit.schema.version', '4', 1);


CREATE TABLE FLW_DATAOBJECT_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_DATAOBJECT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_DO_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DATAOBJECT_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    NAME_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    SOURCE_ID_ VARCHAR(128) NULL,
    SOURCE_TYPE_ VARCHAR(128) NULL,
    TYPE_ VARCHAR(128) NULL,
    SUB_TYPE_ VARCHAR(128) NULL,
    EXTERNAL_ID_ VARCHAR(128) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_DO_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DATAOBJECT_DEFINITION
    ADD CONSTRAINT FK_DATAOBJECT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DATAOBJECT_DEF_DEPLOYMENT ON FLW_DATAOBJECT_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DATAOBJECT_DEF_UNIQ ON FLW_DATAOBJECT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_MASTER_DATA_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    DEFINITION_ID_ VARCHAR(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    EXTERNAL_ID_ VARCHAR(128) NULL,
    KEY_ VARCHAR(128) NULL,
    NAME_ VARCHAR(255) NULL,
    STATE_ VARCHAR(64) NULL,
    SORT_ORDER_ INT NULL,
    IS_FAVORITE_ TINYINT NULL,
    DESCRIPTION_ VARCHAR(2000) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(128) NULL,
    UPDATE_TIME_ datetime(6) NOT NULL,
    UPDATER_ID_ VARCHAR(128) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_DO_DATA_INSTANCES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_VARIABLES (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    DATA_INSTANCE_ID_ VARCHAR(255) NULL,
    BYTEARRAY_ID_ VARCHAR(255) NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    TEXT2_ VARCHAR(4000) NULL,
    CONSTRAINT PK_FLW_DO_VARIABLES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_SCHEMA_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    VERSION_ INT NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_DO_SCHEMA_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DO_SCHEMA_DEFINITION
    ADD CONSTRAINT FK_DO_SCHEMA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DO_SCHEMA_DEF_DEPLOYMENT ON FLW_DO_SCHEMA_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DO_SCHEMA_DEF_UNIQ ON FLW_DO_SCHEMA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DO_DATAOBJECT_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    DEFINITION_ID_ VARCHAR(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    LOOKUP_ID_ VARCHAR(128) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(128) NULL,
    UPDATE_TIME_ datetime(6) NOT NULL,
    UPDATER_ID_ VARCHAR(128) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SUB_SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    SCOPE_DEFINITION_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_DO_DATAOBJECT_INSTANCES PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('dataobject.schema.version', '7', 1);


CREATE TABLE FLW_POLICY_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_POLICY_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_POLICY_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_POLICY_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_POLICY_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_POLICY_RSRC_DPL ON FLW_POLICY_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_POLICY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    TYPE_ VARCHAR(128) NULL,
    NAME_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_POLICY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEF_LINK (
    ID_ VARCHAR(255) NOT NULL,
    POLICY_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_POLICY_DEF_LINK PRIMARY KEY (ID_),
    CONSTRAINT FK_POLICY_DEF_LINK_POLICY_DEF FOREIGN KEY (POLICY_DEFINITION_ID_) REFERENCES FLW_POLICY_DEFINITION (ID_)
);

ALTER TABLE FLW_POLICY_DEFINITION
    ADD CONSTRAINT FK_POLICY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX IDX_POLICY_DEF_DEPLOYMENT ON FLW_POLICY_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_POLICIES_DEF_UNIQ ON FLW_POLICY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_POLICY_DEF_LINK_POLICY_DEF ON FLW_POLICY_DEF_LINK (POLICY_DEFINITION_ID_);

insert into ACT_GE_PROPERTY
    values ('policy.schema.version', '3', 1);


CREATE TABLE FLW_SE_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_SE_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_SE_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_SE_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_SE_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_SE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_SE_RSRC_DPL ON FLW_SE_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_SE_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    NAME_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    REFERENCE_KEY_ VARCHAR(255) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    CONSTRAINT PK_SERVICE_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX ACT_IDX_SERVICE_DEF_UNIQ ON FLW_SE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_SE_DEFINITION
    ADD CONSTRAINT FK_SERVICE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX IDX_SERVICE_DEF_DEPLOYMENT ON FLW_SE_DEFINITION (DEPLOYMENT_ID_);

insert into ACT_GE_PROPERTY
    values ('service.schema.version', '4', 1);


CREATE TABLE FLW_TEMPL_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_TEMPL_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_TEMPL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_TEMPL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_TEMPL_RSRC_DPL ON FLW_TEMPL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_TEMPL_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(128) NULL,
    VERSION_ INT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128) NULL,
    TYPE_ VARCHAR(128) NULL,
    SUB_TYPE_ VARCHAR(128) NULL,
    FORM_KEY_ VARCHAR(128) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    UPDATOR_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_TEMPL_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_VAR_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    TEMPLATE_DEF_KEY_ VARCHAR(128) NULL,
    VARIATION_KEY_ VARCHAR(128) NULL,
    NAME_ VARCHAR(128) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    VERSION_ INT NULL,
    VALID_FROM_ datetime(6) NULL,
    VALID_TO_ datetime(6) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    EXTERNAL_ID_ VARCHAR(255) NULL,
    CONTENT_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '' NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    CREATOR_ID_ VARCHAR(64) NULL,
    CONSTRAINT PK_TEMPL_VAR_DEFINITIONS PRIMARY KEY (ID_)
);

create index FLW_IDX_TEMPL_VAR_DEF_DEF_KEY
    on FLW_TEMPL_VAR_DEFINITION (TEMPLATE_DEF_KEY_, VARIATION_KEY_);

INSERT INTO ACT_GE_PROPERTY
VALUES ('template.schema.version', '8', 1);


CREATE TABLE FLW_AGENT_DEPLOYMENT
(
    ID_                   VARCHAR(255) NOT NULL,
    NAME_                 VARCHAR(255) NULL,
    KEY_                  VARCHAR(255) NULL,
    CATEGORY_             VARCHAR(255) NULL,
    DEPLOY_TIME_          datetime     NULL,
    TENANT_ID_            VARCHAR(255) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEPLOYMENT_RES
(
    ID_             VARCHAR(255) NOT NULL,
    NAME_           VARCHAR(255) NULL,
    DEPLOYMENT_ID_  VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB     NULL,
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEFINITION
(
    ID_              VARCHAR(255)           NOT NULL,
    REV_             INT                    NOT NULL,
    KEY_             VARCHAR(255)           NULL,
    VERSION_         INT                    NULL,
    DEPLOYMENT_ID_   VARCHAR(255)           NOT NULL,
    NAME_            VARCHAR(255)           NULL,
    DESCRIPTION_     VARCHAR(4000)          NULL,
    API_ENABLED_     TINYINT DEFAULT 0      NULL,
    RESOURCE_NAME_   VARCHAR(4000)          NULL,
    TYPE_            VARCHAR(255)           NOT NULL,
    TENANT_ID_       VARCHAR(64) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_AGENT_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_DEF_UNIQ ON FLW_AGENT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_DEF_DEPLOYMENT ON FLW_AGENT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);

CREATE TABLE FLW_AGENT_INSTANCE
(
    ID_                     VARCHAR(255)           NOT NULL,
    REV_                    INT                    NOT NULL,
    TENANT_ID_              VARCHAR(64) DEFAULT '' NULL,
    AGENT_DEFINITION_ID_    VARCHAR(255)           NOT NULL,
    START_TIME_             datetime(6)            NOT NULL,
    CHAT_ENABLED_           TINYINT DEFAULT 0 NULL,
    START_USER_ID_          VARCHAR(255)           NULL,
    REFERENCE_ID_           VARCHAR(255)           NULL,
    REFERENCE_TYPE_         VARCHAR(255)           NULL,
    CALLBACK_ID_            VARCHAR(255)           NULL,
    CALLBACK_TYPE_          VARCHAR(255)           NULL,
    CONSTRAINT PK_FLW_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INSTANCE_DEF_ID ON FLW_AGENT_INSTANCE (AGENT_DEFINITION_ID_);
CREATE INDEX IDX_FLW_AGENT_INSTANCE_REF_ID ON FLW_AGENT_INSTANCE (REFERENCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE
    ADD CONSTRAINT FK_FLW_AGENT_INSTANCE_DEF FOREIGN KEY (AGENT_DEFINITION_ID_) REFERENCES FLW_AGENT_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_KB_DEFINITION
(
    ID_              VARCHAR(255) NOT NULL,
    REV_             INT      NOT NULL,
    KEY_             VARCHAR(255),
    VERSION_         INT,
    DEPLOYMENT_ID_   VARCHAR(255) NOT NULL,
    NAME_            VARCHAR(255),
    DESCRIPTION_     VARCHAR(4000),
    RESOURCE_NAME_   VARCHAR(4000),
    TENANT_ID_       VARCHAR(64) DEFAULT '',
    READY_           TINYINT DEFAULT 0 NOT NULL,
    CONSTRAINT PK_FLW_AGENT_KB_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_UNIQ ON FLW_AGENT_KB_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_KB_DEF_DEPL ON FLW_AGENT_KB_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_KB_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_KB_DEF_DEPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);


CREATE TABLE FLW_AGENT_KB_ITEM
(
    ID_                    VARCHAR(255)     NOT NULL,
    PARENT_ID_             VARCHAR(255)     NULL,
    ROOT_ID_               VARCHAR(255)     NULL,
    KB_DEF_ID_             VARCHAR(255)     NULL,
    IS_CONTAINER_          TINYINT DEFAULT 0 NOT NULL,
    SCOPE_ID_              VARCHAR(255)     NULL,
    SCOPE_TYPE_            VARCHAR(255)     NULL,
    CHECKSUM_              VARCHAR(255)     NULL,
    CONSTRAINT PK_FLW_AGENT_KB_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_UNIQ ON FLW_AGENT_KB_ITEM (SCOPE_ID_, SCOPE_TYPE_);
CREATE INDEX IDX_FLW_AGENT_KB_ITEM_DEF ON FLW_AGENT_KB_ITEM (KB_DEF_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_DEF FOREIGN KEY (KB_DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_INSTANCE_EXCHANGE
(
    ID_                     VARCHAR(255) NOT NULL,
    REV_                    INT                    NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR(255),
    OPERATION_KEY_          VARCHAR(255),
    CREATION_TIME_          TIMESTAMP(6) NOT NULL,
    TYPE_                   VARCHAR(255),
    USER_ID_                VARCHAR(255),
    PROCESSING_             TINYINT DEFAULT 0 NULL,
    CONTENT_                TEXT,
    TECHNICAL_CONTENT_      TEXT,
    TOKEN_COUNT_            INT,
    CONSTRAINT PK_FLW_AGENT_INSTANCE_EXCHANGE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INST_EXCH_INST ON FLW_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_AGENT_INST_EXCH_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE
(
    ID_                  VARCHAR(255) NOT NULL,
    REV_                 INT      NOT NULL,
    TENANT_ID_           VARCHAR(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) NOT NULL,
    END_TIME_            TIMESTAMP(6) NULL,
    CHAT_ENABLED_        TINYINT DEFAULT 0 NULL,
    STATE_               VARCHAR(255),
    START_USER_ID_       VARCHAR(255),
    REFERENCE_ID_        VARCHAR(255),
    REFERENCE_TYPE_      VARCHAR(255),
    CALLBACK_ID_         VARCHAR(255),
    CALLBACK_TYPE_       VARCHAR(255),
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_DEF_ID ON FLW_HI_AGENT_INSTANCE (AGENT_DEFINITION_ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
(
    ID_                         VARCHAR(255) NOT NULL,
    REV_                        INT NOT NULL,
    AGENT_INSTANCE_ID_          VARCHAR(255),
    OPERATION_KEY_              VARCHAR(255),
    CREATION_TIME_              TIMESTAMP(6) NOT NULL,
    TYPE_                       VARCHAR(255),
    USER_ID_                    VARCHAR(255),
    PROCESSING_                 TINYINT DEFAULT 0 NULL,
    CONTENT_                    TEXT,
    TECHNICAL_CONTENT_          TEXT,
    TOKEN_COUNT_       INT,
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_EXC_INST ON FLW_HI_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_HI_AGENT_INST_EXC_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_AGENT_KB_ITEM_SECTION
(
    ID_                     VARCHAR(255) NOT NULL,
    KB_ITEM_ID_             VARCHAR(255) NOT NULL,
    EXTERNAL_ID_            VARCHAR(500) NULL,
    CONSTRAINT PK_FLW_AGENT_KB_ITEM_SECTION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_SEC_ITEM ON FLW_AGENT_KB_ITEM_SECTION (KB_ITEM_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM_SECTION
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_SEC_ITEM FOREIGN KEY (KB_ITEM_ID_) REFERENCES FLW_AGENT_KB_ITEM (ID_);


CREATE TABLE FLW_HI_AGENT_INSTANCE_KB_LINK
(
    ID_                             VARCHAR(255) NOT NULL,
    REV_                            INT          NOT NULL,
    AGENT_INSTANCE_ID_              VARCHAR(255) NULL,
    KB_ITEM_SECTION_ID_             VARCHAR(255) NULL,
    EXTERNAL_ID_                    VARCHAR(500) NULL,
    SCORE_ DOUBLE NULL,
    CONSTRAINT PK_FLW_HI_AGENT_INST_KB_LINK PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_KB_DEF_METADATA
(
    ID_     VARCHAR(255) NOT NULL,
    REV_    INT          NOT NULL,
    DEF_ID_ VARCHAR(255) NOT NULL,
    NAME_   VARCHAR(255) NULL,
    VALUE_  VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_AGENT_KB_DEF_METADATA PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_META_UNIQ ON FLW_AGENT_KB_DEF_METADATA (DEF_ID_, NAME_);

ALTER TABLE FLW_AGENT_KB_DEF_METADATA
    ADD CONSTRAINT FK_AGENT_KB_DEF_META_DEF_ FOREIGN KEY (DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

insert into ACT_GE_PROPERTY
values ('agent.schema.version', '1', 1);

