

CREATE TABLE FLW_ISP_DATABASECHANGELOGLOCK (ID INTEGER NOT NULL, LOCKED NUMBER(1) NOT NULL, LOCKGRANTED TIMESTAMP, LOCKEDBY VARCHAR2(255), CONSTRAINT PK_FLW_ISP_DATABASECHANGELOGLO PRIMARY KEY (ID));

DELETE FROM FLW_ISP_DATABASECHANGELOGLOCK;

INSERT INTO FLW_ISP_DATABASECHANGELOGLOCK (ID, LOCKED) VALUES (1, 0);

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = TO_TIMESTAMP('2020-07-20 13:16:03.351', 'YYYY-MM-DD HH24:MI:SS.FF') WHERE ID = 1 AND LOCKED = 0;

CREATE TABLE FLW_ISP_DATABASECHANGELOG (ID VARCHAR2(255) NOT NULL, AUTHOR VARCHAR2(255) NOT NULL, FILENAME VARCHAR2(255) NOT NULL, DATEEXECUTED TIMESTAMP NOT NULL, ORDEREXECUTED INTEGER NOT NULL, EXECTYPE VARCHAR2(10) NOT NULL, MD5SUM VARCHAR2(35), DESCRIPTION VARCHAR2(255), COMMENTS VARCHAR2(255), TAG VARCHAR2(255), LIQUIBASE VARCHAR2(20), CONTEXTS VARCHAR2(255), LABELS VARCHAR2(255), DEPLOYMENT_ID VARCHAR2(10));

CREATE TABLE FLW_INSP_DEPLOYMENT (ID_ VARCHAR2(255) NOT NULL, NAME_ VARCHAR2(255), KEY_ VARCHAR2(255), CATEGORY_ VARCHAR2(255), DEPLOY_TIME_ TIMESTAMP, TENANT_ID_ VARCHAR2(255), PARENT_DEPLOYMENT_ID_ VARCHAR2(255), CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_INSP_DEPLOYMENT_RESOURCE (ID_ VARCHAR2(255) NOT NULL, NAME_ VARCHAR2(255), DEPLOYMENT_ID_ VARCHAR2(255), RESOURCE_BYTES_ BLOB, CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURC PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_DEFINITION (ID_ VARCHAR2(255) NOT NULL, REV_ INTEGER NOT NULL, KEY_ VARCHAR2(128), NAME_ VARCHAR2(128), VERSION_ INTEGER, RESOURCE_NAME_ VARCHAR2(4000), DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL, TENANT_ID_ VARCHAR2(64) DEFAULT '', CONSTRAINT PK_TEST_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_INSTANCE (ID_ VARCHAR2(255) NOT NULL, TEST_DEFINITION_ID_ VARCHAR2(255) NOT NULL, START_DATE_ TIMESTAMP(6), SCOPE_DEFINITION_ID_ VARCHAR2(255), SCOPE_ID_ VARCHAR2(255), SCOPE_TYPE_ VARCHAR2(255), TENANT_ID_ VARCHAR2(255), CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_DEFINITION ADD CONSTRAINT FK_TEST_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

ALTER TABLE FLW_TEST_INSTANCE ADD CONSTRAINT FK_TEST_INST_TEST_DEF FOREIGN KEY (TEST_DEFINITION_ID_) REFERENCES FLW_TEST_DEFINITION (ID_);

CREATE INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION(KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE(TEST_DEFINITION_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 1, '8:84b7b01796aeb34dde0236f98185376e', 'createTable tableName=FLW_INSP_DEPLOYMENT; createTable tableName=FLW_INSP_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEST_DEFINITION; createTable tableName=FLW_TEST_INSTANCE; addForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constrain...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

CREATE TABLE FLW_TEST_USER_DEFINITION (ID_ VARCHAR2(255) NOT NULL, REV_ INTEGER NOT NULL, KEY_ VARCHAR2(128), NAME_ VARCHAR2(128), VERSION_ INTEGER, RESOURCE_NAME_ VARCHAR2(4000), DEPLOYMENT_ID_ VARCHAR2(255) NOT NULL, TENANT_ID_ VARCHAR2(64) DEFAULT '', CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_USER_DEFINITION ADD CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

CREATE INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 2, '8:472999077c245f4eae3736bdaf62bbd4', 'createTable tableName=FLW_TEST_USER_DEFINITION; addForeignKeyConstraint baseTableName=FLW_TEST_USER_DEFINITION, constraintName=FK_TEST_USER_DEF_DEPLOYMENT, referencedTableName=FLW_INSP_DEPLOYMENT; createIndex indexName=IDX_TEST_DEF_USER_DEPLOYMENT...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

CREATE TABLE FLW_INSP_TEST_MODEL (ID_ VARCHAR2(255) NOT NULL, KEY_ VARCHAR2(128), NAME_ VARCHAR2(128), SCOPE_ID_ VARCHAR2(255), SCOPE_TYPE_ VARCHAR2(255), SCOPE_DEFINITION_ID_ VARCHAR2(255), SCOPE_DEFINITION_KEY_ VARCHAR2(255), MODEL_CONTENT_ CLOB, CREATION_TIME_ TIMESTAMP, CREATOR_ID_ VARCHAR2(255), TENANT_ID_ VARCHAR2(64) DEFAULT '', CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_));

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL(CREATOR_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 3, '8:2310d4da8100cf273e2b7ed2af07e244', 'createTable tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_SCOPE, tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_CREATOR, tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

CREATE TABLE FLW_INSP_BREAKPOINT (ID_ VARCHAR2(255) NOT NULL, SCOPE_ID_ VARCHAR2(255), SCOPE_TYPE_ VARCHAR2(255), SCOPE_DEFINITION_ID_ VARCHAR2(255), SCOPE_DEFINITION_KEY_ VARCHAR2(255), BREAKPOINT_CONTENT_ CLOB, CREATION_TIME_ TIMESTAMP, CREATOR_ID_ VARCHAR2(255), TENANT_ID_ VARCHAR2(64) DEFAULT '', CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_));

CREATE INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 4, '8:7ce51a8366cd2815f5f0d58b30648443', 'createTable tableName=FLW_INSP_BREAKPOINT; createIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

DROP INDEX IDX_BREAKPOINT_SCOPE;

ALTER TABLE FLW_INSP_BREAKPOINT RENAME TO FLW_INSP_META_MODEL;

ALTER TABLE FLW_INSP_META_MODEL ADD TYPE_ VARCHAR2(255);

ALTER TABLE FLW_INSP_META_MODEL RENAME COLUMN BREAKPOINT_CONTENT_ TO META_MODEL_CONTENT_;

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL(TYPE_, SCOPE_ID_, SCOPE_TYPE_);

UPDATE FLW_INSP_META_MODEL SET TYPE_ = 'breakpoint';

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 5, '8:d25802a16d0e67ba5f93ee606f98a45d', 'dropIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT; renameTable newTableName=FLW_INSP_META_MODEL, oldTableName=FLW_INSP_BREAKPOINT; addColumn tableName=FLW_INSP_META_MODEL; renameColumn newColumnName=META_MODEL_CONTENT_, oldCo...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

ALTER TABLE FLW_TEST_DEFINITION DROP CONSTRAINT FK_TEST_DEF_DEPLOYMENT;

ALTER TABLE FLW_TEST_INSTANCE DROP CONSTRAINT FK_TEST_INST_TEST_DEF;

DROP INDEX IDX_TEST_DEF_DEPLOYMENT;

DROP INDEX FLW_IDX_TEST_DEF_UNIQ;

DROP TABLE FLW_TEST_DEFINITION;

ALTER TABLE FLW_INSP_TEST_MODEL ADD DEPLOYMENT_ID_ VARCHAR2(255);

ALTER TABLE FLW_INSP_DEPLOYMENT_RESOURCE RENAME TO FLW_INSP_RESOURCE;

ALTER TABLE FLW_INSP_RESOURCE RENAME COLUMN DEPLOYMENT_ID_ TO TEST_MODEL_ID_;

DROP INDEX IDX_TEST_INST_TEST_DEF;

ALTER TABLE FLW_TEST_INSTANCE RENAME COLUMN TEST_DEFINITION_ID_ TO TEST_MODEL_ID_;

ALTER TABLE FLW_TEST_INSTANCE ADD SCOPE_DEFINITION_KEY_ VARCHAR2(255);

ALTER TABLE FLW_TEST_INSTANCE ADD INSTANCE_CONTENT_ CLOB;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT;

DROP INDEX IDX_TEST_DEF_USER_DEPLOYMENT;

DROP INDEX FLW_IDX_TEST_USER_DEF_UNIQ;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN RESOURCE_NAME_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN VERSION_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN REV_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN KEY_;

ALTER TABLE FLW_TEST_USER_DEFINITION ADD USER_DEF_CONTENT_ CLOB;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 6, '8:b00efa4a7546d38c3326f5e196409141', 'dropForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constraintName=FK_TEST_DEF_DEPLOYMENT; dropForeignKeyConstraint baseTableName=FLW_TEST_INSTANCE, constraintName=FK_TEST_INST_TEST_DEF; dropIndex indexName=IDX_TEST_DEF_DEPLOYMENT, tableNa...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

ALTER TABLE FLW_TEST_USER_DEFINITION ADD DISPLAY_NAME_ VARCHAR2(255);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 7, '8:1d436452c45d4a9d605f27b367209661', 'addColumn tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

ALTER TABLE FLW_TEST_USER_DEFINITION MODIFY DEPLOYMENT_ID_ NULL;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 8, '8:e9c789af997432e14d72ceeb19c138e7', 'dropNotNullConstraint columnName=DEPLOYMENT_ID_, tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

ALTER TABLE FLW_INSP_TEST_MODEL ADD END_TIME_ TIMESTAMP;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', SYSTIMESTAMP, 9, '8:ba23058357db05aedb922affae0694cd', 'addColumn tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250963540');

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

