
CREATE TABLE FLW_ISP_DATABASECHANGELOGLOCK (ID INT NOT NULL, `LOCKED` BIT(1) NOT NULL, LOCKGRANTED datetime NULL, LOCKEDBY VARCHAR(255) NULL, CONSTRAINT PK_FLW_ISP_DATABASECHANGELOGLOCK PRIMARY KEY (ID));

DELETE FROM FLW_ISP_DATABASECHANGELOGLOCK;

INSERT INTO FLW_ISP_DATABASECHANGELOGLOCK (ID, `LOCKED`) VALUES (1, 0);

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2020-07-20 14:56:35.987' WHERE ID = 1 AND `LOCKED` = 0;

CREATE TABLE FLW_ISP_DATABASECHANGELOG (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED datetime NOT NULL, ORDEREXECUTED INT NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35) NULL, `DESCRIPTION` VARCHAR(255) NULL, COMMENTS VARCHAR(255) NULL, TAG VARCHAR(255) NULL, LIQUIBASE VARCHAR(20) NULL, CONTEXTS VARCHAR(255) NULL, LABELS VARCHAR(255) NULL, DEPLOYMENT_ID VARCHAR(10) NULL);

CREATE TABLE FLW_INSP_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NULL, KEY_ VARCHAR(255) NULL, CATEGORY_ VARCHAR(255) NULL, DEPLOY_TIME_ datetime NULL, TENANT_ID_ VARCHAR(255) NULL, PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL, CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_));

CREATE TABLE FLW_INSP_DEPLOYMENT_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255) NULL, DEPLOYMENT_ID_ VARCHAR(255) NULL, RESOURCE_BYTES_ LONGBLOB NULL, CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, KEY_ VARCHAR(128) NULL, NAME_ VARCHAR(128) NULL, VERSION_ INT NULL, RESOURCE_NAME_ VARCHAR(4000) NULL, DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '' NULL, CONSTRAINT PK_TEST_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_INSTANCE (ID_ VARCHAR(255) NOT NULL, TEST_DEFINITION_ID_ VARCHAR(255) NOT NULL, START_DATE_ datetime(6) NULL, SCOPE_DEFINITION_ID_ VARCHAR(255) NULL, SCOPE_ID_ VARCHAR(255) NULL, SCOPE_TYPE_ VARCHAR(255) NULL, TENANT_ID_ VARCHAR(255) NULL, CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_DEFINITION ADD CONSTRAINT FK_TEST_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

ALTER TABLE FLW_TEST_INSTANCE ADD CONSTRAINT FK_TEST_INST_TEST_DEF FOREIGN KEY (TEST_DEFINITION_ID_) REFERENCES FLW_TEST_DEFINITION (ID_);

CREATE INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION(KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE(TEST_DEFINITION_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 1, '8:84b7b01796aeb34dde0236f98185376e', 'createTable tableName=FLW_INSP_DEPLOYMENT; createTable tableName=FLW_INSP_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEST_DEFINITION; createTable tableName=FLW_TEST_INSTANCE; addForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constrain...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

CREATE TABLE FLW_TEST_USER_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INT NOT NULL, KEY_ VARCHAR(128) NULL, NAME_ VARCHAR(128) NULL, VERSION_ INT NULL, RESOURCE_NAME_ VARCHAR(4000) NULL, DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '' NULL, CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_USER_DEFINITION ADD CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

CREATE INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 2, '8:472999077c245f4eae3736bdaf62bbd4', 'createTable tableName=FLW_TEST_USER_DEFINITION; addForeignKeyConstraint baseTableName=FLW_TEST_USER_DEFINITION, constraintName=FK_TEST_USER_DEF_DEPLOYMENT, referencedTableName=FLW_INSP_DEPLOYMENT; createIndex indexName=IDX_TEST_DEF_USER_DEPLOYMENT...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

CREATE TABLE FLW_INSP_TEST_MODEL (ID_ VARCHAR(255) NOT NULL, KEY_ VARCHAR(128) NULL, NAME_ VARCHAR(128) NULL, SCOPE_ID_ VARCHAR(255) NULL, SCOPE_TYPE_ VARCHAR(255) NULL, SCOPE_DEFINITION_ID_ VARCHAR(255) NULL, SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL, MODEL_CONTENT_ LONGTEXT NULL, CREATION_TIME_ datetime NULL, CREATOR_ID_ VARCHAR(255) NULL, TENANT_ID_ VARCHAR(64) DEFAULT '' NULL, CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_));

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL(CREATOR_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 3, '8:2310d4da8100cf273e2b7ed2af07e244', 'createTable tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_SCOPE, tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_CREATOR, tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

CREATE TABLE FLW_INSP_BREAKPOINT (ID_ VARCHAR(255) NOT NULL, SCOPE_ID_ VARCHAR(255) NULL, SCOPE_TYPE_ VARCHAR(255) NULL, SCOPE_DEFINITION_ID_ VARCHAR(255) NULL, SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL, BREAKPOINT_CONTENT_ LONGTEXT NULL, CREATION_TIME_ datetime NULL, CREATOR_ID_ VARCHAR(255) NULL, TENANT_ID_ VARCHAR(64) DEFAULT '' NULL, CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_));

CREATE INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 4, '8:7ce51a8366cd2815f5f0d58b30648443', 'createTable tableName=FLW_INSP_BREAKPOINT; createIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

DROP INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT;

ALTER TABLE FLW_INSP_BREAKPOINT RENAME FLW_INSP_META_MODEL;

ALTER TABLE FLW_INSP_META_MODEL ADD TYPE_ VARCHAR(255) NULL;

ALTER TABLE FLW_INSP_META_MODEL CHANGE BREAKPOINT_CONTENT_ META_MODEL_CONTENT_ LONGTEXT;

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL(TYPE_, SCOPE_ID_, SCOPE_TYPE_);

UPDATE FLW_INSP_META_MODEL SET TYPE_ = 'breakpoint';

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 5, '8:d25802a16d0e67ba5f93ee606f98a45d', 'dropIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT; renameTable newTableName=FLW_INSP_META_MODEL, oldTableName=FLW_INSP_BREAKPOINT; addColumn tableName=FLW_INSP_META_MODEL; renameColumn newColumnName=META_MODEL_CONTENT_, oldCo...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

ALTER TABLE FLW_TEST_DEFINITION DROP FOREIGN KEY FK_TEST_DEF_DEPLOYMENT;

ALTER TABLE FLW_TEST_INSTANCE DROP FOREIGN KEY FK_TEST_INST_TEST_DEF;

DROP INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION;

DROP INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION;

DROP TABLE FLW_TEST_DEFINITION;

ALTER TABLE FLW_INSP_TEST_MODEL ADD DEPLOYMENT_ID_ VARCHAR(255) NULL;

ALTER TABLE FLW_INSP_DEPLOYMENT_RESOURCE RENAME FLW_INSP_RESOURCE;

ALTER TABLE FLW_INSP_RESOURCE CHANGE DEPLOYMENT_ID_ TEST_MODEL_ID_ VARCHAR(255);

DROP INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE;

ALTER TABLE FLW_TEST_INSTANCE CHANGE TEST_DEFINITION_ID_ TEST_MODEL_ID_ VARCHAR(255);

ALTER TABLE FLW_TEST_INSTANCE ADD SCOPE_DEFINITION_KEY_ VARCHAR(255) NULL, ADD INSTANCE_CONTENT_ LONGTEXT NULL;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP FOREIGN KEY FK_TEST_USER_DEF_DEPLOYMENT;

DROP INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION;

DROP INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN RESOURCE_NAME_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN VERSION_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN REV_;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN KEY_;

ALTER TABLE FLW_TEST_USER_DEFINITION ADD USER_DEF_CONTENT_ LONGTEXT NULL;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 6, '8:b00efa4a7546d38c3326f5e196409141', 'dropForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constraintName=FK_TEST_DEF_DEPLOYMENT; dropForeignKeyConstraint baseTableName=FLW_TEST_INSTANCE, constraintName=FK_TEST_INST_TEST_DEF; dropIndex indexName=IDX_TEST_DEF_DEPLOYMENT, tableNa...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

ALTER TABLE FLW_TEST_USER_DEFINITION ADD DISPLAY_NAME_ VARCHAR(255) NULL;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 7, '8:1d436452c45d4a9d605f27b367209661', 'addColumn tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

ALTER TABLE FLW_TEST_USER_DEFINITION MODIFY DEPLOYMENT_ID_ VARCHAR(255) NULL;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 8, '8:e9c789af997432e14d72ceeb19c138e7', 'dropNotNullConstraint columnName=DEPLOYMENT_ID_, tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

ALTER TABLE FLW_INSP_TEST_MODEL ADD END_TIME_ datetime NULL;

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', NOW(), 9, '8:ba23058357db05aedb922affae0694cd', 'addColumn tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5249796001');

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

