

CREATE TABLE FLW_ISP_DATABASECHANGELOGLOCK (ID int NOT NULL, LOCKED bit NOT NULL, LOCKGRANTED datetime2(3), LOCKEDBY nvarchar(255), CONSTRAINT PK_FLW_ISP_DATABASECHANGELOGLOCK PRIMARY KEY (ID))

DELETE FROM FLW_ISP_DATABASECHANGELOGLOCK

INSERT INTO FLW_ISP_DATABASECHANGELOGLOCK (ID, LOCKED) VALUES (1, 0)

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2020-07-20T15:24:14.094' WHERE ID = 1 AND LOCKED = 0

CREATE TABLE FLW_ISP_DATABASECHANGELOG (ID nvarchar(255) NOT NULL, AUTHOR nvarchar(255) NOT NULL, FILENAME nvarchar(255) NOT NULL, DATEEXECUTED datetime2(3) NOT NULL, ORDEREXECUTED int NOT NULL, EXECTYPE nvarchar(10) NOT NULL, MD5SUM nvarchar(35), DESCRIPTION nvarchar(255), COMMENTS nvarchar(255), TAG nvarchar(255), LIQUIBASE nvarchar(20), CONTEXTS nvarchar(255), LABELS nvarchar(255), DEPLOYMENT_ID nvarchar(10))

CREATE TABLE FLW_INSP_DEPLOYMENT (ID_ nvarchar(255) NOT NULL, NAME_ nvarchar(255), KEY_ nvarchar(255), CATEGORY_ nvarchar(255), DEPLOY_TIME_ datetime, TENANT_ID_ nvarchar(255), PARENT_DEPLOYMENT_ID_ nvarchar(255), CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_))

CREATE TABLE FLW_INSP_DEPLOYMENT_RESOURCE (ID_ nvarchar(255) NOT NULL, NAME_ nvarchar(255), DEPLOYMENT_ID_ nvarchar(255), RESOURCE_BYTES_ varbinary(MAX), CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_))

CREATE TABLE FLW_TEST_DEFINITION (ID_ nvarchar(255) NOT NULL, REV_ int NOT NULL, KEY_ nvarchar(128), NAME_ nvarchar(128), VERSION_ int, RESOURCE_NAME_ nvarchar(4000), DEPLOYMENT_ID_ nvarchar(255) NOT NULL, TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_TEST_DEFINITION_TENANT_ID_ DEFAULT '', CONSTRAINT PK_TEST_DEFINITIONS PRIMARY KEY (ID_))

CREATE TABLE FLW_TEST_INSTANCE (ID_ nvarchar(255) NOT NULL, TEST_DEFINITION_ID_ nvarchar(255) NOT NULL, START_DATE_ datetime2(6), SCOPE_DEFINITION_ID_ nvarchar(255), SCOPE_ID_ nvarchar(255), SCOPE_TYPE_ nvarchar(255), TENANT_ID_ nvarchar(255), CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_))

ALTER TABLE FLW_TEST_DEFINITION ADD CONSTRAINT FK_TEST_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_)

ALTER TABLE FLW_TEST_INSTANCE ADD CONSTRAINT FK_TEST_INST_TEST_DEF FOREIGN KEY (TEST_DEFINITION_ID_) REFERENCES FLW_TEST_DEFINITION (ID_)

CREATE NONCLUSTERED INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION(DEPLOYMENT_ID_)

CREATE UNIQUE NONCLUSTERED INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION(KEY_, VERSION_, TENANT_ID_)

CREATE NONCLUSTERED INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE(TEST_DEFINITION_ID_)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 1, '8:9f3325aee319673e4eb44010868c6849', 'createTable tableName=FLW_INSP_DEPLOYMENT; createTable tableName=FLW_INSP_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEST_DEFINITION; createTable tableName=FLW_TEST_INSTANCE; addForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constrain...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

CREATE TABLE FLW_TEST_USER_DEFINITION (ID_ nvarchar(255) NOT NULL, REV_ int NOT NULL, KEY_ nvarchar(128), NAME_ nvarchar(128), VERSION_ int, RESOURCE_NAME_ nvarchar(4000), DEPLOYMENT_ID_ nvarchar(255) NOT NULL, TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_TEST_USER_DEFINITION_TENANT_ID_ DEFAULT '', CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_))

ALTER TABLE FLW_TEST_USER_DEFINITION ADD CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_)

CREATE NONCLUSTERED INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION(DEPLOYMENT_ID_)

CREATE UNIQUE NONCLUSTERED INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION(KEY_, VERSION_, TENANT_ID_)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 2, '8:725a05ae26daa3353ee44cc8360958fb', 'createTable tableName=FLW_TEST_USER_DEFINITION; addForeignKeyConstraint baseTableName=FLW_TEST_USER_DEFINITION, constraintName=FK_TEST_USER_DEF_DEPLOYMENT, referencedTableName=FLW_INSP_DEPLOYMENT; createIndex indexName=IDX_TEST_DEF_USER_DEPLOYMENT...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

CREATE TABLE FLW_INSP_TEST_MODEL (ID_ nvarchar(255) NOT NULL, KEY_ nvarchar(128), NAME_ nvarchar(128), SCOPE_ID_ nvarchar(255), SCOPE_TYPE_ nvarchar(255), SCOPE_DEFINITION_ID_ nvarchar(255), SCOPE_DEFINITION_KEY_ nvarchar(255), MODEL_CONTENT_ nvarchar(MAX), CREATION_TIME_ datetime, CREATOR_ID_ nvarchar(255), TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_INSP_TEST_MODEL_TENANT_ID_ DEFAULT '', CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_))

CREATE NONCLUSTERED INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL(SCOPE_ID_, SCOPE_TYPE_)

CREATE NONCLUSTERED INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL(CREATOR_ID_)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 3, '8:59c6374eb6289dfa69f25416da9ab78c', 'createTable tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_SCOPE, tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_CREATOR, tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

CREATE TABLE FLW_INSP_BREAKPOINT (ID_ nvarchar(255) NOT NULL, SCOPE_ID_ nvarchar(255), SCOPE_TYPE_ nvarchar(255), SCOPE_DEFINITION_ID_ nvarchar(255), SCOPE_DEFINITION_KEY_ nvarchar(255), BREAKPOINT_CONTENT_ nvarchar(MAX), CREATION_TIME_ datetime, CREATOR_ID_ nvarchar(255), TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_INSP_BREAKPOINT_TENANT_ID_ DEFAULT '', CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_))

CREATE NONCLUSTERED INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT(SCOPE_ID_, SCOPE_TYPE_)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 4, '8:3848ba1428b21695a8173041a0a07317', 'createTable tableName=FLW_INSP_BREAKPOINT; createIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

DROP INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT

exec sp_rename 'FLW_INSP_BREAKPOINT', 'FLW_INSP_META_MODEL'

ALTER TABLE FLW_INSP_META_MODEL ADD TYPE_ varchar(255)

exec sp_rename 'FLW_INSP_META_MODEL.BREAKPOINT_CONTENT_', 'META_MODEL_CONTENT_'

CREATE NONCLUSTERED INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL(TYPE_, SCOPE_ID_, SCOPE_TYPE_)

UPDATE FLW_INSP_META_MODEL SET TYPE_ = 'breakpoint'

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 5, '8:e2330e3c7960a4ea9a5ab4e393495c10', 'dropIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT; renameTable newTableName=FLW_INSP_META_MODEL, oldTableName=FLW_INSP_BREAKPOINT; addColumn tableName=FLW_INSP_META_MODEL; renameColumn newColumnName=META_MODEL_CONTENT_, oldCo...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

ALTER TABLE FLW_TEST_DEFINITION DROP CONSTRAINT FK_TEST_DEF_DEPLOYMENT

ALTER TABLE FLW_TEST_INSTANCE DROP CONSTRAINT FK_TEST_INST_TEST_DEF

DROP INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION

DROP INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION

DROP TABLE FLW_TEST_DEFINITION

ALTER TABLE FLW_INSP_TEST_MODEL ADD DEPLOYMENT_ID_ varchar(255)

exec sp_rename 'FLW_INSP_DEPLOYMENT_RESOURCE', 'FLW_INSP_RESOURCE'

exec sp_rename 'FLW_INSP_RESOURCE.DEPLOYMENT_ID_', 'TEST_MODEL_ID_'

DROP INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE

exec sp_rename 'FLW_TEST_INSTANCE.TEST_DEFINITION_ID_', 'TEST_MODEL_ID_'

ALTER TABLE FLW_TEST_INSTANCE ADD SCOPE_DEFINITION_KEY_ nvarchar(255)

ALTER TABLE FLW_TEST_INSTANCE ADD INSTANCE_CONTENT_ nvarchar(MAX)

ALTER TABLE FLW_TEST_USER_DEFINITION DROP CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT

DROP INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION

DROP INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN RESOURCE_NAME_

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN VERSION_

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN REV_

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN KEY_

ALTER TABLE FLW_TEST_USER_DEFINITION ADD USER_DEF_CONTENT_ nvarchar(MAX)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 6, '8:07d0343c1ab24b8d11a4185f12c172b3', 'dropForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constraintName=FK_TEST_DEF_DEPLOYMENT; dropForeignKeyConstraint baseTableName=FLW_TEST_INSTANCE, constraintName=FK_TEST_INST_TEST_DEF; dropIndex indexName=IDX_TEST_DEF_DEPLOYMENT, tableNa...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

ALTER TABLE FLW_TEST_USER_DEFINITION ADD DISPLAY_NAME_ varchar(255)

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 7, '8:1d436452c45d4a9d605f27b367209661', 'addColumn tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

ALTER TABLE FLW_TEST_USER_DEFINITION ALTER COLUMN DEPLOYMENT_ID_ nvarchar(255) NULL

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 8, '8:8d7aa9eff35c1b3eb256b284edddd221', 'dropNotNullConstraint columnName=DEPLOYMENT_ID_, tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

ALTER TABLE FLW_INSP_TEST_MODEL ADD END_TIME_ datetime

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', GETDATE(), 9, '8:ba23058357db05aedb922affae0694cd', 'addColumn tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5251454242')

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1

