
CREATE TABLE FLW_ISP_DATABASECHANGELOGLOCK (ID INTEGER NOT NULL, LOCKED SMALLINT NOT NULL, LOCKGRANTED TIMESTAMP, LOCKEDBY VARCHAR(255), CONSTRAINT PK_DBCHGLOGLOCK PRIMARY KEY (ID));

DELETE FROM FLW_ISP_DATABASECHANGELOGLOCK;

INSERT INTO FLW_ISP_DATABASECHANGELOGLOCK (ID, LOCKED) VALUES (1, 0);

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = TIMESTAMP('2020-07-20 15:06:46.982') WHERE ID = 1 AND LOCKED = 0;

CREATE TABLE FLW_ISP_DATABASECHANGELOG (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP NOT NULL, ORDEREXECUTED INTEGER NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10));

CREATE TABLE FLW_INSP_DEPLOYMENT (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), KEY_ VARCHAR(255), CATEGORY_ VARCHAR(255), DEPLOY_TIME_ TIMESTAMP, TENANT_ID_ VARCHAR(255), PARENT_DEPLOYMENT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_INSP_DEPLO PRIMARY KEY (ID_));

CREATE TABLE FLW_INSP_DEPLOYMENT_RESOURCE (ID_ VARCHAR(255) NOT NULL, NAME_ VARCHAR(255), DEPLOYMENT_ID_ VARCHAR(255), RESOURCE_BYTES_ BLOB, CONSTRAINT PK_FLW_INSP_DEPLO PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INTEGER NOT NULL, KEY_ VARCHAR(128), NAME_ VARCHAR(128), VERSION_ INTEGER, RESOURCE_NAME_ VARCHAR(4000), DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '', CONSTRAINT PK_TEST_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_TEST_INSTANCE (ID_ VARCHAR(255) NOT NULL, TEST_DEFINITION_ID_ VARCHAR(255) NOT NULL, START_DATE_ TIMESTAMP(6), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), TENANT_ID_ VARCHAR(255), CONSTRAINT PK_FLW_TEST_INSTA PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_DEFINITION ADD CONSTRAINT FK_TEST_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

ALTER TABLE FLW_TEST_INSTANCE ADD CONSTRAINT FK_TEST_INST_TEST_DEF FOREIGN KEY (TEST_DEFINITION_ID_) REFERENCES FLW_TEST_DEFINITION (ID_);

CREATE INDEX IDX_TEST_DEF_DEPLOYMENT ON FLW_TEST_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_DEF_UNIQ ON FLW_TEST_DEFINITION(KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_TEST_INST_TEST_DEF ON FLW_TEST_INSTANCE(TEST_DEFINITION_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 1, '8:84b7b01796aeb34dde0236f98185376e', 'createTable tableName=FLW_INSP_DEPLOYMENT; createTable tableName=FLW_INSP_DEPLOYMENT_RESOURCE; createTable tableName=FLW_TEST_DEFINITION; createTable tableName=FLW_TEST_INSTANCE; addForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constrain...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

CREATE TABLE FLW_TEST_USER_DEFINITION (ID_ VARCHAR(255) NOT NULL, REV_ INTEGER NOT NULL, KEY_ VARCHAR(128), NAME_ VARCHAR(128), VERSION_ INTEGER, RESOURCE_NAME_ VARCHAR(4000), DEPLOYMENT_ID_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(64) DEFAULT '', CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_));

ALTER TABLE FLW_TEST_USER_DEFINITION ADD CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_INSP_DEPLOYMENT (ID_);

CREATE INDEX IDX_TEST_DEF_USER_DEPLOYMENT ON FLW_TEST_USER_DEFINITION(DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_TEST_USER_DEF_UNIQ ON FLW_TEST_USER_DEFINITION(KEY_, VERSION_, TENANT_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('2', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 2, '8:472999077c245f4eae3736bdaf62bbd4', 'createTable tableName=FLW_TEST_USER_DEFINITION; addForeignKeyConstraint baseTableName=FLW_TEST_USER_DEFINITION, constraintName=FK_TEST_USER_DEF_DEPLOYMENT, referencedTableName=FLW_INSP_DEPLOYMENT; createIndex indexName=IDX_TEST_DEF_USER_DEPLOYMENT...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

CREATE TABLE FLW_INSP_TEST_MODEL (ID_ VARCHAR(255) NOT NULL, KEY_ VARCHAR(128), NAME_ VARCHAR(128), SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_DEFINITION_KEY_ VARCHAR(255), MODEL_CONTENT_ CLOB, CREATION_TIME_ TIMESTAMP, CREATOR_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(64) DEFAULT '', CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_));

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL(SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL(CREATOR_ID_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('3', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 3, '8:2310d4da8100cf273e2b7ed2af07e244', 'createTable tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_SCOPE, tableName=FLW_INSP_TEST_MODEL; createIndex indexName=IDX_TEST_MODEL_CREATOR, tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

CREATE TABLE FLW_INSP_BREAKPOINT (ID_ VARCHAR(255) NOT NULL, SCOPE_ID_ VARCHAR(255), SCOPE_TYPE_ VARCHAR(255), SCOPE_DEFINITION_ID_ VARCHAR(255), SCOPE_DEFINITION_KEY_ VARCHAR(255), BREAKPOINT_CONTENT_ CLOB, CREATION_TIME_ TIMESTAMP, CREATOR_ID_ VARCHAR(255), TENANT_ID_ VARCHAR(64) DEFAULT '', CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_));

CREATE INDEX IDX_BREAKPOINT_SCOPE ON FLW_INSP_BREAKPOINT(SCOPE_ID_, SCOPE_TYPE_);

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('4', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 4, '8:7ce51a8366cd2815f5f0d58b30648443', 'createTable tableName=FLW_INSP_BREAKPOINT; createIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

DROP INDEX IDX_BREAKPOINT_SCOPE;

RENAME FLW_INSP_BREAKPOINT TO FLW_INSP_META_MODEL;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_INSP_META_MODEL');

ALTER TABLE FLW_INSP_META_MODEL ADD TYPE_ VARCHAR(255);

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_INSP_META_MODEL');

ALTER TABLE FLW_INSP_META_MODEL RENAME COLUMN BREAKPOINT_CONTENT_ TO META_MODEL_CONTENT_;

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL(TYPE_, SCOPE_ID_, SCOPE_TYPE_);

UPDATE FLW_INSP_META_MODEL SET TYPE_ = 'breakpoint';

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('5', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 5, '8:d25802a16d0e67ba5f93ee606f98a45d', 'dropIndex indexName=IDX_BREAKPOINT_SCOPE, tableName=FLW_INSP_BREAKPOINT; renameTable newTableName=FLW_INSP_META_MODEL, oldTableName=FLW_INSP_BREAKPOINT; addColumn tableName=FLW_INSP_META_MODEL; renameColumn newColumnName=META_MODEL_CONTENT_, oldCo...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

ALTER TABLE FLW_TEST_DEFINITION DROP CONSTRAINT FK_TEST_DEF_DEPLOYMENT;

ALTER TABLE FLW_TEST_INSTANCE DROP CONSTRAINT FK_TEST_INST_TEST_DEF;

DROP INDEX IDX_TEST_DEF_DEPLOYMENT;

DROP INDEX FLW_IDX_TEST_DEF_UNIQ;

DROP TABLE FLW_TEST_DEFINITION;

ALTER TABLE FLW_INSP_TEST_MODEL ADD DEPLOYMENT_ID_ VARCHAR(255);

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_INSP_TEST_MODEL');

RENAME FLW_INSP_DEPLOYMENT_RESOURCE TO FLW_INSP_RESOURCE;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_INSP_RESOURCE');

ALTER TABLE FLW_INSP_RESOURCE RENAME COLUMN DEPLOYMENT_ID_ TO TEST_MODEL_ID_;

DROP INDEX IDX_TEST_INST_TEST_DEF;

ALTER TABLE FLW_TEST_INSTANCE RENAME COLUMN TEST_DEFINITION_ID_ TO TEST_MODEL_ID_;

ALTER TABLE FLW_TEST_INSTANCE ADD SCOPE_DEFINITION_KEY_ VARCHAR(255);

ALTER TABLE FLW_TEST_INSTANCE ADD INSTANCE_CONTENT_ CLOB;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_INSTANCE');

ALTER TABLE FLW_TEST_USER_DEFINITION DROP CONSTRAINT FK_TEST_USER_DEF_DEPLOYMENT;

DROP INDEX IDX_TEST_DEF_USER_DEPLOYMENT;

DROP INDEX FLW_IDX_TEST_USER_DEF_UNIQ;

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN RESOURCE_NAME_;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN VERSION_;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN REV_;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

ALTER TABLE FLW_TEST_USER_DEFINITION DROP COLUMN KEY_;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

ALTER TABLE FLW_TEST_USER_DEFINITION ADD USER_DEF_CONTENT_ CLOB;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('6', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 6, '8:b00efa4a7546d38c3326f5e196409141', 'dropForeignKeyConstraint baseTableName=FLW_TEST_DEFINITION, constraintName=FK_TEST_DEF_DEPLOYMENT; dropForeignKeyConstraint baseTableName=FLW_TEST_INSTANCE, constraintName=FK_TEST_INST_TEST_DEF; dropIndex indexName=IDX_TEST_DEF_DEPLOYMENT, tableNa...', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

ALTER TABLE FLW_TEST_USER_DEFINITION ADD DISPLAY_NAME_ VARCHAR(255);

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 7, '8:1d436452c45d4a9d605f27b367209661', 'addColumn tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

ALTER TABLE FLW_TEST_USER_DEFINITION ALTER COLUMN  DEPLOYMENT_ID_ DROP NOT NULL;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_TEST_USER_DEFINITION');

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 8, '8:e9c789af997432e14d72ceeb19c138e7', 'dropNotNullConstraint columnName=DEPLOYMENT_ID_, tableName=FLW_TEST_USER_DEFINITION', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

ALTER TABLE FLW_INSP_TEST_MODEL ADD END_TIME_ TIMESTAMP;

CALL SYSPROC.ADMIN_CMD ('REORG TABLE FLW_INSP_TEST_MODEL');

INSERT INTO FLW_ISP_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'com/flowable/inspect/db/liquibase/flowable-inspect-db-changelog.xml', CURRENT TIMESTAMP, 9, '8:ba23058357db05aedb922affae0694cd', 'addColumn tableName=FLW_INSP_TEST_MODEL', '', 'EXECUTED', NULL, NULL, '3.8.0', '5250407157');

UPDATE FLW_ISP_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

