
CREATE TABLE FLW_INSP_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    TEST_MODEL_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURC PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_INSTANCE (
    ID_ VARCHAR2(255) NOT NULL,
    TEST_MODEL_ID_ VARCHAR2(255) NOT NULL,
    START_DATE_ TIMESTAMP(6),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    INSTANCE_CONTENT_ CLOB,
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_USER_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(128),
    DISPLAY_NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255) NULL,
    USER_DEF_CONTENT_ CLOB,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_TEST_MODEL (
    ID_ VARCHAR2(255) NOT NULL,
    KEY_ VARCHAR2(128),
    NAME_ VARCHAR2(128),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    MODEL_CONTENT_ CLOB,
    CREATION_TIME_ TIMESTAMP,
    CREATOR_ID_ VARCHAR2(255),
    END_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_)
);

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL (CREATOR_ID_);

CREATE TABLE FLW_INSP_META_MODEL (
    ID_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    SCOPE_DEFINITION_ID_ VARCHAR2(255),
    SCOPE_DEFINITION_KEY_ VARCHAR2(255),
    META_MODEL_CONTENT_ CLOB,
    CREATION_TIME_ TIMESTAMP,
    CREATOR_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(64) DEFAULT '',
    CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL (TYPE_, SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('inspect.schema.version', '11', 1);

