
CREATE TABLE FLW_INSP_DEPLOYMENT (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    KEY_ nvarchar(255),
    CATEGORY_ nvarchar(255),
    DEPLOY_TIME_ datetime,
    TENANT_ID_ nvarchar(255),
    PARENT_DEPLOYMENT_ID_ nvarchar(255),
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_RESOURCE (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    TEST_MODEL_ID_ nvarchar(255),
    RESOURCE_BYTES_ varbinary(MAX),
    CONSTRAINT PK_FLW_INSP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_INSTANCE (
    ID_ nvarchar(255) NOT NULL,
    TEST_MODEL_ID_ nvarchar(255) NOT NULL,
    START_DATE_ datetime2(6),
    SCOPE_DEFINITION_ID_ nvarchar(255),
    SCOPE_DEFINITION_KEY_ nvarchar(255),
    SCOPE_ID_ nvarchar(255),
    SCOPE_TYPE_ nvarchar(255),
    INSTANCE_CONTENT_ nvarchar(MAX),
    TENANT_ID_ nvarchar(255),
    CONSTRAINT PK_FLW_TEST_INSTANCE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_USER_DEFINITION (
    ID_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(128),
    DISPLAY_NAME_ nvarchar(255),
    DEPLOYMENT_ID_ nvarchar(255),
    USER_DEF_CONTENT_ nvarchar(MAX),
    TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_TEST_USER_DEFINITION_TENANT_ID_ DEFAULT '',
    CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_TEST_MODEL (
    ID_ nvarchar(255) NOT NULL,
    KEY_ nvarchar(128),
    NAME_ nvarchar(128),
    SCOPE_ID_ nvarchar(255),
    SCOPE_TYPE_ nvarchar(255),
    SCOPE_DEFINITION_ID_ nvarchar(255),
    SCOPE_DEFINITION_KEY_ nvarchar(255),
    DEPLOYMENT_ID_ varchar(255),
    MODEL_CONTENT_ nvarchar(MAX),
    CREATION_TIME_ datetime,
    CREATOR_ID_ nvarchar(255),
    END_TIME_ datetime,
    TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_INSP_TEST_MODEL_TENANT_ID_ DEFAULT '',
    CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_)
);

CREATE NONCLUSTERED INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL(SCOPE_ID_, SCOPE_TYPE_);

CREATE NONCLUSTERED INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL(CREATOR_ID_);

CREATE TABLE FLW_INSP_META_MODEL (
    ID_ nvarchar(255) NOT NULL,
    TYPE_ varchar(255),
    SCOPE_ID_ nvarchar(255),
    SCOPE_TYPE_ nvarchar(255),
    SCOPE_DEFINITION_ID_ nvarchar(255),
    SCOPE_DEFINITION_KEY_ nvarchar(255),
    META_MODEL_CONTENT_ nvarchar(MAX),
    CREATION_TIME_ datetime,
    CREATOR_ID_ nvarchar(255),
    TENANT_ID_ nvarchar(64) CONSTRAINT DF_FLW_INSP_BREAKPOINT_TENANT_ID_ DEFAULT '',
    CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_)
);

CREATE NONCLUSTERED INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL(TYPE_, SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('inspect.schema.version', '11', 1);

