
CREATE TABLE FLW_INSP_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT PK_FLW_INSP_DEPLO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    TEST_MODEL_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_INSP_DEPLO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    TEST_MODEL_ID_ VARCHAR(255) NOT NULL,
    START_DATE_ TIMESTAMP(6),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_DEFINITION_KEY_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    INSTANCE_CONTENT_ CLOB,
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT PK_FLW_TEST_INSTA PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEST_USER_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    DISPLAY_NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    USER_DEF_CONTENT_ CLOB,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_TEST_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_INSP_TEST_MODEL (
    ID_ VARCHAR(255) NOT NULL,
    KEY_ VARCHAR(128),
    NAME_ VARCHAR(128),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_DEFINITION_KEY_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    MODEL_CONTENT_ CLOB,
    CREATION_TIME_ TIMESTAMP,
    CREATOR_ID_ VARCHAR(255),
    END_TIME_ TIMESTAMP,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_INSP_TEST_MODEL PRIMARY KEY (ID_)
);

CREATE INDEX IDX_TEST_MODEL_SCOPE ON FLW_INSP_TEST_MODEL (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_TEST_MODEL_CREATOR ON FLW_INSP_TEST_MODEL (CREATOR_ID_);

CREATE TABLE FLW_INSP_META_MODEL (
    ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_DEFINITION_KEY_ VARCHAR(255),
    META_MODEL_CONTENT_ CLOB,
    CREATION_TIME_ TIMESTAMP,
    CREATOR_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_INSP_BREAKPOINT PRIMARY KEY (ID_)
);

CREATE INDEX IDX_META_MODEL_SCOPE ON FLW_INSP_META_MODEL (TYPE_, SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('inspect.schema.version', '11', 1);

