
CREATE TABLE FLW_ID_PROPERTY (
    NAME_ VARCHAR(64) NOT NULL,
    VALUE_ VARCHAR(300),
    REV_ INTEGER NOT NULL,
    CONSTRAINT "FLW_ID_PROPERTY_pkey" PRIMARY KEY (NAME_)
);

CREATE TABLE FLW_ID_GROUP (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(64) DEFAULT '',
    NAME_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    CONSTRAINT "FLW_ID_GROUP_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    FIRST_ VARCHAR(255),
    LAST_ VARCHAR(255),
    DISPLAY_NAME_ VARCHAR(255),
    EMAIL_ VARCHAR(255),
    PWD_ VARCHAR(255),
    CREATOR_ID_ VARCHAR(64),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATER_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    AVATAR_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    CONSTRAINT "FLW_ID_USER_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_MEMBERSHIP (
    USER_ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(64) NOT NULL,
    CONSTRAINT "FLW_ID_MEMBERSHIP_pkey" PRIMARY KEY (USER_ID_, GROUP_ID_)
);

CREATE TABLE FLW_ID_USER_DEFINITIONS (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR(128),
    KEY_ VARCHAR(128),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATER_ID_ VARCHAR(64),
    DEFINITION_CONTENT_ TEXT,
    CONSTRAINT PK_ID_USER_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_INFO (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    USER_ID_ VARCHAR(64),
    TYPE_ VARCHAR(64),
    KEY_ VARCHAR(255),
    VALUE_ VARCHAR(255),
    PASSWORD_ BYTEA,
    PARENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_ID_INFO_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_IDENTITY_INFO (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    USER_ID_ VARCHAR(64),
    GROUP_ID_REF_ VARCHAR(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    CONSTRAINT PK_FLW_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    TOKEN_VALUE_ VARCHAR(255),
    TOKEN_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE,
    IP_ADDRESS_ VARCHAR(255),
    USER_AGENT_ VARCHAR(255),
    USER_ID_ VARCHAR(255),
    TOKEN_DATA_ VARCHAR(2000),
    CONSTRAINT "FLW_ID_TOKEN_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV (
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    CONSTRAINT "FLW_ID_PRIV_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_PRIV_MAPPING (
    ID_ VARCHAR(64) NOT NULL,
    PRIV_ID_ VARCHAR(64) NOT NULL,
    USER_ID_ VARCHAR(255),
    GROUP_ID_ VARCHAR(255),
    CONSTRAINT "FLW_ID_PRIV_MAPPING_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_MEMB_GROUP ON FLW_ID_MEMBERSHIP (GROUP_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_GROUP FOREIGN KEY (GROUP_ID_) REFERENCES FLW_ID_GROUP (ID_);

CREATE INDEX FLW_IDX_MEMB_USER ON FLW_ID_MEMBERSHIP (USER_ID_);

ALTER TABLE FLW_ID_MEMBERSHIP
    ADD CONSTRAINT FLW_FK_MEMB_USER FOREIGN KEY (USER_ID_) REFERENCES FLW_ID_USER (ID_);

CREATE INDEX FLW_IDX_PRIV_MAPPING ON FLW_ID_PRIV_MAPPING (PRIV_ID_);

ALTER TABLE FLW_ID_PRIV_MAPPING
    ADD CONSTRAINT FLW_FK_PRIV_MAPPING FOREIGN KEY (PRIV_ID_) REFERENCES FLW_ID_PRIV (ID_);

CREATE INDEX FLW_IDX_PRIV_USER ON FLW_ID_PRIV_MAPPING (USER_ID_);

CREATE INDEX FLW_IDX_PRIV_GROUP ON FLW_ID_PRIV_MAPPING (GROUP_ID_);

ALTER TABLE FLW_ID_PRIV
    ADD CONSTRAINT FLW_UNIQ_PRIV_NAME UNIQUE (NAME_);

CREATE INDEX FLW_IDX_USER_CREATE_TIME ON FLW_ID_USER (CREATION_TIME_);

CREATE INDEX FLW_IDX_USER_UPDATE_TIME ON FLW_ID_USER (UPDATE_TIME_);

CREATE INDEX FLW_IDX_IDM_INFO_USER_ID ON FLW_IDENTITY_INFO (USER_ID_);

CREATE TABLE FLW_ID_USER_ACCOUNT_DEFINITION (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR(128),
    KEY_ VARCHAR(128),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATER_ID_ VARCHAR(64),
    DEFINITION_CONTENT_ TEXT,
    CONSTRAINT PK_ID_USER_ACCOUNT_DEFINITION PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_USER_ACCOUNT (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    USER_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    NAME_ VARCHAR(255),
    TYPE_ VARCHAR(64),
    SUB_TYPE_ VARCHAR(64),
    STATE_ VARCHAR(64),
    SUB_STATE_ VARCHAR(64),
    BUSINESS_ACCOUNT_ID_ VARCHAR(255),
    EXTERNAL_USER_ID_ VARCHAR(255),
    USER_ACCOUNT_DEFINITION_ID_ VARCHAR(64),
    CREATOR_ID_ VARCHAR(64),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATER_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONSTRAINT "FLW_ID_USER_ACCOUNT_pkey" PRIMARY KEY (ID_),
    CONSTRAINT FK_ID_USER_ACCOUNT_USER_DEF FOREIGN KEY (USER_ACCOUNT_DEFINITION_ID_) REFERENCES FLW_ID_USER_ACCOUNT_DEFINITION (ID_)
);

CREATE INDEX IDX_USER_ACC_TYPE_SUB_EXT_USER ON FLW_ID_USER_ACCOUNT (TYPE_, SUB_TYPE_, EXTERNAL_USER_ID_);

CREATE INDEX IDX_USER_ACCOUNT_USER ON FLW_ID_USER_ACCOUNT (USER_ID_);

CREATE INDEX IDX_USER_ACCOUNT_USER_DEF ON FLW_ID_USER_ACCOUNT (USER_ACCOUNT_DEFINITION_ID_);

CREATE TABLE FLW_ID_DESIGN_AUTHENTICATION (
    ID_ VARCHAR(255) NOT NULL,
    USER_ID_ VARCHAR(100) NOT NULL,
    TENANT_ID_ VARCHAR(255),
    CREATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    TOKEN_ VARCHAR(2000),
    CONSTRAINT "FLW_ID_DESIGN_AUTHENTICATION_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ID_ACCESS_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(2000),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    EXPIRATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    USER_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255),
    TOKEN_VALUE_ VARCHAR(2000),
    CONSTRAINT "FLW_ID_ACCESS_TOKEN_pkey" PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('idm.schema.version', '21', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR(255) NOT NULL, RESOURCE_BYTES_ BYTEA, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CONSTRAINT "FLW_LIC_LICENSE_pkey" PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR(255) NOT NULL, TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR(255), TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, COUNT_ BIGINT NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR(255) NOT NULL, SIGNATURE_ TEXT NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_TRANSLATION (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATER_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    LOCALE_ VARCHAR(16) NOT NULL,
    VALUE_ TEXT,
    CONSTRAINT PK_FLW_TRANSLATION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TRANSLATION
    ADD CONSTRAINT FLW_UQ_TRANSL_SCOPE_KEY_LOCALE UNIQUE (SCOPE_ID_, SCOPE_TYPE_, KEY_, LOCALE_);

CREATE INDEX FLW_IDX_TRANSLATION_SCOPE ON FLW_TRANSLATION (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_COMMENT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    CONTENT_ TEXT,
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(64),
    USER_ID_ VARCHAR(255),
    CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_COMMENT_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX IDX_COMMENT_SCOPE_ID ON FLW_COMMENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_COMMENT_USER_ID ON FLW_COMMENT (USER_ID_);

CREATE TABLE FLW_CONFIGURATION_PROPERTY (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAMESPACE_ VARCHAR(255),
    NAME_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(500),
    TEXT_VALUE_ TEXT,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    LAST_UPDATER_ID_ VARCHAR(64),
    LAST_UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CONSTRAINT PK_FLW_CONFIGURATION_PROPERTY PRIMARY KEY (ID_)
);

CREATE INDEX FLW_CON_PROP_NS_NAME_TENANT ON FLW_CONFIGURATION_PROPERTY (NAMESPACE_, NAME_, TENANT_ID_);

CREATE TABLE FLW_PL_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_PL_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_PL_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_PL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PL_RSRC_DPL ON FLW_PL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_QUERY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    TYPE_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_QUERY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_QUERY_DEF_UNIQ ON FLW_QUERY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_QUERY_DEF_DEPLOYMENT ON FLW_QUERY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_QUERY_DEFINITION
    ADD CONSTRAINT FK_QUERY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_VAR_EXT_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    TYPE_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_VAR_EXT_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_VAR_EXT_DEF_UNIQ ON FLW_VAR_EXT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_VAR_EXT_DEF_DEPLOYMENT ON FLW_VAR_EXT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_VAR_EXT_DEFINITION
    ADD CONSTRAINT FK_VAR_EXT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SEQUENCE_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_SEQUENCE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SEQUENCE_DEF_UNIQ ON FLW_SEQUENCE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SEQUENCE_DEF_DEPLOYMENT ON FLW_SEQUENCE_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SEQUENCE_DEFINITION
    ADD CONSTRAINT FK_SEQUENCE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_DATA_DICTIONARY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_DATA_DICTIONARY_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_DATA_DICT_DEF_UNIQ ON FLW_DATA_DICTIONARY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DATA_DICT_DEF_DEPLOYMENT ON FLW_DATA_DICTIONARY_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DATA_DICTIONARY_DEFINITION
    ADD CONSTRAINT FK_DATA_DICT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_SLA_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_SLA_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_SLA_DEF_UNIQ ON FLW_SLA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_SLA_DEF_DEPLOYMENT ON FLW_SLA_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_SLA_DEFINITION
    ADD CONSTRAINT FK_SLA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_TEN_VARIABLE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR(255),
    NAME_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255),
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    VARIABLE_PROTECTED_ BOOLEAN,
    CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CREATED_BY_ VARCHAR(255),
    LAST_MODIFIED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    LAST_MODIFIED_BY_ VARCHAR(255),
    CONSTRAINT "FLW_TEN_VARIABLE_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_TEN_VAR_NAME_TENANT ON FLW_TEN_VARIABLE (NAME_, TENANT_ID_);

CREATE TABLE FLW_SLA_AUDIT (
    ID_ VARCHAR(255) NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SUB_SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    ROOT_SCOPE_ID_ VARCHAR(255) NOT NULL,
    ROOT_SCOPE_TYPE_ VARCHAR(64) NOT NULL,
    SCOPE_DEFINITION_KEY_ VARCHAR(255),
    SUB_SCOPE_DEFINITION_KEY_ VARCHAR(255),
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR(255),
    APP_KEY_ VARCHAR(255),
    SLA_DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255),
    CREATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    IN_PROGRESS_START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    IN_PROGRESS_STARTED_BY_ VARCHAR(255),
    CLAIM_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CLAIMED_BY_ VARCHAR(255),
    COMPLETION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    COMPLETED_BY_ VARCHAR(255),
    IN_PROGRESS_START_DUE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    COMPLETION_DUE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    IN_PROGRESS_START_DUE_DUR_ INTEGER,
    COMPLETION_DUE_DURATION_ INTEGER,
    IN_PROGRESS_START_DURATION_ INTEGER,
    COMPLETION_DURATION_ INTEGER,
    IN_PROGRESS_START_RELATIVE_ INTEGER,
    COMPLETION_RELATIVE_ INTEGER,
    IN_PROGRESS_START_SLA_BREACH_ INTEGER,
    COMPLETION_SLA_BREACHED_ INTEGER,
    PAYLOAD_ TEXT,
    CONSTRAINT "FLW_SLA_AUDIT_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_SLA_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_SLA_SUB_SCOPE_ID_TYPE ON FLW_SLA_AUDIT (SUB_SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_DASHBOARD (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR(255),
    CREATOR_ID_ VARCHAR(255),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATER_ID_ VARCHAR(255),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONFIGURATION_ TEXT,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_DASHBOARD PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DASHBOARD_COMP_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_DASHB_COMP_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_DASHB_COMP_DEF_UNIQ ON FLW_DASHBOARD_COMP_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_DASHB_COMP_DEF_DEPLOYMENT ON FLW_DASHBOARD_COMP_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_DASHBOARD_COMP_DEFINITION
    ADD CONSTRAINT FK_DASHB_COMP_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PL_DEPLOYMENT (ID_);

CREATE TABLE FLW_OAUTH_CLIENT_REG (
    ID_ VARCHAR(255) NOT NULL,
    REGISTRATION_KEY_ VARCHAR(255) NOT NULL,
    CLIENT_ID_ VARCHAR(100),
    CLIENT_SECRET_ VARCHAR(255),
    CLIENT_NAME_ VARCHAR(255),
    CLIENT_AUTHENTICATION_METHOD_ VARCHAR(200),
    SCOPES_ VARCHAR(2000),
    ISSUER_URI_ VARCHAR(2000),
    TOKEN_URI_ VARCHAR(2000),
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT FLW_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_OAUTH_CL_REG_KEY_TEN ON FLW_OAUTH_CLIENT_REG (REGISTRATION_KEY_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('platform.schema.version', '19', 1);


CREATE TABLE ACT_APP_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    KEY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    CREATOR_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    CONSTRAINT "ACT_APP_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT PK_APP_DEPLOYMENT_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT ACT_FK_APP_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_RSRC_DPL ON ACT_APP_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE ACT_APP_APPDEF (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    CATEGORY_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    SUB_TYPE_ VARCHAR(255),
    STATE_ VARCHAR(255),
    SUB_STATE_ VARCHAR(255),
    APP_URL_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_NAME_ VARCHAR(4000),
    DESCRIPTION_ VARCHAR(4000),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CREATOR_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    CONSTRAINT "ACT_APP_APPDEF_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE ACT_APP_APPDEF
    ADD CONSTRAINT ACT_FK_APP_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES ACT_APP_DEPLOYMENT (ID_);

CREATE INDEX ACT_IDX_APP_DEF_DPLY ON ACT_APP_APPDEF (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_APP_DEF_UNIQ ON ACT_APP_APPDEF (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE ACT_APP_PAGEDEF (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    APP_ID_ VARCHAR(255),
    APP_KEY_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255) NOT NULL,
    PAGE_URL_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "ACT_APP_PAGEDEF_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE ACT_APP_VARIABLE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR(255),
    NAME_ VARCHAR(255) NOT NULL,
    APP_KEY_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255),
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    CONSTRAINT "ACT_APP_VARIABLE_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_VAR_KEY ON ACT_APP_VARIABLE (APP_KEY_);

CREATE INDEX ACT_IDX_APP_VAR_KEY_TENANT ON ACT_APP_VARIABLE (APP_KEY_, TENANT_ID_);

CREATE TABLE ACT_APP_INCIDENT (
    ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    SUB_TYPE_ VARCHAR(255),
    ROOT_SCOPE_ID_ VARCHAR(255),
    ROOT_SCOPE_TYPE_ VARCHAR(255),
    ROOT_SCOPE_DEFINITION_ID_ VARCHAR(255),
    ROOT_SCOPE_DEFINITION_KEY_ VARCHAR(255),
    APP_KEY_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_DEFINITION_KEY_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SUB_SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    ELEMENT_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    INCIDENT_INFO_ TEXT,
    CREATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CONSTRAINT "ACT_APP_INCIDENT_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX ACT_IDX_APP_INC_DEF_ROOT_KEY ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_K_TENANT ON ACT_APP_INCIDENT (ROOT_SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_DEF_KEY_TENANT ON ACT_APP_INCIDENT (SCOPE_DEFINITION_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_ROOT_SCOPE ON ACT_APP_INCIDENT (ROOT_SCOPE_ID_, ROOT_SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_KEY ON ACT_APP_INCIDENT (APP_KEY_);

CREATE INDEX ACT_IDX_APP_INC_KEY_TENANT ON ACT_APP_INCIDENT (APP_KEY_, TENANT_ID_);

CREATE INDEX ACT_IDX_APP_INC_SCOPE ON ACT_APP_INCIDENT (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_IDX_APP_INC_CREATE ON ACT_APP_INCIDENT (CREATE_TIME_);

insert into ACT_GE_PROPERTY
    values ('app.schema.version', '12', 1);


CREATE TABLE FLW_FO_FORM_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_FO_FORM_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_FO_FORM_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_FO_FORM_RESOURCE
    ADD CONSTRAINT FLW_FK_FO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_FO_FORM_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_FO_RSRC_DPL ON FLW_FO_FORM_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_FO_FORM_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    VERSION_ INTEGER,
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    RESOURCE_NAME_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(255),
    CONSTRAINT "FLW_FO_FORM_DEFINITION_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_FORM_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    FORM_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TASK_ID_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(255),
    PROC_DEF_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SUBMITTED_DATE_ TIMESTAMP WITHOUT TIME ZONE,
    SUBMITTED_BY_ VARCHAR(255),
    FORM_VALUES_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_FO_FORM_INSTANCE_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_FO_CUSTOM_COMPONENT_DEF (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    VERSION_ INTEGER,
    KEY_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    COMPONENT_VERSION_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(255),
    CONSTRAINT "FLW_FO_CUSTOM_COMPONENT_DEF_pkey" PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX FLW_IDX_FORM_DEF_UNIQ ON FLW_FO_FORM_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE UNIQUE INDEX FLW_IDX_CUST_COMP_DEF_UNIQ ON FLW_FO_CUSTOM_COMPONENT_DEF (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX FLW_IDX_FORM_TASK ON FLW_FO_FORM_INSTANCE (TASK_ID_);

CREATE INDEX FLW_IDX_FORM_PROC ON FLW_FO_FORM_INSTANCE (PROC_INST_ID_);

CREATE INDEX FLW_IDX_FORM_SCOPE ON FLW_FO_FORM_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('form.schema.version', '11', 1);


CREATE TABLE FLW_CO_CONTENT_ITEM (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    MIME_TYPE_ VARCHAR(255),
    TASK_ID_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    DEFINITION_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    SUB_TYPE_ VARCHAR(255),
    STATE_ VARCHAR(255),
    SUB_STATE_ VARCHAR(255),
    CONTENT_STORE_ID_ VARCHAR(255),
    CONTENT_STORE_NAME_ VARCHAR(255),
    CONTENT_AVAILABLE_ BOOLEAN DEFAULT FALSE,
    CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CREATED_BY_ VARCHAR(255),
    LAST_MODIFIED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    LAST_MODIFIED_BY_ VARCHAR(255),
    CONTENT_SIZE_ BIGINT DEFAULT 0,
    LOCK_INFO_ VARCHAR(255),
    VERSION_ INTEGER,
    VERSION_INFO_ VARCHAR(255),
    VERSION_PARENT_ID_ VARCHAR(255),
    FOLDER_PARENT_ID_ VARCHAR(255),
    FOLDER_BASE_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_CO_CONTENT_ITEM_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX idx_contitem_taskid ON FLW_CO_CONTENT_ITEM (TASK_ID_);

CREATE INDEX idx_contitem_procid ON FLW_CO_CONTENT_ITEM (PROC_INST_ID_);

CREATE INDEX idx_contitem_scope ON FLW_CO_CONTENT_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_RENDITION_ITEM (
    ID_ VARCHAR(255) NOT NULL,
    CONTENT_ITEM_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    MIME_TYPE_ VARCHAR(255),
    RENDITION_TYPE_ VARCHAR(255),
    TASK_ID_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(255),
    CONTENT_STORE_ID_ VARCHAR(255),
    CONTENT_STORE_NAME_ VARCHAR(255),
    CONTENT_AVAILABLE_ BOOLEAN DEFAULT FALSE,
    CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    LAST_MODIFIED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONTENT_SIZE_ BIGINT DEFAULT 0,
    TENANT_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    CONSTRAINT "FLW_CO_RENDITION_ITEM_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX idx_rendition_taskid ON FLW_CO_RENDITION_ITEM (TASK_ID_);

CREATE INDEX idx_rendition_procid ON FLW_CO_RENDITION_ITEM (PROC_INST_ID_);

CREATE INDEX idx_rendition_scope ON FLW_CO_RENDITION_ITEM (SCOPE_ID_, SCOPE_TYPE_);

CREATE TABLE FLW_CO_CONTENT_OBJECT (
    ID_ VARCHAR(255) NOT NULL,
    CREATED_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONTENT_ BYTEA,
    CONSTRAINT "FLW_CO_CONTENT_OBJECT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_CO_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_CO_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    NAME_ VARCHAR(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    CATEGORY_ VARCHAR(255),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONSTRAINT PK_CO_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CO_METADATA (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR(255),
    NAME_ VARCHAR(255),
    CONTENT_ITEM_ID_ VARCHAR(255),
    BYTEARRAY_ID_ VARCHAR(255),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000),
    CONSTRAINT "FLW_CO_METADATA_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CO_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_CO_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_CO_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_CO_RSRC_DPL ON FLW_CO_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE INDEX idx_contitem_folder ON FLW_CO_CONTENT_ITEM (FOLDER_PARENT_ID_);

CREATE INDEX idx_contitem_name ON FLW_CO_CONTENT_ITEM (NAME_);

CREATE INDEX idx_contitem_verparid ON FLW_CO_CONTENT_ITEM (VERSION_PARENT_ID_);

CREATE INDEX idx_contitem_bfolder ON FLW_CO_CONTENT_ITEM (FOLDER_BASE_ID_);

CREATE INDEX idx_rendition_contentid ON FLW_CO_RENDITION_ITEM (CONTENT_ITEM_ID_);

CREATE INDEX idx_metadata_contentid ON FLW_CO_METADATA (CONTENT_ITEM_ID_);

CREATE UNIQUE INDEX FLW_IDX_CO_DEF_UNIQ ON FLW_CO_DEFINITION (KEY_, VERSION_, TENANT_ID_);

insert into ACT_GE_PROPERTY
    values ('content.schema.version', '18', 1);


CREATE TABLE FLW_ACTION_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_ACTION_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_ACTION_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_ACTION_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_ACTION_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_ACTION_RSRC_DPL ON FLW_ACTION_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_ACTION_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    BOT_KEY_ VARCHAR(128),
    MANDATORY_ BOOLEAN,
    NAME_ VARCHAR(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    SCOPE_TYPE_ VARCHAR(128),
    FORM_KEY_ VARCHAR(128),
    GLOBAL_ BOOLEAN,
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATER_ID_ VARCHAR(64),
    CONSTRAINT PK_ACTION_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    START_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE,
    FORM_KEY_ VARCHAR(128),
    FORM_INSTANCE_ID_ VARCHAR(255),
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SUB_SCOPE_ID_ VARCHAR(255),
    PRIORITY_ INTEGER,
    ICON_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_ACTION_INSTANCE_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_ACTION_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONSTRAINT "FLW_ACTION_LINK_pkey" PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_),
    CONSTRAINT FK_ACTION_LINK_ACTION_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_)
);

CREATE INDEX FLW_IDX_ACTION_LINK_SCOPE ON FLW_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_ACTION_DEFINITION
    ADD CONSTRAINT FK_ACTION_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_ACTION_DEPLOYMENT (ID_);

ALTER TABLE FLW_ACTION_INSTANCE
    ADD CONSTRAINT FK_ACTION_INST_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_);

CREATE INDEX IDX_ACTION_LINK_ACTION_INST ON FLW_ACTION_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_DEFINITION_ID_ ON FLW_ACTION_LINK (ACTION_DEFINITION_ID_);

CREATE INDEX IDX_ACTION_DEF_DEPLOYMENT ON FLW_ACTION_DEFINITION (DEPLOYMENT_ID_);

CREATE INDEX IDX_ACTION_INST_ACTION_DEF ON FLW_ACTION_INSTANCE (ACTION_DEFINITION_ID_);

CREATE TABLE FLW_HI_ACTION_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    START_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE,
    EXECUTION_DATE_ TIMESTAMP(6) WITHOUT TIME ZONE,
    EXECUTED_BY_ VARCHAR(255),
    FORM_KEY_ VARCHAR(128),
    FORM_INSTANCE_ID_ VARCHAR(255),
    FORM_PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SUB_SCOPE_ID_ VARCHAR(255),
    PRIORITY_ INTEGER,
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_HI_ACTION_INSTANCE_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_HI_ACTION_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255),
    ACTION_DEFINITION_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CONSTRAINT "FLW_HI_ACTION_LINK_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_HI_ACTION_LINK_SCOPE ON FLW_HI_ACTION_LINK (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX IDX_HI_ACTION_LINK_ACTION_INST ON FLW_HI_ACTION_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACTION_HI_DEFINITION_ID_ ON FLW_HI_ACTION_LINK (ACTION_DEFINITION_ID_);

CREATE INDEX IDX_HI_ACTION_INST_ACTION_DEF ON FLW_HI_ACTION_INSTANCE (ACTION_DEFINITION_ID_);

CREATE TABLE FLW_ACTION_DEF_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255),
    CONSTRAINT "FLW_ACTION_DEF_LINK_pkey" PRIMARY KEY (ID_),
    CONSTRAINT FK_ACTION_DEF_LINK_ACTION_DEF FOREIGN KEY (ACTION_DEFINITION_ID_) REFERENCES FLW_ACTION_DEFINITION (ID_)
);

CREATE INDEX IDX_ACTION_DEF_LINK_ACTION_DEF ON FLW_ACTION_DEF_LINK (ACTION_DEFINITION_ID_);

CREATE UNIQUE INDEX "ACT_IDX_ACTIONs_DEF_UNIQ" ON FLW_ACTION_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_ACTION_TYPE_LINK (
    ID_ VARCHAR(255) NOT NULL,
    ACTION_INSTANCE_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255),
    CONSTRAINT "FLW_ACTION_TYPE_LINK_pkey" PRIMARY KEY (ID_),
    CONSTRAINT FK_ACT_TYPE_LINK_ACT_INST FOREIGN KEY (ACTION_INSTANCE_ID_) REFERENCES FLW_ACTION_INSTANCE (ID_)
);

CREATE INDEX IDX_ACT_TYPE_LINK_ACT_INST ON FLW_ACTION_TYPE_LINK (ACTION_INSTANCE_ID_);

CREATE INDEX ACT_IDX_SCOPE_ID_TYPE ON FLW_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX ACT_HI_IDX_SCOPE_ID_TYPE ON FLW_HI_ACTION_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

insert into ACT_GE_PROPERTY
    values ('action.schema.version', '20', 1);


CREATE TABLE FLW_AUDIT_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    AUDIT_DEFINITION_ID_ VARCHAR(255),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    CREATOR_ID_ VARCHAR(255),
    EXTERNAL_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    SUB_TYPE_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    SUB_SCOPE_ID_ VARCHAR(255),
    SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    PAYLOAD_ TEXT,
    TENANT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_AUDIT_INSTANCE_pkey" PRIMARY KEY (ID_)
);

CREATE INDEX FLW_IDX_AUDIT_INST_DEF ON FLW_AUDIT_INSTANCE (AUDIT_DEFINITION_ID_);

CREATE INDEX FLW_IDX_AUDIT_INST_TYPE ON FLW_AUDIT_INSTANCE (TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_SCOPE ON FLW_AUDIT_INSTANCE (SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_IDX_AUDIT_INST_CREATE ON FLW_AUDIT_INSTANCE (CREATION_TIME_);

insert into ACT_GE_PROPERTY
    values ('audit.schema.version', '4', 1);


CREATE TABLE FLW_DATAOBJECT_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_DATAOBJECT_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_DO_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DATAOBJECT_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    NAME_ VARCHAR(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    SOURCE_ID_ VARCHAR(128),
    SOURCE_TYPE_ VARCHAR(128),
    TYPE_ VARCHAR(128),
    SUB_TYPE_ VARCHAR(128),
    EXTERNAL_ID_ VARCHAR(128),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    CONSTRAINT PK_DO_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DATAOBJECT_DEFINITION
    ADD CONSTRAINT FK_DATAOBJECT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DATAOBJECT_DEF_DEPLOYMENT ON FLW_DATAOBJECT_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DATAOBJECT_DEF_UNIQ ON FLW_DATAOBJECT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_MASTER_DATA_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    DEFINITION_ID_ VARCHAR(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    EXTERNAL_ID_ VARCHAR(128),
    KEY_ VARCHAR(128),
    NAME_ VARCHAR(255),
    STATE_ VARCHAR(64),
    SORT_ORDER_ INTEGER,
    IS_FAVORITE_ BOOLEAN,
    DESCRIPTION_ VARCHAR(2000),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(128),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATER_ID_ VARCHAR(128),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_DO_DATA_INSTANCES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_VARIABLES (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR(255),
    NAME_ VARCHAR(255),
    DATA_INSTANCE_ID_ VARCHAR(255),
    BYTEARRAY_ID_ VARCHAR(255),
    DOUBLE_ DOUBLE PRECISION,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000),
    CONSTRAINT "FLW_DO_VARIABLES_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DO_SCHEMA_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    CONSTRAINT PK_DO_SCHEMA_DEFINITIONS PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DO_SCHEMA_DEFINITION
    ADD CONSTRAINT FK_DO_SCHEMA_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_DATAOBJECT_DEPLOYMENT (ID_);

CREATE INDEX IDX_DO_SCHEMA_DEF_DEPLOYMENT ON FLW_DO_SCHEMA_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX FLW_IDX_DO_SCHEMA_DEF_UNIQ ON FLW_DO_SCHEMA_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DO_DATAOBJECT_INSTANCE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    DEFINITION_ID_ VARCHAR(255) NOT NULL,
    DEFINITION_KEY_ VARCHAR(255) NOT NULL,
    LOOKUP_ID_ VARCHAR(128),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(128),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    UPDATER_ID_ VARCHAR(128),
    SCOPE_ID_ VARCHAR(255),
    SUB_SCOPE_ID_ VARCHAR(255),
    SCOPE_TYPE_ VARCHAR(255),
    SCOPE_DEFINITION_ID_ VARCHAR(255),
    CONSTRAINT PK_DO_DATAOBJECT_INSTANCES PRIMARY KEY (ID_)
);

insert into ACT_GE_PROPERTY
    values ('dataobject.schema.version', '7', 1);


CREATE TABLE FLW_POLICY_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_POLICY_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_POLICY_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_POLICY_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_POLICY_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_POLICY_RSRC_DPL ON FLW_POLICY_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_POLICY_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    TYPE_ VARCHAR(128),
    NAME_ VARCHAR(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    CONSTRAINT PK_POLICY_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_POLICY_DEF_LINK (
    ID_ VARCHAR(255) NOT NULL,
    POLICY_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    LINK_VALUE_ VARCHAR(255),
    CONSTRAINT "FLW_POLICY_DEF_LINK_pkey" PRIMARY KEY (ID_),
    CONSTRAINT FK_POLICY_DEF_LINK_POLICY_DEF FOREIGN KEY (POLICY_DEFINITION_ID_) REFERENCES FLW_POLICY_DEFINITION (ID_)
);

ALTER TABLE FLW_POLICY_DEFINITION
    ADD CONSTRAINT FK_POLICY_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_POLICY_DEPLOYMENT (ID_);

CREATE INDEX IDX_POLICY_DEF_DEPLOYMENT ON FLW_POLICY_DEFINITION (DEPLOYMENT_ID_);

CREATE UNIQUE INDEX ACT_IDX_POLICIES_DEF_UNIQ ON FLW_POLICY_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_POLICY_DEF_LINK_POLICY_DEF ON FLW_POLICY_DEF_LINK (POLICY_DEFINITION_ID_);

insert into ACT_GE_PROPERTY
    values ('policy.schema.version', '3', 1);


CREATE TABLE FLW_SE_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_SE_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_SE_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_SE_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_SE_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_SE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_SE_RSRC_DPL ON FLW_SE_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_SE_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    REFERENCE_KEY_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    NAME_ VARCHAR(128),
    VERSION_ INTEGER,
    RESOURCE_NAME_ VARCHAR(4000),
    CONSTRAINT PK_SERVICE_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX ACT_IDX_SERVICE_DEF_UNIQ ON FLW_SE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_SE_DEFINITION
    ADD CONSTRAINT FK_SERVICE_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_SE_DEPLOYMENT (ID_);

CREATE INDEX IDX_SERVICE_DEF_DEPLOYMENT ON FLW_SE_DEFINITION (DEPLOYMENT_ID_);

insert into ACT_GE_PROPERTY
    values ('service.schema.version', '4', 1);


CREATE TABLE FLW_TEMPL_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    DEPLOY_TIME_ TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_ VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT "FLW_TEMPL_DEPLOYMENT_pkey" PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT "FLW_TEMPL_DEPLOYMENT_RESOURCE_pkey" PRIMARY KEY (ID_)
);

ALTER TABLE FLW_TEMPL_DEPLOYMENT_RESOURCE
    ADD CONSTRAINT FLW_FK_TEMPL_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_TEMPL_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_TEMPL_RSRC_DPL ON FLW_TEMPL_DEPLOYMENT_RESOURCE (DEPLOYMENT_ID_);

CREATE TABLE FLW_TEMPL_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR(128),
    VERSION_ INTEGER,
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(128),
    TYPE_ VARCHAR(128),
    SUB_TYPE_ VARCHAR(128),
    FORM_KEY_ VARCHAR(128),
    RESOURCE_NAME_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE,
    UPDATOR_ID_ VARCHAR(64),
    CONSTRAINT PK_TEMPL_DEFINITIONS PRIMARY KEY (ID_)
);

CREATE TABLE FLW_TEMPL_VAR_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR(128),
    TEMPLATE_DEF_KEY_ VARCHAR(128),
    VARIATION_KEY_ VARCHAR(128),
    DEPLOYMENT_ID_ VARCHAR(255) NOT NULL,
    VERSION_ INTEGER,
    VALID_FROM_ TIMESTAMP(6) WITHOUT TIME ZONE,
    VALID_TO_ TIMESTAMP(6) WITHOUT TIME ZONE,
    RESOURCE_NAME_ VARCHAR(4000),
    EXTERNAL_ID_ VARCHAR(255),
    CONTENT_ID_ VARCHAR(255),
    TENANT_ID_ VARCHAR(64) DEFAULT '',
    CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    CREATOR_ID_ VARCHAR(64),
    CONSTRAINT PK_TEMPL_VAR_DEFINITIONS PRIMARY KEY (ID_)
);

create index FLW_IDX_TEMPL_VAR_DEF_DEF_KEY
    on FLW_TEMPL_VAR_DEFINITION (TEMPLATE_DEF_KEY_, VARIATION_KEY_);

INSERT INTO ACT_GE_PROPERTY
VALUES ('template.schema.version', '8', 1);


CREATE TABLE FLW_AGENT_DEPLOYMENT
(
    ID_                   VARCHAR(255) NOT NULL,
    NAME_                 VARCHAR(255),
    KEY_                  VARCHAR(255),
    CATEGORY_             VARCHAR(255),
    DEPLOY_TIME_          TIMESTAMP WITHOUT TIME ZONE,
    TENANT_ID_            VARCHAR(255),
    PARENT_DEPLOYMENT_ID_ VARCHAR(255),
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEPLOYMENT_RES
(
    ID_             VARCHAR(255) NOT NULL,
    NAME_           VARCHAR(255),
    DEPLOYMENT_ID_  VARCHAR(255),
    RESOURCE_BYTES_ BYTEA,
    CONSTRAINT PK_FLW_AGENT_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_DEFINITION
(
    ID_              VARCHAR(255) NOT NULL,
    REV_             INTEGER      NOT NULL,
    KEY_             VARCHAR(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR(255) NOT NULL,
    NAME_            VARCHAR(255),
    DESCRIPTION_     VARCHAR(4000),
    API_ENABLED_     BOOLEAN DEFAULT FALSE,
    RESOURCE_NAME_   VARCHAR(4000),
    TYPE_            VARCHAR(255) NOT NULL,
    TENANT_ID_       VARCHAR(64) DEFAULT '',
    CONSTRAINT PK_FLW_AGENT_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_DEF_UNIQ ON FLW_AGENT_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_DEF_DEPLOYMENT ON FLW_AGENT_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_DEF_DEPLOYMENT FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);

CREATE TABLE FLW_AGENT_INSTANCE
(
    ID_                  VARCHAR(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    TENANT_ID_           VARCHAR(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    START_USER_ID_       VARCHAR(255),
    CHAT_ENABLED_        BOOLEAN DEFAULT FALSE,
    REFERENCE_ID_        VARCHAR(255),
    REFERENCE_TYPE_      VARCHAR(255),
    CALLBACK_ID_         VARCHAR(255),
    CALLBACK_TYPE_       VARCHAR(255),
    CONSTRAINT PK_FLW_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INSTANCE_DEF_ID ON FLW_AGENT_INSTANCE (AGENT_DEFINITION_ID_);
CREATE INDEX IDX_FLW_AGENT_INSTANCE_REF_ID ON FLW_AGENT_INSTANCE (REFERENCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE
    ADD CONSTRAINT FK_FLW_AGENT_INSTANCE_DEF FOREIGN KEY (AGENT_DEFINITION_ID_) REFERENCES FLW_AGENT_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_KB_DEFINITION
(
    ID_              VARCHAR(255) NOT NULL,
    REV_             INTEGER      NOT NULL,
    KEY_             VARCHAR(255),
    VERSION_         INTEGER,
    DEPLOYMENT_ID_   VARCHAR(255) NOT NULL,
    NAME_            VARCHAR(255),
    DESCRIPTION_     VARCHAR(4000),
    RESOURCE_NAME_   VARCHAR(4000),
    TENANT_ID_       VARCHAR(64) DEFAULT '',
    READY_           BOOLEAN DEFAULT FALSE NOT NULL,
    CONSTRAINT PK_FLW_AGENT_KB_DEF PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_UNIQ ON FLW_AGENT_KB_DEFINITION (KEY_, VERSION_, TENANT_ID_);

CREATE INDEX IDX_FLW_AGENT_KB_DEF_DEPL ON FLW_AGENT_KB_DEFINITION (DEPLOYMENT_ID_);

ALTER TABLE FLW_AGENT_KB_DEFINITION
    ADD CONSTRAINT FK_FLW_AGENT_KB_DEF_DEPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_AGENT_DEPLOYMENT (ID_);


CREATE TABLE FLW_AGENT_KB_ITEM
(
    ID_                    VARCHAR(255)          NOT NULL,
    PARENT_ID_             VARCHAR(255),
    ROOT_ID_               VARCHAR(255),
    KB_DEF_ID_             VARCHAR(255),
    IS_CONTAINER_          BOOLEAN DEFAULT FALSE NOT NULL,
    SCOPE_ID_              VARCHAR(255),
    SCOPE_TYPE_            VARCHAR(255),
    CHECKSUM_              VARCHAR(255),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_UNIQ ON FLW_AGENT_KB_ITEM (SCOPE_ID_, SCOPE_TYPE_);
CREATE INDEX IDX_FLW_AGENT_KB_ITEM_DEF ON FLW_AGENT_KB_ITEM (KB_DEF_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_DEF FOREIGN KEY (KB_DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

CREATE TABLE FLW_AGENT_INSTANCE_EXCHANGE
(
    ID_                     VARCHAR(255) NOT NULL,
    REV_                    INTEGER      NOT NULL,
    AGENT_INSTANCE_ID_      VARCHAR(255),
    OPERATION_KEY_          VARCHAR(255),
    CREATION_TIME_          TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    TYPE_                   VARCHAR(255),
    USER_ID_                VARCHAR(255),
    PROCESSING_             BOOLEAN DEFAULT FALSE,
    CONTENT_                TEXT,
    TECHNICAL_CONTENT_      TEXT,
    TOKEN_COUNT_            INTEGER,
    CONSTRAINT PK_FLW_AGENT_INSTANCE_EXCHANGE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_INST_EXCH_INST ON FLW_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_AGENT_INST_EXCH_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE
(
    ID_                  VARCHAR(255) NOT NULL,
    REV_                 INTEGER      NOT NULL,
    TENANT_ID_           VARCHAR(64) DEFAULT '',
    AGENT_DEFINITION_ID_ VARCHAR(255) NOT NULL,
    START_TIME_          TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    END_TIME_            TIMESTAMP(6) WITHOUT TIME ZONE,
    CHAT_ENABLED_        BOOLEAN DEFAULT FALSE,
    STATE_               VARCHAR(255),
    START_USER_ID_       VARCHAR(255),
    REFERENCE_ID_        VARCHAR(255),
    REFERENCE_TYPE_      VARCHAR(255),
    CALLBACK_ID_         VARCHAR(255),
    CALLBACK_TYPE_       VARCHAR(255),
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_DEF_ID ON FLW_HI_AGENT_INSTANCE (AGENT_DEFINITION_ID_);

CREATE TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
(
    ID_                         VARCHAR(255) NOT NULL,
    REV_                        INTEGER      NOT NULL,
    AGENT_INSTANCE_ID_          VARCHAR(255),
    OPERATION_KEY_              VARCHAR(255),
    CREATION_TIME_              TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL,
    TYPE_                       VARCHAR(255),
    USER_ID_                    VARCHAR(255),
    PROCESSING_                 BOOLEAN DEFAULT FALSE,
    CONTENT_                    TEXT,
    TECHNICAL_CONTENT_          TEXT,
    TOKEN_COUNT_                INTEGER,
    CONSTRAINT PK_FLW_HI_AGENT_INSTANCE_EXCH PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_HI_AGENT_INST_EXC_INST ON FLW_HI_AGENT_INSTANCE_EXCHANGE (AGENT_INSTANCE_ID_);

ALTER TABLE FLW_HI_AGENT_INSTANCE_EXCHANGE
    ADD CONSTRAINT FK_FLW_HI_AGENT_INST_EXC_INST FOREIGN KEY (AGENT_INSTANCE_ID_) REFERENCES FLW_HI_AGENT_INSTANCE (ID_);

CREATE TABLE FLW_AGENT_KB_ITEM_SECTION
(
    ID_                     VARCHAR(255) NOT NULL,
    KB_ITEM_ID_             VARCHAR(255) NOT NULL,
    EXTERNAL_ID_            VARCHAR(500),
    CONSTRAINT PK_FLW_AGENT_KB_ITEM_SECTION PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_AGENT_KB_ITEM_SEC_ITEM ON FLW_AGENT_KB_ITEM_SECTION (KB_ITEM_ID_);

ALTER TABLE FLW_AGENT_KB_ITEM_SECTION
    ADD CONSTRAINT FK_FLW_AGENT_KB_ITEM_SEC_ITEM FOREIGN KEY (KB_ITEM_ID_) REFERENCES FLW_AGENT_KB_ITEM (ID_);


CREATE TABLE FLW_HI_AGENT_INSTANCE_KB_LINK
(
    ID_                             VARCHAR(255) NOT NULL,
    REV_                            INTEGER      NOT NULL,
    AGENT_INSTANCE_ID_              VARCHAR(255),
    KB_ITEM_SECTION_ID_             VARCHAR(255),
    EXTERNAL_ID_                    VARCHAR(500),
    SCORE_                          DOUBLE PRECISION,
    CONSTRAINT PK_FLW_HI_AGENT_INST_KB_LINK PRIMARY KEY (ID_)
);

CREATE TABLE FLW_AGENT_KB_DEF_METADATA
(
    ID_     VARCHAR(255) NOT NULL,
    REV_    INTEGER      NOT NULL,
    DEF_ID_ VARCHAR(255) NOT NULL,
    NAME_   VARCHAR(255),
    VALUE_  VARCHAR(255),
    CONSTRAINT PK_FLW_AGENT_KB_DEF_METADATA PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX IDX_FLW_AGENT_KB_DEF_META_UNIQ ON FLW_AGENT_KB_DEF_METADATA (DEF_ID_, NAME_);

ALTER TABLE FLW_AGENT_KB_DEF_METADATA
    ADD CONSTRAINT FK_AGENT_KB_DEF_META_DEF_ FOREIGN KEY (DEF_ID_) REFERENCES FLW_AGENT_KB_DEFINITION (ID_);

insert into ACT_GE_PROPERTY
values ('agent.schema.version', '1', 1);


CREATE TABLE FLW_ENGAGE_CONVERSATION (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', PARENT_ID_ VARCHAR(64), REFERENCE_ID_ VARCHAR(64), REFERENCE_TYPE_ VARCHAR(64), REFERENCE_DEFINITION_ID_ VARCHAR(64), CONVERSATION_DEFINITION_ID_ VARCHAR(64), STATE_ VARCHAR(64), TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), PERMISSION_TYPE_ VARCHAR(64), JOINING_TYPE_ VARCHAR(64), PRIORITY_ INTEGER, NAME_ VARCHAR(255), FALLBACK_NAME_ VARCHAR(4000), DESCRIPTION_ VARCHAR(4000), AVATAR_ID_ VARCHAR(255), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), RESUBMISSION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_MESSAGE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, METADATA_ TEXT, TAGS_ TEXT, CONSTRAINT PK_ENGAGE_CONVERSATION PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_MESSAGE (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR(128), REPLY_TO_MESSAGE_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR(128), MEDIA_CONTENT_ID_ VARCHAR(128), RECIPIENT_GROUP_ID_ VARCHAR(64), CATEGORY_ VARCHAR(64) NOT NULL, TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), SENDER_ID_ VARCHAR(64) NOT NULL, PRIVATE_ BOOLEAN DEFAULT FALSE, CONVERSATION_ID_ VARCHAR(64), STICKY_ BOOLEAN DEFAULT FALSE, TAGS_ TEXT, MAIN_CONTENT_ TEXT, MAIN_CONTENT_TYPE_ VARCHAR(64), RECIPIENT_ID_ VARCHAR(64), CONSTRAINT PK_ENGAGE_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_MESSAGE_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_MSG_CONVERSATION ON FLW_ENGAGE_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_MSG_CREATION_TIME ON FLW_ENGAGE_MESSAGE(CREATION_TIME_);

CREATE TABLE FLW_CONV_PARTICIPANT_REGISTRY (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, CONVERSATION_ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(64), GROUP_ID_ VARCHAR(64), USER_ACCOUNT_ID_ VARCHAR(64), PARTICIPANT_TYPE_ VARCHAR(255), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, JOINING_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, LEAVING_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_CONV_PARTICIPANT_REGISTRY PRIMARY KEY (ID_), CONSTRAINT FK_CONV_PART_REG_CONVERSATION FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_) ON DELETE CASCADE);

CREATE TABLE FLW_ENGAGE_CONV_DEFINITIONS (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, NAME_ VARCHAR(128), KEY_ VARCHAR(128), TYPE_ VARCHAR(128), TENANT_ID_ VARCHAR(64) DEFAULT '', CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), DEFINITION_CONTENT_ TEXT, CONSTRAINT PK_ENGAGE_CONV_DEFINITIONS PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_CONVERSATION_STATUS (ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(64) NOT NULL, CONVERSATION_ID_ VARCHAR(64), FILTER_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', UNREAD_MESSAGE_COUNT_ INTEGER, UNREAD_PERSONAL_MESSAGE_COUNT_ INTEGER, UNSENT_MESSAGE_COUNT_ INTEGER, LAST_READ_MESSAGE_ID_ VARCHAR(64), LAST_READ_MESSAGE_TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE, LAST_SENT_MESSAGE_ID_ VARCHAR(64), LAST_SENT_MESSAGE_TIMESTAMP_ TIMESTAMP(6) WITHOUT TIME ZONE, CONSTRAINT PK_ENGAGE_CONVERSATION_STATUS PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_CONV_STAT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_STAT_USR_CONV_FLT ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, CONVERSATION_ID_, FILTER_ID_);

CREATE TABLE FLW_ENGAGE_ARC_CONV_EVENT (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CONVERSATION_ID_ VARCHAR(64), SECTION_ID_ INTEGER, PERIOD_START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, PERIOD_END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, PARTICIPANT_IDS_ TEXT, PARTICIPANT_NAMES_ TEXT, MESSAGE_COUNT_ INTEGER, EVENT_COUNT_ INTEGER, ATTACHMENT_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_ARC_CONV_EVENT PRIMARY KEY (ID_));

CREATE TABLE FLW_ENGAGE_ARC_JOB_EVENT (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONVERSATION_COUNT_ INTEGER, PARTICIPANT_COUNT_ INTEGER, DATA_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_ARC_JOB_EVENT PRIMARY KEY (ID_));

CREATE INDEX IDX_ENGAGE_ARC_CONV_CREATE ON FLW_ENGAGE_ARC_CONV_EVENT(CREATION_TIME_);

CREATE INDEX IDX_ENGAGE_ARC_CONV_CONV ON FLW_ENGAGE_ARC_CONV_EVENT(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_ARC_JOB_EVT_CREATE ON FLW_ENGAGE_ARC_JOB_EVENT(CREATION_TIME_);

CREATE INDEX IDX_CONV_PART_REG_CONVERSATION ON FLW_CONV_PARTICIPANT_REGISTRY(CONVERSATION_ID_);

CREATE INDEX IDX_ENGAGE_CONV_STAT_CONV ON FLW_ENGAGE_CONVERSATION_STATUS(CONVERSATION_ID_);

CREATE TABLE FLW_ENGAGE_USER_ANALYTICS (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, USER_ID_ VARCHAR(64), START_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, END_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, CONVERSATION_COUNT_ INTEGER, MESSAGE_COUNT_ INTEGER, CONSTRAINT PK_ENGAGE_USER_ANALYTICS PRIMARY KEY (ID_));

CREATE INDEX FLW_IDX_MSG_EXTERNAL_ID ON FLW_ENGAGE_MESSAGE(EXTERNAL_ID_);

CREATE INDEX FLW_IDX_CONV_EXTERNAL_ID ON FLW_ENGAGE_CONVERSATION(EXTERNAL_ID_);

CREATE TABLE FLW_ENGAGE_TEMP_MESSAGE (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, EXTERNAL_ID_ VARCHAR(128), REPLY_TO_MESSAGE_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', ACTION_INSTANCE_ID_ VARCHAR(128), MEDIA_CONTENT_ID_ VARCHAR(128), RECIPIENT_GROUP_ID_ VARCHAR(64), CATEGORY_ VARCHAR(64) NOT NULL, TYPE_ VARCHAR(64), SUB_TYPE_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), SENDER_ID_ VARCHAR(64) NOT NULL, PRIVATE_ BOOLEAN DEFAULT FALSE, CONVERSATION_ID_ VARCHAR(64), STICKY_ BOOLEAN DEFAULT FALSE, TAGS_ TEXT, MAIN_CONTENT_ TEXT, MAIN_CONTENT_TYPE_ VARCHAR(64), RECIPIENT_ID_ VARCHAR(64), PROCESSED_ BOOLEAN DEFAULT FALSE, PROCESSING_STATUS_ VARCHAR(255), PROCESSING_REASON_ TEXT, CONSTRAINT PK_ENGAGE_TEMP_MESSAGE PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_TEMP_MSG_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_TEMP_MSG_CONVERSATION ON FLW_ENGAGE_TEMP_MESSAGE(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_TEMP_MSG_CREATION_TIME ON FLW_ENGAGE_TEMP_MESSAGE(CREATION_TIME_);

CREATE INDEX FLW_IDX_TEMP_MSG_EXTERNAL_ID ON FLW_ENGAGE_TEMP_MESSAGE(EXTERNAL_ID_);

CREATE TABLE FLW_ENGAGE_DEVICE (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), UPDATE_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE, UPDATER_ID_ VARCHAR(64), TENANT_ID_ VARCHAR(64) DEFAULT '', TOKEN_ VARCHAR(255), TOKEN_ENCODING_ VARCHAR(64), ENABLED_ BOOLEAN DEFAULT TRUE, DEVICE_OS_ VARCHAR(64), USER_ID_ VARCHAR(64), APPLICATION_ID_ VARCHAR(255), CONSTRAINT PK_ENGAGE_DEVICE PRIMARY KEY (ID_));

CREATE INDEX IDX_ENGAGE_USR_FILTER ON FLW_ENGAGE_CONVERSATION_STATUS(USER_ID_, FILTER_ID_);

CREATE TABLE FLW_ENGAGE_REACTION (ID_ VARCHAR(64) NOT NULL, MESSAGE_ID_ VARCHAR(64) NOT NULL, USER_ID_ VARCHAR(64) NOT NULL, REACTION_ TEXT NOT NULL, CONSTRAINT PK_ENGAGE_REACTION PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_REACTION_MESSAGE FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE);

CREATE INDEX FLW_IDX_REACTION_MSG ON FLW_ENGAGE_REACTION(MESSAGE_ID_);

CREATE TABLE FLW_ENGAGE_MESSAGE_AUDIT (ID_ VARCHAR(64) NOT NULL, REV_ INTEGER NOT NULL, MESSAGE_ID_ VARCHAR(64) NOT NULL, MEDIA_CONTENT_ID_ VARCHAR(128), CONVERSATION_ID_ VARCHAR(64), MAIN_CONTENT_ TEXT, MAIN_CONTENT_TYPE_ VARCHAR(64), CREATION_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, CREATOR_ID_ VARCHAR(64), MODIFY_TIME_ TIMESTAMP(6) WITHOUT TIME ZONE NOT NULL, MODIFIER_ID_ VARCHAR(64), CONSTRAINT PK_ENGAGE_MESSAGE_AUDIT PRIMARY KEY (ID_), CONSTRAINT FK_ENGAGE_MESSAGE_AUDIT_MSG FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE, CONSTRAINT FK_ENGAGE_MESSAGE_AUDIT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_));

CREATE INDEX FLW_IDX_MESSAGE_AUDIT_MSG ON FLW_ENGAGE_MESSAGE_AUDIT(MESSAGE_ID_);

CREATE INDEX FLW_IDX_MESSAGE_AUDIT_CONV ON FLW_ENGAGE_MESSAGE_AUDIT(CONVERSATION_ID_);

CREATE TABLE FLW_ENGAGE_CONV_USR_ACCOUNT (CONVERSATION_ID_ VARCHAR(64) NOT NULL, USER_ACCOUNT_ID_ VARCHAR(64) NOT NULL, CONSTRAINT FK_CONV_USER_ACCOUNT_ACCOUNT FOREIGN KEY (USER_ACCOUNT_ID_) REFERENCES FLW_ID_USER_ACCOUNT(ID_) ON DELETE CASCADE, CONSTRAINT FK_CONV_USER_ACCOUNT_CONV FOREIGN KEY (CONVERSATION_ID_) REFERENCES FLW_ENGAGE_CONVERSATION(ID_) ON DELETE CASCADE);

CREATE TABLE FLW_ENGAGE_MSG_REF_MAPPING (MESSAGE_ID_ VARCHAR(64) NOT NULL, REFERENCE_ID_ VARCHAR(128), REFERENCE_TYPE_ VARCHAR(64), CONSTRAINT FK_MSG_REF_MAPPING_MESSAGE_ID FOREIGN KEY (MESSAGE_ID_) REFERENCES FLW_ENGAGE_MESSAGE(ID_) ON DELETE CASCADE);

CREATE INDEX FLW_IDX_MSG_REF_MAPPING_REF ON FLW_ENGAGE_MSG_REF_MAPPING(REFERENCE_TYPE_, REFERENCE_ID_);

CREATE INDEX FLW_IDX_CONV_USR_ACC_CONV ON FLW_ENGAGE_CONV_USR_ACCOUNT(CONVERSATION_ID_);

CREATE INDEX FLW_IDX_CONV_USR_ACC_ACCOUNT ON FLW_ENGAGE_CONV_USR_ACCOUNT(USER_ACCOUNT_ID_);

CREATE INDEX FLW_IDX_MSG_REF_MAPPING_MSG ON FLW_ENGAGE_MSG_REF_MAPPING(MESSAGE_ID_);

insert into ACT_GE_PROPERTY
    values ('engage.schema.version', '28', 1);

