CREATE TABLE FLW_DE_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);
insert into FLW_DE_PROPERTY
    values ('design.schema.version', '71', 1);
drop table ACT_DE_DATABASECHANGELOGLOCK;
drop table ACT_DE_DATABASECHANGELOG;
drop table FLW_PAL_DATABASECHANGELOGLOCK;
drop table FLW_PAL_DATABASECHANGELOG;



CREATE TABLE FLW_DE_MODEL_GENERATION (
    ID_ VARCHAR(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR(255) NOT NULL,
    PACKAGE_ID_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    PROMPT_ VARCHAR(2000) NULL,
    GENERATION_TYPE_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    STATUS_ VARCHAR(255) NULL,
    CREATED_ datetime(6),
    LAST_UPDATED_ datetime(6) NULL,
    CONSTRAINT FLW_DE_PK_MODEL_GEN PRIMARY KEY (ID_)
);
ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);
ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PACKAGE FOREIGN KEY (PACKAGE_ID_) REFERENCES ACT_DE_MODEL (id);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_WORKSPACE ON FLW_DE_MODEL_GENERATION (WORKSPACE_ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PACKAGE ON FLW_DE_MODEL_GENERATION (PACKAGE_ID_);
CREATE TABLE FLW_DE_MODEL_GENERATION_PART (
    ID_ VARCHAR(255) NOT NULL,
    MODEL_GENERATION_ID_ VARCHAR(255) NOT NULL,
    KEY_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    USER_PROMPT_ TEXT NULL,
    SYSTEM_PROMPT_ TEXT NULL,
    STATUS_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    RESPONSE_ TEXT NULL,
    MODEL_CONTENT_ TEXT NULL,
    PART_REFERENCE_ VARCHAR(255) NULL,
    PART_COUNT_ INTEGER NULL,
    REFERENCE_SCOPE_KEY_ VARCHAR(255) NULL,
    REFERENCE_SCOPE_TYPE_ VARCHAR(255) NULL,
    CREATED_ datetime(6),
    LAST_UPDATED_ datetime(6) NULL,
    CONSTRAINT FLW_DE_PK_MODEL_GEN_PART PRIMARY KEY (ID_)
);
ALTER TABLE FLW_DE_MODEL_GENERATION_PART
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PART_MOD_GEN FOREIGN KEY (MODEL_GENERATION_ID_) REFERENCES FLW_DE_MODEL_GENERATION (ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PART_GEN ON FLW_DE_MODEL_GENERATION_PART (MODEL_GENERATION_ID_);



update ACT_DE_MODEL set visibility_ = 'public' where visibility_ = 'internal';



CREATE TABLE FLW_DE_CUSTOM_COMP_PROJECT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    UPLOADED_BUNDLE_HASH_ VARCHAR(255) NULL,
    INSTALLED_BUNDLE_HASH_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CREATE_DATE_ datetime(6) NULL,
    INSTALLATION_DATE_ datetime(6) NULL,
    CONSTRAINT PK_FLW_DE_COMP_PROJ PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_COMP_PROJ_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_COMP_PROJ_KEY_TEN ON FLW_DE_CUSTOM_COMP_PROJECT (KEY_, TENANT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    PROJECT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    XML_TAG_ VARCHAR(255) NULL,
    VERSION_ VARCHAR(255) NULL,
    ICON_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    CREATE_DATE_ datetime(6) NULL,
    META_DATA_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_CUSTOM_COMP_KEY_PROJ ON FLW_DE_CUSTOM_COMPONENT (KEY_, PROJECT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMP_MODEL_REL (
    ID_ VARCHAR(255) NOT NULL,
    MODEL_ID_ VARCHAR(255) NOT NULL,
    PROJECT_KEY_ VARCHAR(255) NOT NULL,
    CUSTOM_COMPONENT_KEY_ VARCHAR(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_CUST_COMP_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_WRKS FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE INDEX FLW_DE_IDX_CUST_COMP_REL_MOD ON FLW_DE_CUSTOM_COMP_MODEL_REL (MODEL_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT_RES (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    BUNDLE_HASH_ VARCHAR(255) NULL,
    PROJECT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_RES_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

update FLW_DE_PROPERTY set VALUE_ = '74' where NAME_ = 'design.schema.version';


CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);

drop table FLW_LIC_DATABASECHANGELOG;
drop table FLW_LIC_DATABASECHANGELOGLOCK;


