

CREATE TABLE FLW_PAL_DATABASECHANGELOGLOCK (ID int NOT NULL, LOCKED bit NOT NULL, LOCKGRANTED datetime2(3), LOCKEDBY nvarchar(255), CONSTRAINT PK_FLW_PAL_DATABASECHANGELOGLOCK PRIMARY KEY (ID))

DELETE FROM FLW_PAL_DATABASECHANGELOGLOCK

INSERT INTO FLW_PAL_DATABASECHANGELOGLOCK (ID, LOCKED) VALUES (1, 0)

UPDATE FLW_PAL_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02T09:58:09.072' WHERE ID = 1 AND LOCKED = 0

CREATE TABLE FLW_PAL_DATABASECHANGELOG (ID nvarchar(255) NOT NULL, AUTHOR nvarchar(255) NOT NULL, FILENAME nvarchar(255) NOT NULL, DATEEXECUTED datetime2(3) NOT NULL, ORDEREXECUTED int NOT NULL, EXECTYPE nvarchar(10) NOT NULL, MD5SUM nvarchar(35), DESCRIPTION nvarchar(255), COMMENTS nvarchar(255), TAG nvarchar(255), LIQUIBASE nvarchar(20), CONTEXTS nvarchar(255), LABELS nvarchar(255), DEPLOYMENT_ID nvarchar(10))

CREATE TABLE FLW_PALETTE_DEPLOYMENT (ID_ nvarchar(255) NOT NULL, NAME_ nvarchar(255), CATEGORY_ nvarchar(255), KEY_ nvarchar(255), DEPLOY_TIME_ datetime2(6), PARENT_DEPLOYMENT_ID_ nvarchar(255), TENANT_ID_ nvarchar(255) CONSTRAINT DF_FLW_PALETTE_DEPLOYMENT_TENANT_ID_ DEFAULT '', CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_))

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (ID_ nvarchar(255) NOT NULL, NAME_ nvarchar(255), DEPLOYMENT_ID_ nvarchar(255), RESOURCE_BYTES_ varbinary(MAX), CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_))

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_)

CREATE NONCLUSTERED INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES(DEPLOYMENT_ID_)

CREATE TABLE FLW_PALETTE_DEFINITION (ID_ nvarchar(255) NOT NULL, REV_ int NOT NULL, NAME_ nvarchar(255), KEY_ nvarchar(255) NOT NULL, VERSION_ int NOT NULL, DEPLOYMENT_ID_ nvarchar(255), RESOURCE_NAME_ nvarchar(4000), DESCRIPTION_ nvarchar(4000), SCOPE_TYPE_ nvarchar(255), TENANT_ID_ nvarchar(255) CONSTRAINT DF_FLW_PALETTE_DEFINITION_TENANT_ID_ DEFAULT '', CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_))

CREATE UNIQUE NONCLUSTERED INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION(KEY_, VERSION_, TENANT_ID_)

ALTER TABLE FLW_PALETTE_DEFINITION ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_)

CREATE NONCLUSTERED INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION(DEPLOYMENT_ID_)

INSERT INTO FLW_PAL_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1', 'flowable', 'com/flowable/palette/db/liquibase/flowable-palette-db-changelog.xml', GETDATE(), 1, '8:c051c0eb070ba1bfed1f133e88ee59ca', 'createTable tableName=FLW_PALETTE_DEPLOYMENT; createTable tableName=FLW_PALETTE_DEPLOYMENT_RES; addForeignKeyConstraint baseTableName=FLW_PALETTE_DEPLOYMENT_RES, constraintName=FLW_FK_PALETTE_RSRC_DPL, referencedTableName=FLW_PALETTE_DEPLOYMENT; c...', '', 'EXECUTED', NULL, NULL, '4.3.5', '3792289685')

UPDATE FLW_PAL_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1



UPDATE ACT_DE_DATABASECHANGELOGLOCK SET LOCKED = 1, LOCKEDBY = '192.168.10.1 (192.168.10.1)', LOCKGRANTED = '2022-02-02T09:58:10.769' WHERE ID = 1 AND LOCKED = 0

CREATE TABLE FLW_DE_TENANT (TENANT_ID_ varchar(255) NOT NULL, CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (TENANT_ID_))

INSERT INTO FLW_DE_TENANT (TENANT_ID_) VALUES ('default')

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('7', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', GETDATE(), 7, '8:23bc223608ea31a73f17ca2adb0a13b8', 'createTable tableName=FLW_DE_TENANT; insert tableName=FLW_DE_TENANT', '', 'EXECUTED', NULL, NULL, '4.3.5', '3792291237')

ALTER TABLE ACT_DE_MODEL_RELATION ADD app_model_id varchar(255)

ALTER TABLE ACT_DE_MODEL_METADATA ADD scope_info varchar(MAX)

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('8', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', GETDATE(), 8, '8:4e404d08cf64d77c45dc56bb8e436ab4', 'addColumn tableName=ACT_DE_MODEL_RELATION; addColumn tableName=ACT_DE_MODEL_METADATA', '', 'EXECUTED', NULL, NULL, '4.3.5', '3792291237')

CREATE TABLE ACT_DE_MODEL_RESOURCE (ID_ varchar(255) NOT NULL, NAME_ varchar(255), TYPE_ varchar(255), CREATION_TIME_ datetime2 NOT NULL, MODEL_ID_ varchar(255), RESOURCE_BYTES_ varbinary(MAX), RESOURCE_TYPE_ varchar(255), CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_))

ALTER TABLE ACT_DE_MODEL_RESOURCE ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id)

CREATE NONCLUSTERED INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE(MODEL_ID_)

INSERT INTO ACT_DE_DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('9', 'flowable', 'META-INF/liquibase/flowable-modeler-app-db-changelog.xml', GETDATE(), 9, '8:7ef6226e5b7ebb80e002b30ee84e92fc', 'createTable tableName=ACT_DE_MODEL_RESOURCE; addForeignKeyConstraint baseTableName=ACT_DE_MODEL_RESOURCE, constraintName=fk_model_resource, referencedTableName=ACT_DE_MODEL; createIndex indexName=idx_model_resource, tableName=ACT_DE_MODEL_RESOURCE', '', 'EXECUTED', NULL, NULL, '4.3.5', '3792291237')

UPDATE ACT_DE_DATABASECHANGELOGLOCK SET LOCKED = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1

