CREATE TABLE FLW_DE_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);
insert into FLW_DE_PROPERTY
    values ('design.schema.version', '71', 1);
drop table ACT_DE_DATABASECHANGELOGLOCK;
drop table ACT_DE_DATABASECHANGELOG;
drop table FLW_PAL_DATABASECHANGELOGLOCK;
drop table FLW_PAL_DATABASECHANGELOG;



CREATE TABLE FLW_DE_MODEL_GENERATION (
    ID_ varchar(255) NOT NULL,
    WORKSPACE_ID_ varchar(255) NOT NULL,
    PACKAGE_ID_ varchar(255),
    NAME_ nvarchar(255),
    PROMPT_ nvarchar(2000),
    GENERATION_TYPE_ varchar(255),
    SCOPE_TYPE_ varchar(255),
    STATUS_ varchar(255),
    CREATED_ datetime,
    LAST_UPDATED_ datetime,
    CONSTRAINT FLW_DE_PK_MODEL_GEN PRIMARY KEY (ID_)
);
ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);
ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PACKAGE FOREIGN KEY (PACKAGE_ID_) REFERENCES ACT_DE_MODEL (id);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_WORKSPACE ON FLW_DE_MODEL_GENERATION (WORKSPACE_ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PACKAGE ON FLW_DE_MODEL_GENERATION (PACKAGE_ID_);
CREATE TABLE FLW_DE_MODEL_GENERATION_PART (
    ID_ varchar(255) NOT NULL,
    MODEL_GENERATION_ID_ varchar(255) NOT NULL,
    KEY_ varchar(255),
    NAME_ nvarchar(255),
    USER_PROMPT_ varchar(MAX),
    SYSTEM_PROMPT_ varchar(MAX),
    STATUS_ varchar(255),
    TYPE_ varchar(255),
    RESPONSE_ varchar(MAX),
    MODEL_CONTENT_ varchar(MAX),
    PART_REFERENCE_ varchar(255),
    PART_COUNT_ int,
    REFERENCE_SCOPE_KEY_ varchar(255),
    REFERENCE_SCOPE_TYPE_ varchar(255),
    CREATED_ datetime,
    LAST_UPDATED_ datetime,
    CONSTRAINT FLW_DE_PK_MODEL_GEN_PART PRIMARY KEY (ID_)
);
ALTER TABLE FLW_DE_MODEL_GENERATION_PART
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PART_MOD_GEN FOREIGN KEY (MODEL_GENERATION_ID_) REFERENCES FLW_DE_MODEL_GENERATION (ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PART_GEN ON FLW_DE_MODEL_GENERATION_PART (MODEL_GENERATION_ID_);



update ACT_DE_MODEL set visibility_ = 'public' where visibility_ = 'internal';



CREATE TABLE FLW_DE_CUSTOM_COMP_PROJECT (
    ID_ varchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ nvarchar(255) NOT NULL,
    NAME_ nvarchar(255),
    STATE_ nvarchar(255),
    UPLOADED_BUNDLE_HASH_ nvarchar(255),
    INSTALLED_BUNDLE_HASH_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    TENANT_ID_ varchar(255),
    CREATE_DATE_ datetime2(6),
    INSTALLATION_DATE_ datetime2(6),
    CONSTRAINT PK_FLW_DE_COMP_PROJ PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_COMP_PROJ_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_DE_IDX_COMP_PROJ_KEY_TEN ON FLW_DE_CUSTOM_COMP_PROJECT(KEY_, TENANT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT (
    ID_ varchar(255) NOT NULL,
    REV_ int NOT NULL,
    KEY_ nvarchar(255) NOT NULL,
    PROJECT_ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    STATE_ nvarchar(255),
    XML_TAG_ nvarchar(255),
    VERSION_ nvarchar(255),
    ICON_ nvarchar(255),
    DESCRIPTION_ nvarchar(4000),
    CREATE_DATE_ datetime2(6),
    META_DATA_ nvarchar(MAX),
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE UNIQUE NONCLUSTERED INDEX FLW_DE_IDX_CUSTOM_COMP_KEY_PROJ ON FLW_DE_CUSTOM_COMPONENT(KEY_, PROJECT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMP_MODEL_REL (
    ID_ varchar(255) NOT NULL,
    MODEL_ID_ varchar(255) NOT NULL,
    PROJECT_KEY_ nvarchar(255) NOT NULL,
    CUSTOM_COMPONENT_KEY_ nvarchar(255) NOT NULL,
    WORKSPACE_ID_ varchar(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_CUST_COMP_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_WRKS FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE NONCLUSTERED INDEX FLW_DE_IDX_CUST_COMP_REL_MOD ON FLW_DE_CUSTOM_COMP_MODEL_REL(MODEL_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT_RES (
    ID_ varchar(255) NOT NULL,
    NAME_ nvarchar(255),
    BUNDLE_HASH_ nvarchar(255),
    PROJECT_ID_ varchar(255),
    RESOURCE_BYTES_ varbinary(MAX),    
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_RES_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

update FLW_DE_PROPERTY set VALUE_ = '74' where NAME_ = 'design.schema.version';


CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ nvarchar(64),
    VALUE_ nvarchar(300),
    REV_ int,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);

drop table FLW_LIC_DATABASECHANGELOG;
drop table FLW_LIC_DATABASECHANGELOGLOCK;


