
CREATE TABLE ACT_DE_MODEL (
    id VARCHAR2(255) NOT NULL,
    name VARCHAR2(400) NOT NULL,
    model_key VARCHAR2(400) NOT NULL,
    description VARCHAR2(4000),
    model_comment VARCHAR2(4000),
    created TIMESTAMP(6),
    created_by VARCHAR2(255),
    last_updated TIMESTAMP(6),
    last_updated_by VARCHAR2(255),
    version INTEGER,
    model_type INTEGER,
    model_sub_type VARCHAR2(64),
    model_editor_json CLOB,
    thumbnail BLOB,
    model_svg CLOB,
    palette_def_category_ VARCHAR2(64),
    palette_def_key_ VARCHAR2(64),
    latest_deployment_id VARCHAR2(64),
    visibility_ VARCHAR2(15) DEFAULT 'internal' NOT NULL,
    template_ NUMBER(1) DEFAULT 0,
    locked_by_ VARCHAR2(255),
    locked_at_ TIMESTAMP(6),
    workspace_id_ VARCHAR2(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL PRIMARY KEY (id)
);

CREATE INDEX idx_proc_mod_created ON ACT_DE_MODEL (created_by);

CREATE TABLE ACT_DE_MODEL_HISTORY (
    id VARCHAR2(255) NOT NULL,
    name VARCHAR2(400) NOT NULL,
    model_key VARCHAR2(400) NOT NULL,
    description VARCHAR2(4000),
    model_comment VARCHAR2(4000),
    created TIMESTAMP(6),
    created_by VARCHAR2(255),
    last_updated TIMESTAMP(6),
    last_updated_by VARCHAR2(255),
    removal_date TIMESTAMP(6),
    version INTEGER,
    model_editor_json CLOB,
    model_id VARCHAR2(255) NOT NULL,
    model_type INTEGER,
    model_sub_type VARCHAR2(64),
    model_svg CLOB,
    palette_def_category_ VARCHAR2(64),
    palette_def_key_ VARCHAR2(64),
    latest_deployment_id VARCHAR2(64),
    tags_json VARCHAR2(400),
    workspace_id_ VARCHAR2(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_HISTORY PRIMARY KEY (id)
);

CREATE INDEX idx_proc_mod_history_proc ON ACT_DE_MODEL_HISTORY (model_id);

CREATE TABLE ACT_DE_MODEL_RELATION (
    id VARCHAR2(255) NOT NULL,
    parent_model_id VARCHAR2(255),
    model_id VARCHAR2(255),
    model_key VARCHAR2(255),
    model_type INTEGER,
    relation_type VARCHAR2(255),
    app_model_id VARCHAR2(255),
    workspace_id_ VARCHAR2(255),
    CONSTRAINT PK_ACT_DE_MODEL_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_parent FOREIGN KEY (parent_model_id) REFERENCES ACT_DE_MODEL (id);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_child FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE ACT_DE_USER (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER DEFAULT '1' NOT NULL,
    FIRST_NAME_ VARCHAR2(256) NOT NULL,
    LAST_NAME_ VARCHAR2(400) NOT NULL,
    DISPLAY_NAME_ VARCHAR2(400) NOT NULL,
    PASSWORD_ VARCHAR2(128),
    EMAIL_ VARCHAR2(256),
    TENANT_ID_ VARCHAR2(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_USER PRIMARY KEY (ID_)
);

CREATE TABLE ACT_DE_TOKEN (
    ID_ VARCHAR2(64) NOT NULL,
    TOKEN_VALUE_ VARCHAR2(255),
    TOKEN_DATE_ TIMESTAMP(6),
    IP_ADDRESS_ VARCHAR2(255),
    USER_AGENT_ VARCHAR2(255),
    USER_ID_ VARCHAR2(255),
    TOKEN_DATA_ VARCHAR2(2000),
    CONSTRAINT PK_ACT_DE_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_TENANT (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER DEFAULT '1' NOT NULL,
    NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(4000),
    CREATED_AT_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (ID_)
);

INSERT INTO FLW_DE_TENANT (ID_)
    VALUES ('default');

CREATE TABLE ACT_DE_MODEL_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    CREATION_TIME_ TIMESTAMP NOT NULL,
    MODEL_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    RESOURCE_TYPE_ VARCHAR2(255),
    CREATOR_ID_ VARCHAR2(255),
    UPDATE_TIME_ TIMESTAMP,
    UPDATER_ID_ VARCHAR2(255),
    CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_DE_MODEL_RESOURCE
    ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE (MODEL_ID_);

CREATE TABLE ACT_DE_MODEL_TAG (
    id VARCHAR2(255) NOT NULL,
    name VARCHAR2(400) NOT NULL,
    tenant_id VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG PRIMARY KEY (id)
);

CREATE TABLE ACT_DE_MODEL_TAG_RELATION (
    id VARCHAR2(255) NOT NULL,
    model_tag_id VARCHAR2(255) NOT NULL,
    model_id VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_tag FOREIGN KEY (model_tag_id) REFERENCES ACT_DE_MODEL_TAG (id);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_model FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE FLW_DE_WORKSPACE (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(255) NOT NULL,
    SHARED_WORKSPACE_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(4000),
    ALLOWED_PACKAGE_TYPE_ INTEGER DEFAULT 3 NOT NULL,
    VISIBILITY_ VARCHAR2(15) DEFAULT 'private' NOT NULL,
    CREATED_AT_ TIMESTAMP(6) NOT NULL,
    CREATED_BY_ VARCHAR2(255),
    UPDATED_AT_ TIMESTAMP(6),
    UPDATED_BY_ VARCHAR2(255),
    CONSTRAINT PK_FLW_DE_WORKSPACE PRIMARY KEY (ID_),
    CONSTRAINT FK_FLW_DE_WORKSPACE_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT UQ_FLW_DE_WORKSPACE_KEY_TENANT UNIQUE (KEY_, TENANT_ID_);

INSERT INTO FLW_DE_WORKSPACE (ID_, REV_, KEY_, TENANT_ID_, NAME_, VISIBILITY_, CREATED_AT_)
    VALUES (regexp_replace(lower(SYS_GUID()), '(.{8})(.{4})(.{4})(.{4})(.{12})', '\1-\2-\3-\4-\5'), 1, 'default', 'default', 'Generated default', 'public', sysdate);

CREATE TABLE FLW_DE_IDENTITY_LINK (
    ID_ VARCHAR2(64) NOT NULL,
    USER_ID_ VARCHAR2(255),
    GROUP_ID_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    SCOPE_ID_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    CONSTRAINT PK_FLW_DE_IDENTITY_LINK PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_USER ON FLW_DE_IDENTITY_LINK (USER_ID_);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_GROUP ON FLW_DE_IDENTITY_LINK (GROUP_ID_);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_SCOPE ON FLW_DE_IDENTITY_LINK (SCOPE_TYPE_, SCOPE_ID_);

CREATE TABLE FLW_DE_PRIVILEGE_MAPPING (
    ID_ VARCHAR2(64) NOT NULL,
    PRIVILEGE_ VARCHAR2(64) NOT NULL,
    USER_ID_ VARCHAR2(255),
    GROUP_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_DE_PRIVILEGE_MAPPING PRIMARY KEY (ID_)
);

CREATE INDEX FLW_DE_IDX_PRIVILEGE_USER ON FLW_DE_PRIVILEGE_MAPPING (USER_ID_);

CREATE INDEX FLW_DE_IDX_PRIV_GROUP ON FLW_DE_PRIVILEGE_MAPPING (GROUP_ID_);

CREATE TABLE FLW_DE_APP_REVISION (
    ID_ VARCHAR2(255) NOT NULL,
    KEY_ VARCHAR2(400) NOT NULL,
    DESCRIPTION_ VARCHAR2(4000),
    CREATED_ TIMESTAMP(6),
    CREATED_BY_ VARCHAR2(255),
    APP_ID_ VARCHAR2(255) NOT NULL,
    EXPORT_BYTES_ BLOB,
    CONSTRAINT PK_FLW_DE_APP_REVISION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_FK_APP_REVISION_APP_ID FOREIGN KEY (APP_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE INDEX FLW_DE_IDX_APP_REVISION_APP_ID ON FLW_DE_APP_REVISION (APP_ID_);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_UQ_APP_REV_APP_ID_KEY UNIQUE (APP_ID_, KEY_);

CREATE TABLE FLW_DE_IDENTITY_INFO (
    ID_ VARCHAR2(64) NOT NULL,
    REV_ INTEGER NOT NULL,
    TYPE_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    USER_ID_ VARCHAR2(64) NOT NULL,
    DOUBLE_ DOUBLE PRECISION,
    LONG_ NUMBER(38, 0),
    TEXT_ VARCHAR2(4000),
    TEXT2_ VARCHAR2(4000),
    UPDATE_TIME_ TIMESTAMP(6),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_DE_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE INDEX FLW_DE_IDX_IDM_INFO_USER_ID ON FLW_DE_IDENTITY_INFO (USER_ID_);

ALTER TABLE FLW_DE_IDENTITY_INFO
    ADD CONSTRAINT FLW_DE_UQ_ID_INFO_TEN_USR_NAME UNIQUE (TENANT_ID_, USER_ID_, NAME_);

CREATE TABLE FLW_DE_ACCESS_TOKEN (
    ID_ VARCHAR2(64) NOT NULL,
    NAME_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(2000),
    CREATION_TIME_ TIMESTAMP(6) NOT NULL,
    EXPIRATION_TIME_ TIMESTAMP(6),
    USER_ID_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255) NOT NULL,
    TOKEN_VALUE_ VARCHAR2(2000),
    CONSTRAINT PK_FLW_DE_ACCESS_TOKEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT FK_FLW_DE_WORKSPACE_SHARED_ID FOREIGN KEY (SHARED_WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

CREATE INDEX ACT_DE_IDX_MODEL_REL_APP_ID ON ACT_DE_MODEL_RELATION (app_model_id);

CREATE INDEX ACT_DE_IDX_MODEL_REL_PARENT_ID ON ACT_DE_MODEL_RELATION (parent_model_id);

CREATE INDEX ACT_DE_IDX_MODEL_REL_MODEL_ID ON ACT_DE_MODEL_RELATION (model_id);

CREATE TABLE FLW_DE_MODEL_STAR (
    USER_ID_ VARCHAR2(255) NOT NULL,
    MODEL_ID_ VARCHAR2(255) NOT NULL
);

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_FK_MODEL_STAR_MODEL_ID FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_UQ_MODEL_STAR_USR_MODEL UNIQUE (USER_ID_, MODEL_ID_);
    
CREATE TABLE FLW_DE_CUSTOM_COMP_PROJECT (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    STATE_ VARCHAR2(255),
    UPLOADED_BUNDLE_HASH_ VARCHAR2(255),
    INSTALLED_BUNDLE_HASH_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(255),
    CREATE_DATE_ TIMESTAMP(6),
    INSTALLATION_DATE_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_DE_COMP_PROJ PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_COMP_PROJ_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_COMP_PROJ_KEY_TEN ON FLW_DE_CUSTOM_COMP_PROJECT (KEY_, TENANT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(255) NOT NULL,
    PROJECT_ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    STATE_ VARCHAR2(255),
    XML_TAG_ VARCHAR2(255),
    VERSION_ VARCHAR2(255),
    ICON_ VARCHAR2(255),
    DESCRIPTION_ VARCHAR2(4000),
    CREATE_DATE_ TIMESTAMP(6),
    META_DATA_ CLOB,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_CUSTOM_COMP_KEY_PRJ ON FLW_DE_CUSTOM_COMPONENT (KEY_, PROJECT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMP_MODEL_REL (
    ID_ VARCHAR2(255) NOT NULL,
    MODEL_ID_ VARCHAR2(255) NOT NULL,
    PROJECT_KEY_ VARCHAR2(255) NOT NULL,
    CUSTOM_COMPONENT_KEY_ VARCHAR2(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR2(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_CUST_COMP_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_WRKS FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE INDEX FLW_DE_IDX_CUST_COMP_REL_MOD ON FLW_DE_CUSTOM_COMP_MODEL_REL (MODEL_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT_RES (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    BUNDLE_HASH_ VARCHAR2(255),
    PROJECT_ID_ VARCHAR(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_RES_PROJ FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE TABLE FLW_DE_PLUGIN (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    KEY_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    VERSION_ VARCHAR2(255) NOT NULL,
    MAJOR_VERSION_ INTEGER NOT NULL,
    MINOR_VERSION_ INTEGER NOT NULL,
    PATCH_VERSION_ INTEGER NOT NULL,
    DESCRIPTION_ VARCHAR2(4000),
    TENANT_ID_ VARCHAR2(255),
    RELEASE_DATE_ TIMESTAMP(6),
    INSTALLATION_DATE_ TIMESTAMP(6),
    CONSTRAINT PK_FLW_DE_PLUGIN PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_PLUGIN_KEY_VER_TEN ON FLW_DE_PLUGIN (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DE_PLUGIN_RESOURCE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    PLUGIN_ID_ VARCHAR2(255) NOT NULL,
    REFERENCE_ VARCHAR2(255),
    REFERENCE_TYPE_ VARCHAR2(255),
    GENERATED_ NUMBER(1),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_PLUGIN_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_RES_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_)
);

CREATE INDEX FLW_DE_FK_PLUGIN_RES_PLUGIN ON FLW_DE_PLUGIN_RESOURCE (PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_LINK (
    ID_ VARCHAR2(255) NOT NULL,
    PLUGIN_KEY_ VARCHAR2(255) NOT NULL,
    PLUGIN_ID_ VARCHAR2(255) NOT NULL,
    USE_FIX_VERSION_ NUMBER(1) NOT NULL,
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255) NOT NULL,
    CONSTRAINT PK_PLUGIN_LINK PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_UQ_PLUG_LINK_KEY_SCOPE UNIQUE (PLUGIN_KEY_, SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_DE_IDX_PLUGIN_LINK_SCOPE ON FLW_DE_PLUGIN_LINK (SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_FK_PLUGIN_LINK_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_);

CREATE INDEX FLW_DE_IDX_PLUGIN_LINK_PLUG_ID ON FLW_DE_PLUGIN_LINK (PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_MODEL_RELATION (
    ID_ VARCHAR2(255) NOT NULL,
    MODEL_ID_ VARCHAR2(255) NOT NULL,
    PLUGIN_KEY_ VARCHAR2(255) NOT NULL,
    REFERENCE_KEY_ VARCHAR2(255) NOT NULL,
    REFERENCE_TYPE_ VARCHAR2(255) NOT NULL,
    TYPE_ VARCHAR2(255),
    WORKSPACE_ID_ VARCHAR2(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_PLUGIN_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id)
);

CREATE INDEX FLW_DE_IDX_PLUG_MOD_REL_MOD_ID ON FLW_DE_PLUGIN_MODEL_RELATION (MODEL_ID_);

CREATE TABLE FLW_DE_DEPLOYMENT_SERVER_INFO (
    ID_ VARCHAR2(255) NOT NULL,
    SCOPE_ID_ VARCHAR2(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255) NOT NULL,
    TENANT_ID_ VARCHAR2(255),
    DEPLOYMENT_TENANT_ID_ VARCHAR2(255),
    BASE_SERVER_ADDRESS_ VARCHAR2(2000) NOT NULL,
    AUTHENTICATION_TYPE_ VARCHAR2(100),
    USER_INFO_ VARCHAR2(255),
    SECRET_ VARCHAR2(2000),
    CONSTRAINT FLW_DE_PK_DEPL_SERVER_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_OAUTH_CLIENT_REG (
    ID_ VARCHAR2(255) NOT NULL,
    REGISTRATION_KEY_ VARCHAR2(255) NOT NULL,
    CLIENT_ID_ VARCHAR2(100) NOT NULL,
    CLIENT_SECRET_ VARCHAR2(255),
    CLIENT_NAME_ VARCHAR2(255),
    CLIENT_AUTHENTICATION_METHOD_ VARCHAR2(200),
    SCOPES_ VARCHAR2(2000),
    ISSUER_URI_ VARCHAR2(2000),
    TOKEN_URI_ VARCHAR2(2000),
    TENANT_ID_ VARCHAR2(255),
    CONSTRAINT FLW_DE_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_MODEL_GENERATION (
    ID_ VARCHAR2(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR2(255) NOT NULL,
    PACKAGE_ID_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    PROMPT_ CLOB,
    GENERATION_TYPE_ VARCHAR2(255),
    SCOPE_TYPE_ VARCHAR2(255),
    STATUS_ VARCHAR2(255),
    CREATED_ TIMESTAMP(6),
    LAST_UPDATED_ TIMESTAMP(6),
    CONSTRAINT FLW_DE_PK_MODEL_GEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PACKAGE FOREIGN KEY (PACKAGE_ID_) REFERENCES ACT_DE_MODEL (id);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_WORKSPACE ON FLW_DE_MODEL_GENERATION (WORKSPACE_ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PACKAGE ON FLW_DE_MODEL_GENERATION (PACKAGE_ID_);

CREATE TABLE FLW_DE_MODEL_GENERATION_PART (
    ID_ VARCHAR2(255) NOT NULL,
    MODEL_GENERATION_ID_ VARCHAR2(255) NOT NULL,
    KEY_ VARCHAR2(255),
    NAME_ VARCHAR2(255),
    USER_PROMPT_ CLOB,
    SYSTEM_PROMPT_ CLOB,
    STATUS_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    RESPONSE_ CLOB,
    MODEL_CONTENT_ CLOB,
    PART_REFERENCE_ VARCHAR2(255),
    PART_COUNT_ INTEGER,
    REFERENCE_SCOPE_KEY_ VARCHAR2(255),
    REFERENCE_SCOPE_TYPE_ VARCHAR2(255),
    CREATED_ TIMESTAMP(6),
    LAST_UPDATED_ TIMESTAMP(6),
    CONSTRAINT FLW_DE_PK_MODEL_GEN_PART PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION_PART
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PART_MOD_GEN FOREIGN KEY (MODEL_GENERATION_ID_) REFERENCES FLW_DE_MODEL_GENERATION (ID_);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_PART_GEN ON FLW_DE_MODEL_GENERATION_PART (MODEL_GENERATION_ID_);

CREATE TABLE FLW_PALETTE_DEPLOYMENT (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    KEY_ VARCHAR2(255),
    DEPLOY_TIME_ TIMESTAMP(6),
    PARENT_DEPLOYMENT_ID_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_BYTES_ BLOB,
    CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES
    ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES (DEPLOYMENT_ID_);

CREATE TABLE FLW_PALETTE_DEFINITION (
    ID_ VARCHAR2(255) NOT NULL,
    REV_ INTEGER NOT NULL,
    NAME_ VARCHAR2(255),
    KEY_ VARCHAR2(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ VARCHAR2(255),
    RESOURCE_NAME_ VARCHAR2(4000),
    DESCRIPTION_ VARCHAR2(4000),
    SCOPE_TYPE_ VARCHAR2(255),
    CATEGORY_ VARCHAR2(255),
    TENANT_ID_ VARCHAR2(255) DEFAULT '',
    CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_PALETTE_DEFINITION
    ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION (DEPLOYMENT_ID_);

CREATE TABLE FLW_DE_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    primary key (NAME_)
);

insert into FLW_DE_PROPERTY
    values ('design.schema.version', '75', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR2(255) NOT NULL, RESOURCE_BYTES_ BLOB, CREATION_TIME_ TIMESTAMP(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR2(255) NOT NULL, TIMESTAMP_ TIMESTAMP(6) NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL, TENANT_ID_ VARCHAR2(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR2(255), TIMESTAMP_ TIMESTAMP(6) NOT NULL, COUNT_ NUMBER(38, 0) NOT NULL, SCOPE_TYPE_ VARCHAR2(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR2(255) NOT NULL, SIGNATURE_ CLOB NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);

