
CREATE TABLE ACT_DE_MODEL (
    id VARCHAR(255) NOT NULL,
    name VARCHAR(400) NOT NULL,
    model_key VARCHAR(400) NOT NULL,
    `description` VARCHAR(4000) NULL,
    model_comment VARCHAR(4000) NULL,
    created datetime(6) NULL,
    created_by VARCHAR(255) NULL,
    last_updated datetime(6) NULL,
    last_updated_by VARCHAR(255) NULL,
    version INT NULL,
    model_editor_json LONGTEXT NULL,
    thumbnail LONGBLOB NULL,
    model_svg LONGTEXT NULL,
    latest_deployment_id VARCHAR(64) NULL,
    model_type INT NULL,
    model_sub_type VARCHAR(64) NULL,
    palette_def_category_ VARCHAR(64) NULL,
    palette_def_key_ VARCHAR(64) NULL,
    visibility_ VARCHAR(15) DEFAULT 'internal' NOT NULL,
    template_ TINYINT DEFAULT 0 NULL,
    workspace_id_ VARCHAR(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL PRIMARY KEY (id)
);

CREATE INDEX idx_proc_mod_created ON ACT_DE_MODEL (created_by);

CREATE TABLE ACT_DE_MODEL_HISTORY (
    id VARCHAR(255) NOT NULL,
    name VARCHAR(400) NOT NULL,
    model_key VARCHAR(400) NOT NULL,
    `description` VARCHAR(4000) NULL,
    model_comment VARCHAR(4000) NULL,
    created datetime(6) NULL,
    created_by VARCHAR(255) NULL,
    last_updated datetime(6) NULL,
    last_updated_by VARCHAR(255) NULL,
    removal_date datetime(6) NULL,
    version INT NULL,
    model_editor_json LONGTEXT NULL,
    model_svg LONGTEXT NULL,
    latest_deployment_id VARCHAR(64) NULL,
    model_id VARCHAR(255) NOT NULL,
    model_type INT NULL,
    model_sub_type VARCHAR(64) NULL,
    palette_def_category_ VARCHAR(64) NULL,
    palette_def_key_ VARCHAR(64) NULL,
    tags_json LONGTEXT,
    workspace_id_ VARCHAR(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_HISTORY PRIMARY KEY (id)
);

CREATE INDEX idx_proc_mod_history_proc ON ACT_DE_MODEL_HISTORY (model_id);

CREATE TABLE ACT_DE_MODEL_RELATION (
    id VARCHAR(255) NOT NULL,
    parent_model_id VARCHAR(255) NULL,
    model_id VARCHAR(255) NULL,
    relation_type VARCHAR(255) NULL,
    app_model_id VARCHAR(255) NULL,
    model_key VARCHAR(255) NULL,
    model_type INT NULL,
    workspace_id_ VARCHAR(255) NULL,
    CONSTRAINT PK_ACT_DE_MODEL_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_parent FOREIGN KEY (parent_model_id) REFERENCES ACT_DE_MODEL (id);

ALTER TABLE ACT_DE_MODEL_RELATION
    ADD CONSTRAINT fk_relation_child FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE ACT_DE_USER (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT DEFAULT 1 NOT NULL,
    FIRST_NAME_ VARCHAR(256) NOT NULL,
    LAST_NAME_ VARCHAR(400) NOT NULL,
    DISPLAY_NAME_ VARCHAR(400) NOT NULL,
    PASSWORD_ VARCHAR(128) NULL,
    EMAIL_ VARCHAR(256) NULL,
    TENANT_ID_ VARCHAR(256) NOT NULL,
    CONSTRAINT PK_ACT_DE_USER PRIMARY KEY (ID_)
);

CREATE TABLE ACT_DE_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    TOKEN_VALUE_ VARCHAR(255) NULL,
    TOKEN_DATE_ datetime(6) NULL,
    IP_ADDRESS_ VARCHAR(255) NULL,
    USER_AGENT_ VARCHAR(255) NULL,
    USER_ID_ VARCHAR(255) NULL,
    TOKEN_DATA_ VARCHAR(2000) NULL,
    CONSTRAINT PK_ACT_DE_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_TENANT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT DEFAULT 1 NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    CREATED_AT_ datetime(6) NULL,
    CONSTRAINT PK_FLW_DE_TENANT PRIMARY KEY (ID_)
);

INSERT INTO FLW_DE_TENANT (ID_)
    VALUES ('default');

CREATE TABLE ACT_DE_MODEL_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    CREATION_TIME_ datetime NOT NULL,
    MODEL_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    RESOURCE_TYPE_ VARCHAR(255) NULL,
    CREATOR_ID_ VARCHAR(255) NULL,
    UPDATE_TIME_ datetime NULL,
    UPDATER_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_ACT_DE_MODEL_RESOURCE PRIMARY KEY (ID_)
);

ALTER TABLE ACT_DE_MODEL_RESOURCE
    ADD CONSTRAINT fk_model_resource FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE INDEX idx_model_resource ON ACT_DE_MODEL_RESOURCE (MODEL_ID_);

CREATE TABLE ACT_DE_MODEL_TAG (
    id VARCHAR(255) NOT NULL,
    name VARCHAR(400) NOT NULL,
    tenant_id VARCHAR(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL
    ADD locked_by_ VARCHAR(255) NULL, ADD locked_at_ datetime(6) NULL;

CREATE TABLE ACT_DE_MODEL_TAG_RELATION (
    id VARCHAR(255) NOT NULL,
    model_tag_id VARCHAR(255) NOT NULL,
    model_id VARCHAR(255) NOT NULL,
    CONSTRAINT PK_ACT_DE_MODEL_TAG_RELATION PRIMARY KEY (id)
);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_tag FOREIGN KEY (model_tag_id) REFERENCES ACT_DE_MODEL_TAG (id);

ALTER TABLE ACT_DE_MODEL_TAG_RELATION
    ADD CONSTRAINT fk_tag_relation_model FOREIGN KEY (model_id) REFERENCES ACT_DE_MODEL (id);

CREATE TABLE FLW_DE_WORKSPACE (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    SHARED_WORKSPACE_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    VISIBILITY_ VARCHAR(15) DEFAULT 'private' NOT NULL,
    ALLOWED_PACKAGE_TYPE_ INT DEFAULT 3 NOT NULL,
    CREATED_AT_ datetime(6) NOT NULL,
    CREATED_BY_ VARCHAR(255) NULL,
    UPDATED_AT_ datetime(6) NULL,
    UPDATED_BY_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_DE_WORKSPACE PRIMARY KEY (ID_),
    CONSTRAINT FK_FLW_DE_WORKSPACE_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT UQ_FLW_DE_WORKSPACE_KEY_TENANT UNIQUE (KEY_, TENANT_ID_);

INSERT INTO FLW_DE_WORKSPACE (ID_, REV_, KEY_, TENANT_ID_, NAME_, VISIBILITY_, CREATED_AT_)
    VALUES (convert(uuid() using utf8mb4), 1, 'default', 'default', 'Generated default', 'public', now());

CREATE TABLE FLW_DE_IDENTITY_LINK (
    ID_ VARCHAR(64) NOT NULL,
    USER_ID_ VARCHAR(255) NULL,
    GROUP_ID_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    SCOPE_ID_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_DE_IDENTITY_LINK PRIMARY KEY (ID_)
);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_USER ON FLW_DE_IDENTITY_LINK (USER_ID_);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_GROUP ON FLW_DE_IDENTITY_LINK (GROUP_ID_);

CREATE INDEX IDX_FLW_DE_IDENT_LINK_SCOPE ON FLW_DE_IDENTITY_LINK (SCOPE_TYPE_, SCOPE_ID_);

CREATE TABLE FLW_DE_PRIVILEGE_MAPPING (
    ID_ VARCHAR(64) NOT NULL,
    PRIVILEGE_ VARCHAR(64) NOT NULL,
    USER_ID_ VARCHAR(255) NULL,
    GROUP_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_DE_PRIVILEGE_MAPPING PRIMARY KEY (ID_)
);

CREATE INDEX FLW_DE_IDX_PRIVILEGE_USER ON FLW_DE_PRIVILEGE_MAPPING (USER_ID_);

CREATE INDEX FLW_DE_IDX_PRIV_GROUP ON FLW_DE_PRIVILEGE_MAPPING (GROUP_ID_);

CREATE TABLE FLW_DE_APP_REVISION (
    ID_ VARCHAR(255) NOT NULL,
    KEY_ VARCHAR(400) NOT NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    CREATED_ datetime(6) NULL,
    CREATED_BY_ VARCHAR(255) NULL,
    APP_ID_ VARCHAR(255) NOT NULL,
    EXPORT_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_DE_APP_REVISION PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_FK_APP_REVISION_APP_ID FOREIGN KEY (APP_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

CREATE INDEX FLW_DE_IDX_APP_REVISION_APP_ID ON FLW_DE_APP_REVISION (APP_ID_);

ALTER TABLE FLW_DE_APP_REVISION
    ADD CONSTRAINT FLW_DE_UQ_APP_REV_APP_ID_KEY UNIQUE (APP_ID_, KEY_);

CREATE TABLE FLW_DE_IDENTITY_INFO (
    ID_ VARCHAR(64) NOT NULL,
    REV_ INT NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    USER_ID_ VARCHAR(64) NOT NULL,
    DOUBLE_ DOUBLE NULL,
    LONG_ BIGINT NULL,
    TEXT_ VARCHAR(4000) NULL,
    TEXT2_ VARCHAR(4000) NULL,
    UPDATE_TIME_ datetime(6) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_DE_IDENTITY_INFO PRIMARY KEY (ID_)
);

CREATE INDEX FLW_DE_IDX_IDM_INFO_USER_ID ON FLW_DE_IDENTITY_INFO (USER_ID_);

ALTER TABLE FLW_DE_IDENTITY_INFO
    ADD CONSTRAINT FLW_DE_UQ_ID_INFO_TEN_USR_NAME UNIQUE (TENANT_ID_, USER_ID_, NAME_);

CREATE TABLE FLW_DE_ACCESS_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(2000) NULL,
    CREATION_TIME_ datetime(6) NOT NULL,
    EXPIRATION_TIME_ datetime(6) NULL,
    USER_ID_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NOT NULL,
    TOKEN_VALUE_ VARCHAR(2000) NULL,
    CONSTRAINT PK_FLW_DE_ACCESS_TOKEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_WORKSPACE
    ADD CONSTRAINT FK_FLW_DE_WORKSPACE_SHARED_ID FOREIGN KEY (SHARED_WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

CREATE INDEX ACT_DE_IDX_MODEL_REL_APP_ID ON ACT_DE_MODEL_RELATION (app_model_id);

CREATE INDEX ACT_DE_IDX_MODEL_REL_PARENT_ID ON ACT_DE_MODEL_RELATION (parent_model_id);

CREATE INDEX ACT_DE_IDX_MODEL_REL_MODEL_ID ON ACT_DE_MODEL_RELATION (model_id);

CREATE TABLE FLW_DE_MODEL_STAR (
    USER_ID_ VARCHAR(255) NOT NULL,
    MODEL_ID_ VARCHAR(255) NOT NULL
);

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_FK_MODEL_STAR_MODEL_ID FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id) ON DELETE CASCADE;

ALTER TABLE FLW_DE_MODEL_STAR
    ADD CONSTRAINT FLW_DE_UQ_MODEL_STAR_USR_MODEL UNIQUE (USER_ID_, MODEL_ID_);
    
CREATE TABLE FLW_DE_CUSTOM_COMP_PROJECT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    UPLOADED_BUNDLE_HASH_ VARCHAR(255) NULL,
    INSTALLED_BUNDLE_HASH_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CREATE_DATE_ datetime(6) NULL,
    INSTALLATION_DATE_ datetime(6) NULL,
    CONSTRAINT PK_FLW_DE_COMP_PROJ PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_COMP_PROJ_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_COMP_PROJ_KEY_TEN ON FLW_DE_CUSTOM_COMP_PROJECT (KEY_, TENANT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    PROJECT_ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    STATE_ VARCHAR(255) NULL,
    XML_TAG_ VARCHAR(255) NULL,
    VERSION_ VARCHAR(255) NULL,
    ICON_ VARCHAR(255) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    CREATE_DATE_ datetime(6) NULL,
    META_DATA_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_CUSTOM_COMP_KEY_PROJ ON FLW_DE_CUSTOM_COMPONENT (KEY_, PROJECT_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMP_MODEL_REL (
    ID_ VARCHAR(255) NOT NULL,
    MODEL_ID_ VARCHAR(255) NOT NULL,
    PROJECT_KEY_ VARCHAR(255) NOT NULL,
    CUSTOM_COMPONENT_KEY_ VARCHAR(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_CUST_COMP_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_CUST_COMP_REL_WRKS FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE INDEX FLW_DE_IDX_CUST_COMP_REL_MOD ON FLW_DE_CUSTOM_COMP_MODEL_REL (MODEL_ID_);

CREATE TABLE FLW_DE_CUSTOM_COMPONENT_RES (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    BUNDLE_HASH_ VARCHAR(255) NULL,
    PROJECT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_FLW_DE_CUSTOM_COMPONENT_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_CUSTOM_COMP_RES_PROJECT FOREIGN KEY (PROJECT_ID_) REFERENCES FLW_DE_CUSTOM_COMP_PROJECT (ID_)
);

CREATE TABLE FLW_DE_PLUGIN (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    KEY_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    VERSION_ VARCHAR(255) NOT NULL,
    MAJOR_VERSION_ INT NOT NULL,
    MINOR_VERSION_ INT NOT NULL,
    PATCH_VERSION_ INT NOT NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    RELEASE_DATE_ datetime(6) NULL,
    INSTALLATION_DATE_ datetime(6) NULL,
    CONSTRAINT PK_FLW_DE_PLUGIN PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_TENANT FOREIGN KEY (TENANT_ID_) REFERENCES FLW_DE_TENANT (ID_)
);

CREATE UNIQUE INDEX FLW_DE_IDX_PLUGIN_KEY_VER_TEN ON FLW_DE_PLUGIN (KEY_, VERSION_, TENANT_ID_);

CREATE TABLE FLW_DE_PLUGIN_RESOURCE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    PLUGIN_ID_ VARCHAR(255) NOT NULL,
    REFERENCE_ VARCHAR(255) NULL,
    REFERENCE_TYPE_ VARCHAR(255) NULL,
    GENERATED_ TINYINT NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_PLUGIN_RES PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_RES_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_)
);

CREATE INDEX FLW_DE_FK_PLUGIN_RES_PLUGIN ON FLW_DE_PLUGIN_RESOURCE (PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_LINK (
    ID_ VARCHAR(255) NOT NULL,
    PLUGIN_KEY_ VARCHAR(255) NOT NULL,
    PLUGIN_ID_ VARCHAR(255) NOT NULL,
    USE_FIX_VERSION_ TINYINT NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NOT NULL,
    CONSTRAINT PK_PLUGIN_LINK PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_UQ_PLUG_LINK_KEY_SCOPE UNIQUE (PLUGIN_KEY_, SCOPE_ID_, SCOPE_TYPE_);

CREATE INDEX FLW_DE_IDX_PLUGIN_LINK_SCOPE ON FLW_DE_PLUGIN_LINK (SCOPE_ID_, SCOPE_TYPE_);

ALTER TABLE FLW_DE_PLUGIN_LINK
    ADD CONSTRAINT FLW_DE_FK_PLUGIN_LINK_PLUGIN FOREIGN KEY (PLUGIN_ID_) REFERENCES FLW_DE_PLUGIN (ID_);

CREATE INDEX FLW_DE_IDX_PLUGIN_LINK_PLUG_ID ON FLW_DE_PLUGIN_LINK (PLUGIN_ID_);

CREATE TABLE FLW_DE_PLUGIN_MODEL_RELATION (
    ID_ VARCHAR(255) NOT NULL,
    MODEL_ID_ VARCHAR(255) NOT NULL,
    PLUGIN_KEY_ VARCHAR(255) NOT NULL,
    REFERENCE_KEY_ VARCHAR(255) NOT NULL,
    REFERENCE_TYPE_ VARCHAR(255) NOT NULL,
    TYPE_ VARCHAR(255) NULL,
    WORKSPACE_ID_ VARCHAR(255) NOT NULL,
    CONSTRAINT FLW_DE_PK_PLUGIN_MODEL_REL PRIMARY KEY (ID_),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_MODEL FOREIGN KEY (MODEL_ID_) REFERENCES ACT_DE_MODEL (id),
    CONSTRAINT FLW_DE_FK_PLUGIN_REL_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_)
);

CREATE INDEX FLW_DE_IDX_PLUG_MOD_REL_MOD_ID ON FLW_DE_PLUGIN_MODEL_RELATION (MODEL_ID_);

CREATE TABLE FLW_DE_DEPLOYMENT_SERVER_INFO (
    ID_ VARCHAR(255) NOT NULL,
    SCOPE_ID_ VARCHAR(255) NOT NULL,
    SCOPE_TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    DEPLOYMENT_TENANT_ID_ VARCHAR(255) NULL,
    BASE_SERVER_ADDRESS_ VARCHAR(2000) NOT NULL,
    AUTHENTICATION_TYPE_ VARCHAR(100) NULL,
    USER_INFO_ VARCHAR(255) NULL,
    SECRET_ VARCHAR(2000) NULL,
    CONSTRAINT FLW_DE_PK_DEPL_SERVER_INFO PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_OAUTH_CLIENT_REG (
    ID_ VARCHAR(255) NOT NULL,
    REGISTRATION_KEY_ VARCHAR(255) NOT NULL,
    CLIENT_ID_ VARCHAR(100) NOT NULL,
    CLIENT_SECRET_ VARCHAR(255) NULL,
    CLIENT_NAME_ VARCHAR(255) NULL,
    CLIENT_AUTHENTICATION_METHOD_ VARCHAR(200) NULL,
    SCOPES_ VARCHAR(2000) NULL,
    ISSUER_URI_ VARCHAR(2000) NULL,
    TOKEN_URI_ VARCHAR(2000) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    CONSTRAINT FLW_DE_PK_OAUTH_CLIENT_REG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_DE_MODEL_GENERATION (
    ID_ VARCHAR(255) NOT NULL,
    WORKSPACE_ID_ VARCHAR(255) NOT NULL,
    PACKAGE_ID_ VARCHAR(255),
    NAME_ VARCHAR(255) NULL,
    PROMPT_ TEXT NULL,
    GENERATION_TYPE_ VARCHAR(255) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    STATUS_ VARCHAR(255) NULL,
    CREATED_ datetime(6),
    LAST_UPDATED_ datetime(6) NULL,
    CONSTRAINT FLW_DE_PK_MODEL_GEN PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_WORKSPACE FOREIGN KEY (WORKSPACE_ID_) REFERENCES FLW_DE_WORKSPACE (ID_);

ALTER TABLE FLW_DE_MODEL_GENERATION
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PACKAGE FOREIGN KEY (PACKAGE_ID_) REFERENCES ACT_DE_MODEL (id);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_WORKSPACE ON FLW_DE_MODEL_GENERATION (WORKSPACE_ID_);
CREATE INDEX FLW_DE_IDX_MODEL_GEN_PACKAGE ON FLW_DE_MODEL_GENERATION (PACKAGE_ID_);

CREATE TABLE FLW_DE_MODEL_GENERATION_PART (
    ID_ VARCHAR(255) NOT NULL,
    MODEL_GENERATION_ID_ VARCHAR(255) NOT NULL,
    KEY_ VARCHAR(255) NULL,
    NAME_ VARCHAR(255) NULL,
    USER_PROMPT_ TEXT NULL,
    SYSTEM_PROMPT_ TEXT NULL,
    STATUS_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    RESPONSE_ TEXT NULL,
    MODEL_CONTENT_ TEXT NULL,
    PART_REFERENCE_ VARCHAR(255) NULL,
    PART_COUNT_ INTEGER NULL,
    REFERENCE_SCOPE_KEY_ VARCHAR(255) NULL,
    REFERENCE_SCOPE_TYPE_ VARCHAR(255) NULL,
    CREATED_ datetime(6),
    LAST_UPDATED_ datetime(6) NULL,
    CONSTRAINT FLW_DE_PK_MODEL_GEN_PART PRIMARY KEY (ID_)
);

ALTER TABLE FLW_DE_MODEL_GENERATION_PART
    ADD CONSTRAINT FLW_FK_MODEL_GEN_PART_MOD_GEN FOREIGN KEY (MODEL_GENERATION_ID_) REFERENCES FLW_DE_MODEL_GENERATION (ID_);

CREATE INDEX FLW_DE_IDX_MODEL_GEN_PART_GEN ON FLW_DE_MODEL_GENERATION_PART (MODEL_GENERATION_ID_);

CREATE TABLE FLW_PALETTE_DEPLOYMENT (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NULL,
    DEPLOY_TIME_ datetime(6) NULL,
    PARENT_DEPLOYMENT_ID_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_PALETTE_DEPLOYMENT PRIMARY KEY (ID_)
);

CREATE TABLE FLW_PALETTE_DEPLOYMENT_RES (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_BYTES_ LONGBLOB NULL,
    CONSTRAINT PK_PALETTE_DEPLOYMENT_RES PRIMARY KEY (ID_)
);

ALTER TABLE FLW_PALETTE_DEPLOYMENT_RES
    ADD CONSTRAINT FLW_FK_PALETTE_RSRC_DPL FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_RSRC_DPL ON FLW_PALETTE_DEPLOYMENT_RES (DEPLOYMENT_ID_);

CREATE TABLE FLW_PALETTE_DEFINITION (
    ID_ VARCHAR(255) NOT NULL,
    REV_ INT NOT NULL,
    NAME_ VARCHAR(255) NULL,
    KEY_ VARCHAR(255) NOT NULL,
    VERSION_ INT NOT NULL,
    DEPLOYMENT_ID_ VARCHAR(255) NULL,
    RESOURCE_NAME_ VARCHAR(4000) NULL,
    DESCRIPTION_ VARCHAR(4000) NULL,
    SCOPE_TYPE_ VARCHAR(255) NULL,
    CATEGORY_ VARCHAR(255) NULL,
    TENANT_ID_ VARCHAR(255) DEFAULT '' NULL,
    CONSTRAINT PK_FLW_PALETTE_DEFINITION PRIMARY KEY (ID_)
);

CREATE UNIQUE INDEX FLW_IDX_PALETTE_DEF_UNIQ ON FLW_PALETTE_DEFINITION (KEY_, VERSION_, TENANT_ID_);

ALTER TABLE FLW_PALETTE_DEFINITION
    ADD CONSTRAINT FLW_FK_PALETTE_DEF_DPLY FOREIGN KEY (DEPLOYMENT_ID_) REFERENCES FLW_PALETTE_DEPLOYMENT (ID_);

CREATE INDEX FLW_IDX_PALETTE_DEF_DPLY ON FLW_PALETTE_DEFINITION (DEPLOYMENT_ID_);

CREATE TABLE FLW_DE_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_DE_PROPERTY
    values ('design.schema.version', '75', 1);


CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR(255) NOT NULL, RESOURCE_BYTES_ LONGBLOB NULL, CREATION_TIME_ datetime(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR(255) NOT NULL, TIMESTAMP_ datetime(6) NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(255) NULL);

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR(255) NULL, TIMESTAMP_ datetime(6) NOT NULL, COUNT_ BIGINT NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR(255) NOT NULL, SIGNATURE_ LONGTEXT NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);

