
CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR2(255) NOT NULL, RESOURCE_BYTES_ BLOB, CREATION_TIME_ TIMESTAMP(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR2(255) NOT NULL, TIMESTAMP_ TIMESTAMP(6) NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL, TENANT_ID_ VARCHAR2(255));

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR2(255), TIMESTAMP_ TIMESTAMP(6) NOT NULL, COUNT_ NUMBER(38, 0) NOT NULL, SCOPE_TYPE_ VARCHAR2(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR2(255) NOT NULL, SIGNATURE_ CLOB NOT NULL, APPLICATION_ VARCHAR2(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_CTRL_SERVER_CONFIG (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(50),
    DESCRIPTION_ VARCHAR2(255),
    SERVER_ADDRESS_ VARCHAR2(100),
    PORT_ INTEGER,
    CONTEXT_ROOT_ VARCHAR2(100),
    REST_ROOT_ VARCHAR2(100),
    USER_NAME_ VARCHAR2(100),
    PASSWORD_ VARCHAR2(100),
    ENDPOINT_TYPE_ INTEGER,
    CLUSTER_ID_ VARCHAR2(255) DEFAULT '' NOT NULL,
    CLUSTER_OVERRIDE_ NUMBER(1) DEFAULT 0 NOT NULL,
    AUTHENTICATION_TYPE_ VARCHAR2(100) DEFAULT 'basic',
    TENANT_ID_ VARCHAR2(50),
    CONSTRAINT PK_FLW_CTRL_SERVER_CONFIG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_USER (
    ID_ VARCHAR2(255) NOT NULL,
    FIRST_NAME_ VARCHAR2(256) NOT NULL,
    LAST_NAME_ VARCHAR2(400) NOT NULL,
    DISPLAY_NAME_ VARCHAR2(400) NOT NULL,
    USERNAME_ VARCHAR2(128) NOT NULL,
    PASSWORD_ VARCHAR2(128),
    EMAIL_ VARCHAR2(256),
    TENANT_ID_ VARCHAR2(256),
    IS_ADMIN_ NUMBER(1),
    CONTROL_RIGHTS_ CLOB,
    CONSTRAINT PK_FLW_CTRL_USER PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_TOKEN (
    ID_ VARCHAR2(64) NOT NULL,
    TOKEN_VALUE_ VARCHAR2(255),
    TOKEN_DATE_ TIMESTAMP(6),
    IP_ADDRESS_ VARCHAR2(255),
    USER_AGENT_ VARCHAR2(255),
    USER_ID_ VARCHAR2(255),
    TOKEN_DATA_ VARCHAR2(2000),
    CONSTRAINT PK_FLW_CTRL_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_CLUSTER_CONFIG (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(50),
    DESCRIPTION_ VARCHAR2(255),
    SERVER_ADDRESS_ VARCHAR2(100),
    PORT_ INTEGER,
    CONTEXT_ROOT_ VARCHAR2(100),
    USER_NAME_ VARCHAR2(100),
    PASSWORD_ VARCHAR2(100),
    TYPE_ VARCHAR2(100),
    AUTHENTICATION_TYPE_ VARCHAR2(100) DEFAULT 'basic',
    MULTI_TENANCY_ NUMBER(1) DEFAULT '0' NOT NULL,
    TENANT_ID_ VARCHAR2(50),
    CONSTRAINT PK_FLW_CTRL_CLUSTER_CONFIG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_AUDIT_LOG (
    ID_ VARCHAR2(255) NOT NULL,
    CLUSTER_ID_ VARCHAR2(255),
    CREATED_BY_ VARCHAR2(255),
    CREATED_ON_ TIMESTAMP(6),
    TENANT_ID_ VARCHAR2(255),
    TYPE_ VARCHAR2(255),
    SUB_TYPE_ VARCHAR2(255),
    PAYLOAD_ CLOB,
    CONSTRAINT PK_FLW_CTRL_AUDIT_LOG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_ROLE (
    ID_ VARCHAR2(255) NOT NULL,
    NAME_ VARCHAR2(255),
    PRIVILEGES_ CLOB,
    CONSTRAINT PK_FLW_CTRL_ROLE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_ROLE_USER_MAPPING (
    ID_ VARCHAR2(64) NOT NULL,
    USER_ID_ VARCHAR2(255),
    ROLE_ID_ VARCHAR2(255),
    GROUP_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_CTRL_ROLE_USER_MAPPING PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CTRL_USER
    ADD CONSTRAINT FLW_CTRL_UNIQ_USERNAME UNIQUE (USERNAME_);

CREATE TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING (
    ID_ VARCHAR2(255) NOT NULL,
    AUTHORITY_ VARCHAR2(255),
    CLUSTER_CONFIG_ID_ VARCHAR2(255),
    CONSTRAINT PK_FLW_CTRL_AUTH_CLUSTER_MAPPI PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING
    ADD CONSTRAINT FLW_CTRL_FK_CLUSTER_CONFIG FOREIGN KEY (CLUSTER_CONFIG_ID_) REFERENCES FLW_CTRL_CLUSTER_CONFIG (ID_) ON DELETE CASCADE;

CREATE INDEX FLW_CTRL_IDX_AUTHORITY_ ON FLW_CTRL_AUTH_CLUSTER_MAPPING (AUTHORITY_);

CREATE INDEX FLW_CTRL_IDX_PRIVILEGE_GROUP ON FLW_CTRL_ROLE_USER_MAPPING (GROUP_ID_);

CREATE INDEX FLW_CTRL_IDX_PRIVILEGE_ROLE ON FLW_CTRL_ROLE_USER_MAPPING (ROLE_ID_);

CREATE TABLE FLW_CTRL_PROPERTY (
    NAME_ NVARCHAR2(64),
    VALUE_ NVARCHAR2(300),
    REV_ INTEGER,
    primary key (NAME_)
);

insert into FLW_CTRL_PROPERTY
    values ('control.schema.version', '12', 1);

