
CREATE TABLE FLW_LIC_LICENSE (ID_ VARCHAR(255) NOT NULL, RESOURCE_BYTES_ LONGBLOB NULL, CREATION_TIME_ datetime(6) NOT NULL, CONSTRAINT PK_FLW_LIC_LICENSE PRIMARY KEY (ID_));

CREATE TABLE FLW_LIC_USER_LOGIN (USER_ID_ VARCHAR(255) NOT NULL, TIMESTAMP_ datetime(6) NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL, TENANT_ID_ VARCHAR(255) NULL);

CREATE TABLE FLW_LIC_INSTANCE_COUNT (TENANT_ID_ VARCHAR(255) NULL, TIMESTAMP_ datetime(6) NOT NULL, COUNT_ BIGINT NOT NULL, SCOPE_TYPE_ VARCHAR(255) NOT NULL, SCOPE_SUB_TYPE_ VARCHAR(255) NOT NULL, SIGNATURE_ LONGTEXT NOT NULL, APPLICATION_ VARCHAR(255) NOT NULL);

CREATE INDEX FLW_LIC_INST_COUNT_TIMESTAMP ON FLW_LIC_INSTANCE_COUNT(TIMESTAMP_);

CREATE TABLE FLW_LIC_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_LIC_PROPERTY
values ('license.schema.version', '5', 1);


CREATE TABLE FLW_CTRL_SERVER_CONFIG (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(50) NULL,
    DESCRIPTION_ VARCHAR(255) NULL,
    SERVER_ADDRESS_ VARCHAR(100) NULL,
    PORT_ INT NULL,
    CONTEXT_ROOT_ VARCHAR(100) NULL,
    REST_ROOT_ VARCHAR(100) NULL,
    USER_NAME_ VARCHAR(100) NULL,
    PASSWORD_ VARCHAR(100) NULL,
    ENDPOINT_TYPE_ INT NULL,
    CLUSTER_ID_ VARCHAR(255) DEFAULT '' NOT NULL,
    CLUSTER_OVERRIDE_ TINYINT DEFAULT 0 NOT NULL,
    AUTHENTICATION_TYPE_ VARCHAR(100) DEFAULT 'basic' NULL,
    TENANT_ID_ VARCHAR(50) NULL,
    CONSTRAINT PK_FLW_CTRL_SERVER_CONFIG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_USER (
    ID_ VARCHAR(255) NOT NULL,
    FIRST_NAME_ VARCHAR(256) NOT NULL,
    LAST_NAME_ VARCHAR(400) NOT NULL,
    DISPLAY_NAME_ VARCHAR(400) NOT NULL,
    USERNAME_ VARCHAR(128) NOT NULL,
    PASSWORD_ VARCHAR(128) NULL,
    EMAIL_ VARCHAR(256) NULL,
    TENANT_ID_ VARCHAR(256) NULL,
    IS_ADMIN_ TINYINT NULL,
    CONTROL_RIGHTS_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_CTRL_USER PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_TOKEN (
    ID_ VARCHAR(64) NOT NULL,
    TOKEN_VALUE_ VARCHAR(255) NULL,
    TOKEN_DATE_ datetime(6) NULL,
    IP_ADDRESS_ VARCHAR(255) NULL,
    USER_AGENT_ VARCHAR(255) NULL,
    USER_ID_ VARCHAR(255) NULL,
    TOKEN_DATA_ VARCHAR(2000) NULL,
    CONSTRAINT PK_FLW_CTRL_TOKEN PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_CLUSTER_CONFIG (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(50) NULL,
    DESCRIPTION_ VARCHAR(255) NULL,
    SERVER_ADDRESS_ VARCHAR(100) NULL,
    PORT_ INT NULL,
    CONTEXT_ROOT_ VARCHAR(100) NULL,
    USER_NAME_ VARCHAR(100) NULL,
    PASSWORD_ VARCHAR(100) NULL,
    TYPE_ VARCHAR(100) NULL,
    AUTHENTICATION_TYPE_ VARCHAR(100) DEFAULT 'basic' NULL,
    MULTI_TENANCY_ TINYINT DEFAULT 0 NOT NULL,
    TENANT_ID_ VARCHAR(50) NULL,
    CONSTRAINT PK_FLW_CTRL_CLUSTER_CONFIG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_AUDIT_LOG (
    ID_ VARCHAR(255) NOT NULL,
    CLUSTER_ID_ VARCHAR(255) NULL,
    CREATED_BY_ VARCHAR(255) NULL,
    CREATED_ON_ datetime(6) NULL,
    TENANT_ID_ VARCHAR(255) NULL,
    TYPE_ VARCHAR(255) NULL,
    SUB_TYPE_ VARCHAR(255) NULL,
    PAYLOAD_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_CTRL_AUDIT_LOG PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_ROLE (
    ID_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NULL,
    PRIVILEGES_ LONGTEXT NULL,
    CONSTRAINT PK_FLW_CTRL_ROLE PRIMARY KEY (ID_)
);

CREATE TABLE FLW_CTRL_ROLE_USER_MAPPING (
    ID_ VARCHAR(64) NOT NULL,
    USER_ID_ VARCHAR(255) NULL,
    ROLE_ID_ VARCHAR(255) NULL,
    GROUP_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_CTRL_ROLE_USER_MAPPING PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CTRL_USER ADD CONSTRAINT FLW_CTRL_UNIQ_USERNAME UNIQUE (USERNAME_);

CREATE TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING (
    ID_ VARCHAR(255) NOT NULL,
    AUTHORITY_ VARCHAR(255) NULL,
    CLUSTER_CONFIG_ID_ VARCHAR(255) NULL,
    CONSTRAINT PK_FLW_CTRL_AUTH_CLUSTER_MAPPING PRIMARY KEY (ID_)
);

ALTER TABLE FLW_CTRL_AUTH_CLUSTER_MAPPING
    ADD CONSTRAINT FLW_CTRL_FK_CLUSTER_CONFIG FOREIGN KEY (CLUSTER_CONFIG_ID_) REFERENCES FLW_CTRL_CLUSTER_CONFIG (ID_) ON DELETE CASCADE;

CREATE INDEX FLW_CTRL_IDX_AUTHORITY_ ON FLW_CTRL_AUTH_CLUSTER_MAPPING (AUTHORITY_);

CREATE INDEX FLW_CTRL_IDX_PRIVILEGE_GROUP ON FLW_CTRL_ROLE_USER_MAPPING (GROUP_ID_);

CREATE INDEX FLW_CTRL_IDX_PRIVILEGE_ROLE ON FLW_CTRL_ROLE_USER_MAPPING (ROLE_ID_);

CREATE TABLE FLW_CTRL_PROPERTY (
    NAME_ varchar(64),
    VALUE_ varchar(300),
    REV_ integer,
    primary key (NAME_)
);

insert into FLW_CTRL_PROPERTY
    values ('control.schema.version', '12', 1);

